/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.DoubleArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.LongBuffer;

public final class DoubleVarContainer
extends BaseVarContainer
implements VDataContainer.CDouble {
    final double[] dpad;

    public DoubleVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl, ByteOrder byteOrder) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(cDFImpl, variable, nArray, bl, byteOrder, Double.TYPE);
        Object object = this.thisCDF.getPadValue(variable);
        if (DataTypes.typeCategory[this.type] == 5) {
            long[] lArray = (long[])object;
            this.dpad = new double[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                this.dpad[i] = lArray[i];
            }
        } else {
            this.dpad = (double[])object;
        }
    }

    public DoubleVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl) throws IllegalAccessException, InvocationTargetException, Throwable {
        this(cDFImpl, variable, nArray, bl, ByteOrder.nativeOrder());
    }

    @Override
    ByteBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8 * n);
        byteBuffer.order(this.order);
        return byteBuffer;
    }

    @Override
    Object allocateDataArray(int n) {
        return new double[n];
    }

    @Override
    void doMissing(int n, ByteBuffer byteBuffer, Object object, int n2) {
        int n3;
        double[] dArray = (double[])object;
        double[] dArray2 = null;
        try {
            dArray2 = n2 < 0 ? this.dpad : this.var.asDoubleArray(new int[]{n2});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Should not see this.");
        }
        int n4 = byteBuffer.position();
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        for (int i = n; i > 0; i -= n3) {
            n3 = i;
            if (n3 * this.elements > dArray.length) {
                n3 = dArray.length / this.elements;
            }
            int n5 = 0;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < this.elements; ++k) {
                    dArray[n5++] = dArray2[k];
                }
            }
            doubleBuffer.put(dArray, 0, n3 * this.elements);
            n4 += 8 * n3 * this.elements;
        }
        byteBuffer.position(n4);
    }

    @Override
    void doData(ByteBuffer byteBuffer, int n, int n2, int n3, ByteBuffer byteBuffer2, Object object) throws Throwable, IllegalAccessException, InvocationTargetException {
        double[] dArray = (double[])object;
        int n4 = byteBuffer2.position();
        DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
        switch (DataTypes.typeCategory[n]) {
            case 0: {
                int n5;
                int n6;
                float[] fArray = new float[dArray.length];
                int n7 = byteBuffer.position();
                FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                for (n5 = 0; n5 < n3; n5 += n6 / n2) {
                    n6 = (n3 - n5) * n2;
                    if (n6 > dArray.length) {
                        n6 = dArray.length;
                    }
                    floatBuffer.get(fArray, 0, n6);
                    n7 += 4 * n6;
                    for (int i = 0; i < n6; ++i) {
                        dArray[i] = fArray[i];
                    }
                    doubleBuffer.put(dArray, 0, n6);
                    n4 += 8 * n6;
                }
                byteBuffer.position(n7);
                byteBuffer2.position(n4);
                break;
            }
            case 1: {
                int n5;
                int n8 = byteBuffer.position();
                DoubleBuffer doubleBuffer2 = byteBuffer.asDoubleBuffer();
                while (n5 < n3) {
                    int n9 = (n3 - n5) * n2;
                    if (n9 > dArray.length) {
                        n9 = dArray.length;
                    }
                    doubleBuffer2.get(dArray, 0, n9);
                    n8 += 8 * n9;
                    doubleBuffer.put(dArray, 0, n9);
                    n4 += 8 * n9;
                    n5 += n9 / n2;
                }
                byteBuffer.position(n8);
                byteBuffer2.position(n4);
                break;
            }
            case 2: {
                int n5;
                Method method = DataTypes.method[n];
                while (n5 < n3) {
                    int n10 = (n3 - n5) * n2;
                    if (n10 > dArray.length) {
                        n10 = dArray.length;
                    }
                    for (int i = 0; i < n10; ++i) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        dArray[i] = number.doubleValue();
                    }
                    doubleBuffer.put(dArray, 0, n10);
                    n4 += 8 * n10;
                    n5 += n10 / n2;
                }
                byteBuffer2.position(n4);
                break;
            }
            case 3: {
                int n5;
                Method method = DataTypes.method[n];
                long l = DataTypes.longInt[n];
                while (n5 < n3) {
                    int n11 = (n3 - n5) * n2;
                    if (n11 > dArray.length) {
                        n11 = dArray.length;
                    }
                    for (int i = 0; i < n11; ++i) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n12 = number.intValue();
                        dArray[i] = n12 >= 0 ? (double)n12 : (double)(l + (long)n12);
                    }
                    doubleBuffer.put(dArray, 0, n11);
                    n4 += 8 * n11;
                    n5 += n11 / n2;
                }
                byteBuffer2.position(n4);
                break;
            }
            case 5: {
                int n5;
                int n13 = byteBuffer.position();
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                long[] lArray = new long[dArray.length];
                while (n5 < n3) {
                    int n14 = (n3 - n5) * n2;
                    if (n14 > dArray.length) {
                        n14 = dArray.length;
                    }
                    longBuffer.get(lArray, 0, n14);
                    n13 += 8 * n14;
                    for (int i = 0; i < n14; ++i) {
                        dArray[i] = lArray[i];
                    }
                    doubleBuffer.put(dArray, 0, n14);
                    n4 += 8 * n14;
                    n5 += n14 / n2;
                }
                byteBuffer.position(n13);
                byteBuffer2.position(n4);
                break;
            }
            default: {
                throw new Throwable("Unrecognized data type " + n);
            }
        }
    }

    public static boolean isCompatible(int n, boolean bl) {
        return DoubleVarContainer.isCompatible(n, bl, Double.TYPE);
    }

    public Object _asArray() throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n > 4) {
            throw new Throwable("Rank > 4 not supported yet.");
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining() / 8;
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n3 = -1;
        switch (n) {
            case 0: {
                Object object;
                double[] dArray = new double[n2];
                doubleBuffer.get(dArray);
                if (this.singlePoint) {
                    Double d;
                    object = d;
                    d = new Double(dArray[0]);
                } else {
                    object = dArray;
                }
                return object;
            }
            case 1: {
                int n4 = (Integer)this.var.getElementCount().elementAt(0);
                n3 = n2 / n4;
                double[][] dArray = new double[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    doubleBuffer.get(dArray[i]);
                }
                return this.singlePoint ? (Object)dArray[0] : dArray;
            }
            case 2: {
                int n5 = (Integer)this.var.getElementCount().elementAt(0);
                int n6 = (Integer)this.var.getElementCount().elementAt(1);
                n3 = n2 / (n5 * n6);
                double[][][] dArray = new double[n3][n5][n6];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n5; ++j) {
                            doubleBuffer.get(dArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n5; ++k) {
                                dArray[i][k][j] = doubleBuffer.get();
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)dArray[0] : dArray;
            }
            case 3: {
                int n7 = (Integer)this.var.getElementCount().elementAt(0);
                int n8 = (Integer)this.var.getElementCount().elementAt(1);
                int n9 = (Integer)this.var.getElementCount().elementAt(2);
                n3 = n2 / (n7 * n8 * n9);
                double[][][][] dArray = new double[n3][n7][n8][n9];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                doubleBuffer.get(dArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n9; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                for (int i2 = 0; i2 < n7; ++i2) {
                                    dArray[i][i2][k][j] = doubleBuffer.get();
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)dArray[0] : dArray;
            }
            case 4: {
                int n10 = (Integer)this.var.getElementCount().elementAt(0);
                int n11 = (Integer)this.var.getElementCount().elementAt(1);
                int n12 = (Integer)this.var.getElementCount().elementAt(2);
                int n13 = (Integer)this.var.getElementCount().elementAt(3);
                n3 = n2 / (n10 * n11 * n12 * n13);
                double[][][][][] dArray = new double[n3][n10][n11][n12][n13];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n10; ++j) {
                            for (int k = 0; k < n11; ++k) {
                                for (int i3 = 0; i3 < n12; ++i3) {
                                    doubleBuffer.get(dArray[i][j][k][i3]);
                                }
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n13; ++j) {
                            for (int k = 0; k < n12; ++k) {
                                for (int i4 = 0; i4 < n11; ++i4) {
                                    for (int i5 = 0; i5 < n10; ++i5) {
                                        dArray[i][i5][i4][k][j] = doubleBuffer.get();
                                    }
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)dArray[0] : dArray;
            }
        }
        throw new Throwable("Internal error");
    }

    public Object asArrayElement(int[] nArray) throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n != 1) {
            throw new Throwable("Rank > 1 not supported.");
        }
        if (!DoubleVarContainer.validElement(this.var, nArray)) {
            return null;
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining() / 8;
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n3 = -1;
        int n4 = (Integer)this.var.getElementCount().elementAt(0);
        n3 = n2 / n4;
        if (nArray.length == 1) {
            int n5 = nArray[0];
            double[] dArray = new double[n3];
            int n6 = n5;
            for (int i = 0; i < n3; ++i) {
                dArray[i] = doubleBuffer.get(n6);
                n6 += n4;
            }
            return dArray;
        }
        int n7 = nArray.length;
        double[][] dArray = new double[n3][n7];
        int n8 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n7; ++j) {
                dArray[i][j] = doubleBuffer.get(n8 + nArray[j]);
            }
            n8 += n4;
        }
        return dArray;
    }

    public Object asArrayElement(int n, int n2) throws Throwable {
        int n3 = this.var.getEffectiveRank();
        if (n3 != 2) {
            throw new Throwable("Rank other than 2 not supported.");
        }
        int n4 = (Integer)this.var.getElementCount().elementAt(0);
        if (n < 0 || n >= n4) {
            throw new Throwable("Invalid first index " + n);
        }
        int n5 = (Integer)this.var.getElementCount().elementAt(1);
        if (n2 < 0 || n2 >= n5) {
            throw new Throwable("Invalid second index " + n2);
        }
        int n6 = n4 * n5;
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n7 = byteBuffer.remaining() / 8;
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n8 = n7 / n6;
        double[] dArray = new double[n8];
        int n9 = this.var.rowMajority() ? n5 * n + n2 : n4 * n2 + n;
        int n10 = 0;
        for (int i = 0; i < n8; ++i) {
            dArray[i] = doubleBuffer.get(n10 + n9);
            n10 += n6;
        }
        return dArray;
    }

    public void fillArray(double[] dArray, int n, int n2, int n3) throws Throwable {
        if (this.buffers.size() == 0) {
            throw new Throwable("buffer not available");
        }
        int n4 = (n3 - n2 + 1) * this.elements;
        ByteBuffer byteBuffer = this.getBuffer();
        int n5 = (n2 - this.getRecordRange()[0]) * this.elements * this.getLength();
        byteBuffer.position(n5);
        byteBuffer.asDoubleBuffer().get(dArray, n, n4);
    }

    @Override
    public double[] as1DArray() {
        return (double[])super.as1DArray();
    }

    @Override
    public double[] asOneDArray() {
        return (double[])super.asOneDArray(true);
    }

    @Override
    public double[] asOneDArray(boolean bl) {
        return (double[])super.asOneDArray(bl);
    }

    @Override
    public DoubleArray asArray() throws Throwable {
        return new DoubleArray(this._asArray());
    }
}

