/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;

public final class CDFDataType {
    public static final CDFDataType INT1 = new CDFDataType(1);
    public static final CDFDataType INT2 = new CDFDataType(2);
    public static final CDFDataType INT4 = new CDFDataType(4);
    public static final CDFDataType INT8 = new CDFDataType(8);
    public static final CDFDataType UINT1 = new CDFDataType(11);
    public static final CDFDataType UINT2 = new CDFDataType(12);
    public static final CDFDataType UINT4 = new CDFDataType(14);
    public static final CDFDataType FLOAT = new CDFDataType(21);
    public static final CDFDataType DOUBLE = new CDFDataType(22);
    public static final CDFDataType EPOCH = new CDFDataType(31);
    public static final CDFDataType EPOCH16 = new CDFDataType(32);
    public static final CDFDataType CHAR = new CDFDataType(51);
    public static final CDFDataType TT2000 = new CDFDataType(33);
    int type;

    private CDFDataType(int n) {
        this.type = n;
    }

    public int getValue() {
        return this.type;
    }

    public static CDFDataType getType(CDFTimeType cDFTimeType) {
        if (cDFTimeType.getValue() == 31) {
            return EPOCH;
        }
        if (cDFTimeType.getValue() == 32) {
            return EPOCH16;
        }
        if (cDFTimeType.getValue() == 33) {
            return TT2000;
        }
        return null;
    }
}

