/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;

public class ByteArray
extends AArray {
    public ByteArray(Object object) throws Throwable {
        super(object);
    }

    public ByteArray(Object object, boolean bl) throws Throwable {
        super(object, bl);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                return (byte[])this.o;
            }
            case 2: {
                return (byte[][])this.o;
            }
            case 3: {
                return (byte[][][])this.o;
            }
            case 4: {
                return (byte[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> clazz, int n) throws Throwable {
        if (clazz != Byte.TYPE) {
            throw new Throwable("Only byte targets supported");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        ByteBuffer byteBuffer = this.allocate(1);
        int[] nArray = this.aa.getDimensions();
        switch (this.dim) {
            case 1: {
                byte[] byArray = (byte[])this.o;
                byteBuffer.put(byArray);
                byteBuffer.flip();
                return byteBuffer;
            }
            case 2: {
                byte[][] byArray = (byte[][])this.o;
                for (int i = 0; i < nArray[0]; ++i) {
                    byteBuffer.put(byArray[i]);
                }
                byteBuffer.flip();
                return byteBuffer;
            }
            case 3: {
                byte[][][] byArray = (byte[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            byteBuffer.put(byArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                byteBuffer.put(byArray[i][k][j]);
                            }
                        }
                    }
                }
                byteBuffer.flip();
                return byteBuffer;
            }
            case 4: {
                byte[][][][] byArray = (byte[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                byteBuffer.put(byArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                    byteBuffer.put(byArray[i][i2][k][j]);
                                }
                            }
                        }
                    }
                }
                byteBuffer.flip();
                return byteBuffer;
            }
        }
        return null;
    }
}

