/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FloatNumberField
extends NumberField {
    static final long serialVersionUID = 1L;

    public Document createDefaultModel() {
        return new PlainDocument(){
            static final long serialVersionUID = 1L;

            public final void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                String string2 = this.getText(0, this.getLength());
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n, string2.length());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3);
                stringBuffer.append(string);
                stringBuffer.append(string4);
                try {
                    FloatNumberField.this.formatter.parse(stringBuffer.toString());
                    super.insertString(n, string, attributeSet);
                }
                catch (ParseException parseException) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
    }

    public Document createDefaultModelOLD() {
        return new PlainDocument(){
            static final long serialVersionUID = 1L;

            public final void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = this.getText(0, this.getEndPosition().getOffset()).toCharArray();
                char[] cArray2 = string.toCharArray();
                char[] cArray3 = new char[cArray2.length];
                int n2 = 0;
                boolean bl = false;
                int n3 = 0;
                while (n3 < cArray.length) {
                    if (cArray[n3] == '.') {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                n3 = 0;
                int n4 = 0;
                while (n4 < cArray.length) {
                    if (cArray[n4] == 'E') {
                        n3 = 1;
                        break;
                    }
                    ++n4;
                }
                n4 = 0;
                while (n4 < cArray3.length) {
                    if (Character.isDigit(cArray2[n4]) || cArray2[n4] == '.' && !bl || n != 0 && n3 == 0 && cArray2[n4] == 'E' || n == 0 && cArray2[n4] == '-') {
                        cArray3[n2++] = cArray2[n4];
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    ++n4;
                }
                super.insertString(n, new String(cArray3, 0, n2), attributeSet);
            }
        };
    }

    public Integer getInteger() {
        try {
            return new Integer(this.formatter.parse(this.getText()).intValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Long getLong() {
        try {
            return new Long(this.formatter.parse(this.getText()).longValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Float getFloat() {
        try {
            return new Float(this.formatter.parse(this.getText()).floatValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Double getDouble() {
        try {
            return new Double(this.formatter.parse(this.getText()).doubleValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public FloatNumberField(float f, int n) {
        super(n);
        this.formatter = NumberFormat.getNumberInstance(Locale.US);
        this.formatter.setParseIntegerOnly(false);
        this.formatter.setMaximumIntegerDigits(5);
        this.formatter.setMaximumFractionDigits(2);
        this.setText(new Float(f).toString());
    }
}

