/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EditVariableDialog
extends JDialog
implements ActionListener,
CDFConstants {
    static final long serialVersionUID = 1L;
    private static final String ENTER = "Change";
    private static final String END = "End";
    private static final String RESET = "Reset";
    private JButton enter;
    private JButton end;
    private JButton reset;
    private JLabeledTF jtfne;
    private JLabeledTF jtfcl;
    private JLabeledTF jtfbf;
    private JLabeledTF jtfir;
    private JLabeledTF jtfpv;
    private JLabeledTF jtfstr;
    private JLabeledTF jtfend;
    private JLabeledTF jtfstrd;
    private JLabeledTF jtfendd;
    private WholeNumberField tfdim;
    private JTextField tfne;
    private JTextField tfcl;
    private JTextField tfbf;
    private JTextField tfir;
    private JTextField tfpv;
    private JTextField tfstr;
    private JTextField tfend;
    private JTextField tfstrd;
    private JTextField tfendd;
    private JLabeledCB cbdt;
    private JLabeledCB cbcp;
    private JLabeledCB cbsp;
    private JCheckBox cbrv;
    private JLabeledDataTable jdtsizes;
    private JLabeledDataTable jdtvarys;
    private JLabeledDataTable jdtallorecs;
    private JFrame myFrame;
    private long recVariance;
    private Object pad;
    private String padString;
    private long numDim;
    private long dataType;
    private long numElements;
    private long bf;
    private long sparse;
    private long compress;
    private long compresslvl;
    private long[] dimSizes;
    private long[] dimVariances;
    private long[] compressParms;
    private boolean[] dimVarL;
    private long numRecA;
    private long numRecW;
    private boolean editable;
    private Variable var;
    private CDF cdf;
    private Dimension ss;
    private Dimension ps;

    private final void createButtonPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        this.enter = new JButton(ENTER);
        this.enter.addActionListener(this);
        this.enter.setToolTipText("Modify the variable based on the entered fields");
        jPanel2.add(this.enter);
        jPanel2.add(Box.createRigidArea(new Dimension(40, 1)));
        this.reset = new JButton(RESET);
        this.reset.setToolTipText("Reset fields back to their current values");
        this.reset.addActionListener(this);
        jPanel2.add(this.reset);
        jPanel2.add(Box.createRigidArea(new Dimension(40, 1)));
        this.end = new JButton(END);
        this.end.setToolTipText("End/Quit the editing");
        this.end.addActionListener(this);
        jPanel2.add(this.end);
        jPanel.add((Component)jPanel2, "South");
    }

    private final JPanel createVariancePanel() {
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Variances");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.cbrv = new JCheckBox("Record");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cbrv, gridBagConstraints);
        jLabeledPanel.add(this.cbrv);
        this.jdtvarys = new JLabeledDataTable("Dimension", this.editable);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.jdtvarys, gridBagConstraints);
        jLabeledPanel.add(this.jdtvarys);
        jLabeledPanel.setEnabled(true);
        return jLabeledPanel;
    }

    private final JPanel createDimensionPanel() {
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Dimensions");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tfdim = new WholeNumberField(0, 3);
        JLabeledTF jLabeledTF = new JLabeledTF("Number", this.tfdim, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabeledTF, gridBagConstraints);
        jLabeledPanel.add(jLabeledTF);
        this.jdtsizes = new JLabeledDataTable("Sizes", false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.jdtsizes, gridBagConstraints);
        jLabeledPanel.add(this.jdtsizes);
        jLabeledPanel.setEnabled(true);
        return jLabeledPanel;
    }

    private final JPanel createAllocRecsPanel() {
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Allocate Records");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tfstr = new JTextField(4);
        this.jtfstr = new JLabeledTF("Start  Rec#", this.tfstr, true);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfstr, gridBagConstraints);
        jLabeledPanel.add(this.jtfstr);
        this.tfend = new JTextField(4);
        this.jtfend = new JLabeledTF("End  Rec#", this.tfend, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfend, gridBagConstraints);
        jLabeledPanel.add(this.jtfend);
        return jLabeledPanel;
    }

    private final JPanel createDelRecsPanel() {
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Delete Records");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.tfstrd = new JTextField(4);
        this.jtfstrd = new JLabeledTF("Start  Rec#", this.tfstrd, true);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfstrd, gridBagConstraints);
        jLabeledPanel.add(this.jtfstrd);
        this.tfendd = new JTextField(4);
        this.jtfendd = new JLabeledTF("End  Rec#", this.tfendd, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfendd, gridBagConstraints);
        jLabeledPanel.add(this.jtfendd);
        return jLabeledPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals(END)) {
                this.setVisible(false);
                this.enter.removeActionListener(this);
                this.end.removeActionListener(this);
                this.reset.removeActionListener(this);
                this.dispose();
                System.gc();
            } else if (string.equals(RESET)) {
                this.reset();
            } else if (string.equals(ENTER)) {
                ((JButton)object).setEnabled(false);
                if (this.editable) {
                    long l;
                    switch (this.cbdt.getIndex()) {
                        case 0: {
                            l = 41L;
                            break;
                        }
                        case 1: {
                            l = 1L;
                            break;
                        }
                        case 2: {
                            l = 11L;
                            break;
                        }
                        case 3: {
                            l = 2;
                            break;
                        }
                        case 4: {
                            l = 12L;
                            break;
                        }
                        case 5: {
                            l = 4;
                            break;
                        }
                        case 6: {
                            l = 14L;
                            break;
                        }
                        case 7: {
                            l = 8L;
                            break;
                        }
                        case 8: {
                            l = 21L;
                            break;
                        }
                        case 9: {
                            l = 44L;
                            break;
                        }
                        case 10: {
                            l = 22L;
                            break;
                        }
                        case 11: {
                            l = 45L;
                            break;
                        }
                        case 12: {
                            l = 31L;
                            break;
                        }
                        case 13: {
                            l = 32L;
                            break;
                        }
                        case 14: {
                            l = 33L;
                            break;
                        }
                        case 15: {
                            l = 51L;
                            break;
                        }
                        case 16: {
                            l = 52L;
                            break;
                        }
                        default: {
                            l = 41L;
                        }
                    }
                    long l2 = 1L;
                    if (this.dataType == 51L || this.dataType == 52L) {
                        l2 = Long.parseLong(this.tfne.getText());
                    }
                    if (this.dataType != l || this.numElements != l2) {
                        try {
                            this.var.updateDataSpec(l, l2);
                            this.dataType = l2;
                            this.numElements = l2;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: Data Type Change", 0);
                            this.cbdt.set(CDFUtils.getStringDataType((long)this.dataType));
                        }
                    }
                }
                this.doEditing();
                ((JButton)object).setEnabled(true);
            }
        }
    }

    private final void reset() {
        this.numDim = this.var.getNumDims();
        this.numElements = this.var.getNumElements();
        this.dimSizes = this.var.getDimSizes();
        this.dataType = this.var.getDataType();
        this.dimVariances = this.var.getDimVariances();
        this.dimVarL = new boolean[(int)this.numDim];
        int n = 0;
        while (n < (int)this.numDim) {
            boolean bl = false;
            if (this.dimVariances[n] == (long)-1) {
                bl = true;
            }
            this.dimVarL[n] = bl;
            ++n;
        }
        this.recVariance = this.var.getRecVariance() ? (long)-1 : 0L;
        this.pad = null;
        try {
            if (this.var.checkPadValueExistence()) {
                this.pad = this.var.getPadValue();
            }
        }
        catch (CDFException cDFException) {}
        try {
            this.bf = this.var.getBlockingFactor();
        }
        catch (CDFException cDFException) {
            this.bf = 0L;
        }
        this.sparse = this.var.getSparseRecords();
        this.compress = this.var.getCompressionType();
        if (this.compress == (long)5) {
            this.compressParms = this.var.getCompressionParms();
            this.compresslvl = this.compressParms[0];
        }
        this.tfdim.setText("" + this.numDim);
        this.tfdim.setEnabled(true);
        this.tfdim.setEditable(false);
        this.tfne.setText("" + this.numElements);
        this.jtfne.setEnabled(true);
        if (this.editable) {
            if (this.dataType == 51L || this.dataType == 52L) {
                this.tfne.setEditable(true);
            } else {
                this.tfne.setEditable(false);
            }
        }
        this.cbdt.set(CDFUtils.getStringDataType((long)this.dataType));
        this.cbdt.setEnabled(true);
        this.cbdt.comboBox.setEnabled(this.editable);
        this.tfdim.setEnabled(true);
        this.tfdim.setEditable(false);
        this.jdtsizes.setEnabled(true);
        if (this.numDim > 0L) {
            this.jdtsizes.setVisible(true);
            this.jdtsizes.getModel().createEmptyTable(1, (int)this.numDim, Long.TYPE);
            this.jdtsizes.getModel().setData(this.dimSizes);
            this.jdtsizes.setEnabled(true);
            this.jdtvarys.setVisible(true);
            this.jdtvarys.setEnabled(true);
            this.jdtvarys.getModel().createEmptyTable(1, (int)this.numDim, Boolean.TYPE);
            this.jdtvarys.getModel().setData(this.dimVarL);
        } else {
            this.jdtsizes.setVisible(true);
            this.jdtsizes.getModel().setData(null);
            this.jdtvarys.setVisible(true);
            this.jdtvarys.getModel().setData(null);
        }
        boolean bl = false;
        if (this.recVariance == (long)-1) {
            bl = true;
        }
        this.cbrv.setSelected(bl);
        this.cbrv.setEnabled(this.editable);
        this.doPading();
        this.doBlockingFactor();
        this.doSparseness();
        this.doCompression();
        this.tfstr.setText("");
        this.tfend.setText("");
        this.tfstrd.setText("");
        this.tfendd.setText("");
        this.tfir.setText("");
        if (this.recVariance == 0L) {
            this.tfstr.setEditable(false);
            this.tfend.setEditable(false);
            this.tfstrd.setEditable(false);
            this.tfendd.setEditable(false);
            this.tfir.setEditable(false);
        }
    }

    private final void doEditing() {
        String string;
        String string2;
        long l;
        Object object;
        String string3;
        long l2;
        long l3;
        Object object2;
        long l4;
        long l5 = l4 = this.cbrv.isSelected() ? (long)-1 : 0L;
        if (l4 != this.recVariance) {
            try {
                this.var.setRecVariance(l4);
                this.recVariance = l4;
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Record Variances Error", 0);
            }
        }
        if (this.numDim > 0L) {
            object2 = new long[(int)this.numDim];
            boolean bl = false;
            boolean[] blArray = new boolean[(int)this.numDim];
            if (this.numDim == 1L) {
                blArray[0] = (Boolean)this.jdtvarys.getModel().getData();
            } else {
                blArray = (boolean[])this.jdtvarys.getModel().getData();
            }
            int n = 0;
            while ((long)n < this.numDim) {
                object2[n] = blArray[n] ? (long)-1 : 0L;
                if (object2[n] != this.dimVariances[n]) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                try {
                    this.var.setDimVariances((long[])object2);
                    this.dimVariances = (long[])object2;
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Dimension Variances Error", 0);
                }
            }
        }
        if ((object2 = this.tfbf.getText()) != null && ((String)object2).trim().length() != 0 && (l3 = Long.parseLong((String)object2)) != this.bf) {
            try {
                this.var.setBlockingFactor(l3);
                this.bf = l3;
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Blocking Factor Error", 0);
                this.doBlockingFactor();
            }
        }
        if ((l2 = (long)this.cbsp.getIndex()) > (long)-1 && l2 != this.sparse) {
            try {
                this.var.setSparseRecords(l2);
                this.sparse = l2;
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Record Sparseness Error", 0);
                this.doSparseness();
            }
        }
        long l6 = this.cbcp.getIndex();
        long[] lArray = new long[1];
        if (l6 != this.compress) {
            if (l6 == (long)4) {
                ++l6;
                lArray[0] = Long.parseLong(this.tfcl.getText());
            }
            try {
                this.var.setCompression(l6, lArray);
                this.compress = l6;
                if (l6 == (long)5) {
                    this.compressParms[0] = lArray[0];
                }
                if (l6 == (long)5) {
                    this.compresslvl = lArray[0];
                }
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Compression Error", 0);
                this.doCompression();
            }
        } else if (l6 == (long)4) {
            ++l6;
            lArray[0] = Long.parseLong(this.tfcl.getText());
            if (lArray[0] != this.compresslvl) {
                try {
                    this.var.setCompression(l6, lArray);
                    this.compress = l6;
                    this.compressParms[0] = lArray[0];
                    this.compresslvl = lArray[0];
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Compression Error", 0);
                    this.doCompression();
                }
            }
        }
        if ((string3 = this.tfpv.getText()) != null) {
            string3 = string3.trim();
        }
        if (string3.length() != 0 && !string3.equals(this.padString)) {
            try {
                object = CDFToolUtils.parseContent(string3, this.dataType);
                this.var.setPadValue(object);
                this.pad = object;
                this.padString = string3;
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Pad Value Error", 0);
                this.doPading();
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, numberFormatException.toString(), "MYEditor: CDFException", 0);
                this.doPading();
            }
        }
        if ((object = this.tfir.getText()) != null && ((String)object).trim().length() != 0 && (l = Long.parseLong((String)object)) > 0L) {
            try {
                this.var.setInitialRecords(l);
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Write Initial Records Error", 0);
            }
        }
        l = 0L;
        long l7 = 0L;
        String string4 = this.tfstr.getText();
        String string5 = this.tfend.getText();
        if (string4 != null && string5 != null) {
            string2 = string4.trim();
            string = string5.trim();
            if (string2 != null && !string2.equals("") && string != null && !string.equals("") && (l = Long.parseLong(string2)) <= (l7 = Long.parseLong(string)) && l >= 1L) {
                try {
                    this.var.allocateBlock(l - 1L, l7 - 1L);
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Allocate records Error", 0);
                }
            }
        }
        string4 = this.tfstrd.getText();
        string5 = this.tfendd.getText();
        if (string4 != null && string5 != null) {
            string2 = string4.trim();
            string = string5.trim();
            if (string2 != null && !string2.equals("") && string != null && !string.equals("") && (l = Long.parseLong(string2)) <= (l7 = Long.parseLong(string)) && l >= 1L) {
                try {
                    this.var.deleteRecords(l - 1L, l7 - 1L);
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Delete records Error", 0);
                }
            }
        }
    }

    private final void doCompression() {
        this.cbcp.comboBox.setSelectedIndex((int)(this.compress == (long)5 ? this.compress - 1L : this.compress));
        if (this.compress == (long)5) {
            this.jtfcl.setVisible(true);
            this.jtfcl.setEnabled(true);
            this.jtfcl.setEditable(true);
            this.tfcl.setText("" + this.compresslvl);
        } else {
            this.jtfcl.setVisible(true);
            this.jtfcl.setEnabled(true);
            this.jtfcl.setEditable(false);
            if (this.compress == 0L) {
                this.tfcl.setText("");
            } else {
                this.tfcl.setText("0");
            }
        }
    }

    private final void doSparseness() {
        if (this.sparse == 0L) {
            this.cbsp.comboBox.setSelectedIndex(-1);
        } else {
            this.cbsp.comboBox.setSelectedIndex((int)this.sparse);
        }
    }

    private final void doBlockingFactor() {
        if (this.bf == 0L) {
            this.tfbf.setText("");
        } else {
            this.tfbf.setText("" + this.bf);
        }
    }

    private final void doPading() {
        if (this.pad == null) {
            this.padString = "";
        } else if (this.dataType != 31L && this.dataType != 32L && this.dataType != 33L) {
            this.padString = this.pad.toString();
        } else if (this.dataType == 32L) {
            double[] dArray = new double[]{(Double)this.pad, (Double)this.pad};
            this.padString = Epoch16.encode((Object)dArray);
        } else if (this.dataType == 31L) {
            double d = (Double)this.pad;
            this.padString = Epoch.encode((double)d);
        } else {
            long l = (Long)this.pad;
            this.padString = CDFTT2000.toUTCstring((long)l);
        }
        this.tfpv.setText(this.padString);
    }

    private final /* synthetic */ void this() {
        this.compress = -1;
        this.var = null;
        this.cdf = null;
    }

    public EditVariableDialog() {
        this.this();
    }

    public EditVariableDialog(JFrame jFrame, Variable variable) {
        super((Frame)jFrame, true);
        this.this();
        this.myFrame = jFrame;
        this.var = variable;
        this.setTitle("Edit zVariable: " + variable.getName());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.setResizable(true);
        this.setSize(500, 450);
        this.setLocation(10, 20);
        this.setVisible(false);
        this.ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.ps = this.getPreferredSize();
        try {
            this.numRecA = variable.getNumAllocatedRecords();
            this.numRecW = variable.getNumWrittenRecords();
            int n = 0;
            if (this.numRecA > 0L || this.numRecW > 0L) {
                n = 1;
            }
            this.editable = 1 - n;
        }
        catch (CDFException cDFException) {
            this.editable = false;
        }
        JSplitPane jSplitPane = new JSplitPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabeledPanel jLabeledPanel = new JLabeledPanel("", BorderFactory.createEmptyBorder());
        jLabeledPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Vector<String> vector = new Vector<String>(17);
        vector.addElement("CDF_BYTE");
        vector.addElement("CDF_INT1");
        vector.addElement("CDF_UINT1");
        vector.addElement("CDF_INT2");
        vector.addElement("CDF_UINT2");
        vector.addElement("CDF_INT4");
        vector.addElement("CDF_UINT4");
        vector.addElement("CDF_INT8");
        vector.addElement("CDF_REAL4");
        vector.addElement("CDF_FLOAT");
        vector.addElement("CDF_REAL8");
        vector.addElement("CDF_DOUBLE");
        vector.addElement("CDF_EPOCH");
        vector.addElement("CDF_EPOCH16");
        vector.addElement("CDF_TIME_TT2000");
        vector.addElement("CDF_CHAR");
        vector.addElement("CDF_UCHAR");
        this.cbdt = new JLabeledCB("Data Type", vector, false, this.editable);
        this.cbdt.addItemListener(new DataTypeListener());
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.cbdt, gridBagConstraints);
        jLabeledPanel.add(this.cbdt);
        this.tfne = new JTextField(2);
        this.jtfne = new JLabeledTF("NumElements", this.tfne, this.editable);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfne, gridBagConstraints);
        jLabeledPanel.add(this.jtfne);
        JPanel jPanel2 = this.createDimensionPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jLabeledPanel.add(jPanel2);
        jPanel2 = this.createVariancePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jLabeledPanel.add(jPanel2);
        JLabeledPanel jLabeledPanel2 = new JLabeledPanel("", BorderFactory.createEmptyBorder());
        jLabeledPanel2.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Vector<String> vector2 = new Vector<String>(3);
        vector2.addElement("None");
        vector2.addElement("PAD_SPARSERECORDS");
        vector2.addElement("PREV_SPARSERECORDS");
        this.cbsp = new JLabeledCB("Record Sparseness", vector2, true);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cbsp, gridBagConstraints);
        jLabeledPanel2.add(this.cbsp);
        Vector<String> vector3 = new Vector<String>(5);
        vector3.addElement("None");
        vector3.addElement("RLE");
        vector3.addElement("HUFF");
        vector3.addElement("AHUFF");
        vector3.addElement("GZIP");
        this.cbcp = new JLabeledCB("Compression", vector3, true);
        this.cbcp.addItemListener(new CompressionListener());
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbcp, gridBagConstraints);
        jLabeledPanel2.add(this.cbcp);
        this.tfcl = new JTextField(1);
        this.jtfcl = new JLabeledTF("Level", this.tfcl, false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfcl, gridBagConstraints);
        jLabeledPanel2.add(this.jtfcl);
        this.tfpv = new JTextField(3);
        this.jtfpv = new JLabeledTF("Pad Value", this.tfpv, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfpv, gridBagConstraints);
        jLabeledPanel2.add(this.jtfpv);
        this.tfbf = new JTextField(3);
        this.jtfbf = new JLabeledTF("Blocking Factor", this.tfbf, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfbf, gridBagConstraints);
        jLabeledPanel2.add(this.jtfbf);
        this.tfir = new JTextField(3);
        this.jtfir = new JLabeledTF("Write Initial Records", this.tfir, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfir, gridBagConstraints);
        jLabeledPanel2.add(this.jtfir);
        JPanel jPanel3 = this.createAllocRecsPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jLabeledPanel2.add(jPanel3);
        JPanel jPanel4 = this.createDelRecsPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jLabeledPanel2.add(jPanel4);
        jSplitPane.setLeftComponent(jLabeledPanel);
        jSplitPane.setRightComponent(jLabeledPanel2);
        jLabeledPanel.setMinimumSize(new Dimension(260, 400));
        jLabeledPanel2.setMinimumSize(new Dimension(240, 400));
        jSplitPane.setDividerLocation(260);
        jSplitPane.setDividerSize(5);
        jSplitPane.setPreferredSize(new Dimension(500, 400));
        jPanel.add((Component)jSplitPane, "Center");
        this.createButtonPanel(jPanel);
        this.reset();
        this.setVisible(true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DataTypeListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            String string = (String)EditVariableDialog.this.cbdt.get();
            if (string.equals("CDF_CHAR") || string.equals("CDF_UCHAR")) {
                EditVariableDialog.this.tfne.setText("" + EditVariableDialog.this.numElements);
                EditVariableDialog.this.jtfne.setEnabled(true);
                EditVariableDialog.this.tfne.setEditable(EditVariableDialog.this.editable);
            } else {
                EditVariableDialog.this.tfne.setText("1");
                EditVariableDialog.this.jtfne.setEnabled(true);
                EditVariableDialog.this.tfne.setEditable(false);
            }
        }

        DataTypeListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CompressionListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (EditVariableDialog.this.cbcp.getIndex() == 4) {
                EditVariableDialog.this.jtfcl.setVisible(true);
                EditVariableDialog.this.jtfcl.setEnabled(true);
                EditVariableDialog.this.jtfcl.setEditable(true);
                EditVariableDialog.this.jtfcl.set("5");
            } else {
                EditVariableDialog.this.jtfcl.setVisible(true);
                EditVariableDialog.this.jtfcl.setEnabled(true);
                EditVariableDialog.this.jtfcl.setEditable(false);
                if (EditVariableDialog.this.cbcp.getIndex() == 0) {
                    EditVariableDialog.this.jtfcl.set("");
                } else {
                    EditVariableDialog.this.jtfcl.set("0");
                }
            }
        }

        CompressionListener() {
        }
    }
}

