/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;

public class Cformat {
    private static Cformat instance;
    private int width;
    private int precision;
    private String pre;
    private String post;
    private boolean leading_zeroes;
    private boolean show_plus;
    private boolean alternate;
    private boolean show_space;
    private boolean left_align;
    private char fmt;

    public static Cformat getInstance(String string) {
        if (instance == null) {
            instance = new Cformat();
        }
        instance.reset();
        instance.setup(string);
        return instance;
    }

    private final void reset() {
        this.width = 0;
        this.precision = -1;
        this.pre = "";
        this.post = "";
        this.leading_zeroes = false;
        this.show_plus = false;
        this.alternate = false;
        this.show_space = false;
        this.left_align = false;
        this.fmt = (char)32;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setup(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == '%') {
                if (n3 >= n - 1) throw new IllegalArgumentException();
                if (string.charAt(n3 + 1) == '%') {
                    this.pre = this.pre + '%';
                    ++n3;
                } else {
                    n2 = 1;
                }
            } else {
                this.pre = this.pre + string.charAt(n3);
            }
            ++n3;
        }
        while (n2 == 1) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == ' ') {
                this.show_space = true;
            } else if (string.charAt(n3) == '-') {
                this.left_align = true;
            } else if (string.charAt(n3) == '+') {
                this.show_plus = true;
            } else if (string.charAt(n3) == '0') {
                this.leading_zeroes = true;
            } else if (string.charAt(n3) == '#') {
                this.alternate = true;
            } else {
                n2 = 2;
                --n3;
            }
            ++n3;
        }
        while (n2 == 2) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.width = this.width * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            if (string.charAt(n3) == '.') {
                n2 = 3;
                this.precision = 0;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        while (n2 == 3) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.precision = this.precision * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        if (n2 == 4) {
            if (n3 >= n) {
                n2 = 5;
            } else {
                this.fmt = string.charAt(n3);
            }
            ++n3;
        }
        if (n3 >= n) return;
        this.post = string.substring(n3, n);
    }

    public static void print(PrintStream printStream, String string, double d) {
        printStream.print(Cformat.getInstance(string).form(d));
    }

    public static void print(PrintStream printStream, String string, long l) {
        printStream.print(Cformat.getInstance(string).form(l));
    }

    public static void print(PrintStream printStream, String string, char c) {
        printStream.print(Cformat.getInstance(string).form(c));
    }

    public static void print(PrintStream printStream, String string, String string2) {
        printStream.print(Cformat.getInstance(string).form(string2));
    }

    public static int atoi(String string) {
        return (int)Cformat.atol(string);
    }

    public static long atol(String string) {
        int n = 0;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == '0') {
            if (n + 1 < string.length() && (string.charAt(n + 1) == 'x' || string.charAt(n + 1) == 'X')) {
                return Cformat.parseLong(string.substring(n + 2), 16);
            }
            return Cformat.parseLong(string, 8);
        }
        return Cformat.parseLong(string, 10);
    }

    private static final long parseLong(String string, int n) {
        int n2 = 0;
        int n3 = 1;
        long l = 0L;
        while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 < string.length() && string.charAt(n2) == '-') {
            n3 = -1;
            ++n2;
        } else if (n2 < string.length() && string.charAt(n2) == '+') {
            ++n2;
        }
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if ('0' <= c && c < 48 + n) {
                l = l * (long)n + (long)c - 48L;
            } else if ('A' <= c && c < 65 + n - 10) {
                l = l * (long)n + (long)c - 65L + 10L;
            } else if ('a' <= c && c < 97 + n - 10) {
                l = l * (long)n + (long)c - 97L + 10L;
            } else {
                return l * (long)n3;
            }
            ++n2;
        }
        return l * (long)n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String string) {
        int n = 0;
        int n2 = 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        boolean bl = false;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == '-') {
            n2 = -1;
            ++n;
        } else if (n < string.length() && string.charAt(n) == '+') {
            ++n;
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if ('0' <= c && c <= '9') {
                if (!bl) {
                    d = d * 10.0 + (double)c - 48.0;
                } else if (bl) {
                    d += (d3 /= 10.0) * (double)(c - 48);
                }
            } else if (c == '.') {
                if (bl) return (double)n2 * d;
                bl = true;
            } else {
                if (c != 'e' && c != 'E') return (double)n2 * d;
                long l = (int)Cformat.parseLong(string.substring(n + 1), 10);
                return (double)n2 * d * Math.pow(10.0, l);
            }
            ++n;
        }
        return (double)n2 * d;
    }

    public String form(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.precision < 0) {
            this.precision = 6;
        }
        int n = 1;
        if (d < 0.0) {
            d = -d;
            n = -1;
        }
        if (this.fmt == 'f') {
            stringBuffer.append(this.fixed_format(d));
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            stringBuffer.append(this.exp_format(d));
        } else if (this.fmt == 'd' || this.fmt == 'i') {
            if (n == -1 && d >= 1.0) {
                long l = (long)(-d);
                stringBuffer.append(("" + l).substring(1));
            } else {
                if (n == -1 && d < 1.0) {
                    n = 1;
                }
                long l = (long)d;
                stringBuffer.append(l);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, stringBuffer.toString()));
    }

    public String form(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (l < 0L) {
                stringBuffer.append(("" + l).substring(1));
                n = -1;
            } else {
                stringBuffer.append(l);
                n = 1;
            }
        } else if (this.fmt == 'o') {
            stringBuffer.append(Cformat.convert(l, 3, 7, "01234567"));
        } else if (this.fmt == 'x') {
            stringBuffer.append(Cformat.convert(l, 4, 15, "0123456789abcdef"));
        } else if (this.fmt == 'X') {
            stringBuffer.append(Cformat.convert(l, 4, 15, "0123456789ABCDEF"));
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, stringBuffer.toString()));
    }

    public String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String string = "" + c;
        return this.pad(string);
    }

    public String form(String string) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0 && this.precision < string.length()) {
            string = string.substring(0, this.precision);
        }
        return this.pad(string);
    }

    public static void main(String[] stringArray) {
        double d = 1.23456789012;
        double d2 = 123.0;
        double d3 = 1.2345E30;
        double d4 = 1.02;
        double d5 = 1.234E-5;
        int n = 51966;
        Cformat.print(System.out, "x = |%f|\n", d);
        Cformat.print(System.out, "u = |%20f|\n", d5);
        Cformat.print(System.out, "x = |% .5f|\n", d);
        Cformat.print(System.out, "w = |%20.5f|\n", d4);
        Cformat.print(System.out, "x = |%020.5f|\n", d);
        Cformat.print(System.out, "x = |%+20.5f|\n", d);
        Cformat.print(System.out, "x = |%+020.5f|\n", d);
        Cformat.print(System.out, "x = |% 020.5f|\n", d);
        Cformat.print(System.out, "y = |%#+20.5f|\n", d2);
        Cformat.print(System.out, "y = |%-+20.5f|\n", d2);
        Cformat.print(System.out, "z = |%20.5f|\n", d3);
        Cformat.print(System.out, "x = |%e|\n", d);
        Cformat.print(System.out, "u = |%20e|\n", d5);
        Cformat.print(System.out, "x = |% .5e|\n", d);
        Cformat.print(System.out, "w = |%20.5e|\n", d4);
        Cformat.print(System.out, "x = |%020.5e|\n", d);
        Cformat.print(System.out, "x = |%+20.5e|\n", d);
        Cformat.print(System.out, "x = |%+020.5e|\n", d);
        Cformat.print(System.out, "x = |% 020.5e|\n", d);
        Cformat.print(System.out, "y = |%#+20.5e|\n", d2);
        Cformat.print(System.out, "y = |%-+20.5e|\n", d2);
        Cformat.print(System.out, "x = |%g|\n", d);
        Cformat.print(System.out, "z = |%g|\n", d3);
        Cformat.print(System.out, "w = |%g|\n", d4);
        Cformat.print(System.out, "u = |%g|\n", d5);
        Cformat.print(System.out, "y = |%.2g|\n", d2);
        Cformat.print(System.out, "y = |%#.2g|\n", d2);
        Cformat.print(System.out, "d = |%d|\n", n);
        Cformat.print(System.out, "d = |%20d|\n", n);
        Cformat.print(System.out, "d = |%020d|\n", n);
        Cformat.print(System.out, "d = |%+20d|\n", n);
        Cformat.print(System.out, "d = |% 020d|\n", n);
        Cformat.print(System.out, "d = |%-20d|\n", n);
        Cformat.print(System.out, "d = |%20.8d|\n", n);
        Cformat.print(System.out, "d = |%x|\n", n);
        Cformat.print(System.out, "d = |%20X|\n", n);
        Cformat.print(System.out, "d = |%#20x|\n", n);
        Cformat.print(System.out, "d = |%020X|\n", n);
        Cformat.print(System.out, "d = |%20.8x|\n", n);
        Cformat.print(System.out, "d = |%o|\n", n);
        Cformat.print(System.out, "d = |%020o|\n", n);
        Cformat.print(System.out, "d = |%#20o|\n", n);
        Cformat.print(System.out, "d = |%#020o|\n", n);
        Cformat.print(System.out, "d = |%20.12o|\n", n);
        Cformat.print(System.out, "s = |%-20s|\n", "Hello");
        Cformat.print(System.out, "s = |%-20c|\n", '!');
        Cformat.print(System.out, "|%i|\n", Long.MIN_VALUE);
        Cformat.print(System.out, "|%6.2e|\n", 0.0);
        Cformat.print(System.out, "|%6.2g|\n", 0.0);
        Cformat.print(System.out, "|%6.2f|\n", 9.99);
        Cformat.print(System.out, "|%6.2f|\n", 9.999);
        Cformat.print(System.out, "|%6.0f|\n", 9.999);
    }

    private static final String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static final String convert(long l, int n, int n2, String string) {
        if (l == 0L) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (l != 0L) {
            stringBuffer.insert(0, string.charAt((int)(l & (long)n2)));
            l >>>= n;
        }
        return stringBuffer.toString();
    }

    private final String pad(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Cformat.repeat(' ', this.width - string.length()));
        if (this.left_align) {
            return this.pre + string + stringBuffer.toString() + this.post;
        }
        return this.pre + stringBuffer.toString() + string + this.post;
    }

    private final String sign(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            stringBuffer.append("-");
        } else if (n > 0) {
            if (this.show_plus) {
                stringBuffer.append("+");
            } else if (this.show_space) {
                stringBuffer.append(" ");
            }
        } else if (this.fmt == 'o' && this.alternate && string.length() > 0 && string.charAt(0) != '0') {
            stringBuffer.append("0");
        } else if (this.fmt == 'x' && this.alternate) {
            stringBuffer.append("0x");
        } else if (this.fmt == 'X' && this.alternate) {
            stringBuffer.append("0X");
        }
        int n2 = 0;
        if (this.leading_zeroes) {
            n2 = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            n2 = this.precision;
        }
        if (this.fmt == 'd' || this.fmt == 'i') {
            return stringBuffer.append(string).toString();
        }
        return stringBuffer.append(Cformat.repeat('0', n2 - stringBuffer.length() - string.length())).append(string).toString();
    }

    private final String fixed_format(double d) {
        boolean bl;
        boolean bl2 = false;
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            bl2 = bl = true;
        }
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        if (this.precision == 0) {
            return (long)(d + 0.5) + (bl ? "" : ".");
        }
        long l = (long)d;
        double d2 = d - (double)l;
        if (d2 >= 1.0 || d2 < 0.0) {
            return this.exp_format(d);
        }
        double d3 = 1.0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n <= this.precision && d3 <= 9.223372036854776E18) {
            d3 *= 10.0;
            stringBuffer.append("0");
            ++n;
        }
        long l2 = (long)(d3 * d2 + 0.5);
        if ((double)l2 >= d3) {
            l2 = 0L;
            ++l;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString()).append(l2);
        stringBuffer3.append(".").append(stringBuffer2.toString().substring(stringBuffer2.length() - this.precision, stringBuffer2.length()));
        if (bl) {
            int n2 = stringBuffer2.length() - 1;
            while (n2 >= 0 && stringBuffer2.charAt(n2) == '0') {
                --n2;
            }
            if (n2 >= 0 && stringBuffer2.charAt(n2) == '.') {
                --n2;
            }
            stringBuffer3.setLength(n2 + 1 + 1);
        }
        return stringBuffer3.insert(0, l).toString();
    }

    private final String exp_format(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        double d2 = d;
        double d3 = 1.0;
        if (d != 0.0) {
            while (d2 > 10.0) {
                ++n;
                d3 /= 10.0;
                d2 /= 10.0;
            }
            while (d2 < 1.0) {
                --n;
                d3 *= 10.0;
                d2 *= 10.0;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && n >= -4 && n < this.precision) {
            return this.fixed_format(d);
        }
        stringBuffer.append(this.fixed_format(d *= d3));
        if (this.fmt == 'e' || this.fmt == 'g') {
            stringBuffer.append("e");
        } else {
            stringBuffer.append("E");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("000");
        if (n >= 0) {
            stringBuffer.append("+");
            stringBuffer2.append(n);
        } else {
            stringBuffer.append("-");
            stringBuffer2.append(-n);
        }
        return stringBuffer.append(stringBuffer2.toString().substring(stringBuffer2.length() - 2, stringBuffer2.length())).toString();
    }

    private Cformat() {
    }
}

