;$Author: tkovalic $
;$Date: 2022/04/19 18:19:42 $
;$Header: /home/cdaweb/dev/control/RCS/project_subtitle.pro,v 1.42 2022/04/19 18:19:42 tkovalic Exp tkovalic $
;$Locker: tkovalic $
;$Revision: 1.42 $
;+------------------------------------------------------------------------
; NAME: PROJECT_SUBTITLE
; PURPOSE: Examine the structure given by the input parameter, and return
;          a string to be used as a subtitle giving project information,
;          and write this string onto current plot.
; CALLING SEQUENCE:
;       project_subtitle,a,title
; INPUTS:
;       a = structure containing a variable from the type of structure
;           returned by the read_mycdf procedure.
; OUTPUTS:
;       title = the string written to the plot or gif.
; KEYWORD PARAMETERS:
;       IMAGE    = special processing for image-type displays
;       TIMETAG  = epoch value associated with a single image
; AUTHOR:
;       Richard Burley, NASA/GSFC/Code 632.0, Feb 22, 1996
;       burley@nssdca.gsfc.nasa.gov    (301)286-2864
; MODIFICATION HISTORY:
;       8/7/96  R.Burley    ; Add TIMETAG keyword
;     10/21/97  R.Baldwin   ; Add SSCWEB keyword 
;     01/29/98  R.Baldwin   ; Added TCOLOR keyword 
;     10/14/98  T. Kovalick ; Added the acknowledgements line.
;     05/16/01  T. Kovalick ; Added carriage return after ISTP line since
;			      it was running of the page.
;
;Copyright 1996-2013 United States Government as represented by the 
;Administrator of the National Aeronautics and Space Administration. 
;All Rights Reserved.
;
;------------------------------------------------------------------
;
PRO project_subtitle, a, title, SSCWEB=SSCWEB, IMAGE=IMAGE, TIMETAG=TIMETAG,$
                      TCOLOR=TCOLOR,ps=ps

;if keyword_set(TCOLOR) then TCOLOR=TCOLOR else TCOLOR=247  ; rtb added 1/98
;if (n_elements(TCOLOR) gt 0) then TCOLOR=TCOLOR else TCOLOR=247  ; RCJ changed. 03/2006
if (n_elements(TCOLOR) gt 0) then TCOLOR=TCOLOR else TCOLOR=!d.table_size-1  ; RJK changed to match deviceopen. 08/2015

; write the title (at the top of the page) to the gif file
if keyword_set(SSCWEB) then web_code='SSCWEB' else web_code='CDAWeb'

;if (title ne '' and keyword_set(IMAGE)) then begin
;  xyouts,!d.x_size/2,!d.y_size-!d.y_ch_size,title,/DEVICE,ALIGNMENT=0.5,$
;     COLOR=TCOLOR
;endif else xyouts,!d.x_size/2,!d.y_size-!d.y_ch_size,title,/DEVICE,ALIGNMENT=0.5
;  RCJ 04/2006  Line above replaced w/ line below:
if (title ne '') then begin
   if keyword_set(ps) then begin
      xyouts,!d.x_size/2,!d.y_size-4*!d.y_ch_size,title,/DEVICE,ALIGNMENT=0.5,$
      COLOR=TCOLOR
   endif else begin  
      xyouts,!d.x_size/2,!d.y_size-!d.y_ch_size,title,/DEVICE,ALIGNMENT=0.5,$
      COLOR=TCOLOR
   endelse   
endif

; Generate the subtitle
pi = ' ' & s='' & b = tagindex('PROJECT',tag_names(a))
move_up = 0L
if (b[0] ne -1) then begin
 if(n_elements(a.PROJECT) eq 1) then begin 
  pr = break_mystring(a.PROJECT,delimiter='>')
 endif else begin
  pr = break_mystring(a.PROJECT[0],delimiter='>')
 endelse
 if (pr[0] eq 'ISTP') then begin
    s = 'Key Parameter and Survey data (labels K0,K1,K2)'
    s = s + ' are preliminary browse data.' + '!C'
 endif ;ISTP case
 ;TJK 11/2/2006 - add check for long PI string, if longer than 40
 ;put affiliation info. on the next line and set flag to move the line up.
 ;TJK add in code to get and display the PI and PI_AFFILIATION
 b = tagindex('PI_NAME',tag_names(a))
 if (b[0] ne -1) then begin
    if(n_elements(a.PI_NAME) eq 1) then pi = a.PI_NAME
 endif
 b = tagindex('PI_AFFILIATION',tag_names(a))
 if (b[0] ne -1) then begin
    if((n_elements(a.PI_AFFILIATION) eq 1) and (a.PI_AFFILIATION[0] ne "")) then begin
        ;if (strlen(pi)+strlen(a.pi_affiliation) gt 40) then begin
	if keyword_set(ps) then lenlimit=35 else lenlimit=40
        if (strlen(pi)+strlen(a.pi_affiliation) gt lenlimit) then begin
          pi = pi + '!C at '+ a.PI_AFFILIATION
          move_up = 1L
        endif else pi = pi + ' at '+ a.PI_AFFILIATION
    endif
 endif
    
 pi = 'Please acknowledge PI, ' + pi + ' and '+ web_code +' when using these data.'
   
 s = s + ' Generated by '+ web_code + ' on ' + systime()
endif ; Global attribute Project is found

; Write the subtitle into the window
if (s ne '') then begin
  c = 1.0 ; initialize
  if ((!d.x_ch_size * strlen(s)) gt !d.x_size) then begin
    b = float(!d.x_ch_size * strlen(s)) / float(!d.x_size)
    c = 1.0 - (b/7.0)
  endif
  if (c ge 0.75) then begin
    if keyword_set(IMAGE) then begin
      if keyword_set(TIMETAG) then begin
        d = size(TIMETAG) ; determine if time is a range or single time
        ;TJK 3/29/2004 - make the char size larger for frames from movie...
        if d[0] eq 0 then begin
	  ts = 'Frame time: ' + decode_cdfepoch(TIMETAG,/incl_mmm) 
          ;xyouts,!d.x_size/2,23L,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c+.5,COLOR=TCOLOR
          if (move_up) then xyouts,!d.x_size/2,!d.y_ch_size*4.,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c+.5,COLOR=TCOLOR  else $
             xyouts,!d.x_size/2,!d.y_ch_size*2.,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c+.5,COLOR=TCOLOR

        endif else begin
	  ts = 'Time Range: ' + decode_cdfepoch(TIMETAG[0]) + ' to ' + $
                  decode_cdfepoch(TIMETAG[1])
          ;xyouts,!d.x_size/2,23L,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
          if (move_up) then xyouts,!d.x_size/2,!d.y_ch_size*4.,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR else $
          xyouts,!d.x_size/2,!d.y_ch_size*2.,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
	endelse

	; RCJ 05/09/2007  Note: Bob's choice was to leave the lines below out of the plot if plot is ps/pdf
        ; TJK 4/19/2022 - Bobby/Lan decided they want the subtitle on the PS/PDF plots

;        if (not keyword_set(ps) and not move_up) then xyouts,!d.x_size/2,!d.y_ch_size,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR else xyouts,!d.x_size/2,34L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
        if (not move_up) then xyouts,!d.x_size/2,!d.y_ch_size,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR else xyouts,!d.x_size/2,34L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor

       endif ;if TIMETAG

;      if (not keyword_set(ps) and not move_up) then xyouts,!d.x_size/2,!d.y_ch_size/10,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR else xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
      if (not move_up) then xyouts,!d.x_size/2,!d.y_ch_size/10,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR else xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor

     endif else begin ; else not IMAGE
;TJK 4/19/2022 - Bobby/Lan decided they want the subtitle on the
;                PS/PDF plots - so put this logic back in
       if keyword_set(ps) then begin
          if move_up then begin
             xyouts,!d.x_size/2,!d.y_ch_size*2.75,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
             xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
	  endif else begin
             xyouts,!d.x_size/2,!d.y_ch_size*2.,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
             xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
          endelse
       endif else begin
          if move_up then begin
            xyouts,!d.x_size/2,34L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
            xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
          endif else begin  ; y distance below was 20L and 10L.  RCJ
            xyouts,!d.x_size/2,!d.y_ch_size*2.,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
            xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
          endelse
      endelse
    endelse

  endif 

  if (c lt 0.75) then begin ;TJK added to handle label when
				       ;space is limited

    s = ''
    if (pr[0] eq 'ISTP') then begin
      s = 'Key Parameter and Survey data (labels K0,K1,K2) are '
      s = s + 'preliminary browse data.' + '!C'
    endif

    gen_date = ' Generated by '+ web_code + ' on ' + systime()

    if keyword_set(IMAGE) then begin
      if keyword_set(TIMETAG) then begin
        d = size(TIMETAG) ; determine if time is a range or single time
        if d[0] eq 0 then ts = 'Frame time: ' + decode_cdfepoch(TIMETAG) $
        else ts = 'Time Range: ' + decode_cdfepoch(TIMETAG[0]) + ' to ' + $
                  decode_cdfepoch(TIMETAG[1])
	ts = ts + '; ' + gen_date
        ;xyouts,!d.x_size/2,23L,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
        ;xyouts,!d.x_size/2,13L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
        xyouts,!d.x_size/2,!d.y_ch_size*2.,ts,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
        xyouts,!d.x_size/2,!d.y_ch_size,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
      endif
      ;xyouts,!d.x_size/2,3L,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
      xyouts,!d.x_size/2,!d.y_ch_size/10,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,COLOR=TCOLOR
    endif else begin
       if keyword_set(ps) then begin
          if move_up then begin
             xyouts,!d.x_size/2,!d.y_ch_size*2.75,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
             xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
	  endif else begin
             xyouts,!d.x_size/2,!d.y_ch_size*2.,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
             xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
          endelse
       endif else begin	
          if move_up then begin  
             xyouts,!d.x_size/2,34L,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
             xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
          endif else begin; y distance was 20L and 10L:
             xyouts,!d.x_size/2,!d.y_ch_size*2.,pi,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
             xyouts,!d.x_size/2,!d.y_ch_size,s,/DEVICE,ALIGNMENT=0.5,CHARSIZE=c,color=tcolor
          endelse
       endelse
    endelse

  endif
endif  
end





