/*
//	vgrsdrc.c
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>


#define HDR_SIZE	12

unsigned char label[] =
{ 0x4e, 0x4a, 0x50, 0x4c, 0x32, 0x49, 0x30, 0x30, 0x43, 
  0x32, 0x32, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x70 };

unsigned char aggr_chdo[] =
{ 0x00, 0x01, 0x00, 0x84 };

unsigned char primary[] =
{ 0x00, 0x02, 0x00, 0x04, 0x0b, 0x80, 0x00, 0x80 };

unsigned char secondary[] =
{ 0x00, 0x0f, 0x00, 0x50, 0x30, 0x75, 0x00, 0x94, 0x00, 0x80 };

unsigned char tert[] =
{ 0x00, 0x32, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

unsigned char quat[] =
{ 0x00, 0x1b, 0x00, 0x06, 0x00, 0x00, 0x00, 0x39, 0x02, 0x01 };

unsigned char data_chdo[] =
{ 0x00, 0x1c, 0x00, 0xe4, 0x2c, 0x00, 0x02, 0xcb };


/*
// ---- Internal Functions
*/
void do_data( unsigned char b[], unsigned char in_b[] );

/*
// ---- External Functions
*/
extern unsigned char *cvt_mtstime( unsigned char*, unsigned char* );
extern int	read_ibm_blocking(FILE*, int, int*);

/* -------------------------------------- */
int main( int argc, char **argv )
{
    unsigned char	c=0xa0;
    unsigned char	o_clk[6];
    unsigned char	clk[6];
    unsigned char	b[1000];
    unsigned char	mtstime[6];
    unsigned char	sfoc_time[6];
    unsigned char	in_b[10000];
    FILE		*out_fd;
    FILE		*in_fd=stdin;
    int			rec_length;
    int			line_count;


/*
    // ---- Initializiation
*/

    if ( argc < 2 )
    {
	fprintf( stderr, "usage: %s outfile <infile>\n", argv[0] );
	exit( 0 );
    }

    if ( !(out_fd = fopen(argv[1], "w")) )
    {
	perror("could not open output file");
	exit( 1 );
    }

    if ( argc > 2 )
    {
	if ( !(in_fd = fopen(argv[2], "r")) )
	{
	    perror("could not open input file");
	    exit( 2 );
	}
    }


/*
    // ---- Start Loop
*/

    while ( !feof(in_fd) )
    {

	
/*
	// ---- blocking
*/

	if ( !fread( in_b, 1, 6, in_fd ) )
            break;

	if ( in_b[0] != 0xff )
	{
	    fseek( in_fd, (long)(-6), SEEK_CUR );
	}

/*
	// ---- fread in_b SDR_SIZE bytes 
*/
	if ( !fread( in_b, 1, HDR_SIZE, in_fd ) )
	    break;


	rec_length = ( (in_b[4] << 8) | in_b[5] ) * 2;
/*
printf("%d\n", rec_length);
*/
	rec_length -= HDR_SIZE;
	if ( !fread( &in_b[HDR_SIZE], 1, rec_length, in_fd ) )
	    break;

/*
	// ---- make sure this is cheng
*/
	if ( in_b[1] != 0x01 )
	{
/*
	    puts("wrong data type");
*/
	    continue;
	}

/*
	// ---- SCLK 
*/
	clk[0] = in_b[20];
	clk[1] = in_b[21];
	clk[2] = 0x00;
	clk[3] = in_b[22] >> 2;
	clk[4] = in_b[22] & 0x03;
	clk[5] = in_b[23];

	line_count = (clk[4] << 8) | clk[5];
	switch ( line_count )
	{
	    case 1:
	    case 201:
	    case 401:
	    case 601:
		break;
	    default:
		clk[4] = 0x00;
		clk[5] = 0x01;
	}

	/* skip if duplicates */
	if ( !memcmp(clk, o_clk, 6) )
	{
puts("DUPLICATE");
	    memcpy( o_clk, clk, 6 );
	    continue;
	}
	memcpy( o_clk, clk, 6 );

/*
	Start writing
*/

	fwrite( label, 1, sizeof(label), out_fd );
	fwrite( aggr_chdo, 1, sizeof(aggr_chdo), out_fd );
	fwrite( primary, 1, sizeof(primary), out_fd );

/*
	// ---- sc id 
*/
	if ( (in_b[0]&0x07) == 0x1 )
	    secondary[6] = 0x1f;
	else
	    secondary[6] = 0x20;

	fwrite( secondary, 1, sizeof(secondary), out_fd );

/*
	// ---- Set Year
*/
	mtstime[0] = 0x00;
	mtstime[1] = in_b[38];

/*
	// ---- ERT 
*/
	memcpy( &mtstime[2], &in_b[14], 4 );
	cvt_mtstime( sfoc_time, mtstime );
	fwrite( sfoc_time, 1, sizeof(sfoc_time), out_fd );

/*
	// ---- Finish Secondary
*/
	memset( b, 0x00, sizeof(b) );

/*
	// ---- rate
*/
	switch ( (unsigned char)(in_b[3] & 0x18) >> 3 ) 
	{
	    case 0x00:
		b[21] = 0x0a;
		break;
	    case 0x01:
		b[21] = 0x28;
		break;
	    case 0x02:
		b[20] = 0x04;
		b[21] = 0xb0;
		break;
	    case 0x03:
		b[20] = 0x1c;
		b[21] = 0x20;
		break;
	    default:
		b[21] = 0x0a;
	}

	fwrite( b, 1, 22, out_fd );
	memset( b, 0x00, sizeof(b) );
	fwrite( b, 1, 46, out_fd );

/*
	// ---- Tert
*/
	fwrite( tert, 1, sizeof(tert), out_fd );

	fwrite( clk, 1, 6, out_fd );

/*
	// ---- SCET 
*/
	memcpy( &mtstime[2], &in_b[24], 4 );
	cvt_mtstime( sfoc_time, mtstime );
	fwrite( sfoc_time, 1, sizeof(sfoc_time), out_fd );
	
	memset( b, 0x00, sizeof(b) );
	fwrite( b, 1, 8, out_fd );

/*
	// ---- Quat
*/
	fwrite( quat, 1, sizeof(quat), out_fd );
	fwrite( data_chdo, 1, sizeof(data_chdo), out_fd );

/*
	// ---- Now do Data 
*/
	memset( b, 0x00, sizeof(b) );
	do_data( b, &in_b[72] );
	fwrite( b, 1, 224, out_fd );

    }

    if ( ferror(in_fd) )
	perror("problem with input file");

    fclose( in_fd );
    fclose( out_fd );
    
}

/* ----------------------------------- */
void do_data( unsigned char b[], unsigned char in_b[] )
{
    int i;
    int chn_cntr;
    int left_to_do;
    unsigned char valid;


    chn_cntr = 0;

    for (i=0; i<60; i++)
    {
	valid = (unsigned char)(in_b[i*4] & 0x20) >> 5;

	if ( !valid )
	{
	    b[chn_cntr*4] = 0x2c;
	    b[(chn_cntr*4)+1] = in_b[(i*4)+1];
	    b[(chn_cntr*4)+2] = in_b[(i*4)+2] & 0x03;
	    b[(chn_cntr*4)+3] = in_b[(i*4)+3];
	    chn_cntr++;
	}
    }

    left_to_do = 56-chn_cntr;
    if (left_to_do < 0)
	left_to_do = 0;

    /* fill to end */
    for (i=0; i<left_to_do; i++)
    {
	b[chn_cntr*4] = 0x20;
	b[(chn_cntr*4)+1] = 0x03;
	b[(chn_cntr*4)+2] = 0x00;
	b[(chn_cntr*4)+3] = 0x00;
	chn_cntr++;

	if (chn_cntr >= 56 )
	    break;
    }
}

