#!/bin/csh 
# optional argument -x to list lines
#
# execute this script in the directory where data is
#
# usage: proc_weekly data.pl YRDOY sc_abbrev
# YRDOY - 21203
# sc_abbrev a=VBGR-1 b=VGR-2
#
# process weekly data after runs of:
#  test_axd0_f.csh, test_axd1_f.csh and/or test_axd10_f.csh
# to get number/type of records in edr data
#
#
# 4-10-2022 - Ray Bambery - initial release
# 4-14-2022 - Ray Bambery - change if ($sc == "a") to  if ($sc == "b")
# $#argv is total number of arguments
# ${0} = name of shell script
#
if ($#argv == 0) then
    echo "usage: ${0} input YRDOY sc_abbrev (a or b)"
    exit 
endif
if ($#argv < 2) then
    echo "missing sc_abbrev (a or b)"
    exit 
endif
set yd = ${1}
set sc = ${2}
set dot = "."

echo " YRDOY.sc_abbrev = $yd$dot$sc"


od -xv crsf$yd$dot$sc > crsf$yd$dot$sc.hex
edr_recid.pl ./ ./ crsf$yd$dot$sc.hex crsf$yd$dot$sc.hexrecid hex > crsf$yd$dot$sc.hexrecid.list 

od -xv lecf$yd$dot$sc > lecf$yd$dot$sc.hex
edr_recid.pl ./ ./ lecf$yd$dot$sc.hex lecf$yd$dot$sc.hexrecid hex > lecf$yd$dot$sc.hexrecid.list

od -xv magf$yd$dot$sc > magf$yd$dot$sc.hex
edr_recid.pl ./ ./ magf$yd$dot$sc.hex magf$yd$dot$sc.hexrecid hex > magf$yd$dot$sc.hexrecid.list

if ($sc == "b") then
    od -xv plsf$yd$dot$sc > plsf$yd$dot$sc.hex
    edr_recid.pl ./ ./ plsf$yd$dot$sc.hex plsf$yd$dot$sc.hexrecid hex > plsf$yd$dot$sc.hexrecid.list
endif

od -xv pwsf$yd$dot$sc > pwsf$yd$dot$sc.hex
edr_recid.pl ./ ./ pwsf$yd$dot$sc.hex pwsf$yd$dot$sc.hexrecid hex > pwsf$yd$dot$sc.hexrecid.list

od -xv engf$yd$dot$sc > engf$yd$dot$sc.hex
edr_recid.pl ./ ./ engf$yd$dot$sc.hex engf$yd$dot$sc.hexrecid hex > engf$yd$dot$sc.hexrecid.list


