#!/usr/bin/perl -w
##
$perlproc = "sfdu2_map.pl";
# 
#
#       - RJB - Mar 25, 2021 - initial release
#       - RJB - Mar 29, 2021 - realign 196 byte data CHDO and allow oct format
#       - RJB - Dec 09, 2021 - Add test to see if byte reversed data
#       - RJB - Feb 07, 2022 - add GS-10 mode
#
#  usage: sfdu2_map.pl src_dir dest_dir edr_file edr_map_file  format
#
#   Program to create a fully commented record in a file created from the output
#   of program od on a Voyager telemetry sfdu2 file.
#  
#   Environment variables:
#    <none>
#
#   Input:
#       The output of a unix od command of an sfdu2 file
#
#   Output:
#       the first record of an sfdu2 with comments
#
use warnings;
use Env;
use POSIX qw(uname);
use Term::ANSIColor;
#use Number::Convert;
#
#  PARAMETER PROCESSOR
#
$argCount = scalar @ARGV;
if (($argCount eq 0)) {
    print color ("blue"), "\n";
    print "\n";
    print "    usage: $perlproc src_dir dest_dir   sfdu2_file             sfdu2_map_file       format\n";
    print "            Ex:       ./       ./      datafile20350.b.hex    datafile20350.b.hexmap    hex \n";
    print "\n";
    print "Separate the records in a file created from the output of od on a Voyager sfdu2 file\n";
    print "\n";
    print "\n", color("reset");
    exit(0);
}
if (($argCount == 1)) {
    if ($ARGV[0] =~ /-h/i || $ARGV[0] =~ /help/i || $ARGV[0] =~ /\?/i) {
        print color ("blue"), "\n";
        print "    Voyager Project program to Separate the records in a file created from the output of od on a Voyager sfdu2 file\n";
        print "\n";
        print "    usage: $perlproc src_dir dest_dir   sfdu2_file         sfdu2_map_file           format\n";
        print "            Ex:       ./       ./    datafile20350.b.hex    datafile20350.b.hexmap    hex \n";
        print "\n";
        print "where:\n";
        print "     src_dir is location of input od dump file \n";
        print "     dest_dir is where data is processed and products created\n";
        print "     sfdu2_file is the name of input od dump file \n";
        print "     sfdu2_map_file is the name of the output file with the record mapped\n";
        print "     format is the internal format produced by command od\n";
        print "           byte or oct = octal byte format from command 'od -b'";
        print "           hex  = hex byte format from command 'od -x'";
        print "\n";
        print "\n", color("reset");
        exit;
    }
}
if ($argCount < 5) {
    print color ("red"), "\n";
    print "\n";
    print "Did you forget something?\n\n", color("reset");
    exit(1);
}

#**
##** DECLARATIONS:
##**
#
$byte = "byte";
#$data_hdr = 240;  #bytes
$data_rec = "   Rec ";
#$header = "   Header";
$hex = "hex";
$magic_hex = "4e4a";            # "NJ"  #next 2 bytes  504c";
$rev_magic_hex = "4a4e";       # "PN" 
$magic_byte = "116 112";        #120 114" next 2 bytes;   #"NJPL"
$rev_magic_byte = "112 116";    # "PN"
$oct = "oct";
#$rec ="   Rec ";
$return = "\n";
#
#**
##**  ENVIRONMENT
##**
#
##print "ARGV[0] = $ARGV[0]\n";          #src dir
##print "ARGV[1] = $ARGV[1]\n";          #dest dir
##print "ARGV[2] = $ARGV[2]\n";          #edr_file 
##print "ARGV[3] = $ARGV[3]\n";          #edr_mod_file file extension
##print "ARGV[4] = $ARGV[4]\n";          #byte or hex
#
$destpath = $ARGV[1];

if (-d $destpath) {
    #
} else {
    print color ("red"), "      ??E destpath = $destpath does NOT exist\n", color("reset");
    exit(1);
}

my @name = split ( //,$ARGV[2] );
my $instr = join ( "",$name[0],$name[1],$name[2] );
# print "instr = $instr\n";
my $format = $ARGV[4];

if ($format =~ m/byte/ || $format =~ m/hex/ || $format =~ m/oct/) {
#
    $destpath = $ARGV[1];
} else {
    print color ("red"), "      ??E format not byte, oct or hex";
     print "\n", color("reset");
}

# open that file and find magic 
my $magic_num = 0;          #number of total records
my $eng_num = 0;            #number of engineering records
my $tot_rec = 0;            # total record count
$cur = "000000";
$outfile = $ARGV[3];
open(INFILE,"$ARGV[2]") || die "Cannot find INFILE: $ARGV[2]\n";
open(OUTFILE,">$outfile") || die "Cannot open OUTFILE: $outfile\n";

print OUTFILE "Documented in 820-013_0182-Telecomm-VGR Rev F Jun 23, 1011 \n";
print OUTFILE "SFDUs Generated from TIS for Voyager\n";
print OUTFILE "Table 4-1: Voyager Record Sizes\n";
print OUTFILE "Also 618-690 - Detailed Processing Requirements Voyager Adaptation,SFOC, Telemetry\n"; 
print OUTFILE "Vol 1 - Front_End Processing GCF/Frame Synchronization/Extraction, Apr 15, 1990\n";
print OUTFILE "\n";
print OUTFILE " Header field - 20 bytes\n";
print OUTFILE "Bytes 1-4 - Project ID: ASCII 'NJPL'\n";
print OUTFILE "Bytes 9-12 - ASCII C220 = CR_5A mode,  C221 = UV_5A mode C224 = GS-10 mode \n";
print OUTFILE "         C220 (hex) = 4332 3230    C221 (hex) = 4332 3231     C224 (hex) = 4332 3234\n";
if ($format =~ "byte") {
    print OUTFILE " Aggregation CHDO - 4 bytes - bytes 1,2 = 000 001\n";
    print OUTFILE " Primary CHDO - 8 bytes - bytes 1,2 = 000 002\n";
    print OUTFILE " Secondary CHDO - 84 bytes -  bytes 1,2 = 000 017 (15-TIS Telemetry - Table 4.2.1.2)\n";
    print OUTFILE " Tertiary CHDO - 30 bytes - bytes 1,2 = 000 062 (50 Voyager Telemetry - Table 4.2.1.3)\n";
    print OUTFILE " Quaternary CHDO - 16 bytes - bytes 1,2 = 000 065 (53 Voyager Science-GS&E Cruise - Table 4.2.1.4.2)\n";
    print OUTFILE " Data CHDO - 196 bytes - bytes 1,2 = 000 012 (10 Voyager Data CR_5A - Table 4.2.1.5.1)\n"; 
} else {
    print OUTFILE " Aggregation CHDO - 4 bytes - bytes 1,2 = 0001\n";
    print OUTFILE " Primary CHDO - 8 bytes- bytes 1,2 = 0002\n";
    print OUTFILE " Secondary CHDO - 84 bytes-  bytes 1,2 = 000f (15-TIS Telemetry - Table 4.2.1.2)\n";
    print OUTFILE " Tertiary CHDO - 30 bytes - bytes 1,2 = 0032 (50 Voyager Telemetry- Table 4.2.1.3)\n";
    print OUTFILE " Quaternary CHDO - 16 bytes - bytes 1,2 = 0035 (53 Voyager Science-GS&E Cruise - Table 4.2.1.4.2)\n";
    print OUTFILE " Data - 196 bytes - bytes 1,2 = 000a (10 Voyager Data CR_5A Table 4.2.1.5)\n";
}
print OUTFILE "\n";
print OUTFILE " Data breakout from 820-013_182-Telecomm-VGR - Table 4.2.1.5 - 196 bytes\n";
print OUTFILE "   CR_5A IDF (Instrument Data Frame) - Sec 4.2.1.5.1 (p4-38)\n";
print OUTFILE "   ENG TLM Format      4.2.1.5.18 (p4-67)\n";
print OUTFILE "   CMD Format      \n";
print OUTFILE "   UVS/STAT IDF Format  4.2.1.6.1.7 (p4-83)\n";
print OUTFILE "   MAG IDF Format       4.2.1.6.1.3 (p4-78)\n";
print OUTFILE "   CRS IDF Format       4.2.1.6.1.1 (p4-76)\n";
print OUTFILE "   PLS IDF Format       4.2.1.6.1.4 (p4-79)\n";
print OUTFILE "   LECP IDF Format      4.2.1.6.1.2 (p4-77)\n";
print OUTFILE "   PRA IDF Format       4.2.1.6.1.5 (p4-80)\n";
print OUTFILE "   PWS IDF Format       4.2.1.6.1.6 (p4-82)\n";
print OUTFILE "\n";

$rec_rdr = 0;
LINEA: while (<INFILE>) {
    chop;
    $line = $_;
    $skip = 0;
    @find = split (/\s+/, $line);           #split on spacea
    if ($find[1] =~ $rev_magic_hex && $format =~ m/$hex/ ) {
        print color ("red"), "\n";
        print "DATA SET is Byte reversed\n";
        print "PLEASE run byteswap program\n\n", color("reset");
        exit;
    }

   if ($find[1] =~ $rev_magic_byte && $format =~ m/$byte/ ) {
        print color ("red"), "\n";
        print "DATA SET is Byte reversed\n";
        print "PLEASE run byteswap program\n\n", color("reset");
        exit;
    }
 $cur = $find[0];
#    print OUTFILE "$line\n";
#    print OUTFILE "crs_cnt = $crs_cnt cur = $cur\n";
   if ($format =~ m/$hex/ ) {
        $rec_rdr++;
        $magic_num++;
        @next = split( /\s+/,$line);     #split on spaces
# if magic_hex then process
        if ($line =~ m/$magic_hex/ ) {
            $skip = 0;
            @find = split( /$magic_hex/, $line );
            $nn = @find;
            if ($find[0] =~ "0000000") {
                @next = split( /\s+/,$find[1]);     #split on spaces
                $ctr = $magic_num;
                $recid = $data_rec;
                $posit = index($line,$magic_hex);
                $filler = " "x$posit;
                $filler = " ";
                $outline = "$line$recid$ctr\n";   #"2>$outline" (PRINTS)
                print OUTFILE $outline;
                next LINEA;
            }
         }
         if ($find[0] =~ "0000020") {    
                $posit = index($line,$magic_hex);
                $filler = " "x$posit;
                $filler = " ";
                $filler2 =  "                  ";
                $filler2a = "                     ";
                $filler3 = "                            ";
                $filler4 = "                               ";
                $hdr20 = " = 20 byte HDR";
                $aggr4 = " = 4 byte aggreg CHDO";
                $prim8 = " = 8 byte primary CHDO";
                $hdr_end = "$find[0]$filler$next[1]$filler$next[2]$filler4$hdr20";
                $aggrg = "$filler2$next[3]$filler$next[4]$filler2a$aggr4";
                $primary = "$filler3$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$filler$prim8\n";
                $outline = "$hdr_end$return$aggrg$return$primary";   #"2>$outline" (PRINTS)
                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000040") {
                $filler = " ";
                $sec84 = " = 84 byte secondary CHDO";
                $outline = "$line$filler$sec84$return";
                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000160") {
                $filler = " ";
                $filler2 = "                  ";
                $sec_end = "$find[0]$filler$next[1]$filler$next[2]";
                $tert = " = 30 byte tertiary CHDO";
                $line_end = "$next[3]$filler$next[4]$filler$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$filler";
                $outline = "$sec_end$return$filler2$line_end$tert$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000220") {
                $filler = " ";
                $filler2 = "             ";
                $quat = " = 16 byte quaternary CHDO";
                $tert_end = "$find[0]$filler$next[1]";
                $line_end = "$next[2]$filler$next[3]$filler$next[4]$filler$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$filler";
                $outline = "$tert_end$return$filler2$line_end$quat$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000240") {
                $chdo1 = "    = CHDO Type = 10";
                $chdo2 = "    = CHDO length = (192+4)";
                $chdo3 = "    = Sync Word = 03915ed3";
                $chdo4 = "    = FID = xF6 (VGR-2)";
                $chdo5 = "    = Other Total = 12-bytes";
               $filler = " ";
                $filler2 = "             ";
                $filler3 = "                  ";
                $filler4 = "                      ";
                $filler5 = "                                 ";
                $filler6 = "                                   ";
                $filler7 = "                                      ";
                $filler8 = "                                           ";
                $filler9 = "                            ";
                $filler10= "                       ";
                $filler11= "              ";
                $filler12= "          ";
                $filler13= "   ";
                $dataq = "===============================================  = 196 byte data CHDO (Fig 5.7)";
                $quat_end = "$find[0]$filler$next[1]";
                $line_end1 = "$next[2]$filler9$chdo1";
                $line_end2 = "$next[3]$filler10$chdo2";
                $line_end3 = "$next[4]$filler$next[5]$filler11$chdo3";
#                $line_end4 = "$filler$next[6]$filler$next[7]$filler$next[8]$filler";
                @b1      = split ( //,$next[6]);
                $combo1  = "$quat_end$return$dataq$return$filler2$line_end1$return$filler3$line_end2$return";
                $combo2  = "$filler4$line_end3$return$filler5$b1[0]$b1[1]$filler12$chdo4$return";
                $combo3  = "$filler6$b1[2]$b1[3]$return";
                $combo4  = "$filler7$next[7]$filler13$chdo5$return";
                $combo5  = "$filler8$next[8]$return";
                $outline = "$combo1$combo2$combo3$combo4$combo5";

                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000260") {
                $eng1 = "    = ENG (12-bytes)";
                $cmd1 = "    = CMD (2-bytes)";
                $filler = " ";
                $filler2 = "                                 ";
                $filler3 = "                                      ";
                $filler4 = "             ";
                $filler5 = "        ";
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]$filler$next[5]$filler4$eng1$return"; 
                $line_end2 = "$filler2$next[6]$filler5$cmd1$return$filler3$next[7]$filler$next[8]$return";
                $outline = "$line_end1$line_end2";
                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000300") {
                $uvs1 = "    = UVS/STAT (6-bytes=48-bits)";
                $filler = " ";
                $filler2 = "             ";
                $filler3 = "                                 ";
                $line_end1 = "$find[0]$filler$next[1]$filler3$uvs1$return";
                $line_end2 = "$filler2$next[2]$filler$next[3]$filler$next[4]$filler$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$return";
                $outline = "$line_end1$line_end2";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000360") {
                $mag1 = "    = MAG (51-bytes=408-bits)";
                
                $filler = " ";
                $filler2 = "                    ";
                $filler3 = "                         ";
                @b1      = split ( //,$next[3]);
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler$b1[0]$b1[1]$filler3$mag1$return";
                $line_end2 = "$filler2$b1[2]$b1[3]$filler$next[4]$filler$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$return";
                $outline = "$line_end1$line_end2";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000420") {
                $crs1 = "   = CRS (39-bytes=312-bits)";
                $filler = " ";
                $filler2 = "                                      ";
                $filler3 = "         ";
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]";
                $line_end2 = "$filler$next[5]$filler$next[6]$filler3$crs1$return$filler2$next[7]$filler$next[8]$return";
                $outline = "$line_end1$line_end2";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000440") {
                $pls1  = " = PLS (20-bytes-160-bits)";
                $filler = " ";
                $filler2 = "             ";
                $filler3 = "                                 ";
                $outline = "$line$filler$pls1$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000460") {
                $lecp1  = "  = LECP (16-bytes=128-bits)";
                $filler = " ";
                $filler2 = "                ";
                $filler3 = "  ";
                $outline = "$line$lecp1$return";
                print OUTFILE $outline;
                next LINEA;

         }

         if ($find[0] =~ "0000500") {
                $pra1 = "    = PRA (7-bytes=56-bits)";
                @b1      = split ( //,$next[4]);
                $filler = " ";
                $filler2 = "          ";
                $filler3 = "                         ";
                $filler4 = "                                   ";
                $filler5 = "                    ";
                $line_end1 = "$find[0]$filler$next[1]";
                $line_end2 = "$filler$next[2]$filler$next[3]$filler$b1[0]$b1[1]$filler5$pra1$return";
                $line_end3 = "$filler3$b1[2]$b1[3]$filler$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$return";
                $outline = "$line_end1$line_end2$line_end3";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000520") {
                $pws1 = "    = PWS (11-bytes-88-bits)";
                $filler = " ";
                $filler2 = "             ";
                $filler3 = "                                 ";
                $line_end1 = "$find[0]$filler$next[1]$filler3$pws1$return";
                $line_end2 = "$filler2$next[2]$filler$next[3]$filler$next[4]$filler";
                $line_end3 = "$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$return";
                $outline = "$line_end1$line_end2$line_end3";
                print OUTFILE $outline;
                next LINEA;

         }

         if ($find[0] =~ "0000540") {
                $fill = "   = Fill (20-bytes)";
                $filler = " ";
                $filler2 = "                       ";
                $filler3 = "                                                ";
                $trailer = " = 358 bytes per record";
                $data_end = "$find[0]$filler2";
                $outline = "$data_end$fill$return$filler3$trailer$return";
                print OUTFILE $outline;
                exit; #if ($magic_num == 2);
         }
#        print OUTFILE ">$line$return";
        exit if ($magic_num == 2);
     }   # end if hex

     if ($format =~ m/$byte/ || $format =~ m/$oct/) {
#        print "BYTE\n";
        $rec_rdr++; 
        $magic_num++;
        @next = split( /\s+/,$line);     #split on spaces
#        print "line = $line\n";
        if ($line =~ m/$magic_byte/ ) {
#            print "MAGIC_BYTE\n";
                @find = split (/$magic_byte/, $line);
                $nn = @find;
                if ($find[0] =~ "0000000") {
                    @next = split( /\s+/,$find[1]);     #split on spaces
                    $ctr = $magic_num;
                    $recid = $data_rec;

                    $posit = index($line,$magic_hex);
                    $filler = " "x$posit;
                    $filler = " ";
                    $outline = "$line$recid$ctr\n";   #"2>$outline" (PRINTS)
                    print OUTFILE $outline;
                    next LINEA;
                }
         }  #if magic_byte
         if ($find[0] =~ "0000020") {    
                $posit = index($line,$magic_byte);
                $filler = " "x$posit;
                $filler = " ";
                $filler2 =  "                        ";
                $filler2a = "                                  ";
                $filler3 = "                                        ";
                $filler4 = "                                                  ";
                $hdr20 = " = 20 byte HDR";
                $aggr4 = " = 4 byte aggreg CHDO";
                $prim8 = " = 8 byte primary CHDO";
                $hdr_end = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]$filler4$hdr20";
                $aggrg = "$filler2$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$filler2a$aggr4";
                $primary1 = "$filler3$next[9]$filler$next[10]$filler$next[11]$filler$next[12]$filler$next[13]";
                $primary2 = "$filler$next[14]$filler$next[15]$filler$next[16]$filler$filler$prim8\n";
                $outline = "$hdr_end$return$aggrg$return$primary1$primary2";   #"2>$outline" (PRINTS)
                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000040") {
                $filler = " ";
                $sec84 = " = 84 byte secondary CHDO";
                $outline = "$line$filler$filler$sec84$return";
                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000160") {
                $filler = " ";
                $filler2 = "                        ";
                $sec_end = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]";
                $tert = " = 30 byte tertiary CHDO";
                $line_end1 = "$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$filler$next[9]$filler$next[10]$filler$next[11]";
                $line_end2 = "$filler$next[12]$filler$next[13]$filler$next[14]$filler$next[15]$filler$next[16]$filler$filler";
                $outline = "$sec_end$return$filler2$line_end1$line_end2$tert$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000220") {
                $filler = " ";
                $filler2 = "                        ";
                $quat = " = 16 byte quaternary CHDO";
                $tert_end = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]";
                $line_end1 = "$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$filler$filler$next[9]$filler$next[10]$filler$next[11]";
                $line_end2 = "$next[12]$filler$next[13]$filler$next[14]$filler$next[15]$filler$next[16]$filler$filler";
                $outline = "$tert_end$return$filler2$line_end1$line_end2$quat$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000240") {
                $chdo1 = "    = CHDO Type = 10";
                $chdo2 = "    = CHDO length = (192+4)";
                $chdo3 = "    = Sync Word = 003221136323";
                $chdo4 = "    = FID = 366 (VGR-2)";
                $chdo5 = "    = Other Total = 12-bytes";
                $filler = " ";  #X
                $filler2 = "                ";    #X
                $filler3 = "                       ";   #X
                $filler4 = "                                "; #X
                $filler5 = "                                             "; #X
                $filler6 = "                                    "; #X
                $filler7 = "                     ";  #X
                $filler8 = "                                                        ";
                $filler9 = "                 ";
                $filler10= "                       ";
                $filler11= "     ";
                $filler12= "                         ";    #X
                $filler13= "                                                    ";
                $filler14= "                                                                ";               
                $dataq = "======================================================================  = 196 byte data CHDO (Fig 5.7)";
                $quat_end = "$find[0]$filler$next[1]$filler$next[2]";
                $line_end1 = "$next[3]$filler$next[4]$filler5$chdo1";

                $line_end2 = "$filler$next[5]$filler$next[6]$filler";
                $line_end2a = "$filler6$chdo2";
                $line_end3 = "$next[7]$filler$next[8]$filler$next[9]$filler$next[10]$filler7$chdo3";
                $line_end3a= "$filler12$next[11]$filler9$chdo4$return";
                $line_end3b="$filler13$next[12]$return";
                $line_end4 = "$next[13]$filler$next[14]$filler11$chdo5";
                $combo1  = "$quat_end$return$dataq$return$filler2$line_end1$return$filler3$line_end2$line_end2a$return";
                $combo2  = "$filler4$line_end3$return$filler10$line_end3a";
                $combo3  = "$line_end3b$filler8$line_end4$return";
                $combo4  = "$filler14$next[15]$filler$next[16]$return";
                $outline = "$combo1$combo2$combo3$combo4";

                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000260") {
                $eng1 = "    = ENG (12-bytes)";
                $cmd1 = "    = CMD (2-bytes)";
                $filler = " ";
                $filler2 = "                                                                ";
                $filler3 = "                                                ";
                $filler4 = "             ";
                $filler5 = "                     ";
                $filler6 = "             ";
                $filler7 = "                                                        ";
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]$filler$next[5]";
                $line_end2 = "$filler$next[6]$filler$next[7]$filler$next[8]";
                $line_end3 = "$filler$next[9]$filler$next[10]$filler5$eng1$return";
                $line_end3b= "$filler3$next[11]$filler$next[12]$filler6$cmd1$return";
                $line_end3c= "$filler7$next[13]$filler$next[14]";
                $line_end4 = "$filler$next[15]$filler$next[16]$return";
 

               $outline = "$line_end1$line_end2$line_end3$line_end3b$line_end3c$line_end4";
                print OUTFILE $outline;
                next LINEA;
         }
         if ($find[0] =~ "0000300") {
                $uvs1 = "    = UVS/STAT (6-bytes=48-bits)";
                $filler = " ";
                $filler2 = "                ";
                $filler3 = "                                                     ";
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler3$uvs1$return";
                $line_end2 = "$filler2$next[3]$filler$next[4]$filler$next[5]$filler$next[6]$filler$next[7]$filler$next[8]$filler$next[9]$filler$next[10]";
                $line_end3 = "$filler$next[11]$filler$next[12]$filler$next[13]$filler$next[14]$filler$next[15]$filler$next[16]";
                $outline = "$line_end1$line_end2$line_end3$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000360") {
                $mag1 = "    = MAG (51-bytes=408-bits)";
                $filler = " ";
                $filler2 = "                                        ";
                $filler3 = "                                         ";
                $filler4 = "                            "; 
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]$filler$next[5]";
                $line_end2 = "$filler3$mag1$return";
                $line_end2b= "$filler4$next[6]$filler$next[7]$filler$next[8]";
                $line_end3 = "$filler$next[9]$filler$next[10]$filler$next[11]$filler$next[12]";
                $line_end4 = "$filler$next[13]$filler$next[14]$filler$next[15]$filler$next[16]$return";
                $outline = "$line_end1$line_end2$line_end2b$line_end3$line_end4";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000420") {
                $crs1 = "   = CRS (39-bytes=312-bits)";
                $filler = " ";
                $filler2 = "                                                        ";
                $filler3 = "              ";
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler$next[3]$filler$next[4]";
                $line_end2 = "$filler$next[5]$filler$next[6]$filler$next[7]$filler$next[8]";
                $line_end3 = "$filler$next[9]$filler$next[10]$filler$next[11]$filler$next[12]";
                $line_end4 = "$filler3$crs1$return$filler2$next[13]$filler$next[14]$filler$next[15]$filler$next[16]$return";
                $outline = "$line_end1$line_end2$line_end3$line_end4";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000440") {
                $pls1  = " = PLS (20-bytes-160-bits)";


                $outline = "$line$pls1$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000460") {
                $lecp1  = " = LECP (16-bytes=128-bits)";
                $filler = " ";
                $filler2 = "                ";
                $filler3 = "  ";
                $outline = "$line$lecp1$return";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000500") {
                $pra1 = "    = PRA (7-bytes=56-bits)";
                $filler = " ";
                $filler2 = "                                 ";
                $filler3 = "                                    ";
                $line_end1 = "$find[0]$filler$next[1]$filler";
                $line_end2 = "$next[2]$filler$next[3]$filler$next[4]";
                $line_end3 = "$filler$next[5]$filler$next[6]$filler$next[7]$filler2$pra1$return";
                $line_end4 = "$filler3$next[8]$filler$next[9]$filler$next[10]$filler$next[11]$filler$next[12]";
                $line_end5 = "$filler$next[13]$filler$next[14]$filler$next[15]$filler$next[16]$return";

                $outline = "$line_end1$line_end2$line_end3$line_end4$line_end5";
                print OUTFILE $outline;
                next LINEA;

         }
         if ($find[0] =~ "0000520") {
                $pws1 = "    = PWS (11-bytes-88-bits)";
                $filler = " ";
                $filler2 = "                ";
                $filler3 = "                                                     ";
                $line_end1 = "$find[0]$filler$next[1]$filler$next[2]$filler3$pws1$return";
                $line_end2 = "$filler2$next[3]$filler$next[4]$filler";
                $line_end3 = "$next[5]$filler$next[6]$filler$next[7]$filler$next[8]";
                $line_end4 = "$filler$next[9]$filler$next[10]$filler$next[11]$filler$next[12]";
                $line_end5 = "$filler$next[13]$filler$next[14]$filler$next[15]$filler$next[16]$return";

                $outline = "$line_end1$line_end2$line_end3$line_end4$line_end5";
                print OUTFILE $outline;
                next LINEA;

         }

         if ($find[0] =~ "0000540") {
                $filler = " ";
                $filler2 = "                                   ";
                $filler3 = "========================================================================";
                $ff = "    = Fill (20-bytes)";
                $trailer = "== 358 bytes per record";
                $data_end = "$find[0]$filler";
                $outline = "$data_end$filler2$ff$return$filler3$trailer$return";
                print OUTFILE $outline;
                exit; #if ($magic_num == 2);
         }

     }   # end if byte
     print OUTFILE "$line$return";
     exit if ($magic_num == 2);

#    
#  
#close (INFILE);
#close (OUTFILE);  
}

