#!/usr/bin/perl -w
#
$perlproc = "edr_recid.pl";
# 
#
#       - RJB - Nov 14, 2021 - initial release
#       - RJB - Nov 17, 2021 - removed debug prints
#       - RJB - Nov 23, 2021 - fix spcid for VGR-1 and VGR-2
#       - RJB - Nov 27, 2021 - merge algorithmic changeds from test_dbl.pl in edr_recid directory
#       - RJB - Nov 29, 2021 - finish mmerge
#       - RJB - Dec 09, 2021 -  Add test to see if byte reversed data
#                                Add test to see if byte format requested and abort if so
#       - RJB - Dec 13, 2021 - fix unitialize message
#       - RJB - Dec 23, 2021 - fix total record count and summary of number of records
#                              fix SCET calculation as in edrdump.f
#       - RJB - Dec 27, 2021   fix for position 18 to put lineno[1] for line2[1]
#                               fix login in computing shours and ssecs in sub &scet_time  
#       - RJB - Jun 06, 2022   print each recid in file instead of stdout
#
#  usage: edr_recid.pl src_dir dest_dir edr_file edr_reclist format
#
#   Program to list the record type in each record of 
#   of a Voyager EDR file.
#  
#   Environment variables:
#    <none>
#
#   Input:
#       Output from a unix od -xv command of an edr file
#
#   Output:
#       The resultant edr file with all records typed
#       a
#       0  0000000   1      DCOM         VGR-2      CR5A   2021-119T16:57:34:052
#       1  0001300   2      CRS          VGR-2      CR5A   2021-119T16:57:34:052
#       2  0010020   3      CRS          VGR-2      CR5A   2021-119T16:05:33:805
#       3  0016520   4      ENG          VGR-2      CR5A   2021-119T16:57:34:052
#       4  0026160   5      CRS          VGR-2      CR5A   2021-119T16:15:09:049
#
# 
#
use Env;
use POSIX qw(uname);
use Term::ANSIColor;
#use strict;
#use Math::Round ;
use warnings;

$argCount = scalar @ARGV;
if (($argCount eq 0)) {
    print color ("blue"), "\n";
    print "\n";
    print "    usage: $perlproc src_dir dest_dir    edr_file         edr_reclist       format\n";
    print "            Ex:       ./       ./      crs20350.b.hex    crs20350.b.hexrecs    hex \n";
    print "\n";
    print "List record type in all records of a Voyager EDR file\n";
    print "\n";
    print "\n", color("reset");
    exit(0);
}
if (($argCount == 1)) {
    if ($ARGV[0] =~ /-h/i || $ARGV[0] =~ /help/i || $ARGV[0] =~ /\?/i) {
        print color ("blue"), "\n";
        print "    Voyager Project program to RList record type in all records of a Voyager EDR file\n";
        print "\n";
        print "    usage: $perlproc src_dir dest_dir edr_file   edr_reclist format\n";
        print "                         [archive [work]       YYYY MM  DD  HH \n";
        print "\n";
        print "where:\n";
        print "     src_dir is location of input od dump file \n";
        print "     dest_dir is where data is processed and products created\n";
        print "     edr_file is sthe name of input od dump file \n";
        print "     edr_reclist  is the name of the output file with each record typed\n";
        print "     format is the internal format produced by command od\n";
        print "           byte = octal byte format fom command 'od -b'";
        print "           hex  = hex byte format from command 'od -x'";
        print "\n";
        print "\n", color("reset");
        exit;
    }
}
if ($argCount < 5) {
    print color ("red"), "\n";
    print "\n";
    print "Did you forget something?\n\n", color("reset");
    exit(1);
}
if ($ARGV[4] =~ lc("byte")) {
    print color ("red"), "\n";
    print "\n";
    print " Byte format is not supported yet\n\n", color("reset");
    exit(1);


}

#**
#** DECLARATIONS:
#**
#
#$byte = "byte";
#$data_rec = "   Data Rec ";
$decom1_rec = "Decom Tbl VGR-1";
$decom2_rec = "Decom Tbl VGR-2";
$eng_rec = "   Engineering Rec ";
#$header = "   Header";
$hex = "hex";
$magic_hex = "d4d1 e2";         #"MJS"
$rev_magic_hex = "d1d4";        #"JM"
#$magic_byte = "324 321 342";   #"MJS"
#$rev_magic_byte = "321 324";  #"JM"
#$rec ="   Rec "; 
$return = "\n";
$space3 = "   ";
$space6 = "      ";
#**
#**  ENVIRONMENT
#**
#
#print "ARGV[0] = $ARGV[0]\n";          #src dir
#print "ARGV[1] = $ARGV[1]\n";          #dest dir
#print "ARGV[2] = $ARGV[2]\n";          #edr_file 
#print "ARGV[3] = $ARGV[3]\n";          #edr_mod_file file extension
#print "ARGV[4] = $ARGV[4]\n";          #byte or hex
#
#
$destpath = $ARGV[1];

if (-d $destpath) {
    #
} else {
    print color ("red"), "      ??E destpath = $destpath does NOT exist\n", color("reset");
    exit(1);
}
my $format = $ARGV[4];

if ($format =~ m/byte/ || $format =~ m/hex/ ) {
# print "format = $format\n";
    if ($format =~ m/byte/ ) {
        print color ("red"), "      ??E Format byte not yet implemented\n", color("reset");
        exit(1); 
    }
} else {
    print color ("red"), "      ??E format not byte or hex";
     print "\n", color("reset");
    exit(1);
}


# extrct from EDR header
#   char                  prjebc[3];     //word 1     PRJID (31-8)        word 1      PROJECT IDENTIFICATION (MJS) 
#   unsigned int          exp_id:4;      //4-bits     RECID (7-4)         word 1      Record Indentification
#   unsigned int          scft_id:4;     //4-bits     SCID (3-0)          word 1      Spacecraft ID     
#   unsigned short int    file_sqnc  ;   //16-bits    PHREC (31-16)       word 2      Physical Record Number 
#   char                  sc_mode;       //8-bits     DMODE (15-8)        word 2      Data mode 
#
#  record id = 
#    618-306 - Rev D - Voyager Experiment Data Record Format  Specification  */
#   Change 5:  1 May 1989                                                  */
#    DRS DATA TYPE  - Table C-1 - item 217 word 60 - Bits 31-24              */
#
#   Byte 4 (1st 4 bits) Instrument ID: (HEX) 
#   10=crs, 20=pls, 30=lec, 40=mag, 70=pra, 80=pws, 90=uvs, b0=eng, f0=decom_tbl VGR2, f1=decom_tbl for VGR1
#
#   Byte 4: (2nd 4 bits) SC ID
#   Byte 6: Record number
#   Byte 7: Spacecraft Data Mode: (HEX)
#          18=CR_5A, 1D=UV_5A
#   Byte 24-25: SCET Hr - GMT Corresponding to first MF 
#   Byte 26-27: SCET Sec
#   Byte 28-29: SCET MSec
#   Byte 30: SCET Year - 2 digits
#
#  scet  (store_scet)     edr hdr word 7 - bits 31-0, word 8 bits 31-8  - bytes 17-20
#
@inst_ascii = ("   ","CRS ","    ","LECP","MAG ","PLS ","   ","PRA ","PWS ","UVS ","   ","ENG ","   ","   ","   ","DCOM");
# open that file and find magic 
my $magic_num = 0;          #number of total records
my $eng_num = 0;            #number of engineering records
my $decom1_num = 0;         #number of decomutation table records VGR-1
my $decom2_num = 0;         #number of decomutation table records VGRx-2
open(INFILE,"$ARGV[2]") || die "Cannot find INFILE: $ARGV[2]\n";
open(OUTFILE,">$ARGV[3]") || die "Cannot open OUTFILE: $ARGV[3]\n";

print OUTFILE "record Instrument  Spacecraft  Mode\n";
$i = 0;
$scet_cnt = 0;
LINEA: while (<INFILE>) {
    chop;
    $line = $_;
    @lineno  = split (/\s+/, $line);           #split on spaces
#    print "scet_cnt = $scet_cnt\n";
#    exit if ($scet_cnt == 10);
    if (defined($lineno[1])) {
        if ($lineno[1] =~ $rev_magic_hex ) {
            print color ("red"), "\n";
            print "DATA SET is Byte reversed\n";
            print "PLEASE run byteswap program\n\n", color("reset");
            exit;
        }
    }
#    next LINEA if($line =~ m/^\*/ );     # skip lines starting with *
    if ($format =~ m/$hex/ ) {
#       print "$lineno[0]\n";
       if ($line =~ m/$magic_hex/ ) {
            $magic_num++;
#       print "magic_num = $magic_num\n";
            $posit = index($line,$magic_hex);
            @find = split( /$magic_hex/, $line );       #separate using magic_hex
#            print "find[0] = $find[0]\n";
            @next = split( /\s+/,$find[1]);      #split on spaces
#            print "next[0] = $next[0] \n";           #second 2 bytes
            @lead = split ( /\s+/,$find[0]);
#            print "lead[0] = $lead[0] \n";           #second 2 bytes
            my @chs = split(//, $next[0]);
#            print "chs   $chs[0] $chs[1]  \n";
            $instid = $chs[0];                      #1st nibble
            $spcid = $chs[1];                       #2nd nibble
#            print "instid = $instid spcid = $spcid\n";
#            print "inst_ascii[1] = $inst_ascii[1]\n";
            $ninstid = $instid;
#            print "ninstid = $ninstid\n";
            if ($instid =~ "b") {$ninstid = 11};
            if ($instid =~ "f") {$ninstid = 15;};
#             print "inst_ascii = $inst_ascii[$ninstid]\n";
            $instrument = $inst_ascii[$ninstid];
#            print OUTFILE "spcid = $spcid\n";
            if ($spcid == "0") {$spc_ascii = "VGR-2";} else {$spc_ascii = "VGR-1"};
#            $rec_type = $next[0];
            $ctr = $magic_num;
            if ($next[0] =~ "f0") {$recid = $decom2_rec; $decom2_num++; $ctr = ""; $magic_num--;}
            if ($next[0] =~ "f1") {$recid = $decom1_rec; $decom1_num++; $ctr = ""; $magic_num--;}
            if ($instid =~ "b") {$recid = $eng_rec; $eng_num++; $ctr = $eng_num; $magic_num--;}
            if ($posit < 38) {
#                print "less than 38\n";
                my @chs2 = split(//, $next[2]);
#                print "chs2   $chs2[0] $chs2[1]      $chs2[2] $chs2[3]\n";
                $mode = "$chs2[0]$chs2[1]";
#                print "mode = $mode\n";
               $init_mode_ascii = "CR5A";
                if ($mode =~ "18") {$mode_ascii = "CR5A";}
                if ($mode =~ "1D") {$mode_ascii = "UV5A";}
#                print "mode_ascii = $mode_ascii\n";
                if ($magic_num == 0) {$init_mode_ascii = $mode_ascii;} 
            } else {
                $mode_ascii = $init_mode_ascii;
            }
            $i++; 
            $outline = "$i$space6$instrument$space6$space3$spc_ascii$space6$mode_ascii"; 
#            print  "$outline$return";;
            $flag = 1;
            $flag18 = 0;
            $flag28 = 0;
            $flag38 = 0;
#            print "$i ::  $line\n";
            next LINEA;
        } elsif ($flag == 1) {
            if ($posit == 8) {                      ## GOOD  SCET is on 2nd line
                @line1 = split (" ",$line);
                @chr = split (//,$line1[8]);
#                print "8>> $line1[5] $line1[6] $line1[7] $chr[0]$chr[1]\n";
                $flag= 0;
                $temp = "$chr[0]$chr[1]";
                print "scet_cnt = $scet_cnt\n";
                ($scet_str[$scet_cnt]) = &scet_time ($posit,$line1[5],$line1[6],$line1[7],$temp);
###&                ($scet_str[$scet_cnt]) = &scet_time1 ($posit,$line1[5],$line1[6],$line1[7],$temp);

#//                $scet_str[$scet_cnt] = "$scet_cnt = $lead[0]:   $line1[5] $line1[6] $line1[7] $chr[0]$chr[1]";
                $scet_str[$scet_cnt] = "$lead[0]$space3$outline$space3$scet_str[$scet_cnt]";
                $scet_cnt++;
            }
            if ($posit == 18) {                     ## GOOD  SCET is on 2nd and 3rd lines
                if ($flag18 == 0) {
#                    print "=========>  $posit :: = $lead[0]\n";
                    $flag18++;
                    next LINEA if ($flag18 > 3);
#//                print "====  flag18 == $flag18\n   #$line\n";
                }
                if ($flag18 == 1 ) {
                    @line2 = split (" ",$line);
#//                    print "18>> $line2[7] $line2[8]\n";
                    $linex[0] = $line2[7];
                    $linex[1] = $line2[8];
#//                    $sc_str = "$line2[7] $line2[8]";
                    $flag18++;
                    next LINEA;
                }
                if ($flag18 == 2) {
                    @chr2 = split (//,$line2[2]);
                    $temp = "$chr2[0]$chr2[1]";
#                    print "lineno[1] = $lineno[1]\n";
                    print "scet_cnt = $scet_cnt\n";
                    ($scet_str[$scet_cnt]) =  &scet_time ($posit,$linex[0],$linex[1],$lineno[1],$temp);
###&                    ($scet_str[$scet_cnt]) = &scet_time1 ($posit,$line1[5],$line1[6],$line1[7],$temp);
#//                    $scet_str[$scet_cnt] = "$scet_cnt = $lead[0]:  $sc_str $line2[1] $chr2[0]$chr2[1]";
                    $scet_str[$scet_cnt] = "$lead[0]$space3$outline$space3$scet_str[$scet_cnt]";

                    $scet_cnt++;
                    $flag18 = 0;
                    $flag = 0;
                    next LINEA;
                }
            }
            if ($posit == 28) {
                if ($flag28 == 0 ) {
#                       print "========>  $posit ::  =  $lead[0]\n";
                        $flag28++;
                        next LINEA;
                }
                if ($flag28 == 1) {
#//                    print "28A>> flag28 = $flag28   $line\n";
                    @line1 = split (" ",$line);
                    @chr3 = split (//,$line1[4]);
                    $temp = "$chr3[0]$chr3[1]";
#                    print "28A>> $line1[1] $line1[2] $line1[3] $temp\n";
                    print "scet_cnt = $scet_cnt\n";
                    ($scet_str[$scet_cnt]) =  &scet_time ($posit,$line1[1],$line1[2],$line1[3],$temp);
#//                $scet_str[$scet_cnt] = "$scet_cnt = $lead[0]:  $line1[1] $line1[2] $line1[3] $chr3[0]$chr3[1]";
###&                    ($scet_str[$scet_cnt]) = &scet_time1 ($posit,$line1[5],$line1[6],$line1[7],$temp);
                    $scet_str[$scet_cnt] = "$lead[0]$space3$outline$space3$scet_str[$scet_cnt]";
                    $scet_cnt++;
                    $flag28 = 0;
                    $flag = 0;
                    next LINEA;
                }

            }
            if ($posit == 38) {
                if ($flag38 == 0) {
#                    print "========>  $posit :: = $lead[0]\n";
                    $flag38++;
                    next LINEA;
                }
                if ($flag38 == 1) {
#//                    print "38A>> flag38 = $flag38   $line\n";
                    @line1 = split (" ",$line);
                    @chr3 = split (//,$line1[6]);
#//                    print "38A>> $line1[3] $line1[4] $line1[5] $chr3[0]$chr3[1]\n";
                    $temp = "$chr3[0]$chr3[1]";
                    print "scet_cnt = $scet_cnt\n";
                    ($scet_str[$scet_cnt]) = &scet_time ($posit,$line1[3],$line1[4],$line1[5],$temp);
###&                    ($scet_str[$scet_cnt]) = &scet_time1 ($posit,$line1[5],$line1[6],$line1[7],$temp);
#//                 $scet_str[$scet_cnt] = "$scet_cnt = $lead[0]:  $line1[3] $line1[4] $line1[5] $chr3[0]$chr3[1]";
                    $scet_str[$scet_cnt] = "$lead[0]$space3$outline$space3$scet_str[$scet_cnt]";
                    $scet_cnt++;
                    $flag38 = 0;
                    $flag = 0;
                    next LINEA;
                }
          }
#        next LINEA ;
       } else {
        $flag = 0;
        next LINEA;
#        print "   LINEA  \n";
#
       }
   }
}
print "END\n";
print "Number of data records   = $magic_num\n";
print "Number of Header records = 1\n";
print "Number of Engineering records = $eng_num\n";
$decom_num = $decom1_num + $decom2_num;
print "Number of Decomutation records = $decom_num \n";
$tr = $magic_num + $eng_num + $decom_num;
print "TOTAL Records = $tr\n";
print OUTFILE "Number of data records   = $magic_num\n";
print OUTFILE "Number of Header records = 1\n";
print OUTFILE "Number of Engineering records = $eng_num\n";
print OUTFILE  "Number of Decomutation records = $decom_num \n";
print OUTFILE  "TOTAL Records = $tr\n";
close (INFILE);
#close (OUTFILE);

FIN:
    for ($ii=0;$ii < $tr; $ii++) {
        print "$ii  $scet_str[$ii]\n";
        print OUTFILE "$ii  $scet_str[$ii]\n";
    }

close (OUTFILE);
print "END2\n";

# FORGET OCTAL FOR NOW - Nov 29, 2021
#
#     if ($format =~ m/$byte/ ) { 
#         if ($line =~ m/$magic_byte/ ) { 
#                $magic_num++; 
#                @find = split (/$magic_byte/, $line);
##                print "find[0] = $find[0]\n";
##                print "find[1] = $find[1]\n";
#                $rec_type = $find[1];
#                $ctr = $magic_num;
#                $recid = $data_rec;
#                if ($rec_type =~ "360") {$recid = $header; $ctr = ""; $magic_num--;}
#                if ($rec_type =~ "260") {$recid = $eng_rec; $eng_num++; $ctr = $eng_num; $magic_num--;}
#                my $posit = index($line,$magic_byte);
#                my $filler = " "x$posit;
#                $outline = "$find[0]$return$filler$magic_byte$find[1]$recid$ctr\n";
#                print OUTFILE $outline;
#         } else {
#            $outline = "$line$return";
#            print OUTFILE $outline;
#         }
#     }
#        exit if ($magic_num == 4);
#}
##################################################################################################
#   SUBROUTINES
#################################################################################################a
#  This subroutine deleted 12-27-2021

sub scet_time1 {
    ($posit,$linesc[0],$linesc[1],$linesc[2],$scyr) = @_;
   
     print "scet_time1\n"; 
         $scet_hr = sprintf("%d", hex($linesc[0]));
         $scet_sec = sprintf("%d",hex($linesc[1]));
         $scet_msec = sprintf("%d",hex($linesc[2]));
         $scet_yr = sprintf ("%d",hex($scyr));
         $scet_cent = 20;
         if ($scet_yr > 70) {
            $scet_yr = 19;
         }
print ">>>>>scet_yr = $scet_cent$scet_yr\n";
print ">>>>>scet_hr = $scet_hr\n";
print ">>>>>scet_sec = $scet_sec\n";
print ">>>>>scet_msec = $scet_msec\n";

    $sct[0] = $scet_yr;                                         #year
    $sct[1] = int($scet_hr/24.0) ;                            #days 
    $sct[2] = int(((($scet_hr/24.0) - $sct[1])*24.0)+0.5);      #hours    #nint

    print "$sct[0]  $sct[1] $sct[2]\n";

     $sct[3] = int($scet_sec/60.0);                            #mins
     $sct[4] = int(((($scet_sec/60.0) - $sct[3])*60.0)+0.5);     #secs    #nint
     $sct[5] = $scet_msec;                                       #msecs
        if ($sct[1] < 10) {$sct[1] = "00$sct[1]";}
        if ($sct[1] < 100) {$sct[1] = "0$sct[1]";}
        if ($sct[2] < 10) {$sct[2] = "0$sct[2]";}
        if ($sct[3] < 10) {$sct[3] = "0$sct[3]";}
        if ($sct[4] < 10) {$sct[4] = "0$sct[4]";}
        if ($sct[5] < 100) {$sct[5] = "0$sct[5]";}
        if ($sct[5] < 10) {$sct[5] = "00$sct[5]";}

        $scet_str = "$sct[0]-$sct[1]T$sct[2]:$sct[3]:$sct[4].$sct[5]\n";
    print ">>>>>>> $sct[0]-$sct[1]T$sct[2]:$sct[3]:$sct[4].$sct[5]\n";
        return ($scet_str)
}




sub scet_time {
    ($posit,$linesc[0],$linesc[1],$linesc[2],$scyr) = @_;

#    print "posit = $posit\n";
#    print "scyr = $scyr\n";
            $scet_hr = sprintf("%d", hex($linesc[0]));
            $scet_sec = sprintf("%d",hex($linesc[1]));
            $scet_msec = sprintf("%d",hex($linesc[2]));
#            print "linesc[0] (SCET_Hr) = $linesc[0]  - scet_hr = $scet_hr  \n";
#            print "linesc[1] (SCET_Sec) =  $linesc[1] - scet_sec = $scet_sec\n";
#            print "linesc[2] (SCET_MSec) =  $linesc[2] - scet_msec = $scet_msec\n";
            $scet_yr = sprintf("%d",hex($scyr));
        $sc_cent = 20;
        if ($scyr > 70)  {
            $sc_cent = 19;
        }

#            print "SCET_Yr:  $sc_cent$scet_yr\n";
        $sdays =  int($scet_hr/24.0);
#        print "SCET days: $sdays\n";
        $shours = int(((($scet_hr/24.0) - $sdays)*24.0)+0.5);
#        print "SCET hours: $shours\n";
        $smins =  int($scet_sec/60.0);
#        print "SCET mins: $smins \n";

        $ssecs = int(((($scet_sec/60.0) -  $smins)*60.0)+0.5);
#        print "SCET secs: $ssecs\n";
#        print "SCET msecs: $scet_msec\n";      
        if ($sdays < 10) {$sdays = "00$sdays";}
        if ($sdays < 100) {$sdays = "0$sdays";}
        if ($shours < 10) {$shours = "0$shours";}
        if ($smins < 10) {$smins = "0$smins";}
        if ($ssecs < 10) {$ssecs = "0$ssecs";}
        if ($scet_msec < 100) {$scet_msec = "0$scet_msec";}
        if ($scet_msec < 10) {$scet_msec = "00$scet_msec";}
#        if ($scet_msec < 100) {$scet_msec = "0$scet_msec";}
        $colon = ":";
        $dash = "-";
        $tee = "T";
        $scet_str = "$sc_cent$scet_yr$dash$sdays$tee$shours$colon$smins$colon$ssecs$colon$scet_msec";
        print  "SCET: $scet_str$return";

        return ($scet_str);
# SCET: 2021-119T05:42:20:180
#  ERT: 1921-120T02:46:15:222

}
####################################################################################################
sub remainder {
#  This subsroutine deleted 12-27-2021
# $a is number 
# $b is divisor
    my ($a, $b) = @_;
    return 0 unless $b && $a;
    return $a / $b - int($a / $b);
}
#################################################################################################
#print remainder(5, 2);  # 0.5
#print remainder(1, 10); # 0.1
#print remainder(9, "0);  # 0
