/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifdef Header
/*****************************************************************
 * TITLE: sfaxdmp.c
 *  
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ***************************************************************
** MANUAL
**	SFAXDMP 3x "October 31, 1989"
**
**	SFOC SFDU TOOLS 
** NAME
**	sfaxdmp - hex-ascii dump procedure
**
** SYNOPSIS
**	  
**	  int  sfaxdmp(fout,fd,buf,start_at,tot_to_dump,is_hex,is_ascii,
**	               actual_offset);
**
**	  SFFOPDEF(fout);
**	  SFFOPDEF(fd);
**	  char    *buf;
**	  long    start_at;
**	  long    tot_to_dump;
**	  BOOL    is_hex;
**	  BOOL    is_ascii;
**	  long    actual_offset;
**
** PARAMETERS
**
**	  1. fout - file descritor for output.
**	  2. fd - file descritpor of file to dump.
**	     information.
**	  3. buf - points to buffer used if 'rdinfo' is 
**	     'FNULL'
**	  4. start_at - byte number to start dump in file or
**	     buffer.
**	  5. tot_to_dump - number of bytes to dump. Must
**	     be input if 'buf' is used.
**	  6. is_hex - TRUE if dump is in hex.
**	  7. is_ascii - TRUE if dump is in ASCII.
**	  8. offset - actual start from bottom of file.
**	     Used if fd input as NULL.
**
** DESCRIPTION
**	'sfaxdmp' uses the same file open, read, close as all the
**	sfdu tools. This means that the user can view the
**	file the same as the sfdu tool functions.
**
** EXAMPLE
**

        >sfaxdmp kevgen.txt -ax -s 20 -t 100

	ascii and hex dump of the file kevgen.txt, start at 20 
	bytes, dump 100 bytes. The resuts are

00000000    N   J   P   L   1   K   0   0   K   L   0   0   0   0   0   0 
           4e  4a  50  4c  31  4b  30  30  4b  4c  30  30  30  30  30  30 
00000010    0   2   8   3   D   A   T   A     S   E   T     N   A   M 
           30  32  38  33  44  41  54  41  5f  53  45  54  5f  4e  41  4d 
00000020    E   =   M   0   0   3   4   B   .   K   T   F  nl   D   A   T 
           45  3d  4d  30  30  33  34  42  2e  4b  54  46   a  44  41  54 
00000030    A     O   B   J   E   C   T     T   Y   P   E   =   K   E 
           41  5f  4f  42  4a  45  43  54  5f  54  59  50  45  3d  4b  45 
00000040    Y   _  T   I   M   E   S  sp  sp  sp  sp  sp  sp  sp  sp  sp 
           59  5f  54  49  4d  45  53  20  20  20  20  20  20  20  20  20 
00000050   sp  sp  sp  sp  sp  sp  sp  sp  sp  sp  sp  sp  sp  sp  sp  sp 
           20  20  20  20  20  20  20  20  20  20  20  20  20  20  20  20 
00000060   sp  sp  sp  sp 
           20  20  20  20 



	Total bytes for kevgen.txt = 100

_____________________________________________________________________

	>sfaxdmp kevgen.pre

	hex dump for all of file kevgen.pre. The resuts are

00000000  0a4c 4142 454c 203d 2043 4353 4431 5a30 
00000010  3030 3030 3130 3030 3030 3430 310a 0941 
00000020  6767 7265 6761 7465 5f4c 6576 656c 203d 
00000030  2030 0a0a 2020 2020 2020 4c41 4245 4c20 
00000040  3d20 4e4a 504c 314b 3030 4b4c 3030 3030 
00000050  3030 3032 3833 0a09 2020 2020 2020 4167 
00000060  6772 6567 6174 655f 4c65 7665 6c20 3d20 
00000070  310a 0a20 2020 2020 204c 4142 454c 203d 
00000080  2043 4353 4431 5230 3030 3030 3330 3030 
00000090  3030 3037 380a 0920 2020 2020 2041 6767 
000000a0  7265 6761 7465 5f4c 6576 656c 203d 2031 
000000b0  0a0a 4c41 4245 4c20 3d20 4343 5344 3152 
000000c0  3030 3030 3033 3030 3030 3030 3432 0a09 
000000d0  4167 6772 6567 6174 655f 4c65 7665 6c20 
000000e0  3d20 300a 



	Total bytes for kevgen.pre = 228

__________________________________________________________________

	>sfaxdmp kevgen.f -a -t 32

	ascii dump of file kevgen.f for 32 bytes. The results are

00000000   nl  nl  ht   V   E   R   S   I   O   N  sp   N   U   M   B   E 
00000010    R  sp   3   .   0  nl  nl  ht   L   A   B   E   L   S  sp   F 



	Total bytes for kevgen.f = 32
** ERRORS
**
** BUGS
**	 
**	 
** SEE ALSO
** END MAN PAGES
*/
#endif   /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"SCAXDMP0") csect(STATIC,"SCAXDMP1")
#endif

#include	<stdio.h>
#include	<string.h>
#include	<sftypes.h>
#include	<sfbufmgr.h>
#include	<sfaxdmp.h>

static	char	first_done[4];
static	int	indxs[sizeof(long int)];
static	int	size_of_li = sizeof(long int);

sfaxdmp(foutfd,fd,buf,start_at,tot_to_dump,is_hex,is_ascii,
	actual_offset)

SFFOPDEF(foutfd);
SFFOPDEF(fd);
char	*buf;
long	tot_to_dump;
long	start_at;
BOOL	is_hex;
BOOL	is_ascii;
long	actual_offset;

{
union {
	long	int	indx;
	char	indx_chr[sizeof(long int)];
} u;
long	int	indx;
long	int	len;
long	offset;
int	i;
int	j;
int	k;
int	ct;
SFFTELLDEF;
SFFSEEKDEF;
int	rt_code;
char	bufs[1054];
int	n_rows;
int	n_col = 16;
int	coln;
int	buf_indx;
int	bufi;
int	chr_indx;
long	int	tot_bytes;
int	nrd = 1024;
BOOL	iss = FALSE;
BOOL	ist = FALSE;
long	ln;
char	asciichar;
long	start_indx;
/*begin*/

if (strncmp(first_done,"YES",3))
{
	strcpy(first_done,"YES");
	i = mchintst(NULL,indxs);
	/*indxs has, in least sig order, the byte order of long ints*/
}
tot_bytes = 0;
offset = 0;
indx = 0;
fout = foutfd;
if (fd != SFFNULL)
{
	if (!tot_to_dump)
	{
		offset = SFFSEEK(fd,offset,2);
		tot_to_dump =  SFFTELL(fd);
		offset = 0;
		offset = SFFSEEK(fd,offset,0);
	}
	if (start_at)
	{
		/*there exists start at condition*/
		offset = SFFSEEK(fd,start_at,0);
	}
	start_indx = start_at;
}
else 
{
	if (buf == NULL  || !tot_to_dump)
	{
		if (buf == NULL)
			printf("No buffer to dump bye.");
		if (!tot_to_dump)
			printf(			
			"Total to dump is zero for buffer inpuf no good.");
		return(-1);
	}
	start_indx = start_at;
}
while (tot_to_dump > 0)
{
	if (fd != SFFNULL)
	{
		rt_code = SFFREAD(fd,bufs,nrd);
		if (rt_code < 0)
		{
			return(-1);
		}
		if (rt_code == 0)
		break;
		/*do tot_in bytes*/
		tot_to_dump -= rt_code;
		if (tot_to_dump < 0)
			rt_code += tot_to_dump;
		tot_bytes += rt_code;
	}
	else
	{
		if (tot_to_dump > (long)nrd)
		{
			tot_to_dump -= (long)nrd;
			tot_bytes = nrd;
		}
		else
		{
			tot_bytes = (int)tot_to_dump;
			tot_to_dump = 0;
		}
		rt_code = tot_bytes;
		memcpy(bufs,&buf[start_indx],tot_bytes);
		start_indx += tot_bytes;
	}
	buf_indx = 0;
	n_rows = rt_code/n_col;
	if (rt_code != rt_code*n_col)
		n_rows++;
	for ( i = 0 ; i < n_rows ; i++)
	{
		if (rt_code < n_col)
		{
			coln = rt_code;
		}
		else
		{
			coln = n_col;
		}
		u.indx = indx*16+start_at+actual_offset;
		for (ct = 0 ; ct < size_of_li ; ct++)
		{
			fprintf(fout,"%02X",
				 u.indx_chr[indxs[size_of_li-ct-1]]&0xff);
		}
		fprintf(fout,"  ");
		if (is_ascii)
		{
			bufi = buf_indx;
			for (j = 0 ; j < coln ; j++)
			{
				asciichar = bufs[bufi]&0x7f;
				chr_indx = (int)asciichar;
				if (chr_indx < TOT_SYMS)
					fprintf(fout,"%s ",symbols[chr_indx]);
				else
					fprintf(fout,"  %c ",asciichar);
				bufi++;
			}
			fprintf(fout,"\n");
			if (is_hex)
			{
				fprintf(fout,"          ");/*space it out*/
				for (j = 0 ; j < coln ; j++)
				{
					fprintf(fout," ");
					h3xchrpr(&bufs[buf_indx]);
					buf_indx++;
				}
				fprintf(fout,"\n");
			}
			else
				buf_indx = bufi;
		}
		else
		{
			bufi = buf_indx;
			while(TRUE)
			{
				h3xchrpr(&bufs[bufi]);
				bufi++;
				if (bufi >= buf_indx + coln)
					break;
				h3xchrpr(&bufs[bufi]);
				bufi++;
				if (bufi >= buf_indx + coln)
					break;
			}
			buf_indx += coln;
			fprintf(fout,"\n");
		}
		rt_code -= coln;
		if (rt_code <= 0)
			break;
		indx++;
	}
}
return(0);
}

static	int
h3xchrpr(hex_char)

char	*hex_char;

{

int	len;
int	chr_int;
char	hexchar[10];

/*begin h3xchrpr*/
chr_int = (int)hex_char[0];
sprintf(hexchar,"%04x",chr_int);
len = strlen(hexchar);
len -= 2;
fprintf(fout,"%s ",&hexchar[len]);
return;
}

