/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: pr2slibm.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ****************************************************************
** MANUAL
**	PR2SIBM 3x "July 20, 1992"
**
** NAME
**	pr2slibm - take parts and build a single precision floating
**	                   point number in IBM 3090 format.
**
** SYNOPSIS
**
**	  #include  <dofloat.h>
**
**	  int pr2slibm(parts,ibm_float);
**
**	  Float_Twos *parts;
**	  char       *ibm_float;
**
** STRUCTURE
**
**	  typedef struct float_twos Float_twos;
**
**	  struct float_twos
**	  {
**	      short int  characteristic; power of two.
**	      BOOL       sign_bit;       TRUE minus, FALSE positive.
**	      char       mantisa[7];     
**	  }
**
** EXTERNS
**
**	  1. int mindx_0 - index in int for placing first byte.
**	  2. int mindx_1 - index in int for placing second byte.
**
** DESCRIPTION
**
**	pr2slibm takes infromation from the parts structure and creates
**	an IBM 3090 floating point number.
**
**	The IBM floating point number, in hex is
**
**	 01234567  89012345  67890123  45678901
**  [scharact][xxxxxxxx][xxxxxxxx][xxxxxxxx]
**	          ^
**
**	where 's' is the sign bit, charact is the characteristic in 
**	powers of 16, ^ is the implied decimal and xxxx etc is the 
**	mantisa.
**
**	NOTE: because it is powers of 16 there can be up to 3 leading 
**	zeros in the mantisa.
**
** RETURN
**
**	parts_2_sibm3090 returns 0 for success and -1 for failure.
**
*/
#endif  /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"PC2SLIB0") csect(STATIC,"PC2SLIB1")
#endif

#include	<stdio.h>
#include	<math.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

pr2slibm(parts,ibm_float)

Float_Twos	*parts;
char		*ibm_float;

{

int	i;
int	n;
Unn	un;
Unn	un1;
int	r;

/*begin*/
if (mindx_0 < 0)
{
	partieee();
}
if (parts->characteristic == 0  &&  parts->mantisa[0] == 0)
{
        /*set to all zeros*/
        for ( i = 0 ; i < 4 ; i++)
        {
                ibm_float[i] = 0;
        }
        return(0);
}
/*check to see if characteristioc is out of bounds*/
/*create [scharact] */
un.uint = (unsigned)parts->characteristic / 4; /*get into powers of 16*/
r = abs(parts->characteristic) % 4; /*remainder*/
if (r)
{
	un.uint++; /*add one to power and shift mantisa 4 bits to 
	             right keeps it even*/
}
/*add 40 hex to characterisitic (bias)*/
un.uint += IBM3090_BIAS;
if (parts->sign_bit)
{
	un.uchar[mindx_1] |= 0x80; /*set sign bit*/
}
/*store into ibm_float[0]*/
ibm_float[0] = un.uchar[mindx_1];
/*place mantisia in ibm_float*/
if (r)
{
	/*remainder*/
	if (parts->characteristic < 0)
	{
		n = r;
	}
	else
	{
		n = 4 - r; /*get number of bits 2 shift*/
		/*why 4 - r ? The remainder is in powers of 2 so we have to 
		  shift to the left of by r but we have to shift to right by 
		  4 because of added one to characteristic*/
	}
	for ( i = 0 ; i < 2 ; i++)
	{
		un.uint = 0;
		un.uchar[mindx_0] = parts->mantisa[i];
		un.uchar[mindx_1] = parts->mantisa[i+1];
		/*shift right n bits*/
		un.uint >>= n;
		if (!i)
		{
			ibm_float[1] = un.uchar[mindx_0];
		}
		ibm_float[i+2] = un.uchar[mindx_1];
	}
}
else
{
	for ( i = 0 ; i < 3 ; i++)
	{
		ibm_float[i+1] = parts->mantisa[i];
	}
}
return(0);
}
