/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: diertscecnv.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ****************************************************************
** MANUAL
**	PR2SIEEE 3x "July 18, 1992"
**
** NAME
**	pr2sieee - take parts of single precision floating point,
**	(power of twos) put into IEEE standard notation.
**
** SYNOPSIS
**
**	  #include <dofloat.h>;
**
**	  int pr2sieee(parts,float_ieee,mach_type);
**
**	  Float_Twos  *parts;
**	  char        *float_ieee;
**	  int         *mach_type;
**
** STRUCTURE
**
**	  typedef struct float_twos  FloatTwos;
**
**	  struct float_twos 
**	  {
**	       short int characteristic;  power of twos
**	       BOOL      sign bit;        TRUE is minus, FALSE is 
**	                                  positive.
**	       char      mantisa[7];      fractional mantisa, left 
**	                                  adjusted.
**	   };
**
**	EXTERNAL
**
**	  1. int mindx_0 - for two consecitive bytes where to place 
**	     byte 0
**	  2. int mindx_1 - where to place byte 1 in unsinged int for 
**	     shifting etc.
**
** INPUTS
**
**	  parts, mindx_0, mindx_1
**
** OUTPUT
**
**	  float_ieee
**
** DESCRIPTION
**
**	'pr2sieee' takes the components input in 'parts' and creates a
**	single precision floating point number in IEEE format.
**
**	The IEEE format is
**
**
** RETURN
**
**	'pr2sieee' returns 0 for success and -1 for failure.
*/
#endif /*   Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"PC2SIEE0") csect(STATIC,"PC2SIEE1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

int pr2sieee(parts,float_ieee,mach_type)

Float_Twos	*parts;
char		*float_ieee;
int		*mach_type;

{

Unn		un;
Unn		un1;
int		i;
int	*indx;

/*begin*/
if (mindx_0 < 0)
{
	partieee();
}
if (mach_type[0] == IEEE_BI_TYPE)
{
	/*big indian */
	indx = bi_s;
}
else
{
	/*little indian*/
	indx = li_s;
}
/*get characteristic and add 7E to it for proper bias*/
un.uint = parts->characteristic;
if (un.uint == 0 && (int)parts->mantisa[0] == 0)
{
        /*set to all zeros*/
        for ( i = 0 ; i < 4 ; i++)
        {
                float_ieee[indx[i]] = 0;
        }
        return(0);
}
un.uint += IEEE_BIAS_S;

/*check for out of bounds for characteristic*/
/*shift left by 7 bits*/
un.uint <<= 7;
/*check sign bit*/
if (parts->sign_bit)
{
	/*is negative*/
	/*set sign bit*/
	un.uchar[mindx_0] |= 0x80;
}
/*set first byte of mantisa*/
un1.uint = 0;
un1.uchar[mindx_1] = parts->mantisa[0];
/*get rid of leading one*/
un1.uint &= 0x7F;
/*or un and un1 together to get characteristic and first part of 
  mantisa in IEEE format*/
un.uint |= un1.uint;
/*store in float_ieee*/
float_ieee[indx[0]] = un.uchar[mindx_0];
float_ieee[indx[1]] = un.uchar[mindx_1];
/*get last two bytes of mantisa*/
float_ieee[indx[2]] = parts->mantisa[1];
float_ieee[indx[3]] = parts->mantisa[2];
return(0); /*is all right*/
}


