/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: pr2dvax.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ****************************************************************
**
** MANUAL
**	PR2DVAX 3x "July 22, 1992"
**
** NAME
**	pr2dvax - take parts of a floating point number and build a
**	doubld precision floating point number in VAX VMS format.
**
** SYNOPSIS
**
**	  #include	<dofloat.h>
**
**	  int pr2dvax(parts,vax_float);
**
**	  Float_Two *parts;
**	  vax_float *char;
**
** PARAMETERS
**
**	INPUT.
**
**	  parts - structure of parts of floating point number.
**
**	OUTPUT
**
**	  vax_float - byte stream in VMSVAX floating point notation.
**
** STRUCTURE
**
**	  typedef struct float_twos Float_Twos;
**
**	  struct float_twos
**	  {
**	      short int  characteristic;   power of twos.
**	      BOOL       sign_bit;         TRUE for minus, FALSE for positive.
**	      char       mantisa[7];       mantisa left adjusted.
**    };
**
** EXTERNS
**
**	  1. int mindx_0 - index for storing leading byte into proper 
**	     place in int;
**	  2. int mindx_1 - index for storing next byte into proper 
**	     place in int.
**	
** DESCRIPTION
**
**	pr2svax takes the parts of a floating point number and creates a
**	single precision floating point number in VAX VMS format.
**
**	The VAX floating point format is
**                1           2           3 
**    01234567  89012345  67890123  45678901
**	 [scharact][exxxxxxx][xxxxxxxx][xxxxxxxx]
**	           ^1
**
**	where 's' is the sign bit, characte is the 8 bit characteristic,
**	 ^ is the implied decimal place and 1 is the implied leading 
**	one of the mantisa xxx etc is the rest of the mantisa.
**
**	This is all fine except that in the VAX VMS system every other 
**	byte is swapped so the first two bytes look like
**
**	 [exxxxxxx][scharact]
**
**	The bias on the characteristic is 0x80 in hex.
**
**	mindx_0 and mindx_1 are neede for two reasons
**
**	  1. All bit manipulations are done as if the int where of size 
**	     2, not 4, this makes the calculations machine independent 
**	     and no testing is needed to check size of int in this 
**	     procedure.
**	  2. On some machines like the VMS VAX the bytes in the int are
**	     not in the same order as on the IBM3090, SUN etc. mindx_0, 
**	     and mindx_1 are calculated in 'machistor' and account for 
**	     this ordering of bytes.
**
**	The bytes in parts->mantisa are in proper byte order.
**
** RETURN
**
**	pr2dvax returns 0 if success and -1 if characteristic is out
**	of bounds.
*/
#endif  /* Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"PC2DVAX0") csect(STATIC,"PC2DVAX1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

int pr2dvax(parts,vax_float)

Float_Twos	*parts;
char		*vax_float;

{

int	i;
Unn	un;
Unn	un1;

/*begin*/

if (mindx_0 < 0)
{
	partieee();
}
/*check to see if characteristic in bounds*/
/*get characteric*/
un.uint = parts->characteristic;
if (un.uint == 0  &&  (int)parts->mantisa[0] == 0)
{
        /*set to all zeros*/
        for ( i = 0 ; i < 8 ; i++)
        {
                vax_float[i] = 0;
        }
        return(0);
}
un.uint += VAXVMS_BIAS;
un1.uint = 0;
un1.uchar[mindx_0] = un.uchar[mindx_1];
/*[characte][00000000]*/
/*shift right by one*/
un1.uint >>= 1;
/*[0charact][e0000000]*/
/*set sign bit*/
if (parts->sign_bit)
{
	un1.uint |= 0x8000;
}
/*get first byte of mantisa*/
un.uint = 0;
un.uchar[mindx_1] = parts->mantisa[0];
/*get rid of leading one*/
un.uint &= 0x7F;
/*[0xxxxxxx]*/
/*OR with characteristic*/
un.uint |= un1.uint;
/*[scharact][exxxxxxx]*/
/*store in VAX order*/
vax_float[0] = un.uchar[mindx_1];
vax_float[1] = un.uchar[mindx_0];
/*get rest of bytes*/
for ( i = 2 ; i < 7 ; i += 2)
{
	vax_float[i] = parts->mantisa[i];
	vax_float[i+1] = parts->mantisa[i-1];
}
return(0);
}
