/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: pr2dieee.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 **************************************************************
 *
** MANUAL
**	PR2DIEEE 3x "July 18, 1992"
**
** NAME
**	pr2dieee - take parts of double precision floating point,
**	 (power of twos) put into IEEE standard notation.
**
** SYNOPSIS
**
**	  #include <dofloat.h>;
**
**	  int pr2dieee(parts,float_ieee,mach_type);
**
**	  Float_Twos  *parts;
**	  char        *float_ieee;
**	  int         *mach_type;
**
** STRUCTURE
**
**	  typedef struct float_twos  FloatTwos;
**
**	  struct float_twos 
**	  {
**	       short int characteristic;  power of twos
**	       BOOL      sign bit;        TRUE is minus, FALSE is 
**	                                  positive.
**	       char      mantisa[7];      fractional mantisa, left 
**	                                  adjusted.
**	   };
**
**	EXTERNAL
**
**	  1. int mindx_0 - for two consecitive bytes where to place 
**	     byte 0
**	  2. int mindx_1 - where to place byte 1 in unsinged int for 
**	     shifting etc.
**
** INPUTS
**
**	  parts, mindx_0, mindx_1
**
** OUTPUT
**
**	  float_ieee in double precision IEEE format
**
** DESCRIPTION
**
**	'pr2sieee' takes the components input in 'parts' and creates a
**	double precision floating point number in IEEE format.
**
**	The IEEE format is
**	             1            2           3 
**   01234567  8901 2345  67890123  45678901
**	[scharact][eris xxxx][xxxxxxxx][xxxxxxxx] etc.
**	              1^
**
**	where the 1 is implied and the ^ is where the decimal point 
**	goes.
**
**	The input does not have in implied one.
**
**	All work is done as if the size of the int were 2.
**
** RETURN
**
**	'pr2dieee' returns 0 for success and -1 for failure.
*/
#endif /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"PC2DIEE0") csect(STATIC,"PC2DIEE1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

int pr2dieee(parts,float_ieee,mach_type)

Float_Twos	*parts;
char		*float_ieee;
int		*mach_type;

{

Unn		un;
Unn		un1;
int		i;
int		j;
int		*indx;

/*begin*/
if (mindx_0 < 0)
{
	partieee();
}
if (mach_type[0] == IEEE_BI_TYPE)
{
	/*big indian*/
	indx = bi_d;
}
else
{
	/*little indian*/
	indx = li_d;
}

/*get characteristic and add 3FE to it for proper bias*/
/*check for out of bounds for characteristic*/
un.uint = parts->characteristic;
if (un.uint == 0 && (int)parts->mantisa[0] == 0)
{
        /*set to all zeros*/
        for ( i = 0 ; i < 8 ; i++)
        {
                float_ieee[indx[i]] = 0;
        }
        return(0);
}
un.uint += IEEE_BIAS_D;
/*[00000cha][racteris]*/
/*shift left by 4 bits*/
un.uint <<= 4;
/*check sign bit*/
if (parts->sign_bit)
{
	/*is negative*/
	/*set sign bit*/
	un.uchar[mindx_0] |= 0x80;
}
/*set first byte of mantisa*/
un1.uint = 0;
un1.uchar[mindx_1] = parts->mantisa[0];
/*get rid of leading one*/
un1.uint &= 0x7F;
/*shift right by  3 bits*/
un1.uint >>= 3;
/*or un and un1 together to get characteristic and first part of 
  mantisa in IEEE format*/
un.uint |= un1.uint;
/*store in float_ieee*/
float_ieee[indx[0]] = un.uchar[mindx_0];
float_ieee[indx[1]] = un.uchar[mindx_1];
/*load two bytes at a time, shift right 4 bits store least sig byte in
  float_ieee*/
un.uint = 0;
j = 2;
for ( i = 0 ; i < 7 ; i++)
{
	/*shift from already used to not used bytes*/
	un.uchar[mindx_0] = parts->mantisa[i];
	un.uchar[mindx_1] = parts->mantisa[i+1];
	un.uint >>= 3; /*shift right  by 3*/
	float_ieee[indx[j]] =  un.uchar[mindx_1];
	if (i <6) j++;
}
return(0);
}


