/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: libmd2pr.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ******************************************************************
 *
** MANUAL
**	LIBMD2PR 3x "July 20, 1992"
**
** NAME
**	libmd2pr - IBM 3090 double precision float format to parts
**	                    in powers of 2.
**
** SYNOPSIS
**
**	  #include <dofloat.h>
**
**	  void libmd2pr(ibm_float,parts);
**	  
**	  char       *ibm_float;
**	  Float_Twos *parts;
**
** STRUCTURE
**
**	 typedef struct float_twos Float_Twos;
**
**	 struct  float_twos
**	 {
**	     short int  characteristic;
**	     BOOL       sign_bit;
**	     char       mantisa[7];
**	 };
**
** EXTERNS
**	
**	  1. int mindx_0 - index into union for storing proper bytes, 
**	     first byte.
**	  2. int mindx_1 - index for next byte.
**
** DESCRIPTION
**
**	libmd2pr takes a double precision floating point number in IBM
**	3090 format and takes it apart, makes into power of twos and 
**	stores in 'parts'
**
**	IBM 3090 format is
**                  1           2           3
**	    01234567  89012345  67890123  45678901
**	   [scharact][xxxxxxxx][xxxxxxxx][xxxxxxxx]plus 4 more bytes 
**	   of mantisa
**               ^
**
**	where 's' is the sign bit, charact is the characteristic, 
**	powers of 16, biased at 40 HEX, '^' is the decimal place, 
**	and xxx etc is the mantisa in fractional parts of base 16.
**
**	All bit manipulation is done as if the int were size of 2.
**
*/

#endif /*  Header */


#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"LICMD2P0") csect(STATIC,"LCBMD2P1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

void  
libmd2pr(ibm_float,parts)

char		*ibm_float;
Float_Twos	*parts;

{

int	i;
Unn	un;
Unn	un1;
int	n;

/*begin*/
if (mindx_0 < 0)
{
	partieee();
}
if (ibm_float[0] == 0)
{
	/*its all zero here*/
	parts->characteristic = 0;
	parts->sign_bit = FALSE;
	for ( i = 0 ; i < 7 ; i++)
	{
		parts->mantisa[i] = 0;
	}
	return;
}
/*find sign bit*/
un.uint = 0;
un.uchar[mindx_1] = ibm_float[0];

/*[scharact] */
if ( un.uint & 0x80)
{
	parts->sign_bit = TRUE; /*this is minus*/
}
else
{
	parts->sign_bit = FALSE; /*this is positive*/
}
/*get rid of sign bit*/
un.uint &= 0x7F;
/*subtract 40 hex, the bias */
un.uint -= IBM3090_BIAS;
/*this is power of 16. 16 is 4*2 so shift left by 2 (4) to get 
  power of 2*/
un.uint <<= 2;
/*store in characteristic*/
parts->characteristic = un.uint;
/*because of base 16 the mantisa could have three leading zeros.*/
un.uint = 0;
/*bring in first byte of mantisa*/
un.uchar[mindx_1] = ibm_float[1];
for (n = 0 ; n < 4 ; n++)
{
	un.uint <<= 1;
	if (un.uchar[mindx_0])
	{
		/*non zero there is a one*/
		break;
	}
	parts->characteristic--; /*subtract a power of two as 
	                           shift to left*/
}
if (n)
{
	/*there are n bits to be shifted*/
	for (i = 0 ; i < 6 ; i++)
	{
		un.uint = 0;
		un.uchar[mindx_0] = ibm_float[i+1];
		un.uchar[mindx_1] = ibm_float[i+2];
		un.uint <<= n;
		parts->mantisa[i] = un.uchar[mindx_0];
	}
	parts->mantisa[i] = un.uchar[mindx_1]; /*last of the bits*/		
}
else
{
	for (i = 0; i < 7 ; i++)
	{
		parts->mantisa[i] = ibm_float[i+1];
	}
}
return;
}
