#ifndef Header
 /*****************************************************************
 * TITLE: ibm2sun.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ****************************************************************
 *
** MANUAL
**	IBM2SUN 3x "August 27, 1993"
**
** NAME
**	ibm2sun - convert from IBM single precision floating point
**	to local floating point.
**
** SYNOPSIS
**
**	   void ibm2sun(input,output);
**
**	   long int *input;
**	   long int *output;
**
** DESCRIPTION
**
**	Convert from input[25] thru [28], from [30] thru [287]
**	using 'ibms2pr' to get parts then use 'pr2sieee' to get 
**	single precision ieee standard out.
**
** END MAN PAGES
*/
#endif /* Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"ICM2SUN0") csect(STATIC,"ICM2SUB1")
#endif

#include	<stdio.h>
#include	<dofloat.h>
static	int	mach_type = IEEE_BI_TYPE;

void
ibm2sun(input,output)

long	int	*input;
float	*output;

{

Float_Twos	parts;
int	i;
char	*pntr_in;
char	*pntr_out;
for ( i = 25 ; i < 288 ; i++)
{
	pntr_in = (char *)&input[i];
	pntr_out = (char *)&output[i];
	/*get parts to xlate*/
	libms2pr(pntr_in,&parts);
	/*translate from parts to ieee single precision number*/
	pr2sieee(&parts,pntr_out,&mach_type);
}
return;
}
