/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/

#ifndef Header
/*****************************************************************
 * TITLE: diertscecnv.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ****************************************************************
** MANUAL
**	FNDBYTST 3x "April 26, 1991"
**
** NAME
**	fndbytst - find a match in buffers for input byte stream
**
** SYNOPSIS
**
**	  int  fndbytst(rdinfo,indx_in_buf,bufnumber,
**	                byte_stream,lngth_byte_stream,
**	                      pars_func);
**
**	   struct  rdinfo  *rdinfo;
**	   int     indx_in_buf;
**	   int     bufnumber;
**	   char    *byte_stream;
**	   int     *lngth_byte_stream;
**	   int     (*pars_func)();
**
** PARAMETERS
**
**	   1. struct  rdinfo - for buffer management.
**	    2. indx_in_buf - where in the buffer in rdbuf.
**	    3. bufnumber - rdbuf->bufs[bufnumber] for buffer.
**	    4. byte_stream - bytes to match in buffers.
**	    5. lngth_byte_stream - length of byte_stream.
**	    6. pars_func - pointer to function to call
**	       for keyword value pairs and words.
**
** STRUCTURES
**
**
**	  structure bufinfo, bufsin, rdbuf used for buffer management
**
**	  struct  bufinfo {
**	     char  *buf;     points to buffer containing map
**	     int   buflen;   length of buffer in bytes
**	     int   bufnumber; current buffer number.
**	     BOOL  contflag; TRUE for more buffers.
**	     int   bufrmode; returned mode for buffers.
**	  } ;
**
**	  bufrmode can be
**	  1. NO_NEW_BUFR - ignore this request.
**	  2. NEXT_BUFR - get next buffer.
**	  3. PREV_BUFR - get previous buffer.
**	  4. BOF - bottom of file get first buffer.
**	  5. EOF - get last buffer.
**
**	  struct rdinfo {
**	     FOPDEF(frd) - frd is file descriptor.
**	     char  *filename; file name of frd.
**	     char  **list_pntr; set of string pointers
**	                        used if filname = NULL
**	     int   indx_in_list - used along with list_pntr.
**	     char  *rdbuf; pointer to buffer struct.
**	     char  *start_adis_pntr; points to first adis structure.
**	  }
**
**	  struct bufsin {
**	     int   tot_bufs;  total number of buffers.
**	     int   tot_bytes; total bytes in all buffers.
**	     BOOL  more_reads; if All buffers full but
**	                       more reads or lists needed.
**	     struct  {
**	        char *pntr; points to buffer.
**	        int  lngth; number of bytes in buf.
**	        int  count; true buffer numbernot modulo MAXNUMBUFRS.
**	     } [MAXNUMBUFRS];
**	  }
**
** FUNCTION
**
**	'pars_func' points to a user supplied function.
**
**	The function must be have the following attributes.
**
**	  int  (*pars_func)(
**	                    indx_of_match,
**	                    buf_num,
**	                    running_count);
**
**	  int  indx_of_match; index in buffer.
**	  int  buf_num;       number of buffer in rdbuf.
**	  long running_count; number of bytes from start of
**	                      parsing to find match.
**
** DESCRIPTION
**
**
** SEE ALSO
**
**	sfbufman
**
** END MAN PAGES
**
*/
#endif  /*  Header */

#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"FCDBYTS0") csect(STATIC,"FCDBYTS1")
#endif

#include	<stdio.h>
#include	<ctype.h>
#include	<sfbufmgr.h>

static	int	start_indx;
static	struct	bufinfo bufinfo;
static	struct	bufsin	*rdbuf;
static	BOOL	is_continue;
static	int	blen;
static	long	running_count;
static	long	start_running_count;
static	long	running_count_offset;
static	int	last_bufnumber;
static	int	indx;
static	char	*byte_pntr;

fndbytst(rdinfo,indx_in_buf,bufnumber,
	       byte_stream,lngth_byte_stream,
	       pars_func,use_len)

struct	rdinfo	*rdinfo;
int	indx_in_buf;
int	bufnumber;
char	*byte_stream;
int	*lngth_byte_stream;
int	(*pars_func)();

{

int	rt_code;
register	char	*pntr;
register	int	i;
BOOL		process_it;

/*begin*/
rdbuf = (struct bufsin *)rdinfo->rdbuf;
bufinfo.bufnumber = bufnumber;
bufinfo.buf = rdbuf->bufs[bufnumber%MAXNUMBUFRS].pntr;
bufinfo.bufrmode = NEXT_BUFR;
bufinfo.buflen = rdbuf->bufs[bufnumber%MAXNUMBUFRS].lngth;
i = indx_in_buf;
if (rdbuf->more_reads ||
    bufnumber < rdbuf->tot_bufs - 1)
	bufinfo.contflag = TRUE;
else
	bufinfo.contflag = FALSE;
pntr = &bufinfo.buf[i];
running_count = 0;
running_count_offset = i;
start_running_count = 0;
start_indx = -1;
is_continue = FALSE;
last_bufnumber = bufinfo.bufnumber;
process_it = FALSE;
for (;;)
{
	if (i == bufinfo.buflen)
	{
		/*this is the end of this buffer*/
		if (!bufinfo.contflag)
		{
			return(1);
		}
		running_count += i - running_count_offset;
		blen = sfbufman(&bufinfo,rdinfo);
		if (blen <= 0)
			return(-1);
		i = 0;
		running_count_offset = 0;
		pntr = bufinfo.buf;
	}
	if (is_continue)
	{
		if (indx == lngth_byte_stream[0])
		{
			process_it = TRUE;
		}
		else
		{
			i++;
			pntr++;
			if (byte_stream[indx] == pntr[0])
			{
				indx++;
				if (indx == lngth_byte_stream[0])
				{
					/*its a hit*/
					process_it = TRUE;
				}
			}
			else 
			{
				is_continue = FALSE;
				i++;
				pntr++;
				continue;
			}
		}
		if (process_it)
		{
			is_continue = FALSE;
			process_it = FALSE;
			rt_code = (*pars_func)(
				   start_indx,
				   last_bufnumber,
				   start_running_count);
			if (rt_code)
			{
				if (rt_code < 0)
				{
					return(rt_code);
				}
				return(0);
			}
			i++;
			pntr++;
		}
	}
	if (is_continue)
	{
		continue;
	}
	if (byte_stream[0] != pntr[0])
	{
		pntr++;
		i++;
		continue;
	}
	is_continue = TRUE;
	indx = 1;
	start_indx = i;
	start_running_count = running_count + i
			      - running_count_offset;
	last_bufnumber = bufinfo.bufnumber;
} /*end of inner for loop*/
}

