/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*
** MANUAL
**	DIHDRCLK 3x, "October, 26 1993"
**
** NAME
**	dihdrclk - read in sclk coeff header write SFDU
**	header for double precision sclk coefficient file.
**
** SYNOPSIS
**
**	  #include  <glowsce.h>
**
**	  int dihdrclk(rtcode);
**
**	  char      *rtcode;
**
** PARAMETERS
**
**	 1. rtcode - return code. 4 characters.
**
** EXTERNS
**
**	 1. fdsceclk - SFFDEFOPEN - input coefficient file.
**	    glowlsce.h
**	 2. fdsccl_out - SFFDEFOPEN - output dp coefficient file.
**	    glowsce.h.
**	 3. dpsceclk_file - char - double precision file name.
**
** DESCRIPTION
**
**	'dihdrclk' reads in an ASCII scet/sclk coefficient file.
**	Reads in the header and creates meta-data for
**	an SFDU file.
**
**	There are 2 different coefficient files. The first is an 
**	older form. The header consists of 80 byte records and looks
**	like the following.
**	 $$ULS       SCLK/SCET COEFFICIENT FILE                          
**	 *SCID       ULS                                            
**	 *FILE       UDMT*SCLKSCETCOEF.                             
**	 *CREATION   90-285/14:49:10                                
**	 *UPDATE     93-106/10:44:39                                
**	 *RATE        2.000030997                                   
**	 *PART 1     90-279/19:10:49.727 @      100                 
**	 *                                                             
**	 *           SCET(UTC) = A0 + A1*(SCLK - SCLK0)            
**	 *                                                      
**	 *    SCLK0             A0            DUT       A1             
**	 * EFFECT. SCLK  EFFECT. SCET(UTC)  ET-UTC EFFECT. RATE         
**	 *SCLKCOUNT.000 YY-DDD/HH:MM:SS.FFF  SECS   SECONDS/RIM    
**	 $$EOH                                                   
**	and the newer coefficient SFDU file that looks like
**	 CCSD3ZS00001$$sclk$$NJPL3KS0L015$$scet$$
**	 MISSION_NAME=ULYSSES;
**	 SPACECRAFT_NAME=ULS;
**	 DATA_SET_ID=SCLK_SCET;
**	 FILE_NAME=SCLK_SCET.00001;
**	 PRODUCT_CREATION_TIME=1990-285T14:49:10;
**	 PRODUCT_VERSION_ID=1;
**	 PRODUCER_ID=DMT;
**	 APPLICABLE_START_TIME=1990-285T14:49:10;
**	 APPLICABLE_STOP_TIME=1999-12-30T12:00:00.000;
**	 MISSION_ID=3;
**	 SPACECRAFT_ID=55;
**	 CCSD3RE00000$$scet$$NJPL3IS00613$$data$$
**	 *____SCLK0_______  ____SCET0____________ _DUT__ _SCLKRATE___ 
**
**	The output double precision coefficient files header looks like
**	 CCSD3ZF0000100000001NJPL3KS0L015$$scet$$
**	 MISSION_NAME=ULYSSES;
**	 SPACECRAFT_NAME=ULS;
**	 DATA_SET_ID=DOUBLE_PRECISION_SCLK_SCET;
**	 FILE_NAME=uls.dp1coeff.data;
**	 PRODUCT_CREATION_TIME=1990-285T14:49:10;
**	 PRODUCT_VERSION_ID=1;
**	 PRODUCER_ID=DMT;
**	 APPLICABLE_START_TIME=1990-285T14:49:10;
**	 APPLICABLE_STOP_TIME=1999-12-30T12:00:00.000;
**	 MISSION_ID=3;
**	 SPACECRAFT_ID=55;
**	 TARGET_PARAMETER_NAME=SCET;
**	 TARGET_PARAMETER_EPOCH=1950-001T00:00:00.000;
**	 CCSD$$MARKER$$scet$$NJPL3IFxxxx00000001
** END MAN PAGES
*/
#endif
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"DCHDRCL0") csect(STATIC,"DCHDRCL1")
#endif
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<glbltme.h>
#include	<glowlsce.h>
#include	<dictmerr.h>
#include	<dihdrclk.h>


dihdrclk(rtcode)

char	*rtcode;

{


int	read;
int	toread;

/*initia;ize here*/
if (strcmp(times_data_init,"YES"))
{
	ditminit();
}
/*malloc area for creating SFDU labels plus meta-data*/
hdr_buf = malloc(80*15);
if (hdr_buf == NULL)
{
	/*error in mallocing*/
	strcpy(rtcode,"MALX");
	return;
}
/*start with the first two SFDU labels */
fprintf(fdsccl_out,
	"%s\n",LEADING_SCECLK_SFDU);
/*do it here*/
clksfdunominal(rtcode);
toread = 160;
r0sceclk(toread,hdr_rec,&read,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
/*check for '$$'*/
if (strncmp(hdr_rec,"$$",2))
{
	/*is not an SCLK/SCET file*/
	d0creams(rtcode);
}
else
{
	d0creuns(rtcode);
}
if (rtcode[3] == 'X')
{
	/*error in getting header*/
	return;
}
/*finish header*/
d0hdrfin(rtcode);
return;
}

static
clksfdunominal(rtcode)

char	*rtcode;

{

char	*pntr;
char	*pntr1;

/*ok do it now*/
/*get current time*/
strcpy(type_in,"CURRENT");
strcpy(type_out,"CCSDSDOY");
dictmcnv(tarray,NULL,NULL,dptimes,tstrng,type_in,
		type_out,hdr_buf,rtcode);
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[CREATION_INDX],
	hdr_buf);
/*do epochs here*/
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[TP_EPOCH_INDX],
	CLOWEPS.epoch);
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[TP_NAME_INDX],
	COEFF_TP_NAME);
/*dataset id*/
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[DATA_SET_ID_INDX],
	COEFF_DATA_SET_ID);
/*file name here,dpsceclk_file*/
/*get file name sans path*/
pntr = dpsceclk_file;
pntr1 = strchr(pntr,'/');
while (pntr1 != NULL)
{
	pntr = pntr1 + 1;
	pntr1 = strchr(pntr,'/');
}
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[FILE_NAME_INDX],
	pntr);
return;
}	

static
d0hdrfin(rtcode)

char *rtcode;

{

/*write out tail of sfdu info*/
fprintf(fdsccl_out,"%s",
	TRAILING_SCECLK_SFDU);
return;
}

static
d0creams(rtcode)

char	*rtcode;

{

char	*pntr;
int	rt_code;

/*set back to start of file */
SFFSEEK(fdsceclk,0,SFSEEK_SET);
/* starting SFDU labels CCSD3ZS00001$$sclk$$NJPL3KS0L015$$scet$$ */
to_read = 40; /*read in two 20 byte SFDU labels*/
r0sceclk(to_read,hdr_buf,&read,rtcode);
/*find end of it but first*/
if(strncmp(hdr_buf,"CCSD",4) ||  strncmp(&hdr_buf[20],"NJPL",4))
{
	/*this is not a proper file*/
	/*is not an SCLK/SCET file*/
	printf("This is not an SCET/SCLK file\n");
	strcpy(rtcode,err_rtrn_code[CLN_INDX]);
	return;
}
file_delimiter = hdr_buf[6];
metadatadelimiter = hdr_buf[26];
to_read = 80*15;
r0sceclk(to_read,hdr_buf,&read,rtcode);
clkoffset = 40;
rt_code = sfnetcall_parser(
                   NULL,
                   0,
                   0,
                   hdr_buf, /*after labels to start of data*/
                   to_read,
                   pars_scet_kywrds,
                   NULL,0);
if (rt_code < 0)
{
	/*this is not a proper file*/
	/*is not an SCLK/SCET file*/
	printf("This is not an SCET/SCLK file\n");
	strcpy(rtcode,err_rtrn_code[CLN_INDX]);
	return;
}
/*read in a record*/
to_read = 160;
SFFSEEK(fdsceclk,clkoffset,SFSEEK_SET);
r0sceclk(to_read,hdr_buf,&read,rtcode);
/*find end of record*/
pntr = strchr(hdr_buf,'\n');
if (pntr == NULL)
{
	/*this is not a proper file*/
	/*is not an SCLK/SCET file*/
	printf("This is not an SCET/SCLK file\n");
	strcpy(rtcode,err_rtrn_code[CLN_INDX]);
	return;
}
while (pntr[0] != ' ')
{
	pntr++;
}
clkrecsize = (long int)pntr - (long int)hdr_buf;
/*set for where to get from buffer*/
use_unisys = FALSE;
clk_indx_any = AMS_CLK_INDX;
clk_len_any = AMS_CLK_LEN;
sce_indx_any = AMS_SCE_INDX;
sce_len_any = AMS_SCE_LEN;
dut_indx_any = AMS_DUT_INDX;
dut_len_any = AMS_DUT_LEN;
a1_indx_any = AMS_A1_INDX;
a1_len_any = AMS_A1_LEN;
return;
}

static
d0creuns(rtcode)

char	*rtcode;

{
	
char	*pntr;
int	i;
BOOL	noeol; /*no end of line*/
int	len;
int	msn_indx;
long	int	minus_offset;

use_unisys = TRUE;
/*set up fro getting info from input records*/
clk_indx_any = UNS_CLK_INDX;
clk_len_any = UNS_CLK_LEN;
sce_indx_any = UNS_SCE_INDX;
sce_len_any = UNS_SCE_LEN;
dut_indx_any = UNS_DUT_INDX;
dut_len_any = UNS_DUT_LEN;
a1_indx_any = UNS_A1_INDX;
a1_len_any = UNS_A1_LEN;
/*find '*' starts next record*/
pntr = strchr(hdr_rec,'*');
if (pntr == NULL)
{
	/*is not an SCLK/SCET file*/
	printf("This is not an SCET/SCLK file\n");
	strcpy(rtcode,err_rtrn_code[CLN_INDX]);
	return;
}
/*find record length*/
clkrecsize = (long int)pntr - (long int)hdr_rec;
/*find if '\n' last character of size*/
/*go to start of record*/
SFFSEEK(fdsceclk,0,SFSEEK_SET);
clknhdrec = 0;
while (TRUE)
{
	r0sceclk(clkrecsize,hdr_rec,&read,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	clknhdrec++;
	if (!strncmp(hdr_rec,"$$EOH",5))
	{
		break;
	}
}
/*compute offset to data*/
clkoffset = clknhdrec * clkrecsize;
/*first mision and spacecraft info*/
msn_indx = msn_case_nmbr*3;
/*mission name*/
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[MSN_NAME_INDX],
	msn_names_etc[msn_indx]);
/*spacecraft name*/
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[SC_NAME_INDX],
	msn_names_etc[msn_indx+1]);
/*mission id*/
fprintf(fdsccl_out,"%s=%d;\n",
	meta_data[MSN_ID_INDX],
	msn_case_nmbr);
/*spacecraft id or number*/
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[SC_ID_INDX],
	msn_names_etc[msn_indx+2]);
/*producers id*/
fprintf(fdsccl_out,"%s=DMT;\n",
	meta_data[PRODUCER_ID_INDX]);
/*get start and stop times*/
/***************************************
          1         2         3         4
01234567890123456789012345678901234567890
*SCLKCOUNT.000 YY-DDD/HH:MM:SS.FFF  SECS   
$$EOH                                       
         0.000 90-279/19:10:49.727 57.184  
*****************************************/
r0sceclk(clkrecsize,hdr_rec,&read,rtcode);
/*read in ASCII count scet etc*/
if (rtcode[3] == 'X')
{
	return;
}
clknhdrec++;
memcpy(tstrng,&hdr_rec[15],19);
tstrng[19] = '\0';
strcpy(type_in,"CHAR");
strcpy(type_out,"CCSDSDOY");
dictmcnv(tarray,NULL,NULL,dptimes,tstrng,type_in,
		type_out,hdr_buf,rtcode);
fprintf(fdsccl_out,"%s=%s;\n",
	meta_data[START_TIME_INDX],
	hdr_buf);
/*go to end of file*/
SFFSEEK(fdsceclk,0,SFSEEK_END);
/******************** END OF COEFF FILE
  42403000.000 93-165/08:48:45.353 59.184  2.000030827 93-166/08:56:18
$$EOF 
**************************************************************/
/*go back 2 records length*/
minus_offset = (long int)clkrecsize*2;
SFFSEEK(fdsceclk,-minus_offset,SFSEEK_CUR);
/*see if we are there*/
to_read = 160;
r0sceclk(to_read,hdr_rec,&read,rtcode);
/*read in ASCII count scet etc*/
if (rtcode[3] == 'X')
{
	return;
}
if (strncmp(&hdr_rec[clkrecsize],"$$EOF",5))
{
	/*no end of file mark so do not try*/
	return;
}
clknhdrec++;
if (hdr_rec[17] == '-'  &&
    hdr_rec[21] == '/')
{
	/*this is a proper time*/
	memcpy(tstrng,&hdr_rec[15],19);
	tstrng[19] = '\0';
	dictmcnv(tarray,NULL,NULL,dptimes,tstrng,type_in,
		type_out,hdr_buf,rtcode);
	fprintf(fdsccl_out,"%s=%s;\n",
		meta_data[STOP_TIME_INDX],
		hdr_buf);
}
return;
}
		
static
r0sceclk(toread,buf,read,rtcode)

int	toread;
char	*buf;
int	*read;
char	*rtcode;

{

read[0] = SFFREAD(fdsceclk,buf,toread);
if (read[0] !=  toread)
{
	strcpy(rtcode,err_rtrn_code[OWR_INDX]);
}
return;
}

pars_scet_kywrds(keyindx,key_len,key_buf,valueindx,value_len,value_buf,
                        runing_count)


int     keyindx;
int     key_len;
int     key_buf;
int     valueindx;
int     value_len;
int     value_buf;
long    runing_count;

{

char    *keywrd;
char    *value;
char	save4keywrd;
char	save4value;

/*begin*/
keywrd = &hdr_buf[keyindx];
if (valueindx < 0)
{
	if (keywrd[0] == ';')
	return(0); /*get next*/
	/*this is the end*/
	if (metadatadelimiter == 'S')
	{
		/*this is marker*/
		if (strncmp(keywrd,"CCSDS",4))
		{
			/*error here*/
			return(-1);
		}
		/*this sould be ok*/
	}
	clkoffset += (long int)keyindx;
	/*find '\n' */
	value = strchr(keywrd,'\n');
	if (value == NULL)
	{
		return(-1);
	}
	value++;
	value = strchr(value,'\n');
	if (value == NULL)
	{
		return(-1);
	}
	value++;
	/*here we are*/
	clkoffset += (long int)value - (long int)keywrd;	
	return(1); /*thus it is ended*/
}

/*ok now find out what it is*/
switch(keywrd[0])
{
	case 'F': /*file name do not use will use output file name*/
	case 'D': /*dataset id do not use*/
	break;
	case 'P':
		if (!strncmp(meta_data[CREATION_INDX],keywrd,key_len))
		{
			/*this is another we do not want*/
			break;
		}
	default:
		value = &hdr_buf[valueindx];
		/*this is a write to fdsclk_out file*/
		save4keywrd = keywrd[key_len];
		keywrd[key_len] = '\0';
		save4value = value[value_len];
		value[value_len] = '\0';
		fprintf(fdsccl_out,"%s=%s;\n",
			keywrd,
			value);
		keywrd[key_len] = save4keywrd;
		value[value_len] = save4value;
	break;
}
return(0);
}

