/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
/*****************************************************************
 * TITLE: crft2nav.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -   
 *******************************************************************/
#include	<stdio.h>
#include	<math.h>
#include	<sedrgl.h>

#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"CCFTNAV0") csect(STATIC,"CCFTNAV1")
#endif
#if (NOPROTO)
extern	void	cgmprc();
extern	void	crot8();
#else
extern	void	cgmprc(DBL **,DBL*,DBL *);
extern	void	crot8(DBL,DBL **);
#endif
/**********************************************************************/
void
crftnav(dtrjda,dblsedr)

DBL	*dtrjda;
DBL	*dblsedr; 

{                                               
      DBL a[3][3],v[3],b[3][3],w[3],avec[3],bvec[3];                  
      DBL  blamda, angle, dlamda;                      
      DBL rlamda;                                                   
      DBL clong,clat,cosasp;
      int i,j,k,k1;                                        
      double degrad = .01745329519943;       
      double dssi;
      double dsyn;
      double dsid;
      double sla;
      double iscor;
      double sla1;

/*-----load ecl50 state vectors*/                                        
                                                                      
      for (j = 31 ; j <= 42 ; j++)
      {                                                     
/*       save tape  35-40,  41-46  */                                      
        k = 4 + j;                                                       
        dblsedr[j] = dtrjda[k];                                                 
      }                                                                    
      for (j = 43 ; j <= 48 ; j++)
      {                                                     
/*   save tape 111-116 [176-181]                                 
     k = 133 + j    */                                                 
        k = 68 + j;                                                     
        dblsedr[j] = dtrjda[k];                                                  
      }                                                             
      for (j = 49 ; j <= 60 ; j++)
      {                                                      
/*   save tape  47-52,  53-58 */                                       
        k = j - 2;                                                       
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
      for (j = 61 ; j <= 66 ; j++)
      {                                                     
/*   save tape 190-195 [255-260]                                     
     k = j + 194   */                                                  
        k = j + 129;                                                     
        dblsedr[j] = dtrjda[k] ;                                                 
      }                                                            
      for (j = 67 ; j <= 72 ; j++)
      {                                                    
/*   save tape 258-263 [323-328]                                     
     k = j + 256  */                                                   
        k = j + 191;                                                     
        dblsedr[j] = dtrjda[k];                                                 
      }                                                            
      for (j = 73 ; j <= 78 ; j++)
      {                                                    
/*   save tape 311-316 [376-381]                                     
     k = j + 303  */                                                   
        k = j + 238;                                                     
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
      for (j = 79 ; j <= 84 ; j++)
      {                                                    
/*   save tape 317-322 [382-387]                                     
     k = j + 303 */                                                    
        k = j + 238;                                                     
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
      for (j = 85 ; j <= 114 ; j++)
      {                                                    
/*   save tape [182-187, 188-193, 194-199, 200-295, 206-211]         
     save tape  117-146                                              
     k = j + 97 */                                                     
        k = j + 32;                                                     
        dblsedr[j] = dtrjda[k];                                                  
      }                                                             
                                                                      
/*-----compute pm in sun direction state vectors                         
                                                                       
    angle = [dtrjda[248]]*degrad                                              
    get longitude of the sun in */                                           
      angle = dtrjda[183]*degrad;                                                
/* compute transformation matrix  */                                         
      crot8(angle, a);                                             
                                                                      
      for (j = 115 ; j <= 144 ; j += 3)
      {                                                  
/*   save tape [218-223, 224-229, 230-235, 236-241, 242-247]         
     save tape 153-182                                               
     k = j + 103  */                                                   
        k = j + 38;                                                      
        v[0] = dtrjda[k];                                                        
        v[1] = dtrjda[k+1];                                                    
        v[2] = dtrjda[k+2];                                                    
        cgmprc(a,v,&dblsedr[j]);                                      
      }                                                            
                                                                      
/*-----compute jupiter sys III state & position vectors */                 
                                                                      
      for (j = 163 ; j <= 168 ; j ++)
      {                                                   
/*   save tape 211-116 [276-281]                                     
     k = j + 113  */                                                  
        k = j + 48;                                                      
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
                                                                      
/* angle = [dtrjda[294]]*degrad     sys III equinox hour angle              
   sys III equinox hour angle  */                                           
      angle = dtrjda[229]*degrad;                                               
                                                                      
/*compute transformation matrix  */                                       
      crot8(angle,a);                                             
                                                                            
      for (j = 169 ; j <= 180 ; j += 3)
      {                                                   
/*   save tape [282-284, 285-287, 288-290, 291-293]                  
     save tape 217-228                                               
     k = j + 113  */                                                   
        k = j + 48;                                                      
        v[0] = dtrjda[k];                                                        
        v[1] = dtrjda[1+k];                                                     
        v[2] = dtrjda[2+k];                                                      
/*perform rotation*/                                                       
        cgmprc(a,v,&dblsedr[j]);                                     
      }                                                            
                                                                      
/*-----compute jupiter sys i state & position vectors */
                                                                      
      dlamda = lambdo + lamdad * dtrjda[1];                              

      dlamda = fmod(dlamda,360.0);
      if (dlamda < 0)
      {
         dlamda += 360.0;
       }                  
/*compute pm difference angle */                                           
      rlamda = dlamda*degrad ;                                           
/*compute transformation matrix*/                 
      crot8(rlamda,a);                                            
/*rotate position vector*/                                                 
/*    v[1] = dtrjda[276]     rotate position vector*/                          
      v[0] = dtrjda[211];                                                      
/*    v[2] = [dtrjda[277]] */                                                      
      v[1] = dtrjda[212];                                                      
/*    v[3] = [dtrjda[278]] */                                                     
      v[2] = dtrjda[213];            
      cgmprc(a,v,&dblsedr[145]);                            
/*rotate velocity components*/                                             
/*    v[1] = [dtrjda[279]]     crotate velocity components  */                    
      v[0] = dtrjda[214];                                                      
/*    v[2] = [dtrjda[280]] */                                                      
      v[1] = dtrjda[215];                                                      
/*    v[3] = [dtrjda[281]] */                                                     
      v[2] = dtrjda[216];                                                      
      cgmprc(a,v,avec);                                             
      blamda = (90.0 + dlamda)*degrad;           
      crot8(blamda,b);                                             
      w[0] = dblsedr[145];                                              
      w[1] = dblsedr[146];                                               
      w[2] = dblsedr[147];                                               
      cgmprc(b,w,bvec);                                              
      for ( i = 0 ; i < 3 ; i++)
      {                                                        
        dblsedr[i+1+147] = avec[i] + lamdad * bvec[i];                     
      }                                                            
/*vector rotation algorithm 3 */                                          
      for (j = 1 ; j <= 10 ; j += 3 )
      {                                                    
        cgmprc(a,&dblsedr[168+j],&dblsedr[150+j]);                     
      }                                                            
                                                                     
/*-----compute sys i sys iii latitude and longitude angles */              
                                                                      
      k = 0;                                                             
      k1 = 0;                                                            
      for (j = 1 ; j <= 13 ; j+= 3 )
      {                                                    
        if ( j == 1 )
        {                                             
/*        dblsedr[180+j] = [dtrjda[301]]   */                                     
          dblsedr[180+j] = dtrjda[236];
        }                                        
        else
        {                                                            
/*        dblsedr[180+j] = [dtrjda[305+k1]]  */                                   
          dblsedr[180+j] = dtrjda[240+k1];                                     
          k1 = k1 +2;                                                   
        }                                                           
/*sys iii long                                                           
        dblsedr[182+j] =360.- [ dtrjda[295+k]]   */                            
        dblsedr[182+j] = 360.- dtrjda[230+k];                                  
/*system i longitude */                                                     
        if (dblsedr[182+j] < 0 )
        {                                     
           dblsedr[182+j] +=  360.;
        }                       
        dblsedr[181+j] = dblsedr[182+j] + dlamda;                              
        if (dblsedr[181+j] < 0 )
        {                                     
            dblsedr[181+j] += 360.;
        }                      
        if (dblsedr[181+j] >= 360.) 
        {                                  
            dblsedr[181+j] -= 360.;
        }                      
        k = k + 1;                                                      
      }                                                            
                                                                      
/*-----end of navigation conversion algorithms*/                           
                                                                      
      dblsedr[196] = dtrjda[12];                                                
      dblsedr[197] = dtrjda[21];                                                 
      dblsedr[198] = dtrjda[15];                                                 
      for (j = 199 ; j <= 204 ; j++)
      {                                                   
/*      dtrjda  148-152 [212-217]  */                                     
        k = j - 52 ;                                                     
        dblsedr[j] = dtrjda[k];                                                 
      }                                                            
      dblsedr[205] = dtrjda[88];                                               
      dblsedr[206] = dtrjda[80];                                               
      dblsedr[207] = dtrjda[87];                                               
/*    dblsedr[208] = dtrjda[261];*/                                              
      dblsedr[208] = dtrjda[196];                                              
/*    dblsedr[209] = dtrjda[262];*/                                             
      dblsedr[209] = dtrjda[197];                                              
/*    dblsedr[210] = dtrjda[263];*/                                            
      dblsedr[210] = dtrjda[198];                                              
/*    dblsedr[211] = dtrjda[264];*/                                             
      dblsedr[211] = dtrjda[199];                                              
                                                                      
/*-----sun aspect angle */                                                 
                                                                      
      for (j = 1 ; j <= 3 ; j++)
      {                                                       
        avec[j-1] = -dblsedr[36+j]/dblsedr[197];
/*    unit vector from s/c to sun */                                      
      } 
      if (dblsedr[26] == 1000. && dblsedr[27] == 1000.)
      {     
         dblsedr[212] = 1000.;                                          
/*      set saa to 1000 if ahf data not available*/
      }                       
      else
      {                                                             
        clong = dblsedr[29] * degrad;                                   
        clat = dblsedr[28] * degrad;                                   
        bvec[0] = cos(clat) * cos(clong);                                      
        bvec[1] = cos(clat) * sin(clong);                                      
        bvec[2] = sin(clat);                                                   
        cosasp = avec[0]*bvec[0] + avec[1]*bvec[1] + avec[2]*bvec[2];    
        dblsedr[212] = acos(cosasp)/degrad;                                    
      }                                                             
                                                                            
/*-----get eme50 ra's & dec's*/                                            
                                                                      
      for (j = 213 ; j <= 218 ; j++)
      {                                                   
/*   savetape 184-189 [249-254]                                      
     k = j + 36  */                                                    
        k = j - 29 ;                                                     
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
                                                                      
/*-----get jupiter centered ra's & dec's  */                               
                                                                      
      for (j = 219 ; j <= 230 ; j++)
      {                                                  
/*   dtrjda 235-246 [300,311]                                        
     k = j + 81  */                                                    
        k = j + 16;                                                      
        dblsedr[j] = dtrjda[k];                                                 
      }                                                            
                                                                      
/*-----get celestial lat's & long's and sun centered ra's & dec's*/        
                                                                      
      for (j = 231 ; j <= 234  ; j++)
      {                                                  
/*      dtrjda [24-27]  */                                                
        k = j - 207;                                                     
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
      for (j = 235 ; j <= 242 ; j++)
      {                                                   
/*   dtrjda 247-254 [312,319]                                        
     k = j + 77 */                                                     
        k = j + 12;                                                      
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
      for (j = 243  ; j <= 247 ; j += 2)
      {                                                  
/*   dtrjda 250-254 [315,319]                                        
     k = 72 + j  */                                                    
        k = j +7;                                                        
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
/*    dblsedr[244] = dtrjda[320]*/                                             
      dblsedr[244] = dtrjda[255];                                                
/*    dblsedr[246] = dtrjda[321] */                                               
      dblsedr[246] = dtrjda[256];                                                
/*    dblsedr[248] = dtrjda[322] */                                              
      dblsedr[248] = dtrjda[257]; 
                                                     
      for (j = 249 ; j <= 265 ; j++)
      {                                                  
/*   dtrjda 323-339 [388-404]                                        
     k = j + 139  */                                                    
        k = j + 74;                                                      
        dblsedr[j] = dtrjda[k];                                                  
      }                                                            
                                                                      
/*-----get saturn ecl50 state vector*/                                     
                                                                      
      for (j = 268 ; j <= 273 ; j++)
      {                                                   
/*   dtrjka 340-345 [405-410]                                        
     k = j + 137*/                                                    
        k = j + 72;                                                      
        dblsedr[j] = dtrjda[k];
      }                                                            
                                                                                                           /*---- COMPUTE NUMBER OF ROTATIONS OF THE SUN RELATIVE TO EARTH                         DRAD = 180.0D0/(4.0D0 * DATAN(1.0D0))                                           DSSI = 2.7D0 * (DSIN(16.0D0/DRAD) **2)                                          DSYN = (13.39D0-DSSI)/(360.0D0 * 86.4D3)                                        TFLANC = DTRJDA(4)                                                              BUF1 = DSYN * TFLANC                                                    
 C------ COMPUTE NUMBER OF ROTATIONS OF THE SUN RELATIVE TO S/C                         SLA = (BUF(244) - 2.0728238)/360.0                                              DSID = (14.38D0-DSSI)/(360.0D0*86.4D3)                                          SLA1 = DSID * TFLANC                                                            ISCOR = 0                                                                       IF (SLA.LE.0.0D0) ISCOR = ISCOR + 1                                             BUF2 = (SLA1 -  SLA -ISCOR)                                                     BUF(266) = BUF1                                                                 BUF(267) = BUF2
*************/
      dssi = 2.7 * pow(sin((double)(16.*degrad)),(double)2.0);
      dsyn = (13.39 - dssi)/(360.0*86400.);
      dblsedr[266] = dsyn * dtrjda[4];
      sla = (dblsedr[244] - 2.0728238)/360.0;
      dsid = (14.38 - dssi)/(360.0*86400.);
      sla1 = dsid * dtrjda[4];
      iscor = 0;
      if (sla <= 0.0)
      {
             iscor++;
      }
      dblsedr[267] = sla1 - sla - iscor;
      return;                                                            
}
