/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: streader.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *
** MANUAL
**	CNVS2DBL 3x, "March 19, 1994"
**
** NAME
**	cnvs2dbl - convert string to double precision
**
** SYNOPSIS
**
**	  #include <sftypes>
**
**	  int cnvs2dbl(strng,dbl);
**
**	  char *strng;
**	  DBL  *dbl;
**
** DESCRIPTION
**
**	The function 'sscanf' is supposed to convert any type of 
**	integer, hex, floating point character strings to there
**	machine type. But on the Macintosh (and maybe others) if
**	you take a double floating point number and print it to
**	a string i.e. sprintf(dbl_strng,"%e",dbl); and then try to
**	use sscanf i.e. sscnaf(dbl_strng,"%e",&dbl); the resulting
**	double precision 'dbl' is incorrect, this goes for %g %E etc.
**	That is why 'cnvs2dbl' was coded.
**
*/
#endif /*  Header */

#include	<stdio.h>
#include	<string.h>
#include	<math.h>
#include	<sftypes.h>

int
cnvs2dbl(dbl_strng,dbl)

char	*dbl_strng;
DBL	*dbl;

{

long	int	ex;
long	int	n1;
long	int	n;
int	len;
int	len1;
char	*pntr;
int	i;
int	j;
char	*ex_pntr;
char	dec_pntr;
char	nmbr[24];
char	nmbr1[24];
char	expon[8];
char	*pntr1;
BOOL	after_dec;
int	aft_dec;
BOOL	sign_nmbr;
BOOL	sign_ex;
BOOL	is_ex;
BOOL	fini;
double	powr;
double	powr1;
double	to10 = 10.0;
double	minus1 = -1.0;
double	use_ex;
double	answr;
double	answr1;

/* the largest 4 byte integer is 2147483647 which is 10 digits long
   so if there are more than 10 digits something needs to be done
   
  first isolate decimal point, then find exponent (if any)
  example 1 dec_strng = '2.4332825000000000D+06' 
  example 2 dec_strng = '-2.4169301333651823D+08'
  example 3 dec_strng = '0.0'
  */	

pntr = dbl_strng;

/*get rid of leading blanks (if any)*/
while (pntr[0] == ' ')
{
	pntr++;
}
len = strlen(pntr);
ex_pntr = NULL;
dec_pntr = 0;
j = 0;
pntr1 = nmbr;
after_dec = FALSE;
aft_dec = 0;
sign_nmbr = FALSE;
sign_ex = FALSE;
is_ex = FALSE;
fini = FALSE;
ex = 0;
n = 0;
n1 = 0;
for ( i = 0 ; i < len ; i++)
{
	if (isdigit(pntr[i]))
	{
		pntr1[j] = pntr[i];
		if (after_dec)
		{
			aft_dec++;
		}
		j++;
		continue;
	}
	switch (pntr[i])
	{
		case 'D':
		case 'd':
		case 'E':
		case 'e':
			/*this starts exponent*/
			pntr1[j] = '\0';
			j = 0;
			pntr1 = expon;
			is_ex = TRUE;
			after_dec = FALSE;
		break;
		case '.':
			after_dec = TRUE;
		break;
		case '+':
		break;
		case '-':
			if (is_ex)
			{
				sign_ex = TRUE;
			}
			else
			{
				sign_nmbr = TRUE;
			}
		break;
		case ' ':
			fini = TRUE;
		break;
		default:
			return(-1);
	}
	if (fini)
	{
		break;
	}
}
pntr1[j] = '\0';
len = strlen(nmbr);
/* in example 1 '2.4332825000000000D+06' aft_dec = 16 
   in example 2 '-2.4169301333651823D+08' aft_dec = 16
   */
if (aft_dec)
{
	for ( i = len -1 ; i > 0 ; i--)
	{
		if (nmbr[i] != '0')
		{
			break;
		}
		aft_dec--;
		nmbr[i] = '\0';
		if (aft_dec <= 1)
		{
			break;
		}
	}
}
/* example 1 nmbr should equal 24332825 and aft_dec should be 7 i.e
   24332825 * 10-7
   example 2 nmbr is 24169301333651823 aft dec is still 16
    i.e. 24169301333651823 * 10-16 */
/*let us get ex if any*/
if (is_ex)
{
	sscanf(expon,"%ld",&ex);
}		
if (sign_ex)
{
	use_ex = (double)(-ex -aft_dec);
}
else
{
	use_ex = (double)(ex - aft_dec);
}
/*use_ex for example 1 is 6 - 7 should be -1.
  use_ex for example 2 is 8 - 16 should be -8
*/
len = strlen(nmbr);
len1 = 0;
if (len > 9)
{
	/*for example 2 len = 17 (which i greater than 9)
	            1
bytes	  01234567890123456789
	          987654321
actual n = 24169301333651823
	  12345678 
	  len - 9 = 8 */
	len1 = len - 9;
	memcpy(nmbr1,nmbr,len1);
	nmbr1[len1] = '\0';
	pntr = &nmbr[len1];
}
else
{
	pntr = nmbr;
}
/*comput n*/
sscanf(pntr,"%ld",&n);
if (len1)
{
	sscanf(nmbr1,"%ld",&n1);
}
/*now do power stuff*/
if (use_ex)
{
	powr = pow(to10,use_ex);
}
else
{
	powr = 1.0;
}
answr = (double)n;
answr *= powr;
if (n1)
{
	use_ex += 9.0;
	/*now do power stuff*/
	if (use_ex)
	{
		powr1 = pow(to10,use_ex);
	}
	else
	{
		powr1 = 1.0;
	}
	answr1 = (double)n1;
	answr1 *= powr1;
	answr += answr1;
}
if (sign_nmbr)
{
	answr *= minus1;
}
dbl[0] = (DBL)answr;

return(0);
}
	
