/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*
** MANUAL
**	DICTMCNV 3x "September 23, 1993"
** NAME
**	dictmcnv - converts between various time formats. Calculates 
**	seconds past epochs of 1950, 2000 and, if desired, an epoch
**	of the users choice.
**
** SYNOPSIS
**
**	  #include <timtyps.h>
**	  #include <glbltme.h>
**
**	  void  dictmcnv(tarray,mon,dow,dptimes,tstrng,type_in,
**	                 type_out,strng_out,rtcode);
**
**	  long int   *tarray;
**	  char       *mon;
**	  char       *dow;
**	  DBL        *dptimes;
**	  char       *tstrng;
**	  char       *type_in;
**	  char       *type_out;
**	  char       *strng_out;
**	  char       *rtcode;
**
**	  NOTE: DBL is defined in 'sftypes.h'. It must be 8 bytes. It 
**	  is  'short double'for the MACINTOSH factory settings. On most 
**	  other machines it can be just 'double' if the double is 8 
**	  bytes.
**
** PARAMETERS AT A GLANCE
**
**	NOTE: The full descrition of each parameter is in
**	PARAMETER DESCRIPTIONS. Also see examples below.
**
**	  1. tarray - long int tarray[16] - time array of different 
**	     times. Input and/or output depending on 'type_in'.
**	  2. mon - char[4] - string month (3 characters). Input 
**	     and/or output depending on 'type_in'. The months are:
**	     JAN, FEB, MAR, APR, MAY, JUN, JUL, AUG, SEP, OCT, 
**	     NOV, DEC (it can be NULL if not wanted or needed).
**	  3. dow - char[4] - string day of the week (3 characters). 
**	     Output.The days are: MON, TUE, WED, THU, FRI, SAT, SUN.
**	     (it can be NULL if not wanted).
**	  4. dptimes - DBL[4] - double precisision times, 
**	     seconds past three epochs and a Julian date. 
**	     Input and/or output depending on 'type_in'.
**	  5. tstrng - char[variable size] - character string of time 
**	     input for 'type_in' equal to 'CHAR'.
**	  6. type_in - char[variable size. Max 12] - type of time 
**	     input for conversion. Input.
**	  7. type_out - char[variable size. Max 12] - if not NULL or 
**	     blank then create a string pointed to by 'strng_out'
**	     based on what is in 'type_out'. Input.
**	  8. strng_out - char[variable size. Max 50] - character  
**	     string output of time types in 'type_out'.
**	  9. rtcode - char[5] - return code 'NORM' for normal 
**	     output. Output.
**
** PARAMATER DESCRIPTIONS
**
**	  1. tarray - long int tarray[16] - time array of different 
**	     times 
**	     1. tarray[0]  - 4 digit year
**	     2. tarray[1]  - doy, day of year
**	     3. tarray[2]  - hoy, hour of year
**	     4. tarray[3]  - second of hour (hoy format)
**	     5. tarray[4]  - month of year
**	     6. tarray[5]  - day of month
**	     7. tarray[6]  - hour of day
**	     8. tarray[7]  - minutes of hour
**	     9. tarray[8]  - seconds of minute
**	    10. tarray[9]  - milliseconds
**	    11. tarray[10] - seconds past 1950
**	    12. tarray[11] - fractional part of seconds past 1950
**	                     Input and output from least 
**	                     signifigant 2 bytes.
**	    13. tarray[12] - seconds from 2000
**	    14. tarray[13] - fractional part of seconds from 2000.
**	                     Input and output from least 
**	                     signifigant 2 bytes.
**	    13. tarray[14] - seconds from other epoch.
**	    14. tarray[15] - fractional part of seconds from some 
**	                     other epoch. Input and output from 
**	                     least signifigant 2 bytes.
**	  2. mon - character month i.e. JAN, FEB, MAR, APR, MAY, 
**	     JUN, JUL, AUG, SEP, OCT, NOV, DEC (it can be NULL 
**	     if not wanted or needed).
**	  3. dow - day of the week, 3 characters i.e. MON, TUES etc.
**	     (it can be NULL if not wanted).   
**	  4. dptimes - dp seconds past epoch and dp Julian date.
**	     1. dptimes[0] - dp seconds past epoch of 1950
**	     2. dptimes[1] - dp seconds past epoch of 2000 
**	        (starts Jan 1 2000 12:00:00.00)
**	     3. dptimes[2] - dp seconds past epoch of choice.
**	     4. dptimes[3] - dp Julian date. Julian date start at
**	        12 noon, not at midnight.
**	        Julian date of 1950 epoch is 2433282.5 (midnight)
**	        Julian date of 2000 epoch is 2451545.0 (noon)
**	        Note the Julian date for the 2000 epoch.
**	  5. tstrng - character string of time in put i.e.
**	     1990 270 12:14:44.567
**	  6. type_in - type of time input for conversion
**	     1. 'DOY' day of year. Inputs are
**	        year, doy, hour, minutes, seconds, milliseconds. 
**	        (tarray indexes 0, 1, 6, 7, 8, 9)
**	     2. 'HOY' hour of year. Inputs are year hoy, seconds of 
**	        hour and milliseconds (tarray indexes 0, 3, 4, 9)
**	     3. 'MONTH'Inputs are year, integer month, day of month, 
**	        hours, minutes, seconds, and milliseconds 
**	        (tarray indexes 0,4,5,6,7,8,9)
**	     4. 'DATE' . Inputs are year, 3 character month 
**	        (input in 'mon'), day of month, hours, miutes, 
**	        seconds, and milliseconds.(tarray indexes 1, 6, 7,
**	         8, 9 and 'mon')
**	     5. 'SP50' integer seconds past 1950. Inputs are 
**	        integer seconds past 1950 and fractional seconds 
**	        (tarray indexes 10, 11) 
**	     6. 'SP50M' integer seconds past 1950. Inputs are
**	        integer seconds past 1950 and milliseconds 
**	        (tarray indexes 9, 10)
**	     7. 'SP2000' integer seconds past 2000. Inputs are
**	        integer seconds past 2000 and fractional seconds 
**	        (tarray indexes 12, 13) 
**	     8. 'SP2000M' integer seconds past 2000. Inputs are
**	        integer seconds past 2000 and milliseconds 
**	        (tarray indexes 9, 12)
**	     9. 'SPEPOCH' integer seconds past some other epoch. 
**	        Inputs are integer seconds past epoch and 
**	        fractional seconds (tarray indexes 14, 15) 
**	    10. 'SP2000M' integer seconds past some other epoch. 
**	        Inputs are integer seconds past epoch and  
**	        milliseconds (tarray indexes 9, 14)
**	    11. 'DP50' double precision seconds past 1950, input in 
**	        'dptimes[0]'
**	    12. 'DP2000' double precision seconds past 2000, input 
**	        in 'dptimes[1]'
**	    13. 'DPEPOCH' double precision seconds past some other 
**	        epoch input in dptimes[2].
**	    14. 'EPOCH xxxx' Set up another epoch. xxxx is any of 
**	        the above, with the exceptions of 'DPEPOCH' and 
**	        'SPEPOCHx'
**	    15. 'DPJULIAN' double precision Julian date.
**	    16. 'CURRENT' get current time from computer.
**	    17. 'CHAR' time input in 'tstrng'
**	        1. Just 'CHAR' the different formats are:
**	           1. yyYY DOY HH:MM:SS.FFF (yy is optional) 
**	              i.e. '1993 203 10:12:15.339'
**	           2. MN DD YYYY HH:MM:SS.FFF (MN is month, DD is 
**	              day of the month) 
**	              i.e. '7 22 1993 10:12:15.339'
**	           3. YYYY MN DD HH:MM:SS.FFF (MN is month, DD is 
**	              day of the month) 
**	              i.e. '1993 7 22 10:12:15.339'
**                 4. YYYY chrmn DD HH:MM:SS.FFF (chrmn is 
**	               character month i.e. 'JANuary')
**	              i.e. '1993 JUL 22 10:12:15.339'
**	           5. chrmn DD YYYY HH:MM:SS.FFF
**	              i.e. 'JULY 22 1993 10:12:15.339'
**	           6. yyYY HOY 'HRS' SSSSS.FFF 'SECS' (yy optional
**	              'chr' is actual characters in string).
**	              i.e. '1993 4882 HRS 735.339 SECS'
**	           7. 'HOY' yyYY HOY SSSSS.FFF 
**	              i.e. 'HOY 1993 4882 735.339'
**	           8. 'SP50' SSSSSSSSS.FFF
**	              i.e. 'SP50 1374487935.339' 
**	           9. 'SP50X' xxxxxxxx xxxx (in hex)
**	              i.e. 'SP50X 51ED057F  56C8'
**	          10. 'SP2000' SSSSSSSSS.FFF
**	              i.e. 'SP2000 -203392064.339'
**	          11. 'SP2000X' xxxxxxxx xxxx (in hex)
**	              i.e. 'SP2000X F3E07BC0  A937'
**	          12. 'SPEPOCH' SSSSSSSSS.FFF (epoch of choice 
**	              is 1970)
**	              i.e. 'SPEPOCH 743335935.339'
**	          13. 'SPEPOCHX' xxxxxxxx xxxx (in hex)
**	              i.e. 'SPEPOCHX 2C4E67FF 0000'
**	    18. 'CCSDSBUNSG5' - CCSDS unsegmented time code.
**	        Input is a binary byte stream. See CCSDS in 
**	        description. From epoch of 1950.
**	    19. 'CCSDSBUNSG2' - CCSDS unsegmented time code.
**	        Input is a binary byte stream. See CCSDS in 
**	        description. From epoch of 2000.
**	    20. 'CCSDSBUNSGE' - CCSDS unsegmented time code.
**	        Input is a binary byte stream. See CCSDS in 
**	        description. From users epoch.
**	    21. 'CCSDSDAYSG5' - CCSDS day segmented time code.
**	        Input is a binary byte stream. See CCSDS in 
**	        description. From epoch of 1950.
**	    22. 'CCSDSDAYSG2' - CCSDS day segmented time code.
**	        Input is a binary byte stream. See CCSDS in 
**	        description. From epoch of 2000.
**	    23. 'CCSDSDAYSGE' - CCSDS day segmented time code.
**	        Input is a binary byte stream. See CCSDS in 
**	        description. From users epoch.
**	    24. 'CCSDSDOYSG' (DOY Calendar segmented time code).
**	        Input is a BCD byte stream. See CCSDS in 
**	        description.
**	    25. 'CCSDSYMDSG' (Year Month Day Calendar segmented 
**	                     time code).
**	        Input is a BCD byte stream. See CCSDS in 
**	        description.
**
**	  7. type_out - if not NULL or blank then create an output 
**	     string based on what is in 'type_out'
**
**	   NOTE: THE INPUT DERSCRIBED IN PARENS '()' IS FOR 
**	   'type_in'EQUAL TO NULL. IF 'type_in' IS NOT NULL THEN
**	   ALL THE DIFFERENT 'type_out's CAN BE CALCULATED.
*
**	   1993 203 10:12:15.339 is the date used in the examples
**	   1970 is the epoch of choice
**	    1. For type_out = 'DOY' (input is year, doy, hour,
**	                       minutes, seconds and milliseconds).
**	       output is 1993 203 10:12:15.339
**	    2. For type_out = 'HOY' (input is year hoy, seconds of 
**	                      hour and milliseconds).
**	       output is 1993 4882 HRS 735.339 SECS
**	    3. For type_out = 'MONTH' (input is year, integer month,
**	                      day of month,hour, minutes, seconds
**	                      and  milliseconds).
**	       output is 1993 7 22 10:12:15.339
**	    4. For type_out = 'MNDY' (input is integer month,day of 
**	                       month, year,hour, minutes,
**	                       seconds and  milliseconds).
**	       output is 7 22 1993 10:12:15.339
**	    5. For type_out = 'DATE' (input is year 3 char month,
**	                       day of month, hour, minutes, 
**	                       seconds and milliseconds).
**	       output is 1993 JUL 22 10:12:15.339
**	    6. For type_out = 'MDY' (input is year, 3 char month, 
**	                      day of month, hour, minutes,
**	                      seconds and milliseconds).
**	       output is JUL 22 1993 10:12:15.339
**	    7. For type_out = 'SP50' (input is integer seconds and
**	                      fractional seconds).
**	       output is 1374487935.339 seconds from 1950
**	    8. For type_out = 'SP2000'  (input is integer seconds 
**	                       and fractional seconds).
**	       output is -203392064.339 seconds from 2000
**	    9. For type_out = 'SP50M' (input is integer seconds 
**	                      and milliseconds).
**	       output is 1374487935.339 seconds from 1950
**	   10. For type_out = 'SP2000M'  (input is integer seconds
**	                       and milliseconds).
**	       output is -203392064.339 seconds from 2000
**	   11. For type_out = 'DP50' (input is double precision
**	                      seconds).
**	       output is 1374487935.339 seconds from 1950
**	   12. For type_out = 'DP2000' (input is double precision
**	                      seconds).
**	       output is -203392064.661 seconds from 2000
**	   13. For type_out = 'DP50E' (input is double precision
**	                      seconds).
**	       output is 1.374487935339E+09 seconds from 1950
**	   14. For type_out = 'DP2000E' (input is double precision
**	                      seconds).
**	       output is -2.033920646610E+08 seconds from 2000
**	   15. For type_out = 'SP50X' (input is integer seconds and
**	                      fractional seconds).
**	       output is 51ED057F  56C9 seconds, in hex, from 1950
**	   16. For type_out = 'SP2000X'  (input is integer seconds
**	                      and fractional seconds).
**	       output is F3E07BC0  A937 seconds, in hex, from 2000
**	   17. For type_out = 'DP50X' (input is double precision 
**	                      seconds).
**	       output is 41D47B41 5FD5B22D DP hex secs from 1950
**	   18. For type_out = 'DP2000X' (input is double precision
**	                      1950 seconds).
**	       output is C1A83F08 81526E98 DP hex secs from 2000
**	   19. For type_out = 'SPEPOCH'  (input is integer seconds 
**	                      and fractional seconds).
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   20. For type_out = 'SPEPOCHM'  (input is integer seconds
**	                      2000 and milliseconds).
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   21. For type_out = 'DPEPOCH' (input is double precision
**	                      seconds).
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   22. For type_out = 'DPEPOCHE' (input is double precision
**	                       seconds).
**	       output is 7.433359353390E+08 seconds from JAN 1 1970 
**	   23. For type_out = 'SPEPOCHX' (input is integer seconds 
**	                      and fractional seconds).
**	       output is 
**	       2C4E67FF  56C9 seconds, in hex, from JAN 1 1970 
**	   24. For type_out = 'DPEPOCHX'  (input is double precision
**	                      seconds)
**	       output is 
**	       41C62733 FFAB645A DP hex secs from JAN 1 1970 
**	   25. For type_out = 'DPJULIAN' (input is double precision
**	                      1970 Julian date).
**	       output is Julian date 2449190.925
**	   26. For type_out = 'DPJULIANE' (input is double precision
**	                      Julian date).
**	       output is Julian date 2.449190925178E+06
**	   27. For type_out = 'DPJULIANX' (input is double precision
**	                      Julian date).
**	       output is Julian date (in hex) 4142AF93 766C37AB
**	   28. For type_out = 'CCSDSDOY' (input is same as DOY)
**	       output is Julian date (in hex) 4142AF93 766C37AB
**	   29. For type_out = 'CCSDSMONTH' (input is same as MONTH).
**	       output is 1993-07-22T10:12:15.339
**	   30. For type_out = 'CCSDSDOYSG5' (DOY Calendar segmented 
**	                      time code).
**	       (input is 'CCSDSDOYSG' in 'tstrng')
**	       output is a BCD byte stream. See CCSDS in 
**	       description.
**	       output is 1993 203 10:12:15.339 
**	   31. For type_out = 'CCSDSYMDSG' (Year Month Day Calendar 
**	                                      segmented time code).
**	       (input is 'CCSDSYMDSG' in 'tstrng')
**	       output is a BCD byte stream. See CCSDS in 
**	       description.
**	       output is 1993 07 22 10:12:15.339 
**	   32. For type_out = 'CCSDSUNSG5' (unsegmnted time code)
**	       (input is 'CCSDSUNSG5' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 1374487935.339 seconds from 1950
**	   33. For type_out = 'CCSDSUNSG2' (unsegmnted time code)
**	       (input is 'CCSDSUNSG2' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is -203392064.661 seconds from 2000
**	   34. For type_out = 'CCSDSUNSGE' (unsegmnted time code)
**	       (input is 'CCSDSUNSGE' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   35. For type_out = 'CCSDSDAYSG5' (day segmented time 
**	       code). (input is 'CCSDSDAYSG5' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 
**	          15908 days 36735339 milliseconds past 1950
**	   36. For type_out = 'CCSDSDAYSG2' (day segmented time 
**	       code). (input is 'CCSDSDAYSG2' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 
**	           -2354 days -6464661 milliseconds past 2000
**	   37. For type_out = 'CCSDSDAYSGE' (day segmented time 
**	       code). (input is 'CCSDSDAYSGE' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 
**	          8603 days 36735339 milliseconds past JAN 1 1970 
**	   38. For type_out = 'EPOCH xxxx'. Output users epoch in 
**	       whatever format is specified by 'xxxx' (non epoch 
**	       output or any CCSDS non ASCII output).
**
**	  8. strng_out - character string ouput of time types in 
**	    'type_out'.
**	  9. rtcode - return code 'NORM' for normal output
**
** EXTERNS
**
**	 1. EPS - EPOCH_STRUCT - structure for epochs other
**	    than 1950 0r 2000. See 'glbltme.h'
**	 structure is
**
**	 struct epoch_struct {
**	       char    char_epoch[24];
**	       long    int     epoch_tarray[SIZE_OF_TARRAY];
**	       DBL     epoch_dptimes[SIZE_OF_DPS];
**	       char    epoch_mon[4];
**	       char    epoch_dow[4];
**	       char    new_epoch[4];
**	       BOOL    find_epoch_times;
**	 };
**	 typedef struct epoch_struct EPOCH_STRUCT;
** 
** DEFINES
**
**	'dictmcnv' uses conditional compiles to port between 
**	different platforms (I know this is not risk free but
**	it is expediant). These conditional compiles use define 
**	symbol(s) when you envoke the compiler instead of in the
**	C code.
**	
**	There are '#if's needed to compute current time and use the
**	proper 'double'. This procedure use 'DBL' defined in
**	'sftypes.h'. The define for this is 'MAC'.
**
**	For finding current times the defines are
**	  1. IBM_MAIN_FRAME - used on the IBM ES-9000.
**	  2. NOCURRTIME - Do not try to get current time.
**
** DESCRIPTION
**
**	'dictmcnv' is a 'C' procedure which calculates all the other 
**	times and can ouput a character string of various time types. 
**
**	'dictmcnv' inputs/outputs seconds past epochs of 1950, 2000 
**	and if desired seconds past an epoch of choice (other than 
**	1950 or 2000 i.e. 1970).
**
**	NOTE: EPOCH 2000 STARTS AT JULIAN DATE 2451545.0, 
**	which is Jan 1 2000 AT NOON.
**
**	If 'type_in' is not NULL or blank then ALL OTHER time types 
**	are calculated and output. Most of the inputs are four byte 
**	integers, the exceptions being 'CHAR'. See examples below for 
**	inputs and outputs of the different types.
**
**	If 'type_out' is NULL or blank then no time character string 
**	is output. Else a string of type 'type_out' is output.
**
**	NOTE: The input is designed to be called from FORTRAN 
**	as well as C procedures.
**
**	If the user wishes to use another epoch besides 1950 or 2000, 
**	the user first establishes this by inputting 'EPOCH xxxx', 
**	where xxxx is any legal 'type_in' (not including other epoch 
**	inputs). The epoch can be any date, and hours, minutes and 
**	seconds of that date, milliseconds for the epoch are not 
**	allowed.
**
**	2018 019 (January 19) 03:14:07.999, is the last allowable 
**	integer input for seconds from 1950.
**
**	HOY (hour of the year) starts at 24 hours at midnight 
**	January 1st.
**
**	Fractional integer seconds are the seconds less than one.
**	These are multiplied by 1000 hex, to shift them into an 
**	unsigned 16 bit integer, this 16 bit integer is 
**	   union {
**	          long int  fractl;
**	          unsigned short fracts[2];
**	   } fractu;
**	where fractu.fractl equals tarray[11] or tarray[13] and
**	the true fractional seconds equals fractu.fracts[1].
**
**	The allowed character inputs for 'type_in' = 'CHAR' or 
**	'EPOCH CHAR' are:
**	
**	   1. For DOY they are
**	        1. YY DOY HH:MM:SS.FFF
**	        2. YYYY DOY HH:MM:SS.FFF
**	        3. YYYY-DOY/HH:MM:SS.FFF
**	        4. YYYY DOYTHH:MM:SS.FFF
**	        5. YYYY DOY HH MM SS
**	        6. YYYY DOY HH MM SS.FFF
**	        7. YYYY DOY (4 digit year and 3 digit DOY MUST 
**	           be input)
**	      Or any combintions of the above.
**	   2. For HOY they are
**	        1. YYYY hhhh ssss.FFF
**	        2. YY hhhh ssss.FFF
**		3. 'HOY' YYYY hhhhh ssss.FFF
**	        4. 'HOY' YYYY hhhhh ssss
**	        5. YYYY hhhhh 'HRS' ssss.FFF 'SECS'
**	        6. YYYY hhhhh 'HRS' ssss 'SECS'
**	   3. For Seconds past 1950
**	       1. 'SP50' sssssss.FFF
**	       2. 'SP50' sssssss
**	       3. 'SP50X' xxxx xx (hex input)
**	   4. For Seconds past 2000
**	       1. 'SP2000' sssssss.FFF
**	       2. 'SP2000' sssssss
**	       3. 'SP2000X' xxxx xx (hex input)
**	   5. For Month
**	       1. YYYY MN DD HH:MM:SS.FFF
**	       2. YY MN DD HH MM SS.FFF
**	       3. YY MN DD HH:MM:SS
**	       4. YYYY MN DD (4 digit year must be input)
**	      Or any combinations of the above.
**	   6. For Date (i.e. Character months i.e. July JUL etc.)
**	       1. 'mon' DD YYYY HH:MM:SS.FFF
**	       2. 'mon' YYYY DD HH MM SS.FFF
**	       3. YYYY 'mon' DD HH:MM:SS.FFF
**	       4. 'mon' DD YYYY
**	       5. 'mon' YYYY DD
**	       6. YYYY 'mon' DD
**	       The four digit year MUST be input for the above.
**	NOTE: Lower case integers, i.e. hhhh, indicates variable 
**	      length inputs. Upper case integers, i.e. DOY, 
**	      indicates the exact length for inputs. Single quotes 
**	      means that  this is ascii input, if it is upper case,   
**	      i.e. 'HOY' this is what must be input, for lower case, 
**	      i.e. 'mon' this has several inputs. For 'mon' these 
**	      can be,  'JANuary' 'FEBruary' 'MARch' 'APRil' 'MAY'  
**	      'JUNe''JULy' 'AUGust' 'SEPtember' 'OCTober' 
**	     'NOVember'  'DECember'. Only the first 3 chracters of 
**	      the month need to be input although the full name can 
**	      be input.
**
**	If 'type_out' is not blank or NULL then the string output is
**	   1993 203 10:12:15.339 is the date used in the examples
**	   1970 is the epoch of choice
**	    1. For type_out = 'DOY' (input is year, doy, hour,
**	                       minutes, seconds and milliseconds).
**	       output is 1993 203 10:12:15.339
**	    2. For type_out = 'HOY' (input is year hoy, seconds of 
**	                      hour and milliseconds).
**	       output is 1993 4882 HRS 735.339 SECS
**	    3. For type_out = 'MONTH' (input is year, integer month,
**	                      day of month,hour, minutes, seconds
**	                      and  milliseconds).
**	       output is 1993 7 22 10:12:15.339
**	    4. For type_out = 'MNDY' (input is integer month,day of 
**	                       month, year,hour, minutes,
**	                       seconds and  milliseconds).
**	       output is 7 22 1993 10:12:15.339
**	    5. For type_out = 'DATE' (input is year 3 char month,
**	                       day of month, hour, minutes, 
**	                       seconds and milliseconds).
**	       output is 1993 JUL 22 10:12:15.339
**	    6. For type_out = 'MDY' (input is year, 3 char month, 
**	                      day of month, hour, minutes,
**	                      seconds and milliseconds).
**	       output is JUL 22 1993 10:12:15.339
**	    7. For type_out = 'SP50' (input is integer seconds and
**	                      fractional seconds).
**	       output is 1374487935.339 seconds from 1950
**	    8. For type_out = 'SP2000'  (input is integer seconds 
**	                       and fractional seconds).
**	       output is -203392064.339 seconds from 2000
**	    9. For type_out = 'SP50M' (input is integer seconds 
**	                      and milliseconds).
**	       output is 1374487935.339 seconds from 1950
**	   10. For type_out = 'SP2000M'  (input is integer seconds
**	                       and milliseconds).
**	       output is -203392064.339 seconds from 2000
**	   11. For type_out = 'DP50' (input is double precision
**	                      seconds).
**	       output is 1374487935.339 seconds from 1950
**	   12. For type_out = 'DP2000' (input is double precision
**	                      seconds).
**	       output is -203392064.661 seconds from 2000
**	   13. For type_out = 'DP50E' (input is double precision
**	                      seconds).
**	       output is 1.374487935339E+09 seconds from 1950
**	   14. For type_out = 'DP2000E' (input is double precision
**	                      seconds).
**	       output is -2.033920646610E+08 seconds from 2000
**	   15. For type_out = 'SP50X' (input is integer seconds and
**	                      fractional seconds).
**	       output is 51ED057F  56C9 seconds, in hex, from 1950
**	   16. For type_out = 'SP2000X'  (input is integer seconds
**	                      and fractional seconds).
**	       output is F3E07BC0  A937 seconds, in hex, from 2000
**	   17. For type_out = 'DP50X' (input is double precision 
**	                      seconds).
**	       output is 41D47B41 5FD5B22D DP hex secs from 1950
**	   18. For type_out = 'DP2000X' (input is double precision
**	                      1950 seconds).
**	       output is C1A83F08 81526E98 DP hex secs from 2000
**	   19. For type_out = 'SPEPOCH'  (input is integer seconds 
**	                      and fractional seconds).
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   20. For type_out = 'SPEPOCHM'  (input is integer seconds
**	                      2000 and milliseconds).
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   21. For type_out = 'DPEPOCH' (input is double precision
**	                      seconds).
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   22. For type_out = 'DPEPOCHE' (input is double precision
**	                       seconds).
**	       output is 7.433359353390E+08 seconds from JAN 1 1970 
**	   23. For type_out = 'SPEPOCHX' (input is integer seconds 
**	                      and fractional seconds).
**	       output is 
**	       2C4E67FF  56C9 seconds, in hex, from JAN 1 1970 
**	   24. For type_out = 'DPEPOCHX'  (input is double precision
**	                      seconds)
**	       output is 
**	       41C62733 FFAB645A DP hex secs from JAN 1 1970 
**	   25. For type_out = 'DPJULIAN' (input is double precision
**	                      1970 Julian date).
**	       output is Julian date 2449190.925
**	   26. For type_out = 'DPJULIANE' (input is double precision
**	                      Julian date).
**	       output is Julian date 2.449190925178E+06
**	   27. For type_out = 'DPJULIANX' (input is double precision
**	                      Julian date).
**	       output is Julian date (in hex) 4142AF93 766C37AB
**	   28. For type_out = 'CCSDSDOY' (input is same as DOY)
**	       output is Julian date (in hex) 4142AF93 766C37AB
**	   29. For type_out = 'CCSDSMONTH' (input is same as MONTH).
**	       output is 1993-07-22T10:12:15.339
**	   30. For type_out = 'CCSDSDOYSG5' (DOY Calendar segmented 
**	                      time code).
**	       (input is 'CCSDSDOYSG' in 'tstrng')
**	       output is a BCD byte stream. See CCSDS in 
**	       description.
**	       output is 1993 203 10:12:15.339 
**	   31. For type_out = 'CCSDSYMDSG' (Year Month Day Calendar 
**	                                      segmented time code).
**	       (input is 'CCSDSYMDSG' in 'tstrng')
**	       output is a BCD byte stream. See CCSDS in 
**	       description.
**	       output is 1993 07 22 10:12:15.339 
**	   32. For type_out = 'CCSDSUNSG5' (unsegmnted time code)
**	       (input is 'CCSDSUNSG5' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 1374487935.339 seconds from 1950
**	   33. For type_out = 'CCSDSUNSG2' (unsegmnted time code)
**	       (input is 'CCSDSUNSG2' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is -203392064.661 seconds from 2000
**	   34. For type_out = 'CCSDSUNSGE' (unsegmnted time code)
**	       (input is 'CCSDSUNSGE' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 743335935.339 seconds from JAN 1 1970 
**	   35. For type_out = 'CCSDSDAYSG5' (day segmented time 
**	       code). (input is 'CCSDSDAYSG5' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 
**	          15908 days 36735339 milliseconds past 1950
**	   36. For type_out = 'CCSDSDAYSG2' (day segmented time 
**	       code). (input is 'CCSDSDAYSG2' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 
**	           -2354 days -6464661 milliseconds past 2000
**	   37. For type_out = 'CCSDSDAYSGE' (day segmented time 
**	       code). (input is 'CCSDSDAYSGE' in 'tstrng')
**	       output is a binary byte stream. See CCSDS in 
**	       description.
**	       output is 
**	          8603 days 36735339 milliseconds past JAN 1 1970 
**	   38. For type_out = 'EPOCH xxxx'. Output users epoch in 
**	       whatever format is specified by 'xxxx' (non epoch 
**	       output or any CCSDS non ASCII output).
**
**	If there exists an epoch of choice then the user can get a 
**	string output for this epoch by proceeding any of the 
**	above 'type_out's (1 - 17) with the word 'EPOCH'.
**	No type_in is needed for this, BUT an epoch must have 
**	been input prior or at the same time as the request.
**
**	NOTE: for ANY 'type_in' the neccessary input for ANY 'type_out'
**	exists so that ONLY the input necessary for 'type_in' is needed.
**
**	Be sure that the space allocation for 'strng_out' is sufficient 
**	for the type of output wanted.
**
**	Consultive Commitee for Space Data Systems (CCSDS) time formats.
**
**	The CCSDS time code formats (none ASCII) contain a preamble
**	field 'P' and a time field 'T'. The preamble field is optional
**	and is not used in 'dictmcnv'. For CCSDS the binary times 
**	can be past the epoch of 1950, 2000 or the users supplied epoch.
**	The different non ASCII CCSDS inputs, identified by 'type_in' 
**	are input as a byte stream in 'tstrng'. The different non ASCII
**	CCSDS outputs, identified by 'type_out' are output as a byte 
**	stream in 'strng_out'. These CCSDS times are as follows.
**	
**	The CCSDS unsegmented time code is a binary time calculated
**	from some epoch. This time is the same as integer seconds past 
**	an epoch plus the fractional seconds but is input and output as 
**	a byte stream. The time consists of 4 bytes of course time 
**	(4 byte integer seconds past an epoch) then 2 bytes of 
**	fractional seconds. 'type_in' is 'CCSDSBUNSG5', for seconds 
**	from 1950, 'CCSDSBUNSG2' for seconds past 2000 and 'CCSDSBUNSGE'
**	for seconds past the users supplied epoch, the input is in
**	'tstrng. 'type_out' is 'CCSDSBUNSG5', 'CCSDSBUNSG2', and
**	'CCSDSBUNE' and the output is in 'strng_out'.
**
**	The CCSDS day segmented time code is a binary time calculated
**	from some epoch. This time consists of 3 bytes of days from
**	the epoch then 4 bytes of milliseconds in the day. 'type_in' is
**	'CCSDSDAYSG5', for days from 1950, 'CCSDSDAYSG2, for days from
**	2000 and 'CCSDSDAYSGE' for days from the users supplied epoch
**	the input byte stream is in 'tstrng'. 'type_out' is 
**	'CCSDSDAYSG5', 'CCSDSDAYSG2' and 'CCSDSDAYSGE' and the output 
**	byte stream is in 'strng_out'.
**
**	CCSDS calendar segmented time codes. There are two different
**	calendar segmented time codes. Both time codes are in segmented
**	BCD (Binary Coded Decimal). They are input in 'tstrng' and
**	output in 'out_strng'. They are:
**	  1. CCSDSYMDSG - Year Month Day segmented and consists
**	     of YYYYMNDDHHMMFFFz.
**	  2. CCSDSDOYSG - DOY segmented time and consists of
**	     YYYYzDOYHHMMSSFFFz. Where 'z'
**	     is 4 bits set to zero.
**	
**	The two CCSDS ASCII time codes are:
**	  1. CCSDSDOY - CCSDS DOY ASCII time. This is ASCII and is
**	     YYYY-DOYTHH:MM:SS.FFF. The input type is 'CHAR' and 
**	     is input as a string in 'tstrng'. The ouput type is
**	     'CCSDSDOY' and is a string output in 'strng_out'.
**	  2. CCSDSMONTH - CCSDS MONTH ASCII time. This is ASCII and 
**	     is YYYY-MN-DDTHH:MM:SS.FFF. The input type is 'CHAR' 
**	     and  is input as a string in 'tstrng'. The ouput type 
**	     is 'CCSDSMONTH' and is a string output in 'strng_out'.
**
** RETURN
**	
**	if there is no errors  'dictmcnv' returns "NORM" in rtcode 
**	else it returns "yyyX" where 'yyy' is shown in ERRORS below.
**
** ERRORS
**	'dictmcnv' returns the following strings in 'rtcode' for 
**	errors encountered in this procedure.
**	 
**	  'CADX'  Alpha character after decimal.  
**	  'CHRX'  Error in character input.  
**	  'CSEX'  Unknown character input. 
**	  'CURX'  Current time not found.  
**	  'DATX'  Chacter month incorrect.   
**	  'DAOX'  Day of month is out of range.   
**	  'DOYX'  Day of year input is incorrect.   
**	  'DPOX'  Double precision input is incorrect.   
**	  'DYOX'  Day of year is out of range.   
**	  'EPNX'  Other Epoch type not there  
**	  'EPCX'  Error in character string for epoch  
**	  'HOYX'  Input to hoy incorrect.   
**	  'HROX'  Hour is out of range.   
**	  'HXOX'  Number of hex characters inconsistent.  
**	  'HYCX'  Characters in hoy incorrect.   
**	  'HYOX'  Hoy is out of range.   
**	  'MMOX'  Minute is out of range.   
**	  'MNOX'  Month is out of range.   
**	  'MONX'  Month input is incrrect.   
**	  'MSOX'  Milliseconds is out of range.
**	  'NEMX'  No epoch genereated, milliseconds found.   
**	  'NEPX'  No epoch inputs found.  
**	  'NYRX'  No year input.  
**	  'PRSX'  Error from parsing procedure.   
**	  'SCOX'  Second is out of range.   
**	  'SFEX'  Seconds from epoch incorrect.   
**	  'SFOX'  Seconds from epoch out of range.   
**	  'SHOX'  Seconds of hour is out of range.   
**	  'YROX'  Year out of range.   
**	  'WNCX'  Wrong number of arguments input in 'tstrng'.   
**
** TYPE_IN ALPHABETICAL
**
**	  1. 'CCSDSDAYSG2' Day segmented time code from 2000.
**	  2. 'CCSDSDAYSG5' Day segmented time code from 1950
**	  3. 'CCSDSDAYSGE' Day segmented time code from users.
**	  4. 'CCSDSDOYSG'  Calendar DOY segmented time code.
**	  5. 'CCSDSBUNSG2' Unsegmented time code from 2000.
**	  6. 'CCSDSBUNSG5' Unsegmented time code from 1950.
**	  7. 'CCSDSBUNSGE' Unsegmented time code from user.
**	  8. 'CCSDSYMDSG'  Calendar DOY segmented time code.
**	  9. 'CHAR' time input in 'tstrng'
**	 10. 'CURRENT' get current time from computer.
**	 11. 'DATE' Year, 3 character month(input in 'mon'), day of 
**	      month, hours, miutes, seconds, and milliseconds.
**	 12. 'DOY' day of year. 
**	 13. 'DP50' double precision seconds past 1950
**	 14. 'DP2000' double precision seconds past 2000
**	 15. 'DPEPOCH' double precision seconds past some other 
**	      epoch.
**	 16. 'DPJULIAN' double precision Julian date.
**	 17. 'EPOCH xxxx' Set up another epoch. 
**	 18. 'HOY' hour of year
**	 19. 'MONTH' Year, month, day of month, hours, minutes, seconds
**	     and milliseconds.
**	 20. 'SP50' integer seconds past 1950.
**	 21. 'SP50M' integer seconds past 1950 use milliseconds.
**	 22. 'SP2000' integer seconds past 2000
**	 23. 'SP2000M' integer seconds past 2000 use milliseconds.
**	 24. 'SPEPOCH' integer seconds past some other epoch. 
**	 25. 'SPEPOCHM' integer seconds past some other epoch. Use
**	     mills. 
** 
** TYPE_OUT ALPHABETICAL
** 
**	  1. 'CCSDSDAYSG2' Day segmented time code from 2000.
**	  2. 'CCSDSDAYSG5' Day segmented time code from 1950.
**	  3. 'CCSDSDAYSGE' Day segmented time code from users.
**	  4. 'CCSDSDOY'    ASCII DOY time format.
**	  5. 'CCSDSDOYSG'  Calendar DOY segmented time code.
**	  6. 'CCSDSMONTH'  ASCII MONTH time format.
**	  7. 'CCSDSBUNSG2' Unsegmented time code from 1950.
**	  8. 'CCSDSBUNSG5' Unsegmented time code from 2000.
**	  9. 'CCSDSBUNSGE' Unsegmented time code from users.
**	 10. 'CCSDSYMDSG'  Calendar DOY segmented time code.
**	 11. 'DATE'
**	 12. 'DOY' day of year. 
**	 13. 'DP50' double precision seconds past 1950.
**	 14. 'DP50E' Exponential dp seconds past 1950.
**	 15. 'DP50X' Hex dp seconds past 1950.
**	 16. 'DP2000' double precision seconds past 2000.
**	 17. 'DP2000E' Exponential dp seconds past 2000.
**	 18. 'DP2000X' Hex dp seconds past 2000.
**	 19. 'DPEPOCH' double precision seconds past some other 
**	     epoch.
**	 20. 'DPEPOCHE' Exponential dp secs past users epoch.
**	 21. 'DPEPOCHX' Hex dp secs past users epoch.
**	 22. 'DPJULIAN' double precision Julian date.
**	 23. 'DPJULIANE' Exponetial dp Julian date.
**	 24. 'DPJULIANX' Hex dp Julian date.
**	 25. 'EPOCH xxxxx' Users epoch output type in 'xxxx' i.e. 
**	     'EPOCH DOY'.
**	 26. 'HOY' hour of year.
**	 27. 'MDY' Month (character) Day Year.
**	 28. 'MNDY' Month (digits) Day Year.
**	 29. 'MONTH'.
**	 30. 'SP50' integer seconds past 1950.
**	 31. 'SP50M' integer seconds past 1950 use milliseconds.
**	 32. 'SP50X' Hex integer seconds past 1950.
**	 33. 'SP2000' integer seconds past 2000.
**	 34. 'SP2000M' integer seconds past 2000 use milliseconds.
**	 35. 'SP2000X' Hex integer seconds past 2000.
**	 36. 'SPEPOCH' integer seconds past some other epoch. 
**	 37. 'SPEPOCHM' integer seconds past users epoch. Use mills.
**	 38. 'SPEPOCHX' Hex integer secs past users epoch.
**	 
** EXAMPLE


The examples are for 
   1. 1993 203 (July 22) 10:12:15.339 
   2. 2018 019 (January 19) 03:14:07.999
      The last allowable input for integer seconds past 1950.
   3. 2020 203 (July 21) 10:12:15.339
With the epoch of choice midnight January 1st 1970.
  
First set of examples are for 1993 203 (July 22) 10:12:15.339 
The definitions and call used in this example are:

	long	int	tarray[16];
	char	mon[4];
	char	dow[4];
	DBL	dptimes[4];
	char	tstrng[80];
	char	type_in[12];
	char	type_out[12];
	char	strng_out[40];
	char	rtcode[5];

	dictmcnv(tarray,mon,dow,dptimes,tstrng,type_in,type_out,
	         strng_out,rtcode);
	

Example 1. CHAR

The inputs are: 'type_in' is 'CHAR', 'type_out' is 'DOY'
'tstrng' is '1993 203 10:12:15.339'
The outputs are:

THR JUL 22 1993

Year        - tarray[0]  = 1993
DOY         - tarray[1]  = 203
HOY         - tarray[2]  = 4882
Sec of Hr   - tarray[3]  = 735
Month       - tarray[4]  = 7
Day of mn   - tarray[5]  = 22
Hours       - tarray[6]  = 10
Minutes     - tarray[7]  = 12
Seconds     - tarray[8]  = 15
Millisecs   - tarray[9]  = 339
SP50        - tarray[10] = 1374487935, (in hex '51ED57F')
Frac (1950) - tarray[11] = 22217, (in hex '56C9')
SP2000      - tarray[12] = -203392064, (in hex 'F3E07BC0')
Frac (2000) - tarray[13] = 43319, (in hex 'A937')
No Epoch of choice.
DP50   - 'sfepoch[0]' = 1.374487935339E+09
DP2000 - 'sfepoch[1]' = -2.033920646610E+08
Julian Date - 'sfepoch[3]' = 2449190.925
'strng_out' is '1993 203 10:12:15.339'


Example 2. EPOCH CHAR

Create an epoch of choice.
The inputs are: 'type_in' is 'EPOCH CHAR', 'type_out' is 'EPOCH MDY'
'tstrng' is '1970 1 1 00:00:00.000'
The outputs are:

THR JAN 1 1970

Year        - tarray[0]  = 1970
DOY         - tarray[1]  = 1
HOY         - tarray[2]  = 24
Sec of Hr   - tarray[3]  = 0
Month       - tarray[4]  = 1
Day of mn   - tarray[5]  = 1
Hours       - tarray[6]  = 0
Minutes     - tarray[7]  = 0
Seconds     - tarray[8]  = 0
Millisecs   - tarray[9]  = 0
SP50        - tarray[10] = 631152000, (in hex '259E9D80')
Frac (1950) - tarray[11] = 0, (in hex '0')
SP2000      - tarray[12] = -946728000, (in hex 'C79213C0')
Frac (2000) - tarray[13] = 0, (in hex '0')
No Epoch of choice.
DP50   - 'sfepoch[0]' = 6.311520000000E+08
DP2000 - 'sfepoch[1]' = -9.467280000000E+08
Julian Date - 'sfepoch[3]' = 2440587.500
'strng_out' is 'JAN 1 1970 00:00:00.000'


Example 3. HOY

The inputs are: 'type_in' is 'HOY', 'type_out' is 'HOY'
tarray[0] = 1993, ..[2] = 4882, ..[3] = 735, ..[9] = 339
The outputs are:

THR JUL 22 1993

Year        - tarray[0]  = 1993
DOY         - tarray[1]  = 203
HOY         - tarray[2]  = 4882
Sec of Hr   - tarray[3]  = 735
Month       - tarray[4]  = 7
Day of mn   - tarray[5]  = 22
Hours       - tarray[6]  = 10
Minutes     - tarray[7]  = 12
Seconds     - tarray[8]  = 15
Millisecs   - tarray[9]  = 339
SP50        - tarray[10] = 1374487935, (in hex '51ED57F')
Frac (1950) - tarray[11] = 22217, (in hex '56C9')
SP2000      - tarray[12] = -203392064, (in hex 'F3E07BC0')
Frac (2000) - tarray[13] = 43319, (in hex 'A937')
SPEPOCH     - tarray[14] = 743335935, (in hex '2C4E67FF')
Frac (EPOCH)- tarray[15] = 22217, (in hex '56C9')
DP50   - 'sfepoch[0]' = 1.374487935339E+09
DP2000 - 'sfepoch[1]' = -2.033920646610E+08
DPEPOCH - 'sfepoch[2]' = 7.433359353390E+08
Julian Date - 'sfepoch[3]' = 2449190.925
'strng_out' is '1993 4882 HRS 735.339 SECS'


Example 4. MONTH

The inputs are: 'type_in' is 'MONTH', 'type_out' is 'MONTH'
tarray[0] = 1993, ..[4] = 7, ..[5] = 22
tarray[6] = 10, ..[7] = 12, ..[8] = 15, ..[9] = 339
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '1993 7 22 10:12:15.339'


Example 5. DATE

The inputs are: 'type_in' is 'DATE', 'type_out' is 'DATE'
tarray[0] = 1993, 'mon' = 'THR', tarray[5] = 22
tarray[6] = 10, ..[7] = 12, ..[8] = 15, ..[9] = 339
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '1993 JUL 22 10:12:15.339'


Example 6. SP50

The inputs are: 'type_in' is 'SP50', 'type_out' is 'SP50'
tarray[10] = 1374487935, tarray[11] = 22217
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '1374487935.339 seconds from 1950'


Example 7. SP50M

The inputs are: 'type_in' is 'SP50M', 'type_out' is 'SP50X'
tarray[10] = 1374487935, tarray[9] = 339
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '51ED057F  56C9 seconds, in hex, from 1950'


Example 8. Hex seconds past 1950 

The inputs are: 'tstrng' is 'SP50X 51ED057F  56C9', 'type_out' is 'SP2000X'
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is 'F3E07BC0  A937 seconds, in hex, from 2000'


Example 9. Hex seconds from 2000 

The inputs are: 'tstrng' is 'SP2000X F3E07BC0  A937', 'type_out' is 'SPEPOCHX'
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '2C4E67FF  56C9 seconds, in hex, from JAN 1 1970 '


Example 10. Hex seconds from 1970 

The inputs are: 'tstrng' is 'SPEPOCHX 2C4E67FF  56C9', 'type_out' is 'DP50X'
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '41D47B41 5FD5B240 DP hex secs from 1950'


Example 11. SP2000

The inputs are: 'type_in' is 'SP2000', 'type_out' is 'SP2000'
tarray[12] = -203392064, tarray[13] = 43319
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '-203392064.661 seconds from 2000'


Example 12. SP2000M

The inputs are: 'type_in' is 'SP2000M', 'type_out' is 'SP2000X'
tarray[12] = -203392064, tarray[9] = 339
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is 'F3E07BC0  A937 seconds, in hex, from 2000'


Example 13. DP50

The inputs are: 'type_in' is 'DP50', 'type_out' is 'DP50'
sfepoch[0] = 1.374487935339E+09
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '1374487935.339 seconds from 1950'


Example 14. DP2000

The inputs are: 'type_in' is 'DP2000', 'type_out' is 'DP2000'
sfepoch[1] = -2.033920646610E+08
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '-203392064.661 seconds from 2000'


Example 15. SPEPOCH

The inputs are: 'type_in' is 'SPEPOCH', 'type_out' is 'SPEPOCH'
tarray[14] = 743335935, tarray[15] = 22217
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '743335935.339 seconds from JAN 1 1970 '


Example 16. SPEPOCHM

The inputs are: 'type_in' is 'SPEPOCHM', 'type_out' is 'SPEPOCHX'
tarray[14] = 743335935, tarray[9] = 339
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '2C4E67FF  56C9 seconds, in hex, from JAN 1 1970 '


Example 17. DPEPOCH

The inputs are: 'type_in' is 'DPEPOCH', 'type_out' is 'DPEPOCH'
sfepoch[2] = 7.433359353390E+08
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '743335935.339 seconds from JAN 1 1970 '


Example 18. to DPEPOCHE

The inputs are: 'type_in' is 'NULL', 'type_out' is 'DPEPOCHE'
sfepoch[2] = 7.433359353390E+08
No output, except 'strng_out', is calculated
because type_in is NULL.
'strng_out' is '7.433359353390E+08 seconds from JAN 1 1970 '


Example 19. DPJULIAN

The inputs are: 'type_in' is 'DPJULIAN', 'type_out' is 'DPJULIAN'
sfepoch[3] = 2.449190925178E+06
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is 'Julian date 2449190.925'


Example 20. from SP50 to CCSDSDAYSG5

The inputs are: 'type_in' is 'SP50', 'type_out' is 'CCSDSDAYSG5'
tarray[10] = 1374487935, tarray[11] = 22217
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSDAYSG5, in strng_out is 3 bytes of days from 1950
and 4 bytes of milliseconds in the day.
CCSDS code in hex = 003E24 0230896B
15908 days 36735339 milliseconds past 1950

Example 21. from CCSDSDAYSG5 to CCSDSDAYSG2

The inputs are: 'type_in' is 'CCSDSDAYSG5', 'type_out' is 'CCSDSDAYSG2'
Input CCSDS code in hex = 003E24 0230896B
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSDAYSG2, in strng_out is 3 bytes of days from 2000
and 4 bytes of milliseconds in the day.
CCSDS code in hex = FFF6CE FF9D5B6B
-2354 days -6464661 milliseconds past 2000

Example 22. from CCSDSDAYSG2 to CCSDSDAYSGE

The inputs are: 'type_in' is 'CCSDSDAYSG2', 'type_out' is 'CCSDSDAYSGE'
Input CCSDS code in hex = FFF6CE FF9D5B6B
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSDAYSGE, in strng_out is 3 bytes of days from 1970
and 4 bytes of milliseconds in the day.
CCSDS code in hex = 00219B 0230896B
8603 days 36735339 milliseconds past JAN 1 1970 

Example 23. from CCSDSDAYSGE to CCSDSDOYSG

The inputs are: 'type_in' is 'CCSDSDAYSGE', 'type_out' is 'CCSDSDOYSG'
Input CCSDS code in hex = 00219B 0230896B
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSDOYSG, in strng_out, is BCD and is
YYYYzDOYHHMMSSFFFz where the 'z's are zero
CCSDS code in hex = 199302031012153390
1993 203 10:12:15.339 

Example 24. from CCSDSDOYSG to CCSDSYMDSG

The inputs are: 'type_in' is 'CCSDSDOYSG', 'type_out' is 'CCSDSYMDSG'
Input CCSDS code in hex = 199302031012153390
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSMDYSG, in strng_out, is BCD and is
YYYYMMDDHHMMSSFFFz where the 'z's are zero
CCSDS code in hex = 199307221012153390
1993 07 22 10:12:15.339 

Example 25. from CCSDSYMDSG to CCSDSBUNSG5

The inputs are: 'type_in' is 'CCSDSYMDSG', 'type_out' is 'CCSDSBUNSG5'
Input CCSDS code in hex = 199307221012153390
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSBUNSG5, in strng_out, is seconds and fracs from 1950
CCSDS code in hex = 51ED057F 56C9
1374487935.339 seconds from 1950

Example 26. from CCSDSBUNSG5 to CCSDSBUNSG2

The inputs are: 'type_in' is 'CCSDSBUNSG5', 'type_out' is 'CCSDSBUNSG2'
Input CCSDS code in hex = 51ED057F 56C9
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSBUNSG2, in strng_out, is seconds and fracs from 2000
CCSDS code in hex = F3E07BC0 A937
-203392064.661 seconds from 2000

Example 27. from CCSDSBUNSG2 to CCSDSBUNSGE

The inputs are: 'type_in' is 'CCSDSBUNSG2', 'type_out' is 'CCSDSBUNSGE'
Input CCSDS code in hex = F3E07BC0 A937
The rest of the outputs, except 'strng_out',
are the same as above.
CCSDSBUNSG2, in strng_out, is seconds and fracs from 1970
CCSDS code in hex = 2C4E67FF 56C9
743335935.339 seconds from JAN 1 1970 

Example 28. from CCSDSBUNSGE to CCSDSDOY

The inputs are: 'type_in' is 'CCSDSBUNSGE', 'type_out' is 'CCSDSDOY'
Input CCSDS code in hex = 2C4E67FF 56C9
The rest of the outputs, except 'strng_out',
are the same as above.
'strng_out' is '1993-203T10:12:15.339'


Example 29. Greatest Seconds from 1950


The last allowed time for seconds from 1950 is 
The inputs are: 'type_in' is SP2000M, 'type_out' is 'MDY'
tarray[12] = 569646847, ..[9] = 999
The outputs are:

FRI JAN 19 2018

Year        - tarray[0]  = 2018
DOY         - tarray[1]  = 19
HOY         - tarray[2]  = 471
Sec of Hr   - tarray[3]  = 847
Month       - tarray[4]  = 1
Day of mn   - tarray[5]  = 19
Hours       - tarray[6]  = 15
Minutes     - tarray[7]  = 14
Seconds     - tarray[8]  = 7
Millisecs   - tarray[9]  = 999
SP50        - tarray[10], is greater than
              allowed by a 4 byte integer.
SP2000      - tarray[12] = 569646847, (in hex '21F41EFF')
Frac (2000) - tarray[13] = 65470, (in hex 'FFBE')
SPEPOCH     - tarray[14] = 1516374847, (in hex '5A62B3F')
Frac (EPOCH)- tarray[15] = 65470, (in hex 'FFBE')
DP50   - 'sfepoch[0]' = 2.147526847999E+09
DP2000 - 'sfepoch[1]' = 5.696468479990E+08
DPEPOCH - 'sfepoch[2]' = 1.516374847999E+09
Julian Date - 'sfepoch[3]' = 2458138.134
'strng_out' is 'JAN 19 2018 15:14:07.999'


Example 30. Seconds from 2000


The inputs are: 'type_in' is 'CHAR', 'type_out' is 'DATE'
'tstrng' is '2020 203 10:12:15.339'
The outputs are:

TUE JUL 21 2020

Year        - tarray[0]  = 2020
DOY         - tarray[1]  = 203
HOY         - tarray[2]  = 4882
Sec of Hr   - tarray[3]  = 735
Month       - tarray[4]  = 7
Day of mn   - tarray[5]  = 21
Hours       - tarray[6]  = 10
Minutes     - tarray[7]  = 12
Seconds     - tarray[8]  = 15
Millisecs   - tarray[9]  = 339
SP50        - tarray[10], is greater than
              allowed by a 4 byte integer.
SP2000      - tarray[12] = 648598335, (in hex '26A8D33F')
Frac (2000) - tarray[13] = 22217, (in hex '56C9')
SPEPOCH     - tarray[14] = 1595326335, (in hex '5F16BF7F')
Frac (EPOCH)- tarray[15] = 22217, (in hex '56C9')
DP50   - 'sfepoch[0]' = 2.226478335339E+09
DP2000 - 'sfepoch[1]' = 6.485983353390E+08
DPEPOCH - 'sfepoch[2]' = 1.595326335339E+09
Julian Date - 'sfepoch[3]' = 2459051.925
'strng_out' is '2020 JUL 21 10:12:15.339'


Example 31. CURR


The inputs are: 'type_in' is 'CURR', 'type_out' is 'MDY'
The outputs are:

TUE JAN 18 1994

Year        - tarray[0]  = 1994
DOY         - tarray[1]  = 18
HOY         - tarray[2]  = 441
Sec of Hr   - tarray[3]  = 2252
Month       - tarray[4]  = 1
Day of mn   - tarray[5]  = 18
Hours       - tarray[6]  = 9
Minutes     - tarray[7]  = 37
Seconds     - tarray[8]  = 32
Millisecs   - tarray[9]  = 0
SP50        - tarray[10] = 1390037852, (in hex '52DA4B5C')
Frac (1950) - tarray[11] = 0, (in hex '0')
SP2000      - tarray[12] = -187842148, (in hex 'F4CDC19C')
Frac (2000) - tarray[13] = 0, (in hex '0')
SPEPOCH     - tarray[14] = 758885852, (in hex '2D3BADDC')
Frac (EPOCH)- tarray[15] = 0, (in hex '0')
DP50   - 'sfepoch[0]' = 1.390037852000E+09
DP2000 - 'sfepoch[1]' = -1.878421480000E+08
DPEPOCH - 'sfepoch[2]' = 7.588858520000E+08
Julian Date - 'sfepoch[3]' = 2449370.901
'strng_out' is 'JAN 18 1994 09:37:32.000'


** END MAN PAGES
*/
#endif Header
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"DCCTMCN0") csect(STATIC,"DCCTMCN1")
#endif

#include	<stdio.h>
#include	<math.h>
#include	<string.h>
#include	<ctype.h>
#include	<sftypes.h>
#include	<dictmext.h>
#include	<dictmcnv.h>
#include	<dictmerr.h>
#include	<glbltme.h>

void
dictmcnv(tarray,mon,dow,dptimes,tstrng,type_in,type_out,strng_out,
	rtcode)

	long int	*tarray;
	char		*dow;
	char		*mon;
	DBL		*dptimes;
	char		*tstrng;
	char		*type_in;
	char		*type_out;
	char		*strng_out;
	char		*rtcode;
		
{

int	rtrn;

/*begin 'dictmcnv'*/
strcpy(rtcode,"NORM");
type_in_is = FALSE;
if (strcmp(times_data_init,"YES"))
{
	ditminit();
}
if (!strcmp(EPS.new_epoch,"YES"))
{
	EPS.find_epoch_times = TRUE;
}
else
{
	EPS.find_epoch_times = FALSE;
}
if (strcmp(vax_ordr_called,"YES"))
{
	/*check on order of integters (VAX VMS< etc vs SUN, MACINTOSH, 
	  IBM main frame*/
	strcpy(vax_ordr_called,"YES");
	rtrn = mchintst(NULL,NULL);
	if (rtrn)
	{
		/*this is a VAX order reorder array*/
		vax4_or_othr[0] = 3;
		vax4_or_othr[1] = 2;
		vax4_or_othr[2] = 1;
		vax4_or_othr[3] = 0;
		vax2_or_othr[0] = 1;
		vax2_or_othr[1] = 0;
	}
}
if (type_in != NULL)
{
	type_in_is = TRUE;
	switch (type_in[0])
	{
		case 'D':
		case 'd': /*DOY, DATE, or DPEPOCH*/
			if (type_in[1] == 'O'  ||
			    type_in[1] == 'o')
			{
				/*DOY here*/
				d5doyinp(tarray,dptimes,mon,rtcode);
			}
			else if (type_in[1] == 'A'  ||
			         type_in[1] == 'a')
			{
				/* DATE here*/
				d5datinp(tarray,dptimes,mon,rtcode);
			}
			else
			{
				/*double precision seconds from epoch*/
				d5dpinp(tarray,dptimes,mon,
				        type_in,rtcode);
			}
		break;
		case 'H':
		case 'h':
			/*HOY here*/
			d5hoyinp(tarray,dptimes,mon,rtcode);
		break;
		case 'M':
		case 'm':
			/*month here*/
			d5mninp(tarray,dptimes,mon,rtcode);
		break;
		case 'C':
		case 'c':
			if (type_in[1] == 'H'  ||
			    type_in[1] == 'h')
			{
				/*character string input here*/
				d5fchar(tarray,mon,dptimes,tstrng,
				        rtcode);
			}
			else if (type_in[1] == 'C' ||
				 type_in[1] == 'c')
			{
				/*this is CCSDS inputs*/
				d5fccsds(tarray,dptimes,mon,
					tstrng,type_in,rtcode);
			}
			else
			{
				/*this should be current time*/
				d5current(tarray,mon,dptimes,rtcode);
			}
		break;
		case 'S':
		case 's':
			/*seconds past some epoch*/
			d5secinp(tarray,dptimes,mon,type_in,rtcode);
		break;
		case 'E':
		case 'e':
			/*this is EPOCH etc.*/
			d5epoch(tarray,mon,dow,dptimes,tstrng,
			        type_in,rtcode);
		break;
		default:
			type_in_is = FALSE;
		break;
	} /*end of select*/
} /* end if 'type_in' not NULL */
if (rtcode[3] == 'X')
{
	return;
}
if (type_in)
{
	d5dow(tarray,dow,rtcode);
}
if (type_out == NULL)
{
	return;
}
if (type_out[0] == ' ')
{
	return;
}
d5strout(tarray,mon,dptimes,type_out,strng_out,rtcode);
return;
}

static
d5fccsds(tarray,dptimes,mon,tstrng,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*tstrng;
char	*type_in;
char	*rtcode;

{

int	i;

/*CCSDS input types. These are
	1. CCSDSDAYSG(2,5,E) day segmented binary time code.
	2. CCSDSDOYSG calendar DOY BCD YYYYzDOYHHMMSSFFFz
	3. CCSDSBUNSG(2.5.E) unsegmented binary time code.
	4. CCSDSYMDSG Year Month Day calendar BCD YYYYMNDDHHMMSSFFFz
NOTE 'z' is 4 bits of zeros*/

switch (type_in[6])
{
	case 'A': /*012345678901*/
	case 'a': /*CCSDSDAYSG*/
		d5dayseg(tarray,dptimes,mon,tstrng,type_in,rtcode);
	break;
	case 'O': /*012345678901*/
	case 'o': /*CCSDSDOYSG*/
	case 'M':
	case 'm': /*CCSDSYMDSG*/
		d5calseg(tarray,dptimes,mon,tstrng,type_in,rtcode);
	break;
	case 'U': /*012345678901*/
	case 'u':
		 /*CCSDSBUNSG*/
		d5bunseg(tarray,dptimes,mon,tstrng,type_in,rtcode);
	break;
	default:
		/*error here set code then return*/
	break;
}
return;
}	

static
d5dayseg(tarray,dptimes,mon,tstrng,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*tstrng;
char	*type_in;
char	*rtcode;

{

long	int	millsinday;
long	int	secsfrm;
int	i;

/*CCSDS DAY segmented binary timecodes*/
/*input in tstrng is 3 bytes of days past an epoch and 4 bytes of 
milliseconds from the day*/
/*consider machin byte ordering for integers*/
/*check for minus here*/
if (tstrng[0]&0x80)
{
	ORDINT.li = -1;
}
else
{
	ORDINT.li = 0;
}
for ( i = 0 ; i < 3 ; i++)
{
	ORDINT.ch[vax4_or_othr[i+1]] = tstrng[i];
}
secsfrm = ORDINT.li*86400;
millsinday = 0;
ORDINT.li = 0;
for ( i = 0 ; i < 4 ; i++)
{
	ORDINT.ch[vax4_or_othr[i]] = tstrng[i+3];
}
millsinday = ORDINT.li;
MILLSEC = millsinday%1000;
if (MILLSEC < 0)
{
	MILLSEC += 1000;
}
millsinday /= 1000; /*now we have seconds in a day*/
secsfrm += millsinday;
/*********************
	'CCSDSBUNSG2'
	'CCSDSBUNSG5'
	'CCSDSBUNSGE'
*********************/
switch(type_in[10])
{
	case '5': /*seconds from 1950*/
		SECSF1950 = secsfrm;
		d5secinp(tarray,dptimes,mon,"SP50M",rtcode);
	break;
	case '2': /*seconds from 2000*/
		SECSF2000 = secsfrm;
		d5secinp(tarray,dptimes,mon,"SP2000M",rtcode);
	break;
	case 'E': /*seconds from user supplied epoch*/
		SECSFEPOCH = secsfrm;
		d5secinp(tarray,dptimes,mon,"SPEPOCHM",rtcode);
	break;
	default:
		/*set error here*/
	break;
}
return;
}

static
d5calseg(tarray,dptimes,mon,tstrng,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*tstrng;
char	*type_in;
char	*rtcode;

{

/*this is seqmented calendar and is in BCD*/

/*the two time codes for this are
  1. YYYYzDOYHHMMSS.FFFz
  2. YYYYMNDDHHMMSS.FFFz
  so we can get year hh mm ss and mills*/

/*change from bcd to year 0   1   2   3   4   5   6   7   8 */
/*                       [YY][YY][0D][OY][HH][MM][SS][FF][F0]*/
/*hours                  [MN][DD]                    */
d5ichfbcd(&tstrng[0],0,&YEAR,4);
d5ichfbcd(&tstrng[4],0,&HOUR,2);
/*minutes*/ 
d5ichfbcd(&tstrng[5],0,&MINUTE,2);
/*seconds*/
d5ichfbcd(&tstrng[6],0,&SECOND,2);
/*milliseconds*/
d5ichfbcd(&tstrng[7],0,&MILLSEC,3);
switch (type_in[5])
{
	case 'D': /*01234567890*/
	case 'd': /*CCSDSDOYSG*/
		/*this is YYYYzDOYHHMMSS.FFFz in BCD*/
		d5ichfbcd(&tstrng[2],1,&DOY,3);
		/*ok now doit*/
		/*DOY here*/
		d5doyinp(tarray,dptimes,mon,rtcode);
	break;
	case 'Y':
	case 'y':
		/*this is YearDayMonth here*/
		/*month here*/
		d5ichfbcd(&tstrng[2],0,&MONTH,2);
		d5ichfbcd(&tstrng[3],0,&DAY,2);
		d5mninp(tarray,dptimes,mon,rtcode);
	break;
	default:
		/*error*/
	break;
}
return;
}

static
d5bunseg(tarray,dptimes,mon,tstrng,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*tstrng;
char	*type_in;
char	*rtcode;

{

long	int	secsfrm;
long	int	fracsfrm;
int	i;

/*unsegmented time code. Same as seconds past Plus fracs*/
/*tarray is long int for current machine
  binary time codes are byte ordered. Put in proper order*/
for ( i = 0 ; i < 4 ; i++)
{
	ORDINT.ch[vax4_or_othr[i]] = tstrng[i];
}
secsfrm = ORDINT.li;
/*bring in fractions*/
ORDINT.li = 0;
for ( i = 0 ; i < 2 ; i++)
{
	/*place in last 2 least sig bytes*/
	ORDINT.ch[vax4_or_othr[i+2]] = tstrng[i+4];
}
fracsfrm = ORDINT.li;
/*********************
	'CCSDSBUNSG2'
	'CCSDSBUNSG5'
	'CCSDSBUNSGE'
*********************/
switch(type_in[10])
{
	case '5': /*seconds from 1950*/
		SECSF1950 = secsfrm;
		FRACF1950 = fracsfrm;
		d5secinp(tarray,dptimes,mon,"SP50",rtcode);
	break;
	case '2': /*seconds from 2000*/
		SECSF2000 = secsfrm;
		FRACF2000 = fracsfrm;
		d5secinp(tarray,dptimes,mon,"SP2000",rtcode);
	break;
	case 'E': /*seconds from user supplied epoch*/
		SECSFEPOCH = secsfrm;
		FRACFEPOCH = fracsfrm;
		d5secinp(tarray,dptimes,mon,"SPEPOCH",rtcode);
	break;
	default:
		/*set error here*/
	break;
}
return;
}

static
d5dow(tarray,dow,rtcode)

long	int	*tarray;
char	*dow;
char	*rtcode;

{

long	int	days_past_epoch;
int	day_of_week;

/*compute day of week*/
if (use_sf50)
{
	/*compute days past epoch*/
	days_past_epoch = SECSF1950/86400 + DOW_1950;
}
else
{
	/*epoch start at noon on jan 1st 2000*/
	days_past_epoch = (SECSF2000 + 43200)/86400 + DOW_2000;
}
if (dow != NULL)
{
	day_of_week = (int)(days_past_epoch % 7);
	strcpy(dow,day_o_week[day_of_week]);
}
return;
}

static
d5epoch(tarray,mon,dow,dptimes,tstrng,type_in,rtcode)

long	int	*tarray;
char	*mon;
char	*dow;
DBL	*dptimes;
char	*tstrng;
char	*type_in;
char	*rtcode;

{

char	*pntr;
int	i;

/*this is epoch input find new epoch here*/
/*set to find new one do not use older (if there)*/
strcpy(EPS.new_epoch,"NO"); 
EPS.find_epoch_times = FALSE;
/*find next word in 'type_in'*/
pntr = strchr(type_in,' '); /*find blank*/
if (pntr == NULL)
{
	/*error here*/
	strcpy(rtcode,err_rtrn_code[EPN_INDX]);
	return;
}
while(pntr[0] == ' ')
{
	pntr++;
}
if (mon != NULL)
{
	memcpy(EPS.epoch_mon,mon,4);
}
switch (pntr[0])
{
	case 'D':
	case 'd': /*DOY, DATE, or DPEPOCH*/
		if (pntr[1] == 'O'  ||
		    pntr[1] == 'o')
		{
			/*DOY here*/
			d5doyinp(tarray,dptimes,EPS.epoch_mon,rtcode);
		}
		else if (pntr[1] == 'A'  ||
		         pntr[1] == 'a')
		{
			/* DATE here*/
			d5datinp(tarray,dptimes,EPS.epoch_mon,rtcode);
		}
		else
		{
			/*double precision seconds from epoch 
			  or Julian date*/
			d5dpinp(tarray,dptimes,EPS.epoch_mon,pntr,
				rtcode);
		}
	break;
	case 'H':
	case 'h':
		/*HOY here*/
		d5hoyinp(tarray,dptimes,EPS.epoch_mon,rtcode);
	break;
	case 'M':
	case 'm':
		/*month here*/
		d5mninp(tarray,dptimes,EPS.epoch_mon,rtcode);
	break;
	case 'C':
	case 'c':
		/*character string input here*/
		d5fchar(tarray,EPS.epoch_mon,dptimes,tstrng,rtcode);
	break;
	case 'S':
	case 's':
		/*seconds past some epoch*/
		d5secinp(tarray,dptimes,EPS.epoch_mon,pntr,rtcode);
	break;
	default:
		/*error here*/
		strcpy(rtcode,err_rtrn_code[EPC_INDX]);
		return;
	break;
} /*end of select*/
/*check for error return here*/
if (rtcode[3] == 'X')
{
	/*error here*/
	return;
}
if (MILLSEC != 0)
{
	/*error here*/
	strcpy(rtcode,err_rtrn_code[NEM_INDX]);
	return;
}	
strcpy(EPS.new_epoch,"YES"); /*set to there is a new other epoch*/
for ( i = 0 ; i < SIZE_OF_TARRAY ; i++)
{
	EPS.epoch_tarray[i] = tarray[i];
}
for ( i = 0 ; i < SIZE_OF_DPS ; i++)
{
	EPS.epoch_dptimes[i] = dptimes[i];
}
if (mon != NULL)
{
	strcpy(mon,EPS.epoch_mon);
}
d5dow(tarray,EPS.epoch_dow,rtcode);
d5strmdy(tarray,EPS.epoch_mon,EPS.char_epoch,rtcode);
if (HOUR  ||  MINUTE  || SECOND)
{
	/*get rid of '.000'*/
	pntr = strchr(EPS.char_epoch,'.');
	if (pntr != NULL)
	{
		pntr[0] = '\0';
	}
}
else
{
	/*'mon DD YYYY'*/
	EPS.char_epoch[11] = '\0';
}
return;
}	

static
d5current(tarray,mon,dptimes,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*rtcode;

{

BOOL	found_current;
int	rt_code;
char	strng[50];

/*get current times here*/
#if (NOCURRTIME)
/*opening soon the rest*/
strcpy(rtcode,err_rtrn_code[CUR_INDX]);
return;
#else
t_p = time(NULL);
chrtime = ctime(&t_p);
/*chrtime points to
          1         2         3
0123456789012345678901234567890
day mon DD HH:MM:SS YYYY\n\0
to strng
YYYY mon DD HH:MM:SS\0
*/
memcpy(strng,&chrtime[20],4); /*YYYY*/
memcpy(&strng[4],&chrtime[3],16); /* mon DD HH:MM:SS*/
strng[20] = '\0';
d5fchar(tarray,mon,dptimes,strng,rtcode);
return;
#endif
}

static
d5doyinp(tarray,dptimes,mon,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*rtcode;

{

d5chkdoy(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5tepfd(tarray,dptimes,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5thfd(tarray,rtcode);
d5tmnfd(tarray,mon,rtcode);
return;
}

static
d5datinp(tarray,dptimes,mon,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*rtcode;

{

d5fdatmn(tarray,mon,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5chkmn(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5fmntd(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5tepfd(tarray,dptimes,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5thfd(tarray,rtcode);
return;
}

static
d5dpinp(tarray,dptimes,mon,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*type_in;
char	*rtcode;

{				

d5fdptd(tarray,dptimes,type_in,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5thfd(tarray,rtcode);
d5tmnfd(tarray,mon,rtcode);
return;
}

static
d5hoyinp(tarray,dptimes,mon,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*rtcode;

{

d5chkhoy(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5fhtd(tarray,rtcode);
d5tepfd(tarray,dptimes,rtcode);
d5tmnfd(tarray,mon,rtcode);
return;
}

static
d5mninp(tarray,dptimes,mon,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*rtcode;


{

d5chkmn(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5fmntd(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
if (mon != NULL)
{
	/*need character 'mon'*/
	strcpy(mon,mnths[MONTH-1]);
}
d5tepfd(tarray,dptimes,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5thfd(tarray,rtcode);
return;
}

static
d5secinp(tarray,dptimes,mon,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*mon;
char	*type_in;
char	*rtcode;

{

d5fsftd(tarray,dptimes,type_in,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5thfd(tarray,rtcode);
d5tmnfd(tarray,mon,rtcode);
return;
}
			
static
d5fchar(tarray,mon,dptimes,tstrng,rtcode)

long	int	*tarray;
char		*mon;
DBL		*dptimes;
char		*tstrng;
char		*rtcode;

{
int	rt_code;
int	i;
int	len;

len = strlen(tstrng);
if (len > 50)
{
	len = 50;
}
strncpy(time_strng,tstrng,len);
time_strng[len] = '\0';
strncpy(use_strng,tstrng,len);
use_strng[len] = '\0';
tot_in_array = 0;
dec_indx = 0;
/*initialize arrays for storing data from input */
for ( i = 0 ; i < 10 ; i++)
{
	tary_pntrs[i] = NULL;
	tary_ints[i] = 0;
	tary_type[i] = ' ';
	tary_clen[i] = 0;
}
month_from_chars = 0;
next_wrd_frac = FALSE;
minus_found = FALSE;
hex_strng = FALSE;
rt_code = dictprs(use_strng,len,
	          pars_func,spcl_chars);
if (rt_code)
{
	strcpy(rtcode,err_rtrn_code[PRS_INDX]);
	return;
}
/*ok we have parsed the string letus find out what type it is*/

/**********************************************************************
find case for type of character input. They are:
1  (DOY)      'YYyy DOY HH:MM:SS.FFF'
2  (MONTH)    'YYyy MN DD HH:MM:SS.FFF'
3  (DATE)     'monxxxxx YYyy DD HH:MM:SS.FFF'
4  (DATE)     'YYyy monxxxxx DD HH:MM:SS.FFF'
5  (HOY)      'YYyy hhhh ssss.FFF' (there are a max of 8784 hours 
		  	            in a year, 3600 seconds in an hour)
6  (HOY)      'HOY YYyy hhhh ssss.FFF'
7  (HOY)      'YYyy hhhh hrs ssss.FFF secs'
8  (SP50)     'SP50 ssssssssss.FFF'
9  (SP2000)   'SP2000 ssssssssss.FFF'
10 (SPEPOCH)  'SPEPOCH ssssssssss.FFF'
**********************************************************************/
case_input = 0;
/*check to see if decimal is there*/
if (dec_indx)
{
	if (tary_type[dec_indx] == 'c')
	{
		/*this is an error*/
		strcpy(rtcode,err_rtrn_code[CAD_INDX]);
		return;
	}
}
/*test to see if tary_type[0] is 'c' or 'i'*/
if (tary_type[0] == 'c')
{
	chk1stchr(rtcode);
}
else
{
	chkyr1st(rtcode);
}
if (!case_input)
{
	return;
}
switch (case_input)
{
	case DOY_CASE: /*DOY here */
		d5chrdoy(tarray,mon,dptimes,rtcode);
	break;
	case MONTH_CASE: /*MONTH here*/
		d5chrmonth(tarray,mon,dptimes,rtcode);
	break;
	case DATE_CASE: /*DATE */
	case DATE1_CASE: /*date*/
		d5chrdate(tarray,mon,dptimes,rtcode);
	break;
	case HOY_CASE: /*HOY */
	case HOY1_CASE:
	case HOY2_CASE:
		d5chrhoy(tarray,mon,dptimes,rtcode);
	break;
	case SP50_CASE: /*SP50*/
	case SP2000_CASE: /*SP2000*/
	case SPEPOCH_CASE: /*other epcoh*/
		d5chrspepoch(tarray,mon,dptimes,rtcode);
	break;
	default:
		strcpy(rtcode,err_rtrn_code[CSE_INDX]);
		return;
}
	
return;

}
static
d5chrmonth(tarray,mon,dptimes,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*rtcode;

{

int	indx;

/* This should be month input
   YYyy MN DD HH:MM:SS.FFF */
/*change character inputs to integer*/
d5chg2in(rtcode);
/*check year*/
if (tary_clen[2] == 4)
{
	/*this is month day year inputs*/
	year_indx = 2;
	MONTH = tary_ints[0];
	day_indx = 1;
}
else
{
	year_indx = 0;
	MONTH = tary_ints[1];
	day_indx = 2;
}
d5fndyr(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
indx = MONTH - 1;
if (tot_in_array == 3)
{
	tary_ints[3] = 0;
	tary_ints[4] = 0;
	tary_ints[5] = 0;
}
hour_indx = 3;
minute_indx = 4;
second_indx = 5;
if (mon != NULL)
{
	strcpy(mon,mnths[indx]);
}
d5tmnfc(tarray,dptimes,rtcode);	
return;
}

static
d5chrdate(tarray,mon,dptimes,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*rtcode;

{

int	i;

/*input should be date find rest fom here*/


switch (case_input)
{
	case DATE_CASE:
		/*monxxxxx YYYY DD HH MM SS FFF or  
		  monxxxxx DD YYYY HH MM SS FFF*/
		if (tary_clen[1] == 4)
		{
			/*monxxxxx YYYY DD HH MM etc*/
			day_indx = 2;
			year_indx = 1;
		}
		else if (tary_clen[2] == 4)
		{
			/*monxxxx DD YYYY HH MM SS FFFF*/
			year_indx = 2;
			day_indx = 1;
		}
		else
		{
			strcpy(rtcode,err_rtrn_code[NYR_INDX]);
			return;
		}
	break;
	case DATE1_CASE:
		/*YYyy monxxxxx DD HH MM SS FFF*/
		year_indx = 0;
		day_indx = 2;
	break;
	default:
		strcpy(rtcode,err_rtrn_code[DAT_INDX]);
		return;
}
/*change character inputs to integer*/
d5chg2in(rtcode);
/*month has been found and is in month_of_chars*/
d5fndyr(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
MONTH = month_from_chars;
if (mon != NULL)
{
	/*need character 'mon'*/
	strcpy(mon,mnths[MONTH-1]);
}
if (tot_in_array == 3)
{
	/*no hh mm ss*/
	tary_ints[3] = 0;
	tary_ints[4] = 0;
	tary_ints[5] = 0;
}
hour_indx = 3;
minute_indx = 4;
second_indx = 5;
d5tmnfc(tarray,dptimes,rtcode);
return;
}

static
d5chrhoy(tarray,mon,dptimes,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*rtcode;

{

/*HOY type input*/

switch (case_input)
{
	case HOY_CASE:
		/*YYyy hhhh ssss.FFF*/
		year_indx = 0;
		hoy_indx = 1;
		secohr_indx = 2;
	break;
	case HOY1_CASE:
		/*'HOY' YYyy hhhh ssss.FFF*/
		year_indx = 1;
		hoy_indx = 2;
		secohr_indx = 3;
	break;
	case HOY2_CASE:
		/*YYyy hhhh 'HRS' ssss.FFF 'SECS'*/
		if (strcmp(tary_pntrs[2],"HRS")  ||
		    strcmp(tary_pntrs[chs_indx],"SECS"))
		{
			strcpy(rtcode,err_rtrn_code[HOY_INDX]);
			return;
		}
		year_indx = 0;
		hoy_indx = 2;
		secohr_indx = 3;
	break;
	default:
		strcpy(rtcode,err_rtrn_code[HYC_INDX]);
		return;
}
/*change character inputs to integer*/
d5chg2in(rtcode);
/*do year here*/
d5fndyr(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
HOY = tary_ints[hoy_indx];
SECOHR = tary_ints[secohr_indx];
if (dec_indx)
{
	MILLSEC = tary_ints[dec_indx];
}
else
{
	MILLSEC = 0;
}
/*go for the gusto, just the rest of times*/
/*HOY here*/
/*check HOY*/
d5chkhoy(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5fhtd(tarray,rtcode);
d5tepfd(tarray,dptimes,rtcode);
d5tmnfd(tarray,mon,rtcode);
return;
}

static
d5chrspepoch(tarray,mon,dptimes,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*rtcode;

{

char	typein[8];
char	*typ_pntr;
DBL	dbl_mills;

FRACF1950 = 0;
FRACF2000 = 0;
MILLSEC = 0;
if (hex_strng)
{
	d5chg2hx(rtcode);
	if (rtcode[3] == 'X')
	{
		return; /*error exists*/
	}
}
else
{
	d5chg2in(rtcode);
	if (dec_indx)
	{
		if (minus_found)
		{
			MILLSEC = 1000 - tary_ints[dec_indx];
		}
		else
		{
			MILLSEC = tary_ints[dec_indx];
		}
	}
}
switch (case_input)
{
	case SP50_CASE: /*SP50 format*/
		SECSF1950 = tary_ints[1];
		if (hex_strng)
		{
			FRACF1950 = tary_ints[2];
			d5secinp(tarray,dptimes,mon,"SP50",rtcode);
		}
		else
		{
			d5secinp(tarray,dptimes,mon,"SP50M",rtcode);
		}
	break;
	case SP2000_CASE: /*SP2000 format*/
		SECSF2000 = tary_ints[1];
		if (hex_strng)
		{
			FRACF2000 = tary_ints[2];
			d5secinp(tarray,dptimes,mon,"SP2000",rtcode);
		}
		else
		{
			d5secinp(tarray,dptimes,mon,"SP2000M",rtcode);
		}
	break;
	case SPEPOCH_CASE: /*SPEPOCH format*/
		if (strcmp(EPS.new_epoch,"YES"))
		{
			/*error here*/
			strcpy(rtcode,err_rtrn_code[NEP_INDX]);
			return;
		}
		SECSFEPOCH = tary_ints[1];
		if (hex_strng)
		{
			FRACFEPOCH = tary_ints[2];
			d5secinp(tarray,dptimes,mon,"SPEPOCH",rtcode);
		}
		else
		{
			d5secinp(tarray,dptimes,mon,"SPEPOCHM",rtcode);
		}
	break;
	default:
		strcpy(rtcode,err_rtrn_code[SFE_INDX]);
		return;
}
return;
}

static
d5chrdoy(tarray,mon,dptimes,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*rtcode;

{

/*this is DOY input*/
/*cheang to integers from string*/
d5chg2in(rtcode);
/*check year*/
year_indx = 0;
d5fndyr(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
DOY = tary_ints[1];
if (tot_in_array == 2)
{
	tary_ints[2] = 0;
	tary_ints[3] = 0;
	tary_ints[4] = 0;
}
HOUR = tary_ints[2];
MINUTE = tary_ints[3];
SECOND = tary_ints[4];
if (dec_indx)
{
	MILLSEC = tary_ints[dec_indx];
}
else
{
	MILLSEC = 0;
}
/*ok now do rest*/
/*DOY here*/
/*check doy*/
d5chkdoy(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5tepfd(tarray,dptimes,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5thfd(tarray,rtcode);
d5tmnfd(tarray,mon,rtcode);
return;
}

static
d5strout(tarray,mon,dptimes,type_out,strng_out,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*type_out;
char	*strng_out;
char	*rtcode;

{

/*********************************************************************
**	   1993 203 10:12:15.339 is the date used in the examples
**	   1970 is the epoch of choice
**	   1. For type_out = 'DOY' (input is year, doy, hour, 
**	                            minutes, seconds and milliseconds).
**	      output is 1993 203 10:12:15.339
**	   2. For type_out = 'HOY' (input is year hoy, seconds of hour
**	                            and milliseconds).
**	      output is 1993 4882 HRS 735.339 SECS
**	   3. For type_out = 'MONTH' (input is year, integer month,
**	                              day of month,hour, minutes,
**	                              seconds and  milliseconds).
**	      output is 1993 7 22 10:12:15.339
**	   4. For type_out = 'MNDY' (input is integer month,day of 
**	                              month, year,hour, minutes,
**	                              seconds and  milliseconds).
**	      output is 7 22 1993 10:12:15.339
**	   5. For type_out = 'DATE' (input is year 3 char month,
**	                             day of month, hour, minutes, 
**	                             seconds and milliseconds).
**	      output is 1993 JUL 22 10:12:15.339
**	   6. For type_out = 'MDY' (input is year, 3 char month, day
**	                            of month, hour, minutes,
**	                            seconds and milliseconds).
**	      output is JUL 22 1993 10:12:15.339
**	   7. For type_out = 'SP50' (input is integer seconds and
**	                             fractional seconds).
**	      output is 1374487935.339 seconds from 1950
**	   8. For type_out = 'SP2000'  (input is integer seconds and
**	                                fractional seconds).
**	      output is -203392064.339 seconds from 2000
**	   9. For type_out = 'SP50M' (input is integer seconds and
**	                              milliseconds).
**	      output is 1374487935.339 seconds from 1950
**	  10. For type_out = 'SP2000M'  (input is integer seconds
**	                                 and milliseconds).
**	      output is -203392064.339 seconds from 2000
**	  11. For type_out = 'DP50' (input is double precision
**	                             seconds).
**	      output is 1374487935.339 seconds from 1950
**	  12. For type_out = 'DP2000' (input is double precision
**	                               seconds).
**	      output is -203392064.661 seconds from 2000
**	  13. For type_out = 'DP50E' (input is double precision
**	                              seconds).
**	      output is 1.374487935339E+09 seconds from 1950
**	  14. For type_out = 'DP2000E' (input is double precision
**	                                seconds).
**	      output is -2.033920646610E+08 seconds from 2000
**	  15. For type_out = 'SP50X' (input is integer seconds and
**	                              fractional seconds).
**	      output is 51ED057F  56C8 seconds, in hex, from 1950
**	  16. For type_out = 'SP2000X'  (input is integer seconds
**	                                 and fractional seconds).
**	      output is F3E07BC0  A937 seconds, in hex, from 2000
**	  17. For type_out = 'DP50X' (input is double precision 
**	                              seconds).
**	      output is 401D401D A3DA0AFE DP seconds, in hex, from 1950
**	  18. For type_out = 'DP2000X' (input is double precision
**	                                seconds).
**	      output is C01AC01A C1F8440A DP seconds, in hex, from 2000
**	  19. For type_out = 'SPEPOCH'  (input is integer seconds and
**	                                 fractional seconds).
**	      output is 743335935.339 seconds from 1970
**	  20. For type_out = 'SPEPOCHM'  (input is integer seconds
**	                                  and milliseconds).
**	      output is 743335935.339 seconds from 1970
**	  21. For type_out = 'DPEPOCH' (input is double precision
**	                                seconds).
**	      output is 743335935.339 seconds from 1970
**	  22. For type_out = 'DPEPOCHE' (input is double precision
**	                                 seconds).
**	      output is 7.433359353390E+08 seconds from 1970
**	  23. For type_out = 'SPEPOCHX'  (input is integer seconds
**	                                  and fractional seconds)
**	      output is 401C401C B1399FFD DP seconds, in hex, from 1970
**	  24. For type_out = 'DPJULIAN' (input is double precision
**	                                 Julian date).
**	      output is Julian date 2449190.925
**	  25. For type_out = 'DPJULIANE' (input is double precision
**	                                  Julian date).
**	      output is Julian date 2.449190925178E+06
**	  26. For type_out = 'DPJULIANX' (input is double precision
**	                                  Julian date).
**	      output is Julian date (in hex) 40144014 957C9BB3
**********************************************************************/
int	i;

if (!type_in_is)
{
	/*transfer tarray into trray*/
	tpntr = tarray;
	for ( i = 0 ; i < SIZE_OF_TARRAY ; i++)
	{
		trray[i] = tarray[i];
	}
}
switch (type_out[0])
{
	case 'D':
	case 'd':
		/*DOY or DATE */
		if (type_out[1] == 'A' || type_out[1] == 'a')
		{
			/*DATE output*/
			d5strdat(tarray,mon,strng_out,rtcode);
		}
		else if (type_out[1] == 'O'  ||  type_out[1] == 'o')
		{
			/*DOY output*/
			d5strdoy(tarray,strng_out,rtcode);
		}
		else
		{
			/*DPSEC out put*/
			d5strdp(tarray,dptimes,type_out,
			        strng_out,rtcode);
		}	
	break;
	case 'H': /*hoy*/
	case 'h':
		d5strhoy(tarray,strng_out,rtcode);
	break;
	case 'M':
	case 'm':
		if (type_out[1] == 'O' || type_out[1] == 'o'  ||
		    type_out[1] == 'N' || type_out[1] == 'n')
		{
			/*month format*/
			d5strmn(tarray,type_out,strng_out,rtcode);
		}
		else
		{
			/*MDY (month day year) format*/
			d5strmdy(tarray,mon,strng_out,rtcode);
		}
	break;
	case 'S':
	case 's':
		/*seconds past epoch*/
		d5strsfe(tarray,type_out,strng_out,rtcode);
	break;
	case 'E':
	case 'e':
		/*epoch output wanted*/
		if (strcmp(EPS.new_epoch,"YES"))
		{
			/*error here*/
			strcpy(rtcode,err_rtrn_code[NEP_INDX]);
			return;
		}
		d5strep(type_out,strng_out,rtcode);
	break;
	case 'C':
	case 'c': /*CCSDS output*/
		d5ccsdsout(tarray,mon,dptimes,type_out,strng_out,
			rtcode);
	break;
	default:
	break;
	
}
return;
}

static
d5ccsdsout(tarray,mon,dptimes,type_out,strng_out,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*type_out;
char	*strng_out;
char	*rtcode;

{

/*the types out are
  1. CCSDSDAYSG - day segmented output binary.
  2. CCSDSDOY -   DOY ASCII output
  3. CCSDSDOYSG - DOY segmented output, BCD.
  4. CCSDSMONTH - month ASCII output.
  5. CCSDSBUNSG - unsegmented time, binary.
  6. CCSDSYMDSG - YearMonthDay segmented time, BCD.
  
*/

switch (type_out[6])
{
	case 'A': /*01234567890*/
	case 'a': /*CCSDSDAYSG*/
		d5odayseg(tarray,mon,dptimes,type_out,strng_out,
			rtcode);
	break;
	case 'O':
	case 'o': /*several*/
		if (type_out[5] == 'M'  ||
		    type_out[5] == 'm')
		{
			/*this is ascii month*/
			sprintf(strng_out,
			   "%ld-%02ld-%02ldT%02ld:%02ld:%02ld.%03ld",
				YEAR,
				MONTH,
				DAY,
				HOUR,
				MINUTE,
				SECOND,
				MILLSEC);
		}
		else if (type_out[8] == 'S'  ||
		         type_out[8] == 's')
		{
			/*this is CCSDSDOYSG bcd code*/
			d5odoyseg(tarray,mon,dptimes,strng_out,rtcode);
		}
		else
		{
			/*this is DOY ascii*/
			d5strdoy(tarray,strng_out,rtcode);
			if (rtcode[3] == 'X')
			{
				return;
			}
			/*change into CCSDS 
			  from YYYY DOY HH etc. to YYYY-DOYTHH etc*/
			strng_out[4] = '-';
			strng_out[8] = 'T';
		}
	break;
	case 'M': /*0123456789*/
	case 'm': /*CCSDSYMDSG*/
		/*this is YearMonthDay BCD CODE*/
		d5oymdseg(tarray,mon,dptimes,strng_out,rtcode);
	break;
	case 'U': /*0123456789*/
	case 'u': /*CCSDSBUNSG*/
		/*this is unsegmanted time codes*/
		d5obunseg(tarray,mon,dptimes,type_out,strng_out,
			rtcode);
	break;
	default:
	break;
}
return;
}

static
d5odayseg(tarray,mon,dptimes,type_out,strng_out,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*type_out;
char	*strng_out;
char	*rtcode;

{

long	int	daysfrmepoch;
long	int	millsinday;
int	i;

/*CCSDSDAYSG - day segmented binary code. Days from epoch and 
  milliseconds of day*/
switch(type_out[10])
{
	case '5': /*from 1950*/
		daysfrmepoch = SECSF1950/86400;
		millsinday = (SECSF1950%86400)*1000 + MILLSEC;
	break;
	case '2': /*from 2000*/
		daysfrmepoch = SECSF2000/86400;
		millsinday = (SECSF2000%86400)*1000;
		if (SECSF2000 < 0)
		{
			millsinday += MILLSEC - 1000;
		}
		else
		{
			millsinday += MILLSEC;
		}
	break;
	case 'E': /*from users epoch*/
		daysfrmepoch = SECSFEPOCH/86400;
		millsinday = (SECSFEPOCH%86400)*1000 + MILLSEC;
	break;
	default:
		/*error */
		return;
	break;
}
ORDINT.li = daysfrmepoch;
/*Day is three bytes in binary */ 
for ( i = 0 ; i < 3 ; i++)
{
	strng_out[i] = ORDINT.ch[vax4_or_othr[i+1]];
}
/*pring in miilsinday*/
ORDINT.li = millsinday;
for (i = 0 ; i < 4 ; i++)
{
	strng_out[i+3] = ORDINT.ch[vax4_or_othr[i]];
}
/*thats all folks. Don't wait it is thru*/
return;
}

static
d5odoyseg(tarray,mon,dptimes,strng_out,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*strng_out;
char	*rtcode;

{

/*this is CCSDSDOYSG which is calendar DOY segmented time code
  the out put is YYYYzDOYHHMMSSFFFz BCD code*/
/*       0   1   2   3   4   5   6   7   8 
 bytes [  ][  ][  ][  ][  ][  ][  ][  ][  ]
        YY  YY  zD  OY  HH  MM  SS  FF  Fz
        */
d5ich2bcd(YEAR,&strng_out[0],4);
d5ich2bcd(DOY,&strng_out[2],3);
d5ich2bcd(HOUR,&strng_out[4],2);
d5ich2bcd(MINUTE,&strng_out[5],2);
d5ich2bcd(SECOND,&strng_out[6],2);
d5dch2bcd(MILLSEC,&strng_out[7],3);
return;
}


static
d5oymdseg(tarray,mon,dptimes,strng_out,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*strng_out;
char	*rtcode;

{

/*this is CCSDSYMDSG which is calendar YearMonthDay segmented time code
  the out put is YYYYMNDDHHMMSSFFFz BCD code*/
/*       0   1   2   3   4   5   6   7   8 
 bytes [  ][  ][  ][  ][  ][  ][  ][  ][  ]
        YY  YY  MN  DD  HH  MM  SS  FF  Fz
        */
d5ich2bcd(YEAR,&strng_out[0],4);
d5ich2bcd(MONTH,&strng_out[2],2);
d5ich2bcd(DAY,&strng_out[3],2);
d5ich2bcd(HOUR,&strng_out[4],2);
d5ich2bcd(MINUTE,&strng_out[5],2);
d5ich2bcd(SECOND,&strng_out[6],2);
d5dch2bcd(MILLSEC,&strng_out[7],3);
return;
}

static
d5obunseg(tarray,mon,dptimes,type_out,strng_out,rtcode)

long	int	*tarray;
char	*mon;
DBL	*dptimes;
char	*type_out;
char	*strng_out;
char	*rtcode;

{

/********************************************************************
**	The CCSDS unsegmented time code is a binary time calculated
**	from some epoch. If there is no user supplied epoch then 1950 
**	is used. This time is the same as integer seconds past an epoch
**	plus the fractional seconds but is input and output as a byte
**	stream. The time consists of 4 bytes of course time (4 byte
**	integer seconds past an epoch) then 2 bytes of fractional 
**	seconds. 'type_in' is 'CCSDSBUNSG' and the input is in
**	'tstrng. 'type_out' is 'CCSDSBUNSG' and the output is in
**	'strng_out'.
*********************************************************************/

long	int	secsfanyep;
long	int	fracs;
int	i;

switch(type_out[10])
{
	case '5': /*from 1950*/
		secsfanyep = SECSF1950;
		fracs = FRACF1950;
	break;
	case '2': /*from 2000*/
		secsfanyep = SECSF2000;
		fracs = FRACF2000;
	break;
	case 'E': /*from users epoch*/
		secsfanyep = SECSFEPOCH;
		fracs = FRACFEPOCH;
	break;
	default:
		/*error */
	break;
}
ORDINT.li = secsfanyep;
for ( i = 0 ; i < 4 ; i++)
{
	strng_out[i] = ORDINT.ch[vax4_or_othr[i]];
}
/*frac*/
ORDINT.li = fracs;
for (i = 2 ; i < 4 ; i++)
{
	strng_out[i+2] = ORDINT.ch[vax4_or_othr[i]];
}
/*thats all folks. Don't wait it is thru*/
return;
}

static
d5strep(type_out,strng_out,rtcode)

char	*type_out;
char	*strng_out;
char	*rtcode;

{

char	*pntr;

/*epoch here find what is next*/
pntr = strchr(type_out,' '); /*find blank*/
if (pntr == NULL)
{
	/*error here*/
	strcpy(rtcode,err_rtrn_code[EPN_INDX]);
	return;
}
while(pntr[0] == ' ')
{
	pntr++;
}
type_in_is = TRUE; /*set to use epoch_tarray, epoch_dptimes etc*/
switch (pntr[0])
{
	case 'D':
	case 'd':
		/*DOY or DATE */
		if (pntr[1] == 'A' || pntr[1] == 'a')
		{
			/*DATE output*/
			d5strdat(EPS.epoch_tarray,EPS.epoch_mon,
			         strng_out,rtcode);
		}
		else if (pntr[1] == 'O'  ||  pntr[1] == 'o')
		{
			/*DOY output*/
			d5strdoy(EPS.epoch_tarray,strng_out,rtcode);
		}
		else
		{
			/*DPSEC out put*/
			d5strdp(EPS.epoch_tarray,EPS.epoch_dptimes,
			        pntr,strng_out,rtcode);
		}	
	break;
	case 'H': /*hoy*/
	case 'h':
		d5strhoy(EPS.epoch_tarray,strng_out,rtcode);
	break;
	case 'M':
	case 'm':
		if (pntr[1] == 'O' || pntr[1] == 'o'  ||
		    pntr[1] == 'N' || pntr[1] == 'n')
		{
			/*month format*/
			d5strmn(EPS.epoch_tarray,pntr,strng_out,
				rtcode);
		}
		else
		{
			/*MDY (month day year) format*/
			d5strmdy(EPS.epoch_tarray,EPS.epoch_mon,
			         strng_out,rtcode);
		}
	break;
	case 'S':
	case 's':
		/*seconds past epoch*/
		d5strsfe(EPS.epoch_tarray,pntr,strng_out,rtcode);
	break;
	default:
	break;
	
}
return;
}


static
d5strdat(tarray,mon,strng_out,rtcode)

long	int	*tarray;
char	*mon;
char	*strng_out;
char	*rtcode;

{

char	mn[4];


if (!type_in_is)
{
	/*trray has inputs neccessary pointed to by tpntr*/
	d5chkyr(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	strcpy(mn,mon);
	d5fdatmn(tpntr,mn,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	d5chkmn(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	/*YYY mon DD HH:MM:SS.FFF
	                   year mn day   hh : mm  :  ss .FFF*/
	sprintf(strng_out,"%4ld %s %ld %02ld:%02ld:%02ld.%03ld",
		YEAR1,
		mn,
		DAY1,
		HOUR1,
		MINUTE1,
		SECOND1,
		MILLSEC1); 	
	return;
}
/*YYY mon DD HH:MM:SS.FFF
                   year mn day   hh : mm  :  ss .FFF*/
sprintf(strng_out,"%4ld %s %ld %02ld:%02ld:%02ld.%03ld",
	YEAR,
	mon,
	DAY,
	HOUR,
	MINUTE,
	SECOND,
	MILLSEC); 	
return;
}

static
d5strmdy(tarray,mon,strng_out,rtcode)

long	int	*tarray;
char	*mon;
char	*strng_out;
char	*rtcode;

{

char	mn[4];


if (!type_in_is)
{
	/*trray has inputs neccessary pointed to by tpntr*/
	d5chkyr(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	strcpy(mn,mon);
	d5fdatmn(tpntr,mn,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	d5chkmn(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	/*mon DD YYYY HH:MM:SS.FFF
	                   mn day year   hh : mm  :  ss .FFF*/
	sprintf(strng_out,"%s %ld %4ld %02ld:%02ld:%02ld.%03ld",
		mn,
		DAY1,
		YEAR1,
		HOUR1,
		MINUTE1,
		SECOND1,
		MILLSEC1); 	
	return;
}
/*mon DD YYYY HH:MM:SS.FFF
                   mn day year   hh : mm  :  ss .FFF*/
sprintf(strng_out,"%s %ld %4ld %02ld:%02ld:%02ld.%03ld",
	mon,
	DAY,
	YEAR,
	HOUR,
	MINUTE,
	SECOND,
	MILLSEC); 	
return;
}

static
d5strmn(tarray,type_out,strng_out,rtcode)

long	int	*tarray;
char	*type_out;
char	*strng_out;
char	*rtcode;

{
if (!type_in_is)
{
	/*trray contains neccessary input for computations.
	  pointed to by tpntr*/
	d5chkyr(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	d5chkmn(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	if (type_out[1] == 'O'  ||  type_out[1] == 'o')
	{
		/*YYYY MN DD HH:MM:SS.FFF
		     year  mn day   hh : mm  :  ss .FFF*/
		sprintf(strng_out,
		    "%4ld %ld %ld %02ld:%02ld:%02ld.%03ld",
			YEAR1,
			MONTH1,
			DAY1,
			HOUR1,
			MINUTE1,
			SECOND1,
			MILLSEC1); 
	}
	else
	{
		/*MN DD YYYY HH:MM:SS.FFF
		     mn day  year  hh : mm  :  ss  .FFF*/
		sprintf(strng_out,
		    "%ld %ld %4ld %02ld:%02ld:%02ld.%03ld",
			MONTH1,
			DAY1,
			YEAR1,
			HOUR1,
			MINUTE1,
			SECOND1,
			MILLSEC1);
	} 
			
	return;
}
if (type_out[1] == 'O'  ||  type_out[1] == 'o')
{
	/*YYYY MN DD HH:MM:SS.FFF
	     year  mn day   hh : mm  :  ss .FFF*/
	sprintf(strng_out,
	    "%4ld %ld %ld %02ld:%02ld:%02ld.%03ld",
		YEAR,
		MONTH,
		DAY,
		HOUR,
		MINUTE,
		SECOND,
		MILLSEC); 
}
else
{
	/*MN DD YYYY HH:MM:SS.FFF
	     mn day  year  hh : mm  :  ss  .FFF*/
	sprintf(strng_out,
	    "%ld %ld %4ld %02ld:%02ld:%02ld.%03ld",
		MONTH,
		DAY,
		YEAR,
		HOUR,
		MINUTE,
		SECOND,
		MILLSEC);
} 			
return;
}

static	
d5strdoy(tarray,strng_out,rtcode)

long	int	*tarray;
char	*strng_out;
char	*rtcode;

{

if (!type_in_is)
{
	/*trarry contains neccessary input for computations.
	  pointed to by tpntr*/
	d5chkyr(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	d5chkdoy(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	/*YYYY DOY HH:MM:SS.FFF
	                   year  doy    hh : mm  :  ss .FFF*/
	sprintf(strng_out,"%4ld %03ld %02ld:%02ld:%02ld.%03ld",
		YEAR1,
		DOY1,
		HOUR1,
		MINUTE1,
		SECOND1,
		MILLSEC1); 	
	return;
}
/*YYYY DOY HH:MM:SS.FFF
                   year  doy    hh : mm  :  ss .FFF*/
sprintf(strng_out,"%4ld %03ld %02ld:%02ld:%02ld.%03ld",
	YEAR,
	DOY,
	HOUR,
	MINUTE,
	SECOND,
	MILLSEC); 	
return;
}

static	
d5strhoy(tarray,strng_out,rtcode)

long	int	*tarray;
char	*strng_out;
char	*rtcode;

{

if (!type_in_is)
{
	/*trarry contains neccessary input for computations.
	  pointed to by tpntr*/
	d5chkyr(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	d5chkhoy(tpntr,rtcode);
	if (rtcode[3] == 'X')
	{
		return;
	}
	/*YYYY hhhh HRS ssss.FFF SECS
	                   year  hoy     hh  ss.FFF*/ 
	sprintf(strng_out,"%4ld %ld HRS %ld.%03ld SECS",
		YEAR1,
		HOY1,
		SECOHR1,
		MILLSEC1); 
	return;	
}
/*YYYY hhhh HRS ssss.FFF SECS
                   year  hoy     hh  ss.FFF*/ 
sprintf(strng_out,"%4ld %ld HRS %ld.%03ld SECS",
	YEAR,
	HOY,
	SECOHR,
	MILLSEC); 	
return;
}


static
d5strsfe(tarray,type_out,strng_out,rtcode)

long	int	*tarray;
char	*type_out;
char	*strng_out;
char	*rtcode;

{

DBL	mills;
long	int	mill;
int	len;
int	j;
union {
	long	int	frsli;
	unsigned short	frsus[2];
} frsx;
char	typeout[24];
int	char_chk_indx;
/*type out = 'SP50', 'SP50M', 'SP50X', 'SP2000', 'SP2000M', 'SP2000X'
  'SPEPOCH', 'SPEPOCHM', 'SPEPOCHX'*/
if (type_out[2] == '2')
{
	/*use epoch of 2000*/
	j = SP2000_INDX ;
	strcpy(typeout,"2000");
	char_chk_indx = 6; /*SP2000? The '?' is in type_in[6]*/
}
else if (type_out[2] == '5')
{
	/*use epoch 1950*/
	j = SP50_INDX;
	strcpy(typeout,"1950");
	char_chk_indx = 4; /*SP50? The '?' is in type_in[4]*/
}
else
{
	/*else use users epoch*/
	if (strcmp(EPS.new_epoch,"YES"))
	{
		/*none here*/
		strcpy(rtcode,err_rtrn_code[NEP_INDX]);
		return;
	}
	j = SPEPOCH_INDX;
	strcpy(typeout,EPS.char_epoch);
	char_chk_indx = 7; /*SPEPOCH? The '?' is in type_in[7]*/
}
if (type_out[char_chk_indx] == 'X'  ||
    type_out[char_chk_indx] == 'x')
{
	/*HEX output*/
	frsx.frsli = tarray[j]; /*fractional seconds*/
	sprintf(strng_out,
		"%04X%04X  ",
		frsx.frsus[ORDS_INDX0]&0xffff,
		frsx.frsus[ORDS_INDX1]&0xffff);
	len = strlen(strng_out);
	frsx.frsli = tarray[j+1]; /*fractional seconds*/
	sprintf(&strng_out[len],"%04X seconds, in hex, from %s",
		frsx.frsus[ORDS_INDX1]&0xffff,typeout);
	return;
}
if (!type_in_is)
{
	if (type_out[char_chk_indx] == 'M')
	{
		/*use milliseconds instead of fractional input*/
		mill = MILLSEC;
	}
	else
	{
		/*trray has inputs neccessary to compute what is needed
		  pointed to by tpntr*/
		/*compute mill from fractional seconds*/
		mills = (DBL)trray[j+1] / hex_1000 + .0005;/*round up*/
		if (mills >= 1.)
		{
			mills -= 1.;
			trray[j] ++;
		}
		mill = (long int)(mills * 1000.);
		if (trray[j] < 0)
		{
			mill = 1000 - mill;
		}
	}
	sprintf(strng_out,"%ld.%03ld seconds from %s",
	        trray[j],mill,typeout);
	return;
}
if (tarray[j] < 0)
{
	mill = 1000 - MILLSEC;
}
else
{
	mill = MILLSEC;
}
sprintf(strng_out,"%ld.%03ld seconds from %s",tarray[j],mill,typeout);
return;
}
	
static
d5strdp(tarray,dptimes,type_out,strng_out,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*type_out;
char	*strng_out;
char	*rtcode;

{

int	indx;
int	indx1;
DBL	mills;
long	int	mill;
long	int	sfep;
union	{
	DBL	sfepu;
	short	int	sfli[4];
} sfx;
char	typeout[24];
int	char_chk_indx;
BOOL	is_julian;
	
/*DBL precision floating point*/
/*type_out = 'DP50', 'DP50E', 'DP50X', 'DP2000', 'DP2000E', 'DP2000X',
  'DPEPOCH', 'DPEPOCHX', 'DPJULIAN', 'DPJULIANE', 'DPJULIANX'*/
is_julian = FALSE;
if(type_out[2] == '2')
{
	/*seconds past 2000*/
	indx = DP2000_INDX;
	indx1 = SP2000_INDX;
	strcpy(typeout,"2000");
	char_chk_indx = 6; /*DP2000? The '?' is in type_in[6]*/
}
else if (type_out[2] == '5')
{
	/*seconds past 1950*/
	indx = DP50_INDX;
	indx1 = SP50_INDX;
	char_chk_indx = 4; /*DP50? The '?' is in type_in[4]*/
	strcpy(typeout,"1950");
}
else if (type_out[2] == 'E'  ||  type_out[2] == 'e')
{
	/*else use users epoch*/
	if (strcmp(EPS.new_epoch,"YES"))
	{
		/*none here*/
		strcpy(rtcode,err_rtrn_code[NEP_INDX]);
		return;
	}
	indx = DPEPOCH_INDX;
	indx1 = SPEPOCH_INDX;
	strcpy(typeout,EPS.char_epoch);
	char_chk_indx = 7; /*DPEPOCH? The '?' is in type_in[7]*/
}
else
{
	/*this is julian date*/
	indx = DPJULIAN_INDX;
	char_chk_indx = 8; /*DPJULIAN? The '?' is in type_in[8]*/
	strcpy(typeout,"Julian date");
	is_julian = TRUE;
}
if (type_out[char_chk_indx] == 'E')
{
	if (is_julian)
	{
		/*Julian date here*/	
		sprintf(strng_out,"Julian date %.12E",dptimes[indx]);
		return;
	}
	sprintf(strng_out,"%.12E seconds from %s",
	        dptimes[indx],typeout);
	return;
}
if (type_out[char_chk_indx] == 'X'  ||
    type_out[char_chk_indx] == 'x')
{
	/*HEX output*/
	sfx.sfepu = dptimes[indx];
	if (is_julian)
	{
		sprintf(strng_out,
			"Julian date (in hex) %04X%04X %04X%04X",
			sfx.sfli[ORDL_INDX0]&0xffff,
			sfx.sfli[ORDL_INDX1]&0xffff,
			sfx.sfli[ORDL_INDX2]&0xffff,
			sfx.sfli[ORDL_INDX3]&0xffff);
		return;
	}
	sprintf(strng_out,
		"%04X%04X %04X%04X DP hex secs from %s",
		sfx.sfli[ORDL_INDX0]&0xffff,
		sfx.sfli[ORDL_INDX1]&0xffff,
		sfx.sfli[ORDL_INDX2]&0xffff,
		sfx.sfli[ORDL_INDX3]&0xffff,
		typeout);
	return;
}
if (!type_in_is  ||  is_julian)
{
	sfep = dptimes[indx];
	if (dptimes[indx] < 0)
	{
		mills = (DBL)sfep - dptimes[indx];
	}
	else
	{
		mills = dptimes[indx] - (DBL)sfep;
	}
	mills *= 1000.;
	mills += .5;
	if (mills >= 1000.)
	{
		mills -= 1000.;
		sfep += 1.;
	}
	mill = mills;
	if (is_julian)
	{
		sprintf(strng_out,"Julian date %ld.%03ld",sfep,mill);
		return;
	}
	sprintf(strng_out,"%ld.%03ld seconds from %s",
		sfep,mill,typeout);
	return;
}
if (tarray[indx1] < 0)
{
	mill = 1000 - MILLSEC;
}
else
{
	mill = MILLSEC;
}
sprintf(strng_out,"%ld.%03ld seconds from %s",
	tarray[indx1],mill,typeout);
return;
}

	
static
d5tmnfc(tarray,dptimes,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*rtcode;

{

DAY = tary_ints[day_indx];
HOUR = tary_ints[hour_indx];
MINUTE = tary_ints[minute_indx];
SECOND = tary_ints[second_indx];

if (dec_indx)
{
	MILLSEC = tary_ints[dec_indx];
}
else
{
	MILLSEC = 0;
}
/*check on months*/
d5chkmn(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
/*create the rest from here*/
d5fmntd(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5tepfd(tarray,dptimes,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5thfd(tarray,rtcode);
return;
}

static 
d5fndyr(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

int	len;

len = strlen(tary_pntrs[year_indx]);

if (len == 2)
{
	/*two digit year*/
	if (tary_ints[year_indx] >= 50)
	{
		YEAR = tary_ints[year_indx] + 1900;
	}
	else 
	{
		YEAR = tary_ints[year_indx] + 2000;
	}
}
else if (len == 4)
{
	YEAR = tary_ints[year_indx];
}
else
{
	strcpy(rtcode,err_rtrn_code[YRO_INDX]);
}
return;
}

static
d5fhtd(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

/*from HOY to DOY*/

/*DOY = HOY/24 */

DOY = HOY/24;

HOUR = HOY % 24;

MINUTE = SECOHR / 60;

SECOND = SECOHR % 60;

return;
}

static
d5fdatmn(tarray,mon,rtcode)

long	int	*tarray;
char	*mon;
char	*rtcode;

{

int	i;

/*from date to month format*/
MONTH = 0;
for ( i = 0 ; i < 12 ; i++)
{
	if (!strncmp(mon,mnths[i],3))
	{
		MONTH = i+1;
		break;
	}
}
if (!MONTH)
{
	strcpy(rtcode,err_rtrn_code[MON_INDX]);
	return;
}
return;
}

static 
d5fmntd(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

int	i;

/*from month format to DOY*/

i = MONTH - 1;


if (!(YEAR % 4))
{
	/*leap year*/
	DOY = DAY + days_leap[i];
	if (DOY > 366)
	{
		strcpy(rtcode,err_rtrn_code[DOY_INDX]);
		return;
	}
}
else
{
	DOY = DAY + daysnonleap[i];
	if (DOY > 365)
	{
		strcpy(rtcode,err_rtrn_code[DOY_INDX]);
		return;
	}
}
return;
}

static
d5fdptd(tarray,dptimes,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*type_in;
char	*rtcode;

{

DBL	mills;
int	i;
BOOL	is_julian;

/*from DP seconds from epoch to DOY*/
is_julian = FALSE;
/*initialize some things here*/
FRACF1950 = 0;
FRACF2000 = 0;
FRACFEPOCH = 0;
if (type_in[2] == '2')
{
	/*seconds from 2000*/
	d5dpscf2(tarray,dptimes,rtcode);
}
else if (type_in[2] == '5')
{		
	/*seconds from 1950*/
	d5dpscf5(tarray,dptimes,rtcode);
}
else if (type_in[2] == 'E' ||  type_in[2] == 'e')
{
	/*use users epoch of choice*/
	if (strcmp(EPS.new_epoch,"YES"))
	{
		/*error  */
		
		strcpy(rtcode,err_rtrn_code[NEP_INDX]);
		return;
	}
	d5dpscfe(tarray,dptimes,rtcode);
}
else
{
	/*julian date here*/
	is_julian = TRUE;
	d5dpfjd(tarray,dptimes,rtcode);
}
if (rtcode[3] == 'X')
{
	/*error fond */
	return;
}
if (use_sf50)
{
	d5use50(tarray,rtcode);
}
else
{
	d5use2000(tarray,rtcode);
}
if (rtcode[3] == 'X')
{
	return;
}
/*compute DOY etc*/
DOY = scs2year/86400 + 1; 
/*DOY starts at one at zero seconds from midnight January 1st*/ 

/*from day of year format to seconds from epochs*/
sfdoy = scs2year % 86400;

/*compute hours etc*/

HOUR = sfdoy/3600;

SECOND = sfdoy % 3600;

MINUTE = SECOND / 60;

SECOND %= 60;
/*check doy computations*/
d5chkdoy(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5fracs(tarray,rtcode);
return;

}

static
d5dpscf2(tarray,dptimes,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*rtcode;

{

DBL	mills;
DBL	days_past_epoch;

SECSF2000 = DPSECSF2000;
DPSECSF50 = dsp50to2000 + DPSECSF2000;
if (DPSECSF2000 >= 0) 
{
	use_sf50 = FALSE;
	if (DPSECSF2000 > (DBL)sp50f2000lrgst)
	{
		/*seconds past 2000 is greater than 
		 sf 1950 can go for 4 byte ints*/
		 SECSF1950 = -1; /*set not usable*/
		 FRACF1950 = -1;
	}
	else
	{
		SECSF1950 = DPSECSF50;
		mills = DPSECSF50 - (DBL)SECSF1950;
		mills *= 1000.;
		mills += .5;
		if (mills >= 1000.)
		{
			mills -= 1000.;
			SECSF1950++;
		}
		MILLSEC = mills;
	}
	if (EPS.find_epoch_times)
	{
		/*user epoch here*/
		/*********************************************
		Seconds from Other Epoch to seconds from 2000

		Seconds from 2000 to epoch is SEPF2000
		Seconds from epoch is SEP
		Seconds from 2000 is SF2000 

		Given SEPF2000 and SF2000 find SEP

			SEP = SF2000 - SEPF2000
	
		***********************************************/
		DPSECSFEPOCH = DPSECSF2000 - DPEPOCH_2000;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*find julian date here*/
	days_past_epoch = DPSECSF2000/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_2000;
}
else
{
	use_sf50 = TRUE;
	SECSF1950 = DPSECSF50;
	mills = DPSECSF50 - (DBL)SECSF1950;
	mills *= 1000.;
	mills += .5;
	if (mills >= 1000.)
	{
		mills -= 1000.;
		SECSF1950++;
	}
	MILLSEC = mills;
	if (EPS.find_epoch_times)
	{
		/*user epoch here*/
		DPSECSFEPOCH = DPSECSF50 - DPEPOCH_50;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*find julian date here*/
	days_past_epoch = DPSECSF2000/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_2000;
}
return;
}

static
d5dpscf5(tarray,dptimes,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*rtcode;

{

DBL	mills;
DBL	days_past_epoch;
int	i;

DPSECSF2000 = DPSECSF50 - dsp50to2000;
SECSF1950 = DPSECSF50;
if (SECSF1950 < 0)
{
	strcpy(rtcode,err_rtrn_code[DPO_INDX]);
	return;
}
SECSF2000 = DPSECSF2000;
mills = DPSECSF50 - (DBL)SECSF1950;
mills *= 1000.;
mills += .5;
if (mills >= 1000.)
{
	mills -= 1000.;
	SECSF1950++;
}
MILLSEC = mills;
/*find julian date here*/
days_past_epoch = DPSECSF50/86400.;
DPJULIAN = days_past_epoch + JULIAN_DATE_1950;
if (SECSF1950 > sp50to2000)
{
	use_sf50 = FALSE;
	if (EPS.find_epoch_times)
	{
		/*user epoch here*/
		/*********************************************
		Seconds from Other Epoch to seconds from 2000

		Seconds from 2000 to epoch is SEPF2000
		Seconds from epoch is SEP
		Seconds from 2000 is SF2000 

		Given SEPF2000 and SF2000 find SEP

			SEP = SF2000 - SEPF2000
	
		***********************************************/
		DPSECSFEPOCH = DPSECSF2000 - DPEPOCH_2000;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
}
else
{
	use_sf50 = TRUE;
	if (EPS.find_epoch_times)
	{
		/*user epoch here*/
		/*********************************************
		Seconds from Other Epoch to seconds from 1950

		Seconds from 1950 to epoch is SEPF50
		Seconds from epoch is SEP
		Seconds from 1950 is SF50 

		Given SEPF50 and SF50 find SEP

			SEP = SF50 - SEPF50
	
		***********************************************/
		DPSECSFEPOCH = DPSECSF50 - DPEPOCH_50;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*find julian date here*/
	days_past_epoch = DPSECSF50/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_1950;
}
return;
}

static
d5dpscfe(tarray,dptimes,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*rtcode;

{

DBL	mills;
DBL	days_past_epoch;

/*compute seconds past epoch or 2000 or 1950 */

SECSFEPOCH = DPSECSFEPOCH;
/*********************************************
Seconds from Other Epoch to seconds from 1950

Seconds from 1950 to epoch is SEPF50
Seconds from epoch is SEP
Seconds from 1950 is SF50 

Given SEPF50 and SEP find SF50

	SF50 = SEPF50 + SEP

***********************************************/
DPSECSF50 = DPEPOCH_50 + DPSECSFEPOCH;
/*********************************************
Seconds from Other Epoch to seconds from 2000

Seconds from 2000 to epoch is SEPF2000
Seconds from epoch is SEP
Seconds from 2000 is SF2000 

Given SEPF2000 and SEP find SF2000

	SF2000 = SEPF2000 + SEP

***********************************************/
DPSECSF2000 = DPEPOCH_2000 + DPSECSFEPOCH;
SECSF2000 = DPSECSF2000;
if (DPSECSF2000 >= 0) 
{
	use_sf50 = FALSE;
	if (DPSECSF2000 > (DBL)sp50f2000lrgst)
	{
		/*seconds past 2000 is greater than 
		 sf 1950 can go for 4 byte ints*/
		 SECSF1950 = -1; /*set not usable*/
		 FRACF1950 = -1;
	}
	else
	{
		SECSF1950 = DPSECSF50;
		mills = DPSECSF50 - (DBL)SECSF1950;
		mills *= 1000.;
		mills += .5;
		if (mills >= 1000.)
		{
			mills -= 1000.;
			SECSF1950++;
		}
		MILLSEC = mills;
	}
	/*find julian date here*/
	days_past_epoch = DPSECSF2000/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_2000;
}
else
{
	use_sf50 = TRUE;
	SECSF1950 = DPSECSF50;
	mills = DPSECSF50 - (DBL)SECSF1950;
	mills *= 1000.;
	mills += .5;
	if (mills >= 1000.)
	{
		mills -= 1000.;
		SECSF1950++;
	}
	MILLSEC = mills;
	/*find julian date here*/
	days_past_epoch = DPSECSF50/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_1950;
}
return;
}

/*Julian date*/
static
d5dpfjd(tarray,dptimes,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*rtcode;

{

DBL	mills;
DBL	days_past_epoch;

if (DPJULIAN >= JULIAN_DATE_2000)
{
	days_past_epoch = DPJULIAN - JULIAN_DATE_2000;
	DPSECSF2000 = days_past_epoch * 86400.;
	SECSF2000 = DPSECSF2000;
	DPSECSF50 = dsp50to2000 + DPSECSF2000;
	use_sf50 = FALSE;
	if (DPSECSF2000 > (DBL)sp50f2000lrgst)
	{
		/*seconds past 2000 is greater than 
		 sf 1950 can go for 4 byte ints*/
		 SECSF1950 = -1; /*set not usable*/
		 FRACF1950 = -1;
	}
	else
	{
		SECSF1950 = DPSECSF50;
		mills = DPSECSF50 - (DBL)SECSF1950;
		mills *= 1000.;
		mills += .5;
		if (mills >= 1000.)
		{
			mills -= 1000.;
			SECSF1950++;
		}
		MILLSEC = mills;
	}
	if (EPS.find_epoch_times)
	{
		/*user epoch here*/
		/*********************************************
		Seconds from Other Epoch to seconds from 2000

		Seconds from 2000 to epoch is SEPF2000
		Seconds from epoch is SEP
		Seconds from 2000 is SF2000 

		Given SEPF2000 and SF2000 find SEP

			SEP = SF2000 - SEPF2000
	
		***********************************************/
		DPSECSFEPOCH = DPSECSF2000 - DPEPOCH_2000;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
}
else
{
	use_sf50 = TRUE;
	days_past_epoch = DPJULIAN - JULIAN_DATE_1950;
	DPSECSF50 = days_past_epoch * 86400.;
	SECSF1950 = DPSECSF50;
	DPSECSF2000 = DPSECSF50 - dsp50to2000;
	SECSF2000 = DPSECSF2000;
	mills = DPSECSF50 - (DBL)SECSF1950;
	mills *= 1000.;
	mills += .5;
	if (mills >= 1000.)
	{
		mills -= 1000.;
		SECSF1950++;
	}
	MILLSEC = mills;
	if (EPS.find_epoch_times)
	{
		/*user epoch here*/
		DPSECSFEPOCH = DPSECSF50 - DPEPOCH_50;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
}
return;
}

static
d5fsftd(tarray,dptimes,type_in,rtcode)

long	int	*tarray;
DBL	*dptimes;
char	*type_in;
char	*rtcode;

{

DBL	mills;
long	int	mill;
int	i;
BOOL	nofndmills;
int	char_chk_indx;
long	int	secsfrm;
/*from seconds from epoch (integer format) to DOY*/
nofndmills = FALSE;
/*      SP50M              SP2000M             SPEPOCHM*/
if (type_in[2] == '2')
{
	/*seconds from 2000*/
	char_chk_indx = 6; /*SP2000? where type_in[6] is '?'*/
	secsfrm = SECSF2000;
}
else if (type_in[2] == '5')
{
	/*seconds from 1950*/
	char_chk_indx = 4; /*SP50? where type_in[4] is '?'*/
	secsfrm = SECSF1950;
}
else if (EPS.find_epoch_times)
{
	/*seconds from epoch*/
	char_chk_indx = 7; /*SPEPOCH? where type_in[7] is '?'*/
	secsfrm = SECSFEPOCH;
}
if (type_in[char_chk_indx] == 'M')
{
	/*use milliseconds instead of fractional input*/
	nofndmills = TRUE;
	if (secsfrm < 0)
	{	
		mill = MILLSEC - 1000;
	}
	else
	{
		mill = MILLSEC;
	}
	mills = (DBL) mill;
	mills /= 1000.;
}
if (type_in[2] == '2')
{
	/*seconds from 2000*/
	d5secsf2(tarray,dptimes,&mills,nofndmills,rtcode);
}
else if (type_in[2] == '5')
{
	/*seconds from 1950*/
	d5secsf5(tarray,dptimes,&mills,nofndmills,rtcode);
}
else if (EPS.find_epoch_times)
{
	/*seconds from epoch*/
	d5secsfe(tarray,dptimes,&mills,nofndmills,rtcode);
}
if (rtcode[3] == 'X')
{
	/*error found*/
	return;
}
if (use_sf50)
{
	d5use50(tarray,rtcode);
}
else
{
	d5use2000(tarray,rtcode);
}
if (rtcode[3] == 'X')
{
	return;
}
/*compute DOY etc*/
DOY = scs2year/86400 + 1; 
/*DOY starts at one at zero seconds from midnight January 1st*/ 

/*from day of year format to seconds from epochs*/
sfdoy = scs2year % 86400;

/*compute hours etc*/

HOUR = sfdoy/3600;

SECOND = sfdoy % 3600;

MINUTE = SECOND / 60;

SECOND %= 60;

d5chkdoy(tarray,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
d5fracs(tarray,rtcode);

return;

}


static d5secsf2(tarray,dptimes,mills,nofndmills,rtcode)

long	int	*tarray;
DBL	*dptimes;
DBL	*mills;
BOOL	nofndmills;
char	*rtcode;

{

long	int	mill;
int	i;
DBL	days_past_epoch;
DBL	fracs;

FRACF1950 = 0;
if (!nofndmills)
{

	d5frac2mills(&SECSF2000,&FRACF2000,&mill,mills);
	if (SECSF2000 > 0)
	{
		MILLSEC = mill;
	}
	else
	{
		MILLSEC = 1000 + mill;
	}
}
else
{
	FRACF2000 = 0;
}
DPSECSF2000 = (DBL)SECSF2000 + mills[0];
DPSECSF50 = dsp50to2000 + DPSECSF2000;
if (SECSF2000 > 0)
{
	use_sf50 = FALSE;
	if (SECSF2000 > sp50f2000lrgst)
	{
		SECSF1950 = -1;
		FRACF1950 = -1;
	}
	else
	{
		SECSF1950 = sp50to2000 + SECSF2000;
	}
	if (EPS.find_epoch_times)
	{
		/*compute seconds past epoch*/
		/*********************************************
		Seconds from Other Epoch to seconds from 2000

		Seconds from 2000 to epoch is SEPF2000
		Seconds from epoch is SEP
		Seconds from 2000 is SF2000 

		Given SEPF2000 and SF2000 find SEP

			SEP = SF2000 - SEPF2000
	
		***********************************************/
		FRACFEPOCH = 0;
		DPSECSFEPOCH = DPSECSF2000 - DPEPOCH_2000;
		SECSFEPOCH = DPSECSFEPOCH;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*find Julian Date*/
	/*find julian date here*/
	days_past_epoch = DPSECSF2000/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_2000;
}
else
{
	use_sf50 = TRUE;
	SECSF1950 = sp50to2000 + SECSF2000;
	if (EPS.find_epoch_times)
	{
		/*compute seconds past epoch*/
		/*********************************************
		Seconds from Other Epoch to seconds from 1950

		Seconds from 1950 to epoch is SEPF50
		Seconds from epoch is SEP
		Seconds from 1950 is SF50 

		Given SEPF50 and SF50 find SEP

			SEP = SF50 - SEPF50
	
		***********************************************/
		FRACFEPOCH = 0;
		DPSECSFEPOCH = DPSECSF50 - DPEPOCH_50;
		SECSFEPOCH = DPSECSFEPOCH;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*find julian date here*/
	days_past_epoch = DPSECSF50/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_1950;
}
return;
}

static
d5secsf5(tarray,dptimes,mills,nofndmills,rtcode)

long	int	*tarray;
DBL	*dptimes;
DBL	*mills;
BOOL	nofndmills;
char	*rtcode;

{
		

long	int	mill;
int	i;
DBL	days_past_epoch;
DBL	fracs;

/*seconds from 1950*/
FRACF2000 = 0;
if (!nofndmills)
{
	/*compute mill from fractional seconds*/
	d5frac2mills(&SECSF1950,&FRACF1950,&MILLSEC,mills);
}
else
{
	FRACF1950 = 0;
}
DPSECSF50 = (DBL)SECSF1950 + mills[0];
DPSECSF2000 = DPSECSF50 - dsp50to2000;
SECSF2000 = DPSECSF2000;
if (SECSF2000 > 0)
{
	use_sf50 = FALSE;
	if (EPS.find_epoch_times)
	{
		/*compute seconds past epoch*/
		/*********************************************
		Seconds from Other Epoch to seconds from 2000

		Seconds from 2000 to epoch is SEPF2000
		Seconds from epoch is SEP
		Seconds from 2000 is SF2000 

		Given SEPF2000 and SF2000 find SEP

			SEP = SF2000 - SEPF2000
	
		***********************************************/
		FRACFEPOCH = 0;
		DPSECSFEPOCH = DPSECSF2000 - DPEPOCH_2000;
		SECSFEPOCH = DPSECSFEPOCH;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*find julian date here*/
	days_past_epoch = DPSECSF2000/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_2000;
}
else
{
	use_sf50 = TRUE;
	if (EPS.find_epoch_times)
	{
		/*compute seconds past epoch*/
		/*********************************************
		Seconds from Other Epoch to seconds from 1950

		Seconds from 1950 to epoch is SEPF50
		Seconds from epoch is SEP
		Seconds from 1950 is SF50 

		Given SEPF50 and SF50 find SEP

			SEP = SF50 - SEPF50
	
		***********************************************/
		FRACFEPOCH = 0;
		DPSECSFEPOCH = DPSECSF50 - DPEPOCH_50;
		SECSFEPOCH = DPSECSFEPOCH;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*find julian date here*/
	days_past_epoch = DPSECSF50/86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_1950;
}
return;
}

static
d5secsfe(tarray,dptimes,mills,nofndmills,rtcode)

long	int	*tarray;
DBL	*dptimes;
DBL	*mills;
BOOL	nofndmills;
char	*rtcode;

{
		

long	int	mill;
int	i;
DBL	days_past_epoch;
DBL	fracs;

/*seconds from EPOCH*/
FRACF1950 = 0;
FRACF2000 = 0;
if (!nofndmills)
{
	/*compute mill from fractional seconds*/
	d5frac2mills(&SECSFEPOCH,&FRACFEPOCH,&mill,mills);
	if (SECSFEPOCH > 0)
	{
		MILLSEC = mill;
	}
	else
	{
		MILLSEC = 1000 + mill;
	}
}
else
{
	FRACFEPOCH = 0;
}
DPSECSFEPOCH = (DBL)SECSFEPOCH + mills[0];
/*********************************************
Seconds from Other Epoch to seconds from 1950

Seconds from 1950 to epoch is SEPF50
Seconds from epoch is SEP
Seconds from 1950 is SF50 

Given SEPF50 and SEP find SF50

	SF50 = SEPF50 + SEP

***********************************************/
DPSECSF50 = DPEPOCH_50 + DPSECSFEPOCH;
/*********************************************
Seconds from Other Epoch to seconds from 2000

Seconds from 2000 to epoch is SEPF2000
Seconds from epoch is SEP
Seconds from 2000 is SF2000 

Given SEPF2000 and SEP find SF2000

	SF2000 = SEPF2000 + SEP

***********************************************/
DPSECSF2000 = DPEPOCH_2000 + DPSECSFEPOCH;
SECSF2000 = DPSECSF2000;
if (SECSF2000 > 0)
{
	use_sf50 = FALSE;
	/*find julian date here*/
	days_past_epoch = DPSECSF2000/86400.;
	if (SECSF2000 > sp50f2000lrgst)
	{
		SECSF1950 = -1;
		FRACF1950 = -1;
	}
	else
	{
		SECSF1950 = DPSECSF50;
	}
	DPJULIAN = days_past_epoch + JULIAN_DATE_2000;
}
else 
{
	use_sf50 = TRUE;
	SECSF1950 = DPSECSF50;
	DPJULIAN = days_past_epoch + JULIAN_DATE_1950;
}
return;
}


static
d5use50(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

int	i;

/*find tims usins seconds from 1950*/
indxf1950 = -1;
for ( i = 13 ; i >= 1 ; i -= 2)
{
	if (SECSF1950 >= sf1950b10[i])
	{
		/*we found it*/
		indxf1950 = i;
		break;
	}
}
if (indxf1950 < 0)
{
	strcpy(rtcode,err_rtrn_code[SFO_INDX]);
	return;
}
scs210 = SECSF1950 - sf1950b10[indxf1950];
yearmod10 = -1;
if (!(sf1950b10[indxf1950-1] % 4))
{
	/*starts with leap year*/
	for ( i = 9 ; i >= 0 ; i--)
	{
		if (scs210 >= secs10leap[i])
		{
			yearmod10 = i;
			scs2year = 
				scs210 - secs10leap[i];
			break;
		}
	}
}
else
{
	/*starts with non leap year*/
	for ( i = 9 ; i >= 0 ; i--)
	{
		if (scs210 >= secs10non[i])
		{
			yearmod10 = i;
			scs2year = 
				scs210 - secs10non[i];
			break;
		}
	}
}
if (yearmod10 < 0)
{
	strcpy(rtcode,err_rtrn_code[SFO_INDX]);
	return;
}
/*compute year*/
YEAR = sf1950b10[indxf1950 - 1] + yearmod10;

return;
}

static
d5use2000(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

int	i;

/*find tims usins seconds from 2000*/
indxf2000 = -1;
for ( i = 13 ; i >= 1 ; i -= 2)
{
	if (SECSF2000 >= sf2000b10[i])
	{
		/*we found it*/
		indxf2000 = i;
		break;
	}
}
if (indxf2000 < 0)
{
	strcpy(rtcode,err_rtrn_code[SFO_INDX]);
	return;
}
scs210 = SECSF2000 - sf2000b10[indxf2000];
yearmod10 = -1;
if (!(sf2000b10[indxf2000-1] % 4))
{
	/*starts with leap year*/
	for ( i = 9 ; i >= 0 ; i--)
	{
		if (scs210 >= secs10leap[i])
		{
			yearmod10 = i;
			scs2year = 
				scs210 - secs10leap[i];
			break;
		}
	}
}
else
{
	/*starts with non leap year*/
	for ( i = 9 ; i >= 0 ; i--)
	{
		if (scs210 >= secs10non[i])
		{
			yearmod10 = i;
			scs2year = 
				scs210 - secs10non[i];
			break;
		}
	}
}
if (yearmod10 < 0)
{
	strcpy(rtcode,err_rtrn_code[SFO_INDX]);
	return;
}
/*compute year*/
YEAR = sf2000b10[indxf2000 - 1] + yearmod10;

return;
}

static
d5tepfd(tarray,dptimes,rtcode)

	long int	*tarray;
	DBL		*dptimes;
	char		*rtcode; 
	
{

DBL	days_past_epoch;

/*compute the seconds past epoch using years*/
FRACF1950 = 0;
FRACF2000 = 0;
d5sfep(YEAR,rtcode);
if (rtcode[3] == 'X')
{
	return;
}
/*compute seconds in year*/
/*January 1st at midnight is zero seconds but is DOY 1 so subtract 
  one day fronm DOY*/
scs2year = (DOY - 1)*86400 + HOUR*3600 + MINUTE*60 + SECOND;
if (use_sf50)
{
	/*use seconds past 1950*/
	SECSF1950 = byrsf1950 + scs2year;
	DPSECSF50 = MILLSEC;
	DPSECSF50 /= 1000.0;
	DPSECSF50 += SECSF1950;
	DPSECSF2000 = DPSECSF50 - dsp50to2000;
	SECSF2000 = DPSECSF2000;
	if (EPS.find_epoch_times)
	{
		/*comute DP epoch from seconds past 50*/
		/*********************************************
		Seconds from Other Epoch to seconds from 1950

		Seconds from 1950 to epoch is SEPF50
		Seconds from epoch is SEP
		Seconds from 1950 is SF50 

		Given SEPF50 and SF50 find SEP

			SEP = SF50 - SEPF50
	
		***********************************************/
		DPSECSFEPOCH = DPSECSF50 - DPEPOCH_50;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*Get Julian date*/
	days_past_epoch = DPSECSF50 / 86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_1950;
}
else
{
	/*find seconds past 2000*/
	SECSF2000 = byrsf2000 + scs2year;
	DPSECSF2000 = MILLSEC;
	DPSECSF2000 /= 1000.0;
	DPSECSF2000 += SECSF2000;
	DPSECSF50 = DPSECSF2000 + dsp50to2000;
	if (SECSF2000 > sp50f2000lrgst)
	{
		/*cannot do SECSF1950*/
		SECSF1950 = -1;
		FRACF1950 = -1;
	}
	else
	{
		SECSF1950 = DPSECSF50;
	}
	if (EPS.find_epoch_times)
	{
		/*********************************************
		Seconds from Other Epoch to seconds from 2000

		Seconds from 2000 to epoch is SEPF2000
		Seconds from epoch is SEP
		Seconds from 2000 is SF2000 

		Given SEPF2000 and SF2000 find SEP

			SEP = SF2000 - SEPF2000
	
		***********************************************/
		DPSECSFEPOCH = DPSECSF2000 - DPEPOCH_2000;
		SECSFEPOCH = DPSECSFEPOCH;
		FRACFEPOCH = 0;
	}
	else
	{
		SECSFEPOCH = -1;
		FRACFEPOCH = -1;
	}
	/*Get Julian date*/
	days_past_epoch = DPSECSF2000 / 86400.;
	DPJULIAN = days_past_epoch + JULIAN_DATE_2000;
}	
/*comp[ute fractional seconds */
d5fracs(tarray,rtcode);

return;
}
 
static
d5thfd(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

/*to HOY from DOY*/

/*hours in year are DOY * 24 + HOURS*/

HOY = DOY * 24 + HOUR;

/*seconds in hour are MINUTE*60 + SECOND*/

SECOHR = MINUTE*60 + SECOND;

return;
}


static
d5tmnfd(tarray,mon,rtcode)

long	int	*tarray;
char	*mon;
char	*rtcode;

{

int	i;

/*to month from DOY*/
if (!(YEAR % 4))
{
	/*leap year here */
	for ( i = 11 ; i >= 0 ; i--)
	{
		if (DOY > days_leap[i])
		{
			MONTH = i+1;
			if (mon != NULL)
			{
				strcpy(mon,mnths[i]);
			}
			DAY = DOY - days_leap[i];
			if (DAY < 1  |  DAY > dmn_leap[i])
			{
				strcpy(rtcode,err_rtrn_code[DYO_INDX]);
			}
			break;
		}
	}
}
else
{
	/*leap year here */
	for ( i = 11 ; i >= 0 ; i--)
	{
		if (DOY > daysnonleap[i])
		{
			MONTH = i+1;
			if (mon != NULL)
			{
				strcpy(mon,mnths[i]);
			}
			DAY = DOY - daysnonleap[i];
			if (DAY < 1  |  DAY > dmn_non[i])
			{
				strcpy(rtcode,err_rtrn_code[DYO_INDX]);
			}
			break;
		}
	}
}
return;
}

/*compute the seconds past epoch using years*/
static
d5sfep(year,rtcode)

long	int	year;
char	*rtcode;

{

if (year >= 2000)
{
	use_sf50 = FALSE;
}
else
{
	use_sf50 = TRUE;
}
if (year < sf1950b10[0]  || year > sf1950b10[16] + 10)
{
	strcpy(rtcode,err_rtrn_code[YRO_INDX]);
	return;
}
/*find	years by 10 */
yearmod10 = year % 10;
if (use_sf50)
{
	indxf1950 = ((year - yearmod10) - sf1950b10[0])/10;
	indxf1950 *= 2;
	if (!(sf1950b10[indxf1950] %4))
	{
		/*10 years starts with a leap year*/
		byrsf1950 = sf1950b10[indxf1950+1] +
	                  secs10leap[yearmod10];
	}
	else
	{
		/*10 years starts with a non leap year*/
		byrsf1950 = sf1950b10[indxf1950+1] +
	                  secs10non[yearmod10];
	}
}
else
{
	/*use seconds past 2000*/
	indxf2000 = ((year - yearmod10) - sf2000b10[0])/10;
	indxf2000 *= 2;
	if (!(sf2000b10[indxf1950] %4))
	{
		/*10 years starts with a leap year*/
		byrsf2000 = sf2000b10[indxf2000+1] +
	                  secs10leap[yearmod10];
	}
	else
	{
		/*10 years starts with a non leap year*/
		byrsf2000 = sf1950b10[indxf2000+1] +
	                  secs10non[yearmod10];
	}
}
return;
}

/*compute fractional seconds */
static
d5fracs(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

union {
	long	int	fracsl;
	unsigned short	int	fracss[2];
} frc;
DBL	fracsd;
int	i;
int	j;
DBL	sfep;

		
for (i = 0 ; i < 3 ; i++)
{
	if (!i)
	{
		if (FRACF1950)
		{
			continue;
		}
		j = SP50_INDX + 1;
	}
	else if (i == 1)
	{
		if (FRACF2000)
		{
			continue;
		}
		j = SP2000_INDX + 1;
	}
	else 
	{
		if (!EPS.find_epoch_times  ||  FRACFEPOCH)
		{
			continue;
		}
		j = SPEPOCH_INDX + 1;
	}
	if (MILLSEC == 0)
	{
		tarray[j] = 0;
		continue;
	}
	frc.fracss[ORDS_INDX0] = 0;
	if (tarray[j-1] < 0)
	{
		fracsd = (DBL)(1000 - MILLSEC);
	}
	else
	{ 		
		fracsd = (DBL)MILLSEC;
	}
	/*fractional portion of seconds*/
	fracsd /= 1000.; /*get as a true number less than one*/
	fracsd *= float_hex_1000;
	fracsd += .5;
	frc.fracss[ORDS_INDX1] = fracsd;
	tarray[j] = frc.fracsl;
}
return;
}

static
d5chkyr(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{


if (YEAR < sf1950b10[0]  ||
    YEAR > sf2000b10[12] + 10)
{
	strcpy(rtcode,err_rtrn_code[YRO_INDX]);
	return;
}
return;
}

static	
d5chkdoy(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{
/*check DOY here */
if (!(YEAR % 4))
{
	/*leap year*/
	if (DOY > 366)
	{
		strcpy(rtcode,err_rtrn_code[DYO_INDX]);
		return;
	}
}
else
{
	if (DOY > 365)
	{
		strcpy(rtcode,err_rtrn_code[DYO_INDX]);
		return;
	}
}
d5chkhms(tarray,rtcode);
return;
}

static
d5chkhoy(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{
/*check hour of year and seconds of hour and milliseconds*/
if (!(YEAR % 4))
{
	/*leap year*/
	if (HOY > 8784)
	{
		strcpy(rtcode,err_rtrn_code[HYO_INDX]); 
		return;
	}
}
else
{
	/*non leap year*/
	if (HOY > 8760)
	{
		strcpy(rtcode,err_rtrn_code[HYO_INDX]); 
		return;
	}
}
if (SECOHR < 0 || SECOHR >= 86400)
{
	strcpy(rtcode,err_rtrn_code[SHO_INDX]); 
	return;
}
if (MILLSEC < 0  || MILLSEC >= 1000)
{
	strcpy(rtcode,err_rtrn_code[MSO_INDX]);
	return;
}
return;
}

d5frac2mills(secsfanyep,frac,mills,dbl_mills)
	
	long	int	*secsfanyep;
	long	int	*frac;
	long	int	*mills;
	DBL	*dbl_mills;

{
	long	int	mill;
	DBL	fracs;

	/*compute mill from fractional seconds*/
	dbl_mills[0] = (DBL)frac[0] / hex_1000;
	fracs = dbl_mills[0] * 1000.;
	fracs += .5;
	if (fracs >= 1000.)
	{
		fracs -= 1000.;
		if (secsfanyep[0] >= 0)
		{
			secsfanyep[0]++;
		}
		else	
		{
			secsfanyep[0]--;
		}
	}
	mills[0] = (long int)fracs;
	/*place same sign as seconds past*/
	if (secsfanyep[0] >= 0)
	{
		return;
	}
	mills[0] *= -1;
	dbl_mills[0] *= -1.0;
	return;
}

static
d5chkmn(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{
/*check month and day of month*/
if (MONTH < 1 || MONTH > 12)
{
	strcpy(rtcode,err_rtrn_code[MNO_INDX]);
	return;
}
if (DAY < 1)
{
	strcpy(rtcode,err_rtrn_code[DAO_INDX]);
	return;
}
if (!(YEAR % 4))
{
	/*leap year */
	if (DAY > dmn_leap[MONTH -1 ])
	{
		strcpy(rtcode,err_rtrn_code[DAO_INDX]);
		return;
	}
}
else
{
	/*non leap year */
	if (DAY > dmn_non[MONTH -1 ])
	{
		strcpy(rtcode,err_rtrn_code[DAO_INDX]);
		return;
	}
}
d5chkhms(tarray,rtcode);
}

static
d5chg2in(rtcode)

char	*rtcode;

{

int	i;

/*change to integer*/

for ( i = 0 ; i < tot_in_array ; i++)
{
	if (tary_type[i] == 'c')
	{
		continue;
	}
	/*find binary int from character string*/
	sscanf(tary_pntrs[i],"%ld",
    	        &tary_ints[i]);
}
return;
}

static
d5chg2hx(rtcode)

char	*rtcode;


{

int	i;
int	j;
int	k;
union
{
	long	int	li;
	short	int	si[2];
	char	ch[4];
} iu;
char	hexchars[3];
int	tot;
int	hexint;

hexchars[2] = '\0';

/*change to hex from character inputs*/
for ( i = 0 ; i < tot_in_array ; i++)
{
	if (tary_type[i] == 'c')
	{
		continue;
	}
	hexint = 0;
	iu.li = 0; /*start clean*/
	if (tary_clen[i] == 4)
	{
		k = 2; /*starting position for 'vax4_or_othr'*/
		tot = 2; /*two characters worth of hexes*/
	}
	else if (tary_clen[i] == 8)
	{
		k = 0; /*start for all*/
		tot = 4; 
	}
	else
	{
		/*find binary int from character string*/
		sscanf(tary_pntrs[i],"%ld",
			&tary_ints[i]);
		if (tary_ints[i] == 0)
		{
			return;
		}
		/*error here */
		strcpy(rtcode,err_rtrn_code[HXO_INDX]);
		return;
	}
	for ( j = 0 ; j < tot ; j++)
	{
		strncpy(hexchars,&tary_pntrs[i][j*2],2);
		/*find hex  from character string*/
		sscanf(hexchars,"%X",
		       &hexint);
		iu.ch[vax4_or_othr[k]] = hexint;
		k++;
	 }
	tary_ints[i] = iu.li;
}
return;
}

static
d5chkhms(tarray,rtcode)

long	int	*tarray;
char	*rtcode;

{

/*check hours minutes seconds and milliseconds*/
if (HOUR < 0  || HOUR > 24)
{
	strcpy(rtcode,err_rtrn_code[HRO_INDX]);
	return;
}
if (MINUTE < 0  || MINUTE > 60)
{
	strcpy(rtcode,err_rtrn_code[MMO_INDX]);
	return;
}
if (SECOND < 0  || SECOND > 60)
{
	strcpy(rtcode,err_rtrn_code[SCO_INDX]);
	return;
}
if (MILLSEC < 0  || MILLSEC >= 1000)
{
	strcpy(rtcode,err_rtrn_code[MSO_INDX]);
	return;
}
return;
}

static
chk1stchr(rtcode)

char *rtcode;

{

int	i;

/*this is a character*/
if (!strncmp((char *)tary_pntrs[0],"SP",2))
{
	/*this is seconds past some epoch*/
	if (!strncmp(tary_pntrs[0],"SP50",4))
	{
		case_input = SP50_CASE;
	}
	else if (!strncmp(tary_pntrs[0],"SP2000",6))
	{
		case_input = SP2000_CASE;
	}
	else if (!strncmp(tary_pntrs[0],"SPEPOCH",7))
	{
		case_input = SPEPOCH_CASE;
	}
	else
	{
		strcpy(rtcode,err_rtrn_code[CHR_INDX]);
		return;
	}
}
else if (!strcmp(tary_pntrs[0],"HOY"))
{
	case_input = HOY1_CASE;
}
else
{
	for ( i = 0 ; i < 12 ; i++)
	{
		if (!strncmp(tary_pntrs[0],mnths[i],3))
		{
			month_from_chars = i+1;
			case_input = DATE_CASE;
			break;
		}
	}
	if (!case_input)
	{
		strcpy(rtcode,err_rtrn_code[CHR_INDX]);
		return;
	}
}
return;
}

static
chkyr1st(rtcode)

char	*rtcode;

{

int	i;


/*first is year check later*/
if (tary_type[1] == 'c')
{ 
	for ( i = 0 ; i < 12 ; i++)
	{
		if (!strncmp(tary_pntrs[1],mnths[i],3))
		{
			month_from_chars = i+1;
			case_input = DATE1_CASE;
			break;
		}
	}
	if (!case_input)
	{	
		strcpy(rtcode,err_rtrn_code[CHR_INDX]);
		return;
	}
}
else
{
	/*this is a month doy hoy */
	if (tary_type[2] == 'c')
	{
		/*should be 'YYyy hhhh HRS ssss FFF SECS'*/
		case_input = HOY2_CASE;
		if (dec_indx)
		{
			chs_indx = dec_indx + 1;
		}
		else
		{
			chs_indx = 4;
		}
		return;
	}
	if (tot_in_array == 3 || tot_in_array == 4)
	{
		case_input = HOY_CASE;
		return;
	}
	if (tary_clen[1] == 3)
	{
		/*YYyy DOY HH MM SS FFF or YYyy DOY HH MM SS 
		  (5 or 6 in array)
		  YYyy hhh ssss FFF or YYyy hhh ssss (3 or 4) */
		if (tot_in_array == 5  ||  tot_in_array == 6)
		{
			case_input = DOY_CASE; /*DOY*/
			return;
		}
		strcpy(rtcode,err_rtrn_code[WNC_INDX]);
		return;
	}
	case_input = MONTH_CASE; /*MONTH*/
}		
			
return;
}

static	void
d5ich2bcd(intin,bcd_out,nbcds)

long	int	intin;
char	*bcd_out;
int	nbcds;

{

int	i;
int	bcd_indx;
int	bcddec;
long	int	dec;

/*this for integers greater than or equal to one*/
/*convert byte_in to binary coded decimal out for nbcds of binary coded
  decimals*/
/*find total number of bytes for bcd_out (2 BCD / byte)*/
bcd_indx = nbcds/2 - 1;
if ((nbcds%2))
{
	bcd_indx++;
}  
dec = intin;

/*zero out ouput bytes*/
for (i = 0 ; i <= bcd_indx ; i++)
{
	bcd_out[i] = 0;
}

for ( i = 0 ; i < nbcds ; i ++)
{
	bcddec = dec%10;
	dec /= 10; /*get it down*/
	/*now this is the decimal of choice but where to place it?*/
	if (!(i%2))
	{
		/*this is an even i so it goes in the low ordr nble*/
		bcd_out[bcd_indx] = bcddec;
	}
	else
	{
		bcd_out[bcd_indx] += bcddec*16; /*shift to left by 4*/
		bcd_indx--; /*bring it down*/
	}
}
return;
}	
	                  

static void
d5dch2bcd(intin,bcd_out,nbcds)

long	int	intin;
char	*bcd_out;
int	nbcds;

{

int	i;
int	bcd_indx;
int	bcddec;
long	int	dec;
BOOL	uneven;

/*this for integers less than one*/
/*convert intin to binary coded decimal out for nbcds of binary coded
  decimals*/
/*find total number of bytes for bcd_out (2 BCD / byte)*/
uneven = FALSE;
bcd_indx = nbcds/2 - 1;
if ((nbcds%2))
{
	bcd_indx++;
	uneven = TRUE;
}  
dec = intin;

/*zero out ouput bytes*/
for (i = 0 ; i <= bcd_indx ; i++)
{
	bcd_out[i] = 0;
}

for ( i = 0 ; i < nbcds ; i ++)
{
	bcddec = dec%10;
	dec /= 10; /*get it down*/
	/*now this is the decimal of choice but where to place it?*/
	if (!(i%2))
	{
		/*this is an even */
		if (uneven)
		{
			bcd_out[bcd_indx] += bcddec*16; 
			/*shift to left by 4*/
			bcd_indx--; /*bring it down*/
		}
		else
		{
			bcd_out[bcd_indx] = bcddec;
		}
	}
	else
	{
		if (uneven)
		{
			bcd_out[bcd_indx] = bcddec;
		}
		else
		{
			bcd_out[bcd_indx] += bcddec*16; 
			/*shift to left by 4*/
			bcd_indx--; /*bring it down*/
		}
	}
}
return;
}	
	                  
static void
d5ichfbcd(bcd_in,sthalf,intout,nbcds)

char	*bcd_in;
int	sthalf; /* 0 or 1*/
long	int	*intout;
int	nbcds;

{

int	bcd_indx;
long	int	pwr10;
unsigned	long	int	bcddec;
int	i;

/*change from a bcd byte stream to integer*/
bcd_indx = 0;
intout[0] = 0; /*letus zero it*/
pwr10 = 1;
for ( i = 1 ; i < nbcds ; i ++)
{
	pwr10 *= 10;
}
for (i = sthalf; i < nbcds + sthalf ; i++)
{
	bcddec = bcd_in[bcd_indx];
	if (!(i%2))
	{
		/*this is even upper nibble*/
		bcddec /= 0x10;
		bcddec %= 0x10; 
		intout[0] += bcddec*pwr10;
		pwr10 /= 10;
	}
	else
	{
		/*this is odd lower nibble*/
		bcddec %= 0x10; 
		intout[0] += bcddec*pwr10;
		pwr10 /= 10;
		bcd_indx++;
	}
}
return;
}

int  
pars_func(indx_of_wrd,len_wrd,is_spcl_chars)

int  indx_of_wrd;   /*index in buffer*/
int  len_wrd;       /*length, in bytes, of 1st word.*/
BOOL is_spcl_chars; /*TRUE this is a special character
                      FALSE it is not*/
                        
{

char	*tpntr;
int	i;
int	j;
int	tot;
BOOL	digits;
int	rt;
BOOL	frac_here;

if (len_wrd < 0)
{
	return(1);
}
if (is_spcl_chars)
{
	switch (use_strng[indx_of_wrd])
	{
		case '.':
			next_wrd_frac = TRUE;
			dec_indx = tot_in_array;
		break;
		case '-':
			minus_found = TRUE;
		break;
		case 'x':
		case 'X':
			hex_strng = TRUE;
		break;
		default:
		break;
	}
	return(0);
}
tary_pntrs[tot_in_array] = &time_strng[indx_of_wrd];
time_strng[indx_of_wrd+len_wrd] = '\0';
tot = len_wrd;
digits = TRUE;
for ( i = 0 ; i < tot ; i++)
{
	tary_type[tot_in_array] = 'i';
	if (!isdigit(tary_pntrs[tot_in_array][i]))
	{
		/*this is not an ascii digit*/
		/*check for hex*/
		if (!hex_strng ||
		    !isxdigit(tary_pntrs[tot_in_array][i]))
		{
			tary_type[tot_in_array] = 'c';
			break;
		}
	}
}
tary_clen[tot_in_array] = tot; 
if (tary_type[tot_in_array] == 'i')
{
	if (next_wrd_frac)
	{
		next_wrd_frac = FALSE;
		/*this is fraction must make fthree digits*/
		/*tot is lenghth*/
		if (tot > 3)
		{
			tary_pntrs[tot_in_array][3] = '\0';
		}
		else if (tot < 3)
		{
			for ( j = tot ; j < 3 ; j++)
			{
				tary_pntrs[tot_in_array][i] = '0';
			}
			tary_pntrs[tot_in_array][3] = '\0';
		}
	}			
}
else
{
	/*change to upper case regardles*/
	for ( i = 0 ; i < tot ; i++)
	{
		if(isupper(tary_pntrs[tot_in_array][i]))
		{
			continue;
		}
		/*change to upper*/
		tary_pntrs[tot_in_array][i] = (char)toupper(
			tary_pntrs[tot_in_array][i]);
	}
}
tot_in_array++;
return(0);
}
