******************************************************************
*
*	TITLE:  INCLUDE MODULE FOR UNPACKING VOYAGER MAG (PLS) EDR
*
*	FILE NAME:  UNPACK.INC
*
*	PURPOSE:  TO MAINTAIN THE COMMON AREAS IN WHICH EDR DATA IS UNPACKED
*                INTO
*
*	HISTORY:
*
*	AUTHOR                        DATE                       CHANGE
*	------                        -----                      ------
*	S. J. KEMPLER                 8/12/85                    ORIGINAL CODE
*	S. B. KRAMER JR.             10/28/92                    NEW MODE CR-5A
*
*	IMPLEMENTATION:  INCLUDE UNPACK.INC
*
*	NOTES:
*
*	THIS INCLUDE CONTAINS THE THREE COMMON AREAS THAT DEFINE THE CONTENTS
*        OF: 1.) THE EDR HEADER, 2.) THE EDR SUBHEADER (PLS DATA) AND 3.) THE
*        SCIENCE DATA (MAG).
*
*	 COMMON	       VARIABLE        TYPE            DESCRIPTION
*        ------        --------        ----            -----------
*
*        HEADER			  REFER TO  VOYAGER EDR FORMAT
*			   	  SPECIFICATION, APPENDIX C FOR
*		        	  DETAILED DESCRIPTION OF
* 				  VARIABLES.
*
*		        PROJID		A*3	WORD 1, BITS 0-23
*			RECID		I*2	WORD 1, BITS 24-27
*			SCID		I*2	WORD 1, BITS 28-31
*			RECNUM		I*2	WORD 2, BITS 0-15
*			DATMOD		I*2	WORD 2, BITS 16-23
*			EEXTFL		I*2	WORD 2, BITS 24-25
*			SCPLAB		I*2	WORD 2, BIT  26
*			RECTIM		I*2	WORD 2, BITS 27-31
*			ERTSHR		I*2	WORD 3, BITS 0-15
*			ERTSSC		I*2	WORD 3, BITS 16-31
*			ERTSML		I*2	WORD 4, BITS 0-15
*			YEAR1		I*2	WORD 4, BITS 16-23
*			DATSRC		I*2	WORD 4, BITS 24-25
*			GOLAY		I*2	WORD 4, BITS 26-27
*			SEGNUM		I*2	WORD 4, BITS 28-31
*			ERTEHR		I*2	WORD 5, BITS 0-15
*			ERTESC		I*2	WORD 5, BITS 16-31
*			ERTEML		I*2	WORD 6, BITS 0-15
*			YEAR2		I*2	WORD 6, BITS 16-23
*			SWVERS		I*2	WORD 6, BITS 24-31
*			SCETHR		I*2	WORD 7, BITS 0-15
*			SCETSC		I*2	WORD 7, BITS 16-31
*			SCETML		I*2	WORD 8, BITS 0-15
*			YEAR3		I*2	WORD 8, BITS 16-23
*			SCEVFL		I*2	WORD 8, BITS 24-27
*			CORRFL		I*2	WORD 8, BITS 28-31
*			MOD216		I*2	WORD 9, BITS 0-15
*			MOD60		I*2	WORD 9, BITS 16-13
*			LINCNT		I*2	WORD 9, BITS 24-31, WORD 10, 
*								BITS 0-7
*			TELRAT		I*2	WORD 10, BITS 8-15
*			EFFRAT		I*2	WORD 10, BITS 16-23
*			FORMID		I*2	WORD 10, BITS 24-31
*			BERTOL		I*2	WORD 11, BITS 0-7
*			DSNCON		I*2	WORD 11, BITS 8-15
*			RECAGC		I*2	WORD 11, BITS 16-31
*			DSNNUM		I*2	WORD 12, BITS 0-7
*			EBEC		I*2	WORD 12, BITS 16-31
*			SYMSNR		I*2	WORD 13, BITS 0-15
*			DECSNR		I*2	WORD 13, BITS 16-31
*			PHYSRN		I*2	WORD 14, BITS 0-15
*
*			DQSW(10),	I*2	        DQSW           DQI
*			DQI(10)		                ----           ---
*						WORD 14, BITS 16-23, BITS 24-31
*						WORD 15, BITS 0-7,   BITS 8-15
*                                 		WORD 15, BITS 16-23, BITS 24-31
*						WORD 16, BITS 0-7,   BITS 8-15
*						WORD 16, BITS 16-23, BITS 24-31
*						WORD 17, BITS 0-7,   BITS 8-15
*						WORD 17, BITS 16-23, BITS 24-31
*						WORD 18, BITS 0-7,   BITS 8-15
*						WORD 18, BITS 16-23, BITS 24-31
*						WORD 19, BITS 0-7,   BITS 8-15
*
*			DPI (80),	I*2	         DPI   	       GCI
*			GCI (80)		         ---	       ---
*						WORD 19, BITS 16-23  BITS 24-31
*						WORD 20, BITS 0-7,   BITS 8-15
*						WORD 20, BITS 16-23, BITS 24-31
*						WORD 21, BITS 0-7,   BITS 8-15
*							*
*	
*							*
*
*							*
*						WORD 57, BITS 16-23, BITS 24-31
*						WORD 58, BITS 0-7,   BITS 8-15
*						WORD 58, BITS 16-23, BITS 24-31
*						WORD 59, BITS 0-7,   BITS 8-15
*
*			DPIRIS		I*2	WORD 59, BITS 16-23
*			GPIRIS		I*2	WORD 59, BITS 24-31
*			DRSDAT		I*2	WORD 60, BITS 0-7
*			GCBEC		I*2	WORD 60, BITS 8-15
*			GBITES		I*2	WORD 60, BITS 16-31
*
******************************************************************
C
      BYTE	FLIP(0:255)
	BYTE HEAD(240)
      INTEGER*2      PLS(3016),   MAG(9600),
     &          IBMODE(0:20), OBMODE(0:20), PRIME(0:20),  MPROC(0:20),
     &           EFLIP(0:20),  IBCAL(0:20), OBCAL(0:20),  POLAR(0:20),
     &          IBFLIP(0:20), OBFLIP(0:20),    SYS1(32),     SYS2(32)
C
      CHARACTER*3     PROJID
C
      INTEGER*2                RECID,    SCID,  RECNUM, DATMOD,
     H                EEXTFL, SCPLAB,  RECTIM,  ERTSHR, ERTSSC,
     H                ERTSML,  YEAR1,  DATSRC,   GOLAY, SEGNUM,
     H                ERTEHR, ERTESC,  ERTEML,   YEAR2, SWVERS,
     H                SCETHR, SCETSC,  SCETML,   YEAR3, SCEVFL,
     H                CORRFL, MOD216,   MOD60,  LINCNT, TELRAT,
     H                EFFRAT, FORMID,  BERTOL,  DSNCON, RECAGC,
     H                DSNNUM,   EBEC,  SYMSNR,  DECSNR, PHYSRN,
     H              DQSW(10),DQI(10),DPI(150),GCI(150), DPIRIS,
     H                GPIRIS, DRSDAT,   GCBEC,  GBITES, RECWRITE
C
      INTEGER*2    MCOMM(2), PCOMM(2),
     P             STAT1(20), STAT2(20),
     P             COMAND,  OBCOM,  IBCOM,
     P             L63, L64, LSTAT1, LSHORT(16,4),
     P             ESTAT1, ESHORT(16), LSTAT2, LLONG(16,4),
     P             ESTAT2, ELONG(16), MSTAT, M(192), LSTAT
C
      INTEGER*2    PDIFF(3,800),   PREF(3,160),   PREC(3,800),
     M             SDIFF(3,800),   SREF(3,160),   SREC(3,800),
     M             OBHFM(3,80),    IBHFM(3,80),
     M             IBOFF(1:3,0:9), OBOFF(1:3,0:9)
C
      INTEGER*4    RNGSET, MODSET, IBRNG(0:20), OBRNG(0:20)

C
      REAL*4       IBSENS(1:3,0:9), OBSENS(1:3,0:9),
     M             VSLIB(3,3), VSLOB(3,3), 
     M             VBLIB(3,3), VBLOB(3,3)
C
      REAL*4       SUMOUT(568),DETOUT(10000)
C
      DATA RECWRITE/0/
C
      COMMON /SYSTEM/   SYS1,   SYS2
C
      COMMON /HEADER/ PROJID,  RECID,   SCID, RECNUM, DATMOD,
     H                EEXTFL, SCPLAB, RECTIM, ERTSHR, ERTSSC,
     H                ERTSML,  YEAR1, DATSRC,  GOLAY, SEGNUM,
     H                ERTEHR, ERTESC, ERTEML,  YEAR2, SWVERS,
     H                SCETHR, SCETSC, SCETML,  YEAR3, SCEVFL,
     H                CORRFL, MOD216,  MOD60, LINCNT, TELRAT,
     H                EFFRAT, FORMID, BERTOL, DSNCON, RECAGC,
     H                DSNNUM,   EBEC, SYMSNR, DECSNR, PHYSRN,
     H                  DQSW,    DQI,    DPI,    GCI, DPIRIS,
     H                GPIRIS, DRSDAT,  GCBEC, GBITES, RECWRITE
C
      COMMON /PLSDAT/   PCOMM,  MCOMM,  STAT1,  STAT2,
     P                 STATIM,
     P                    L63,    L64, LSTAT1, LSHORT,
     P                 ESTAT1, ESHORT, LSTAT2,  LLONG,
     P                 ESTAT2,  ELONG,  MSTAT,      M,
     P                  LSTAT
C
      COMMON /MAGDAT/  VSLIB,   VSLOB,  VBLIB,  VBLOB,
     M                 PDIFF,    PREF,   PREC,  SDIFF,
     M                  SREF,    SREC,  OBHFM,  IBHFM,
     M                 IBOFF,   OBOFF, IBSENS, OBSENS,
     M                 IBRNG,   OBRNG, IBMODE, OBMODE,
     M                 PRIME,   MPROC, MODSET, RNGSET,
     M                 IBFLIP, OBFLIP
C
      COMMON /OUTPUT/  SUMOUT
C
      COMMON /ALLDAT/   HEAD,    PLS,    MAG,   FLIP
C
