static char const rcsid[] = "@(#)$Id: ted_vts.c,v 1.5 1996/01/18 19:08:29 ted Exp $";
/************************************************************************/
/*	Date		Author		Notes				*/
/*     3AUG94		T. Specht	Original Delivery		*/
/*    11-18-2020   Ray Bambery - removed debug printf statements */
/*									*/
/********** THESE ROUTINES MUST BE USED IN A MOTIF APPLICATION!! ********/
/************************************************************************/
/*  This routine displays an Error Dialog Widget when errors are	*/
/*  found in the TDS format time string.				*/
/************************************************************************/
/* void 	createTimeStringErrorDialog(Widget, char*);  		*/
/*		Widget	is the parent widget of the error dialog which  */
/*		is used to notify the operator of errors in the string. */
/*		char*	The Error Message to be displayed.		*/
/*									*/
/************************************************************************/
/*  This routine verifies certain fields in the TDS ERT time fields	*/
/*  (not to be used for SCLK time fields!).  the parameters		*/
/*  consist of a pointer to the time string.  The processing first	*/
/*  tests for a NOW and a FOREVER string which indicates a realtime	*/
/*  query.  The length is the checked to insure 21 characters have	*/
/*  been entered.  The each field is tested to insure they are within	*/
/*  the valid range.							*/
/************************************************************************/
/* int 		verifyTimeString(Widget,char*);				*/
/*		Widget	is the parent widget of the error dialog which  */
/*		is used to notify the operator of errors in the string. */
/*		char*	The TDS time string.				*/
/*		returns 0 if successful else -1				*/
/*									*/
/************************************************************************/
/*  This routine compares the TDS format start and end time string.	*/
/*  It is valid with ERT,RCT or SCET time only.(NOT SCLK)		*/
/************************************************************************/
/* int 		compareTimeStrings(char*,char*);			*/
/*		char*	TDS Start Time string.				*/
/*		char*	TDS Stop Time string.				*/
/*		returns 0 if start time less than stop time else -1	*/
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#define		LOWER	0
#define		HIGHER	1

enum	{STRING_YEAR,STRING_DOY,STRING_HOUR,
	STRING_MINUTE,STRING_SECOND,STRING_MS,MAX_FIELDS};

char	*string_labels[MAX_FIELDS] =
	 {"Year","Day Of Year","Hours","Minutes","Seconds","Millisecs"};

int	time_index[MAX_FIELDS]={0,5,9,12,15,18};

void 	createTimeStringErrorDialog(Widget, char*);
int 	verifyTimeString(Widget,char*);
int 	compareTimeStrings(char*,char*);

int verifyTimeString(parent_widget,time_pointer)
char	*time_pointer;
Widget	parent_widget;
{
int	temp_int,i;
int	time_limits[MAX_FIELDS][2]={1970,2200,1,366,0,23,0,59,0,59,0,999};
char	error_msg[50];
int	field_limit;
//printf ("ted_vts: parent_widget Entry\n");
if ((strcmp(time_pointer,"NOW") == 0) || (strcmp(time_pointer,"now") == 0))
   return(0);
if ((strcmp(time_pointer,"FOREVER") == 0) ||
    			(strcmp(time_pointer,"forever") == 0))
   return(0);
temp_int = strlen(time_pointer);
if (temp_int < 17 || temp_int > 21)
  {
   createTimeStringErrorDialog(parent_widget,
			"Time string has incorrect length");
   return(-1);
   }
if (temp_int > 18)
   /* millisecond field was entered */
   field_limit = MAX_FIELDS;
else/* else dont check for milliseconds */
   field_limit = MAX_FIELDS-1;
for (i=0;i<field_limit;i++)
    {
    temp_int = (int)strtol(time_pointer+time_index[i],(char**)NULL,10);
    if ((temp_int < time_limits[i][LOWER] || temp_int > time_limits[i][HIGHER])
	 || (temp_int == 0 && errno == EINVAL))
       {
       sprintf(error_msg,"Time string %s field is invalid",
						string_labels[i]);
       createTimeStringErrorDialog(parent_widget,error_msg);
       return(-1);
       }
    }
/* check for character - */
if (*(time_pointer+4) != '-')
   {
   createTimeStringErrorDialog(parent_widget,"Time string missing '-'");
   return(-1);
   }
/* check for character T */
if (*(time_pointer+8) != 'T')
   {
   createTimeStringErrorDialog(parent_widget,"Time string missing 'T'");
   return(-1);
   }
if (*(time_pointer+11) != ':')
   {
   createTimeStringErrorDialog(parent_widget,"Time string missing ':'");
   return(-1);
   }
if (*(time_pointer+14) != ':')
   {
   createTimeStringErrorDialog(parent_widget,"Time string missing ':'");
   return(-1);
   }
if (field_limit == MAX_FIELDS && *(time_pointer+17) != '.')
   {
   createTimeStringErrorDialog(parent_widget,"Time string missing '.'");
   return(-1);
   }
else
   {
   if ((field_limit != MAX_FIELDS) && (*(time_pointer+17) == '.'))
      *(time_pointer+17) = NULL;
   }
return(0);
}
void createTimeStringErrorDialog(parent_widget,error_msg)
/****************************************************************/
/* This function creates an error dialog                        */
/* The parameters are:                  			*/
/*     Widget   parent_widget  - The parent Widget ID           */
/*     char*    error_msg      - Description of the error       */
/****************************************************************/
Widget  parent_widget;
char*   error_msg;
{
Arg     	args[5];
Widget  	error_dialog;
int		i=0;
XmString       error_string;
error_string = XmStringCreateSimple(error_msg); i++;
XtSetArg(args[0], XmNmessageString, error_string); i++;
XtSetArg(args[1], XmNtitle, "TIME STRING ERROR"); i++;
XtSetArg(args[2], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL);
error_dialog = XmCreateErrorDialog(parent_widget,"error_dialog", args, i);
XtUnmanageChild(XmMessageBoxGetChild(error_dialog,XmDIALOG_CANCEL_BUTTON));
XtUnmanageChild(XmMessageBoxGetChild(error_dialog,XmDIALOG_HELP_BUTTON));
XtAddCallback(error_dialog,XmNokCallback,XtDestroyWidget,(char *)&error_dialog);
XtManageChild(error_dialog);
XmStringFree(error_string);
}
int compareTimeStrings(start_time,stop_time)
char*	start_time;
char*	stop_time;
{
int	string_offsets[4]={0,5,9,12};
int	i,temp_start,temp_stop;


if (((strcmp(start_time,"NOW") == 0) || (strcmp(start_time,"now") == 0)) &&
   ((strcmp(stop_time,"FOREVER")== 0)||(strcmp(stop_time,"forever")== 0)))
   return(0);
for (i=0;i<MAX_FIELDS;i++)
    {
    temp_start = (int)strtol(start_time+string_offsets[i],(char**)NULL,10);
    temp_stop = (int)strtol(stop_time+string_offsets[i],(char**)NULL,10);
    /*printf("temp_start = %d temp_stop = %d\n",temp_start,temp_stop);*/
    if (temp_stop > temp_start)
       return(0);/* start time is less than stop time */
    if (temp_start > temp_stop)
       return(-1);/* stop time is less than start time */
    /* if the times are equal compare the next field */
    }
return(0);
}  
