/*    @(#)$Id$      */
#ifdef _TED_INIT_
#define INIT(x) x
#define ALLOC
#else
#define INIT(x)
#define ALLOC extern
#endif

typedef	unsigned char	ubyte;

/* size of SFDU label in bytes */
#define LABEL_LENGTH			20
#define MAX_SFDU_LENGTH   	32768+LABEL_LENGTH
#define NJPL				"NJPL"
#define STAT_ERR			"STAT/ERR"
#define TDSQUERY			"TDSQUERY"
#define QUERYSPC			"QUERYSPC"
#define TDSQDATA			"TDSQDATA"
#define K_HEADER			"NJPL3KS0L009"
#define K_HEADER_LENGTH			12
#define END_OBJECT_LABEL		"END_OBJECT"
#define END_OBJECT_LENGTH		28
#define OBJECT_LABEL			"OBJECT"
#define OBJECT_LENGTH			24
#define STATUS				"Status Message"
#define TDS_STATUS			0
#define ERROR				"Error Message"
#define TDS_ERROR			1
ALLOC   char*    MESSAGE_TYPE_LABEL INIT(= {"MESSAGE_TYPE"});
#define MESSAGE_TYPE_LENGTH		12
ALLOC	char*   MESSAGE_NUM_LABEL INIT(= {"MESSAGE_NUM"});
#define MESSAGE_NUM_LENGTH		11
ALLOC	char*   MESSAGE_LABEL	INIT(= {"MESSAGE "});
#define MESSAGE_LENGTH			7

/* SFDU length in label can be ascii or binary, this field */
/* contains the value that determines the length type      */
#define SFDU_LENGTH_TYPE_OFFSET 	4
/* ASCII length type value */
#define ASCII_LENGTH_TYPE		'1'
/* offset to start of ASCII length field */
#define ASCII_LENGTH_OFFSET		12
/* Binary length type value */
#define BINARY_LENGTH_TYPE		'2'
/* offset to start of Binary length field */
#define BINARY_LENGTH_OFFSET		9
/* Variable length type value */
#define VARIABLE_LENGTH_TYPE		'3'

/*******************************************************/
/*** PVL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   PVL_LABEL INIT(= {"CCSD3ZS00001QUERYSPC"});
ALLOC	char*   PVL_TRAILER INIT(= {"CCSD3RE00000QUERYSPC"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   SFDU_LABEL INIT(= {"NJPL3IS0L009TDSQUERY"});
ALLOC	char*   SFDU_TRAILER INIT(= {"CCSD3RE00000TDSQUERY"});

/******************************/
/*** TDS END OF DATA LABEL  ***/
/******************************/
ALLOC	char*   SFDU_EOD_LABEL INIT(= {"CCSD3RE00000TDSQDATA"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER INDICATING A TDS MESSAGE ***/
/*******************************************************/
ALLOC	char*   TDS_MESSAGE_LABEL INIT(= {"NJPL3KS0L009STAT/ERR"});
ALLOC	char*   TDS_MESSAGE_TRAILER INIT(= {"CCSD3RE00000STAT/ERR"});

/*******************************************************/
/*** NJPL LABEL SIGNIFYING QUERY ECHO FROM TDS       ***/
/*******************************************************/
ALLOC	char*   QUERY_ECHO_LABEL INIT(= {"CCSD3ZS00001TDSQDATA"});

/*******************************************************/
/* PVL parameters used to build TDS query              */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
enum    {PVL_OBJECT,
	 PVL_DESCRIPTION,
	 PVL_NAME,
	 PVL_MISSION,
	 PVL_SC_NAME,
	 PVL_TIME_TYPE,
	 PVL_START_TIME,
	 PVL_STOP_TIME,
	 PVL_TIME_ORDER,
	 PVL_DSS_ID,
	 PVL_SOURCE,
	 PVL_LOADER,
	 PVL_PROTOCOL,
	 PVL_GROUP,
	 MAX_PVL_FIELDS};
ALLOC int pvl_indicators[MAX_PVL_FIELDS];
ALLOC char 	object[35];
ALLOC char* 	DESCRIPTION_LABEL INIT(= {"DESCRIPTION = \""});
ALLOC char* 	EO_LABEL INIT(= {"END_OBJECT = "});
ALLOC char* 	O_LABEL INIT(= {"OBJECT = "});
ALLOC char* 	MISSION_LABEL INIT(= {"MISSION_NAME = "});
ALLOC char*	NAME_LABEL INIT(= {"REQUESTER_NAME = "});
ALLOC char	mission[25];
ALLOC char	sc_name[30];
/* TIME TYPE CONSTANTS */
enum	{ERT,
	 SCLK,
	 RCT,
	 SCET,
	 MAX_TIME_TYPES};

ALLOC int	time_type_index;
ALLOC char*   TIME_TYPE_LABEL INIT(= {"TIME_TYPE = "});
static char	*time_type_names[MAX_TIME_TYPES] 
				= {"ERT","SCLK","RCT","SCET"};

ALLOC char*   START_TIME_LABEL INIT(= {"START_TIME = "});
ALLOC char*   STOP_TIME_LABEL INIT(= {"STOP_TIME = "});
/* the only time order parameters are ERT or SCLK */
#define MAX_ORDER_TYPES         2
ALLOC int       time_order_index;
ALLOC char*   TIME_ORDER_LABEL INIT(= {"TIME_ORDER = "});

enum		{NERT,RT,MAX_SOURCE_TYPES};
ALLOC char*   DATA_SOURCE_LABEL INIT(= {"SFOC_DATA_SOURCE = "});
static char*  tds_data_source_names[MAX_SOURCE_TYPES] = {"NERT","RT"};
ALLOC int     tds_data_source[MAX_SOURCE_TYPES];

ALLOC char*   DSS_ID_LABEL INIT(= {"DSS_ID = ALL;"});

/* group indicies */
enum	{FRAME_GROUP,CHANNEL_GROUP,MAX_GROUPS};
ALLOC int	group_index;
ALLOC char*   GROUP_LABEL INIT(= {"GROUP = "});
static char	*group_names[MAX_GROUPS]={"FRAME","CHANNEL"};
ALLOC char*   END_GROUP_LABEL INIT(= {"END_GROUP = "});

ALLOC char	end_object[40];

/*******************************************************/
/* parameters used by frame or packet group query      */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
/* Packet/Frame Group Offsets */
enum	{PFG_DATA_TYPE,
	 PFG_BUS_CODE,
	 PFG_ADDRESS_RANGE,
	 PFG_QQC_MSG_TYPE,
	 PFG_TLM_MODE,
	 PFG_WSE_FILTER,
	 PFG_SAMPLE_MODE,
	 PFG_CH_QQC_MSG_TYPE,/* added 6/13/94 */
	 MAX_PFG_FIELDS};
/* Packet/Frame Group Flags */
ALLOC short	pfg_indicators[MAX_PFG_FIELDS];
/* DATA TYPES */
enum	{ENG_DATA,
	 CHENG_DATA,
	 SCI_DATA,
	 CHSCI_DATA,
	 MON_DATA,
	 CHMON_DATA,
	 QQC_DATA,
	 CHQQC_DATA,
	 IMG_DATA,
	 TP_DATA,
	 CHCCS_DATA,
	 MRO_DATA,
	 MAX_DATA_TYPES};
ALLOC short	data_types[MAX_DATA_TYPES];
ALLOC char*   DT_NAME_LABEL INIT(= {"DATA_TYPE = "});
static char	*data_type_names[MAX_DATA_TYPES]
		 = {"ENG","CHENG","SCI","CHSCI","MON","CHMON",
				"QQC","CHQQC","IMG","TP","CHCCS","MRO"};
ALLOC char*   BUS_CODE_LABEL INIT(= {"BUS_CODE = "});
ALLOC char*   ADDRESS_RANGE_LABEL INIT(= {"ADDRESS_RANGE = "});
ALLOC char*   QQC_MSG_TYPE_LABEL INIT(= {"QQC_MSG_TYPE = "});

enum	{ALL_QQC_MSGS,
	HBEAT_IN_SYNC,
	HBEAT_OUT_SYNC,
	HBEAT_NO_DATA,
	TDM_FAIL_ACQ,
	IN_SYNC,
	OUT_SYNC,
	QQC_NO_DATA,
	SCLK_CHANGE,
	FID_CHANGE,
	DECOM,
	EXTR_BEGIN,
	EXTR_END,
	QQC_SUMMARY,
	QQC_DATA_SUMMARY,
	MAX_QQC_TYPES};
static char*  qqc_msg_types[] ={"ALL QQC MSGS","HBEAT IN SYNC","HBEAT OUT SYNC",\
				"HBEAT NO DATA", "TDM FAIL ACQ",\
				"IN SYNC","OUT_SYNC","NO DATA","SCLK CHANGE",\
				"FID CHANGE","DECOM","EXTR BEGIN","EXTR END",\
				"QQC_SUMMARY","QQC_DATA SUMMARY"};
static char*	tds_qqc[] =    {"qqc_hbeat_in_sync", "qqc_hbeat_out_sync",\
                                "qqc_hbeat_no_data", "qqc_tdm_fail_acq",\
                                "qqc_in_sync", "qqc_out_sync", "qqc_no_data",\
                                "qqc_sclk_change","qqc_fid_change","qqc_decom",\
                                "qqc_extr_begin", "qqc_extr_end", "qqc_summary",\
                                "qqc_data_summary"};
ALLOC int	qqc_msg_used[MAX_QQC_TYPES];
static char*  	tds_ch_qqc[] = {"ch_qqc_hbeat_in_sync","ch_qqc_hbeat_out_sync",\
                                "ch_qqc_hbeat_no_data","ch_qqc_tdm_fail_acq",\
                                "ch_qqc_in_sync", "ch_qqc_out_sync",\
                                "ch_qqc_no_data", "ch_qqc_sclk_change",\
                                "ch_qqc_fid_change", "ch_qqc_decom",\
                                "ch_qqc_extr_begin", "ch_qqc_extr_end",\
                                "ch_qqc_summary", "ch_qqc_data_summary"};
ALLOC int	ch_qqc_msg_used[MAX_QQC_TYPES];
/* Telemetry Mode Offsets */
enum	{MERGED_MODE,
	 REALTIME_MODE,
	 PLAYBACK_MODE,
	 MAX_TLM_MODES};
ALLOC int			tlm_mode_index;
ALLOC char*   TELEMETRY_MODE_LABEL INIT(= {"TELEMETRY_MODE = "});
static char	*tlm_mode_names[MAX_TLM_MODES] 
			= {"MERGED","REALTIME","PLAYBACK"};
ALLOC char*   WSE_FILTER_LABEL INIT(= {"WSE_FILTER = "});
/*******************************************************/
/* parameters used by channel group query 	       */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
/* Channel Group Offsets */
enum	{CG_CHANNEL_SET,
	 CG_SAMPLE_MODE,
	 CG_COMPRESS_HEADER,
	 CG_DELTA_TIME,
	 CG_FREQUENCY,
	 MAX_CG_FIELDS};
ALLOC   short			cg_indicators[MAX_CG_FIELDS];
ALLOC char*   CHANNEL_SET_LABEL INIT(= {"CHANNEL_SET = "});
/* sample mode indicies */
enum	{SAMPLE_ON_SAMPLE,
	 SAMPLE_ON_CHANGE,
	 SAMPLE_CHANGE_ONLY,
	 SAMPLE_DELTA_TIME,
	 SAMPLE_FREQUENCY,
	 MAX_SAMPLE_MODES};
ALLOC char*   SAMPLE_MODE_LABEL INIT(= {"SAMPLE_MODE = "});
ALLOC int       		sample_mode_index;
static char	*sample_mode_names[MAX_SAMPLE_MODES] =
			{"ON_SAMPLE","ON_CHANGE","CHANGES_ONLY",
				"DELTA_TIME","FREQUENCY"};
ALLOC char 			compress_headers[5];
ALLOC char*   TIME_DELTA_LABEL INIT(= {"TIME_DELTA = "});
ALLOC char*   FREQUENCY_LABEL INIT(= {"FREQUENCY = "});

#define COMMA                   ","
#define SEMI_COLON              ";"
#define OPEN_BRACE              "{"
#define CLOSE_BRACE             "}"
#define NEW_LINE		0x0a
ALLOC char	new_line;

/* TDS Query Buffer */
#define MAX_TDS_QUERY_LENGTH	800
ALLOC char 			tds_query_buffer[MAX_TDS_QUERY_LENGTH];
ALLOC int  			tds_query_length;
ALLOC int  			tds_query_sent;
ALLOC int  			tds_query_ready;

/* pointer to SFDU received from TDS */
ALLOC char			*sfdu_pointer;

/* buffer for data received from TDS */
union data_rcvd{
		ubyte		byte_buffer[MAX_SFDU_LENGTH];
		unsigned short	short_buffer[MAX_SFDU_LENGTH/2];
	      };
ALLOC union data_rcvd 		input_data;

ALLOC int 			record_count;
