#ifdef _TED_INIT_
#define INIT(x) x
#define ALLOC
#else
#define INIT(x)
#define ALLOC extern
#endif

typedef	unsigned char	ubyte;

/* size of SFDU label in bytes */
#define LABEL_LENGTH			20
#define PRIMARY_SIZE			4
#define CHDO_SIZE			4
#define PRIMARY_HDR_DATA_OFFSET	LABEL_LENGTH+(2*CHDO_SIZE)
/* offset to start of secondary hdr */
#define SECONDARY_HDR_OFFSET	LABEL_LENGTH+PRIMARY_SIZE+(2*CHDO_SIZE)
/*  size of Phase 1 secondary hdr */
#define P1_SECONDARY_HDR_SIZE		80 + CHDO_SIZE	
/* size of Phase 1 tertiary hdr */
#define P1_TERTIARY_HDR_SIZE		30 + CHDO_SIZE
/*  offset to start of Phase 1 tertiary hdr */
#define P1_TERTIARY_HDR_OFFSET	SECONDARY_HDR_OFFSET + P1_SECONDARY_HDR_SIZE	
/* offset to start of Phase 2 quaternary hdr */
#define P1_QUATERNARY_HDR_OFFSET P1_TERTIARY_HDR_OFFSET+P1_TERTIARY_HDR_SIZE
/*  size of Phase 2 secondary hdr */
#define P2_SECONDARY_HDR_SIZE		56 + CHDO_SIZE
/* size of Phase 2 tertiary hdr */
#define P2_TERTIARY_HDR_SIZE		42 + CHDO_SIZE
/*  offset to start of Phase 2 tertiary hdr */
#define P2_TERTIARY_HDR_OFFSET	SECONDARY_HDR_OFFSET + P2_SECONDARY_HDR_SIZE	
/* offset to start of Phase 2 quaternary hdr */
#define P2_QUATERNARY_HDR_OFFSET P2_TERTIARY_HDR_OFFSET+P2_TERTIARY_HDR_SIZE
/* size of Channelized Data Quaternary hdr */
#define CHANNELIZED_QUATERNARY_HDR_SIZE		6 + CHDO_SIZE
/* size of Phase 1 ENG Quaternary hdr */
#define P1_ENG_QUATERNARY_HDR_SIZE		18 + CHDO_SIZE
/* size of Phase 2 PKT ENG Quaternary hdr */
#define P2_ENG_QUATERNARY_HDR_SIZE		2 + CHDO_SIZE
/* phase 1 ENG Quaternary CHDO type */
#define P1_ENG_QUATERNARY_CHDO			41
/* phase 2 PKT ENG Quaternary CHDO type */
#define P2_ENG_QUATERNARY_CHDO			42
/* Channelized Data Quaternary CHDO type */
#define CHANNELIZED_QUATERNARY_CHDO		27
/* Channelized Data CHDO type */
#define CHANNELIZED_DATA_CHDO			28
/* Galileo SC ID offset in 2nd hdr = PRIMARY_HDR_DATA_OFFSET+10 bytes */
#define SC_ID_OFFSET                    SECONDARY_HDR_OFFSET+CHDO_SIZE+2
#define MAX_SFDU_LENGTH   		32768+LABEL_LENGTH
#define NJPL				"NJPL"
#define AUTHORITY_ID			"NJPL2I00"
#define STAT_ERR			"STAT/ERR"
#define TDSQUERY			"TDSQUERY"
#define QUERYSPC			"QUERYSPC"
#define TDSQDATA			"TDSQDATA"
#define K_HEADER			"NJPL3KS0L009"
#define K_HEADER_LENGTH			12
#define END_OBJECT_LABEL		"END_OBJECT"
#define END_OBJECT_LENGTH		28
#define OBJECT_LABEL			"OBJECT"
#define OBJECT_LENGTH			24
#define STATUS				"Status Message"
#define TDS_STATUS			0
#define ERROR				"Error Message"
#define TDS_ERROR			1
ALLOC   char*    MESSAGE_TYPE_LABEL INIT(= {"MESSAGE_TYPE"});
#define MESSAGE_TYPE_LENGTH		12
ALLOC	char*   MESSAGE_NUM_LABEL INIT(= {"MESSAGE_NUM"});
#define MESSAGE_NUM_LENGTH		11
ALLOC	char*   MESSAGE_LABEL	INIT(= {"MESSAGE "});
#define MESSAGE_LENGTH			7

/* SFDU length in label can be ascii or binary, this field */
/* contains the value that determines the length type      */
#define SFDU_LENGTH_TYPE_OFFSET 	4
/* ASCII length type value */
#define ASCII_LENGTH_TYPE		'1'
/* offset to start of ASCII length field */
#define ASCII_LENGTH_OFFSET		12
/* Binary length type value */
#define BINARY_LENGTH_TYPE		'2'
/* offset to start of Binary length field */
#define BINARY_LENGTH_OFFSET		9
/* Variable length type value */
#define VARIABLE_LENGTH_TYPE		'3'

#define HOURS_PER_DAY		24
#define SECONDS_PER_HOUR	3600
#define SECONDS_PER_MINUTE	60
#define SECONDS_PER_DAY		SECONDS_PER_HOUR*HOURS_PER_DAY
#define MILLISECONDS_PER_DAY	SECONDS_PER_DAY*1000

struct mission_time_struct
   {
   unsigned short days;
   long milliseconds;
   };

struct mission_sclk
   {
   unsigned int rim;
   unsigned char  mod91;
   unsigned char  mod10;
   unsigned char  mod8;
   };
/*******************************************************/
/*** PVL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   PVL_LABEL INIT(= {"CCSD3ZS00001QUERYSPC"});
ALLOC	char*   PVL_TRAILER INIT(= {"CCSD3RE00000QUERYSPC"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER USED TO FRAME QUERY      ***/
/*******************************************************/
ALLOC	char*   SFDU_LABEL INIT(= {"NJPL3IS0L009TDSQUERY"});
ALLOC	char*   SFDU_TRAILER INIT(= {"CCSD3RE00000TDSQUERY"});

/******************************/
/*** TDS END OF DATA LABEL  ***/
/******************************/
ALLOC	char*   SFDU_EOD_LABEL INIT(= {"CCSD3RE00000TDSQDATA"});

/*******************************************************/
/*** NJPL LABEL AND TRAILER INDICATING A TDS MESSAGE ***/
/*******************************************************/
ALLOC	char*   TDS_MESSAGE_LABEL INIT(= {"NJPL3KS0L009STAT/ERR"});
ALLOC	char*   TDS_MESSAGE_TRAILER INIT(= {"CCSD3RE00000STAT/ERR"});

/*******************************************************/
/*** NJPL LABEL SIGNIFYING QUERY ECHO FROM TDS       ***/
/*******************************************************/
ALLOC	char*   QUERY_ECHO_LABEL INIT(= {"CCSD3ZS00001TDSQDATA"});

/*******************************************************/
/* PVL parameters used to build TDS query              */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
enum    {PVL_OBJECT,
	 PVL_DESCRIPTION,
	 PVL_NAME,
	 PVL_MISSION,
	 PVL_SC_NAME,
	 PVL_TIME_TYPE,
	 PVL_START_TIME,
	 PVL_STOP_TIME,
	 PVL_TIME_ORDER,
	 PVL_DSS_ID,
	 PVL_SOURCE,
	 PVL_LOADER,
	 PVL_PROTOCOL,
	 PVL_GROUP,
	 MAX_PVL_FIELDS};
ALLOC int pvl_indicators[MAX_PVL_FIELDS];
ALLOC char 	object[35];
ALLOC char* DESCRIPTION_LABEL INIT(={"DESCRIPTION = \"GLL_PROJECT_SERVER\""});
ALLOC char* 	EO_LABEL INIT(= {"END_OBJECT = GLL_DATA_RECORDS"});
ALLOC char* 	O_LABEL INIT(= {"OBJECT = GLL_DATA_RECORDS"});
ALLOC char* 	MISSION_LABEL INIT(= {"MISSION_NAME = "});
ALLOC char*	NAME_LABEL INIT(= {"REQUESTER_NAME = "});
ALLOC char*	SC_LABEL INIT(= {"SPACECRAFT_NAME = "});
ALLOC char	mission[25];
ALLOC char	sc_name[30];
/***********************************************************/
/* store the spacecraft ID for possible verification       */
/* of SFDUs from TDS(This is mostly to prevent GLL         */
/* Testbed data from getting confused with spacecraft data */
/***********************************************************/
ALLOC int	sc_num;
ALLOC int	sc_id_test_enabled INIT(=FALSE);

/* TIME TYPE CONSTANTS */
enum	{ERT,
	 SCLK,
	 RCT,
	 SCET,
	 MAX_TIME_TYPES};

ALLOC int	time_type_index;
ALLOC char*   TIME_TYPE_LABEL INIT(= {"TIME_TYPE = "});
static char	*time_type_names[MAX_TIME_TYPES] 
				= {"ERT","SCLK","RCT","SCET"};

ALLOC char*   START_TIME_LABEL INIT(= {"START_TIME = "});
ALLOC char*   STOP_TIME_LABEL INIT(= {"STOP_TIME = "});
/* the only time order parameters are ERT or SCLK */
#define MAX_ORDER_TYPES         2
ALLOC int       time_order_index;
ALLOC char*   TIME_ORDER_LABEL INIT(= {"TIME_ORDER = "});

enum		{NERT,RT,MAX_SOURCE_TYPES};
ALLOC char*   DATA_SOURCE_LABEL INIT(= {"SFOC_DATA_SOURCE = {"});
static char*  tds_data_source_names[MAX_SOURCE_TYPES] = {"NERT","RT"};
ALLOC int     tds_data_source[MAX_SOURCE_TYPES];

ALLOC char*   DSS_ID_LABEL INIT(= {"DSS_ID = ALL;"});

/* group indicies */
enum	{FRAME_GROUP,CHANNEL_GROUP,MAX_GROUPS};
ALLOC int	group_index;
ALLOC char*   GROUP_LABEL INIT(= {"GROUP = "});
static char	*group_names[MAX_GROUPS]={"FRAME","CHANNEL"};
ALLOC char*   END_GROUP_LABEL INIT(= {"END_GROUP = "});

ALLOC char	end_object[40];

/*******************************************************/
/* parameters used by frame or packet group query      */
/*******************************************************/
/* Packet/Frame Group Offsets */
/* FOR BEST RESULTS DO NOT REORDER THIS LIST */
enum    {ENG_DATA,  
	 CHENG_DATA,
	 LRS_DATA,
	 CLRS_DATA,
	 CHLRS_DATA,
	 CHDRS_DATA,
	 LPR_DATA,
	 CPRB_DATA,
	 IMG_DATA,
	 QQC_DATA,
	 CHQQC_DATA,
	 MON_DATA,
	 CHMON_DATA,
    	 PKT_ENG_DATA,
	 PKT_CHENG_DATA,
	 PKT_SCI_DATA,		/* all science data */
         DDS_DATA,              /* First SCI type */
	 EDP_DATA,              /*  .   */
	 EUV_DATA,              /*  .   */
	 HIC_DATA,              /*  .   */
	 MAG_DATA,              /*  .   */
	 NIMS_DATA,             /*  .   */
         OPN_DATA,              /*  .   */
	 PLS_DATA,              /*  .   */
	 PPR_DATA,              /*  .   */
	 PWH_DATA,              /*  .   */
	 PWL_DATA,              /*  .   */
	 SSI_DATA,              /*  .   */
	 UVS_DATA,              /* Last SCI type */
	 VCDU_DATA,
	 FCD_DATA,      
	 MISC_DATA,  /*<--- THIS IS THE LAST DATA TYPE */
	 TLM_MODE,
	 MAX_PFG_FIELDS};

/* ALL SCIENCE TYPES MUST BE KEPT TOGETHER        */
/* TO ACHIEVE THE CORRECT VALUE FOR NUM_SCI_TYPES */
#define NUM_SCI_TYPES UVS_DATA - PKT_SCI_DATA
/* Packet/Frame Group Flags */
ALLOC short	pfg_indicators[MAX_PFG_FIELDS];

/*********************************************************************/
/* LAST DATA TYPE MUST BE USED TO DETERMINE THE MAX_DATA_TYPES VALUE */
/*********************************************************************/
#define MAX_DATA_TYPES		MISC_DATA+1
ALLOC short	data_types[MAX_DATA_TYPES];
ALLOC char*   DT_NAME_LABEL INIT(= {"DATA_TYPE = "});
static char	*data_type_names[MAX_DATA_TYPES]
		 = {"ENG","CHENG","LRS","CLRS","CHLRS","CHDRS","LPR","CPRB",
                    "IMG","QQC","CHQQC","MON","CHMON","PENG",
                    "CPENG","PKSCI","DDS","EPD","EUV","HIC","MAG","NIMS",
                    "OPN","PLS","PPR","PWH","PWL","SSI","UVS","VCDU","FCD",
                    "MISC"};
ALLOC char*   BUS_CODE_LABEL INIT(= {"BUS_CODE = "});
ALLOC char*   ADDRESS_RANGE_LABEL INIT(= {"ADDRESS_RANGE = "});

/*****************************************************************/
/* All data types are separated into 2 catagories.  The enum     */
/* variables that end in MAX_*_TYPES(where * is a wildcard) are  */
/* TDS specific.  They are used in PVL queries to TDS.           */
/* The enum variables that end in MAX_*_SFDUS(where * is a wild- */
/* card) are created by TIS and defined in SFOC-5-SYS-*DU-NJPL   */
/*****************************************************************/

enum	{ALL_QQC_MSGS,
	HBEAT_IN_SYNC,
	HBEAT_OUT_SYNC,
	HBEAT_NO_DATA,
	TDM_FAIL_ACQ,
	IN_SYNC,
	OUT_SYNC,
	QQC_NO_DATA,
	SCLK_CHANGE,
	FID_CHANGE,
	DECOM,
	EXTR_BEGIN,
	EXTR_END,
	QQC_SUMMARY,
	QQC_DATA_SUMMARY,
	QQC_P2_SUMMARY,
	MAX_QQC_TYPES};
static char*	qqc_types[MAX_QQC_TYPES] =
				{"qqc","qqc_hbeat_in_sync",
				"qqc_hbeat_out_sync",
                                "qqc_hbeat_no_data", "qqc_tdm_fail_acq",
                                "qqc_in_sync", "qqc_out_sync", "qqc_no_data",
                                "qqc_sclk_change","qqc_fid_change",
				"qqc_decom",
                                "qqc_extr_begin","qqc_extr_end","qqc_summary",
                                "qqc_data_summary","qqc_ph2_data_summary"};

enum	{QQC_HBEAT_IN_SYNC_SFDU,
	QQC_HBEAT_OUT_SYNC_SFDU,
	QQC_HBEAT_NO_DATA_SFDU,
	QQC_TDM_FAIL_SFDU,
	QQC_IN_SYNC_SFDU,
	QQC_OUT_SYNC_SFDU,
	QQC_NO_DATA_SFDU,
	QQC_SCLK_CHANGE_SFDU,
	QQC_FID_CHANGE_SFDU,
	QQC_DECOM_SFDU,
	QQC_EXTR_BEGIN_SFDU,
	QQC_EXTR_END_SFDU,
	QQC_SUMMARY_SFDU,
	QQC_DATA_SUMMARY_SFDU,
	QQC_P2_SUMMARY_SFDU,
	MAX_QQC_SFDUS};


static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into qqc_types */
	char*		ddp_id;
	} qqc_sfdus[MAX_QQC_SFDUS] = {
	{13,0,1,21,0,1,"C561"},
	{13,0,1,22,0,2,"C562"},
	{13,0,1,23,0,3,"C563"},
	{13,0,1,24,0,4,"C564"},
	{13,0,1,25,0,5,"C565"},
	{13,0,1,26,0,6,"C566"},
	{13,0,1,27,0,7,"C418"},
	{13,0,1,28,0,8,"C419"},
	{13,0,1,29,0,9,"C568"},
	{13,0,1,30,0,10,"C569"},
	{13,0,1,31,0,11,"C422"},
	{13,0,1,32,0,12,"C423"},
	{13,0,1,33,0,13,"C570"},
	{13,0,1,34,0,14,"C571"},
	{13,0,1,35,0,15,"C594"}};



ALLOC int	qqc_selected[MAX_QQC_TYPES];

enum	{ALL_CHQQC_MSGS,
	CH_HBEAT_IN_SYNC,
	CH_HBEAT_OUT_SYNC,
	CH_HBEAT_NO_DATA,
	CH_TDM_FAIL_ACQ,
	CH_IN_SYNC,
	CH_OUT_SYNC,
	CH_QQC_NO_DATA,
	CH_SCLK_CHANGE,
	CH_FID_CHANGE,
	CH_DECOM,
	CH_EXTR_BEGIN,
	CH_EXTR_END,
	CH_QQC_SUMMARY,
	CH_QQC_DATA_SUMMARY,
	MAX_CHQQC_TYPES};
static char*  	ch_qqc_types[MAX_CHQQC_TYPES] =
				{"chqqc","ch_qqc_hbeat_in_sync",\
				"ch_qqc_hbeat_out_sync",\
                                "ch_qqc_hbeat_no_data","ch_qqc_tdm_fail_acq",\
                                "ch_qqc_in_sync", "ch_qqc_out_sync",\
                                "ch_qqc_no_data", "ch_qqc_sclk_change",\
                                "ch_qqc_fid_change", "ch_qqc_decom",\
                                "ch_qqc_extr_begin", "ch_qqc_extr_end",\
                                "ch_qqc_summary", "ch_qqc_data_summary"};
ALLOC int	ch_qqc_selected[MAX_CHQQC_TYPES];

enum	{CHQQC_HBEAT_IN_SYNC_SFDU,CHQQC_HBEAT_OUT_SYNC_SFDU,
	 CHQQC_HBEAT_NO_DATA_SFDU,
	 CHQQC_TDM_FAIL_SFDU,CHQQC_IN_SYNC_SFDU,CHQQC_OUT_SYNC_SFDU,
	 CHQQC_NO_DATA_SFDU,CHQQC_SCLK_CHANGE_SFDU,CHQQC_FID_CHANGE_SFDU,
	 CHQQC_DECOM_SFDU,CHQQC_EXTR_BEGIN_SFDU,CHQQC_EXTR_END_SFDU,
	 CHQQC_SUMMARY_SFDU,CHQQC_DATA_SUMMARY_SFDU,CHQQC_P2_SUMMARY,
	 MAX_CHQQC_SFDUS};


static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into ch_qqc_types */
	char*		ddp_id;
	} chqqc_sfdus[MAX_CHQQC_SFDUS] = {
	{11,3,1,21,0,1,"C572"},
	{11,3,1,22,0,2,"C573"},
	{11,3,1,23,0,3,"C574"},
	{11,3,1,24,0,4,"C575"},
	{11,3,1,25,0,5,"C576"},
	{11,3,1,26,0,6,"C577"},
	{11,3,1,27,0,7,"C438"},
	{11,3,1,28,0,8,"C439"},
	{11,3,1,29,0,9,"C579"},
	{11,3,1,30,0,10,"C580"},
	{11,3,1,31,0,11,"C442"},
	{11,3,1,32,0,12,"C443"},
	{11,3,1,33,0,13,"C581"},
	{11,3,1,34,0,14,"C582"},
	{11,3,1,35,0,15,"C595"}};

/* Telemetry Mode Offsets */
enum	{MERGED_MODE,
	 REALTIME_MODE,
	 PLAYBACK_MODE,
	 MAX_TLM_MODES};
ALLOC int			tlm_mode_index;
ALLOC char*   TELEMETRY_MODE_LABEL INIT(= {"TELEMETRY_MODE = "});
static char	*tlm_mode_names[MAX_TLM_MODES] 
			= {"MERGED","REALTIME","PLAYBACK"};
ALLOC char*   WSE_FILTER_LABEL INIT(= {"WSE_FILTER = "});
/*******************************************************/
/* parameters used by channel group query 	       */
/*******************************************************/
/* If ANY of these character array  sizes are modified */
/* the corresponding TextWidget Column parameter has   */
/* to be adjusted also!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*******************************************************/
/* Channel Group Offsets */
enum	{CG_CHANNEL_SET,
	 CG_SAMPLE_MODE,
	 CG_COMPRESS_HEADER,
	 CG_DELTA_TIME,
	 CG_FREQUENCY,
	 MAX_CG_FIELDS};
ALLOC   short			cg_indicators[MAX_CG_FIELDS];
ALLOC char*   CHANNEL_SET_LABEL INIT(= {"CHANNEL_SET = "});
/* sample mode indicies */
enum	{SAMPLE_ON_SAMPLE,
	 SAMPLE_ON_CHANGE,
	 SAMPLE_CHANGE_ONLY,
	 SAMPLE_DELTA_TIME,
	 SAMPLE_FREQUENCY,
	 MAX_SAMPLE_MODES};
ALLOC char*   SAMPLE_MODE_LABEL INIT(= {"SAMPLE_MODE = "});
ALLOC int       		sample_mode_index;
static char	*sample_mode_names[MAX_SAMPLE_MODES] =
			{"ON_SAMPLE","ON_CHANGE","CHANGES_ONLY",
				"DELTA_TIME","FREQUENCY"};
ALLOC char 			compress_headers[5];
ALLOC char*   TIME_DELTA_LABEL INIT(= {"TIME_DELTA = "});
ALLOC char*   FREQUENCY_LABEL INIT(= {"FREQUENCY = "});

#define COMMA                   ","
#define SEMI_COLON              ";"
#define OPEN_BRACE              "{"
#define CLOSE_BRACE             "}"
#define NEW_LINE		0x0a
ALLOC char	new_line;

/* TDS Query Buffer */
#define MAX_TDS_QUERY_LENGTH	1000
ALLOC char 			tds_query_buffer[MAX_TDS_QUERY_LENGTH];
ALLOC int  			tds_query_length;
ALLOC int  			tds_query_sent;
ALLOC int  			tds_query_ready;

/* pointer to SFDU received from TDS */
ALLOC char			*sfdu_pointer;

/* buffer for data received from TDS */
union data_rcvd{
		ubyte		byte_buffer[MAX_SFDU_LENGTH];
		unsigned short	short_buffer[MAX_SFDU_LENGTH/2];
	      };
ALLOC union data_rcvd 		input_data;

ALLOC int 			record_count;

enum  {ALL_ENG,EH8,EHR,ES8,ESS,EMS,EL8,ELS,EVS,E8N,EPN,E8B,EPB,E8M,E8J,EPJ,
	E8V,DMS,CDS,ENG_NONE,ENG_8,ENG_10,ENG_16,ENG_40,ENG_1200,
	MAX_ENG_TYPES};
static char* eng_types[MAX_ENG_TYPES] = {"teng","eh8","ehr","es8","ess",
					"ems","el8","els","evs","e8n","epn",
					"e8b", "epb", "e8m","e8j","epj","e8v",
					"eng_dms","eng_cds","eng_none","eng_8",
					"eng_10","eng_16","eng_40","eng_1200"};
ALLOC int	eng_selected[MAX_ENG_TYPES];

enum	{ENG_EH8_SFDU,ENG_EHR_SFDU,ENG_ES8_SFDU,ENG_ESS_SFDU,ENG_EMS_SFDU,
	 ENG_EL8_SFDU,ENG_ELS_SFDU,ENG_EVS_SFDU,ENG_E8N_SFDU,ENG_EPN_SFDU,
	 ENG_E8B_SFDU,ENG_EPB_SFDU,ENG_E8M_SFDU,ENG_E8J_SFDU,ENG_EPJ_SFDU,
	 ENG_E8V_SFDU,MAX_ENG_SFDUS};


static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into eng_types */
	char*		ddp_id;
	} eng_sfdus[MAX_ENG_SFDUS] = {
	{2,128,1,1,0,1,"C139"},
	{2,128,1,2,0,2,"C139"},
	{2,128,1,3,0,3,"C139"},
	{2,128,1,4,0,4,"C139"},
	{2,128,1,5,0,5,"C139"},
	{2,128,1,6,0,6,"C139"},
	{2,128,1,7,0,7,"C139"},
	{2,128,1,8,0,8,"C139"},
	{2,129,1,1,0,9,"C139"},
	{2,129,1,2,0,10,"C139"},
	{2,129,1,3,0,11,"C139"},
	{2,129,1,4,0,12,"C139"},
	{2,129,1,5,0,13,"C139"},
	{2,129,1,6,0,14,"C139"},
	{2,129,1,7,0,15,"C139"},
	{2,129,1,8,0,16,"C139"}};

enum  {ALL_CHENG,CH_EH8,CH_EHR,CH_ES8,CH_ESS,CH_EMS,CH_EL8,CH_ELS,
       CH_EVS,CH_E8N,CH_EPN,CH_E8B,CH_EPB,CH_E8M,CH_E8J,CH_EPJ,CH_E8V,
       MAX_CHENG_TYPES};

static char* ch_eng_types[MAX_CHENG_TYPES] = {"cteng","ch_eh8","ch_ehr",
	"ch_es8", "ch_ess", "ch_ems", "ch_el8", "ch_els", "ch_evs", "ch_e8n",
        "ch_epn", "ch_e8b", "ch_epb", "ch_e8m", "ch_e8j", "ch_epj", "ch_e8v"};

ALLOC int	ch_eng_selected[MAX_CHENG_TYPES];

enum	{CH_EH8_SFDU,CH_EHR_SFDU,CH_ES8_SFDU,CH_ESS_SFDU,CH_EMS_SFDU,
	 CH_EL8_SFDU,CH_ELS_SFDU,CH_EVS_SFDU,CH_E8N_SFDU,
	 CH_EPN_SFDU,CH_E8B_SFDU,CH_EPB_SFDU,CH_E8M_SFDU,CH_E8J_SFDU,
	 CH_EPJ_SFDU,CH_E8V_SFDU,MAX_CHENG_SFDUS};


static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into ch_eng_types */
	char*		ddp_id;
	} cheng_sfdus[MAX_CHENG_SFDUS] = {
	{11,128,1,1,0,1,"C140"},
	{11,128,1,2,0,2,"C140"},
	{11,128,1,3,0,3,"C140"},
	{11,128,1,4,0,4,"C140"},
	{11,128,1,5,0,5,"C140"},
	{11,128,1,6,0,6,"C140"},
	{11,128,1,7,0,7,"C140"},
	{11,128,1,8,0,8,"C140"},
	{11,129,1,1,0,9,"C140"},
	{11,129,1,2,0,10,"C140"},
	{11,129,1,3,0,11,"C140"},
	{11,129,1,4,0,12,"C140"},
	{11,129,1,5,0,13,"C140"},
	{11,129,1,6,0,14,"C140"},
	{11,129,1,7,0,15,"C140"},
	{11,129,1,8,0,16,"C140"}};

enum  {ALL_MON,MON59_BLK1,MON59_BLK2,MON59_BLK3,MON59_BLK4,MON5_11,MON5_15,
	MAX_MON_TYPES};
static char* mon_types[MAX_MON_TYPES] = {"mon","gif_mon59_block1",
		 "gif_mon59_block2","gif_mon59_block3", "gif_mon59_block4",
                 "gif_mon511", "gif_mon515"};
ALLOC int	mon_selected[MAX_MON_TYPES];

enum	{MON_59_1_SFDU,MON_59_2_SFDU,MON_59_3_SFDU,
	 MON_59_4_SFDU,MON_511_SFDU,MON_515_SFDU, MAX_MON_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into mon_types */
	char*		ddp_id;
	} mon_sfdus[MAX_MON_SFDUS] = {
	{6,1,1,128,0,1,"C193"},
	{6,1,1,129,0,2,"C193"},
	{6,1,1,130,0,3,"C193"},
	{6,1,1,131,0,4,"C193"},
	{6,2,1,2,0,5,"C194"},
	{6,0,1,0,0,6,"C341"}};


enum  {ALL_CH_MON,CH_MON59_BLK1,CH_MON59_BLK2,CH_MON59_BLK3,CH_MON59_BLK4,
       CH_MON5_11,CH_MON5_15,MAX_CH_MON_TYPES};
static char* ch_mon_types[MAX_CH_MON_TYPES]={"chmon","ch_gif_mon59_block1",
            "ch_gif_mon59_block2","ch_gif_mon59_block3", "ch_gif_mon59_block4",
            "ch_gif_mon511","ch_gif_mon515"};
ALLOC int	ch_mon_selected[MAX_CH_MON_TYPES];

enum	{CHMON_59_1_SFDU,CHMON_59_2_SFDU,CHMON_59_3_SFDU,
	 CHMON_59_4_SFDU,CHMON_511_SFDU,CHMON_515_SFDU,
	 MAX_CHMON_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into ch_mon_types */
	char*		ddp_id;
	} chmon_sfdus[MAX_CHMON_SFDUS] = {
	{11,2,1,128,0,1,"C193"},
	{11,2,1,129,0,2,"C193"},
	{11,2,1,130,0,3,"C193"},
	{11,2,1,131,0,4,"C193"},
	{11,2,1,3,0,5,"C194"},
	{11,2,1,4,0,6,"C341"}};

enum  {ALL_IMG,MPW,HCM,IM4,MAX_IMG_TYPES};
static char* img_types[MAX_IMG_TYPES] = {"img","mpw","hcm","im4"};
ALLOC int	img_selected[MAX_IMG_TYPES];

enum	{MPW_SFDU,MPP_SFDU,MPR_SFDU,XPW_SFDU,XCM_SFDU,XED_SFDU,
	 XRW_SFDU,HPW_SFDU,HCM_SFDU,HIM_SFDU,HRW_SFDU,
	 HCJ_SFDU,PW4_SFDU,IM4_SFDU,PW8_SFDU,IM8_SFDU,AI8_SFDU,
	 MAX_IMG_SFDUS};

static	char*	tis_img_types[MAX_IMG_SFDUS] = {
	"mpw","mpp","mpr","xpw","xcm","xed","xrw","hpw","hcm"
	"him","hrw","hcj","pw4","im4","pw8","im8","ai8"};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into tis_img_types */
	char*		ddp_id;
	} img_sfdus[MAX_IMG_SFDUS] = {
	{4,0,1,0,0,0,"C150"},
	{4,0,1,1,0,1,"C151"},
	{4,0,1,2,0,2,"C152"},
	{4,1,1,0,0,3,"C153"},
	{4,1,1,1,0,4,"C154"},
	{4,1,1,2,0,5,"C155"},
	{4,1,1,3,0,6,"C156"},
	{4,2,1,0,0,7,"C157"},
	{4,2,1,1,0,8,"C158"},
	{4,2,1,2,0,9,"C159"},
	{4,2,1,3,0,10,"C160"},
	{4,2,1,4,0,11,"C161"},
	{4,3,1,0,0,12,"C162"},
	{4,3,1,1,0,13,"C163"},
	{4,4,1,0,0,14,"C164"},
	{4,4,1,1,0,15,"C165"},
	{4,4,1,2,0,16,"C166"}};

enum	{CHLRS_SFDU,MAX_CHLRS_SFDUS};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into data_type_names */
	char*		ddp_id;
	} chlrs_sfdus = {11,130,1,0,0,4,"C184"};

enum	{CHDRS_SFDU,MAX_CHDRS_SFDUS};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into data_type_names */
	char*		ddp_id;
	} chdrs_sfdus = {11,130,1,1,0,5,"C184"};

enum	{LRS_SFDU,MAX_LRS_SFDUS};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into data_type_names */
	char*		ddp_id;
	} lrs_sfdus = {3,130,1,0,0,2,"C142"};

enum	{CLRS_SFDU,MAX_CLRS_SFDUS};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into data_type_names */
	char*		ddp_id;
	} clrs_sfdus = {3,130,1,1,0,3,"C143"};

enum	{CPRB_SFDU,MAX_CPRB_SFDUS};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into data_type_names */
	char*		ddp_id;
	} cprb_sfdus = {3,131,1,1,0,7,"C145"};

enum	{LPR_SFDU,MAX_LPR_SFDUS};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into data_type_names */
	char*		ddp_id;
	} lpr_sfdus = {3,131,1,2,0,6,"C147"};

enum	{TDS_ON_SAMPLE,TDS_ON_CHANGE,TDS_FREQUENCY,TDS_TIME_DELTA,
	 TDS_CHANGES_ONLY,TDS_EXP_ON_SAMPLE,TDS_EXP_ON_CHANGE,
	 TDS_EXP_FREQUENCY,TDS_EXP_TIME_DELTA,TDS_EXP_CHANGES_ONLY,
	 MAX_TDS_CHANNELIZED_SFDUS};

static	char*	tds_channelized_names[MAX_TDS_CHANNELIZED_SFDUS] = {
	"TDS on sample","TDS on change","TDS Frequency","TDS time delta",
	"TDS changes only","TDS on sample EXP","TDS on change EXP",
	"TDS frequency EXP","TDS time delta EXP","TDS changes only EXP"};
static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into tds_channelized_names */
	char*		ddp_id;
	} tds_channel_sfdus[MAX_TDS_CHANNELIZED_SFDUS] = {
	{11,5,1,1,0,0,"C270"},
	{11,5,1,2,0,1,"C270"},
	{11,5,1,3,0,2,"C270"},
	{11,5,1,4,0,3,"C270"},
	{11,5,1,5,0,4,"C270"},
	{11,5,1,1,0,5,"C271"},
	{11,5,1,2,0,6,"C271"},
	{11,5,1,3,0,7,"C271"},
	{11,5,1,4,0,8,"C271"},
	{11,5,1,5,0,9,"C271"}};
/*******************************************************************/
/* The following variables are specific to Packet data types       */
/*******************************************************************/
/*******************************************************************/
/*  The following lists are TDS Packet engineering                 */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum 	{PKT_ALL_ENG,
	PKT_ENG1,
	PKT_ENG2,
	PKT_AACS1,
	PKT_AACS2,
	PKT_AACS3_COMP,
	PKT_AACS3_DECOMP,
	PKT_AACS4,
      	PKT_AACS,
	PKT_AACS_ALL,
	PKT_AACS_S1,
	PKT_AACS_S2,
	PKT_SUB_AACS,
	PKT_ENG_2BPS,
      	PKT_ENG_10BPS,
	PKT_ENG_40BPS,
	PKT_ENG_1200BPS,
	PKT_ENG_RT,
	PKT_ENG_PB,
      	PKT_ENG_FRAME,
	MAX_PKT_ENG_TYPES};
ALLOC	int	pkt_eng_selected[MAX_PKT_ENG_TYPES];
static char* pkt_eng_types[MAX_PKT_ENG_TYPES] =
                 {"peng",
		"pkt_eng1_rt",
		"pkt_eng2_pb",
                "aacs1_rt",
		"aacs2_pb",
		"aacs3_pb_comp",
                "aacs3_pb_decomp",
		"aacs4_rrcc",
		"pkt_aacs",
		"pkt_aacs_all",
                "sub_aacs1_rt",
		"sub_aacs2_pb_rrcc",
		"sub_aacs",
                "pkt_eng_frame_2",
		"pkt_eng_frame_10",
		"pkt_eng_frame_40",
                "pkt_eng_frame_1200",
		"pkt_eng_frame_rt",
                "pkt_eng_frame_pb",
		"pkt_eng_frame"};

/*******************************************************************/
/*  The following lists are TIS Packet engineering                 */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{PKT_ENG1_SFDU,PKT_ENG2_SFDU,PKT_AACS1_SFDU,PKT_AACS2_SFDU,
	 PKT_AACS3_SFDU,PKT_AACS4_SFDU,PKT_AACS3D_SFDU,PKT_ENG_2B_SFDU,
	 PKT_ENG_10B_SFDU,PKT_ENG_40B_SFDU,PKT_ENG_1200B_SFDU,
	 PKT_SUB_AACS_RT_SFDU,PKT_SUB_AACS_PB_SFDU,MAX_PKT_ENG_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;/* SFDUS recvd */
	int		dt_index;/* index into pkt_eng_types */
	char*		ddp_id;
	} pkt_eng_sfdus[MAX_PKT_ENG_SFDUS] = {
	{2,135,1,1,0,1,"C654"},
	{2,135,1,2,0,2,"C654"},
	{2,136,1,1,0,3,"C655"},
	{2,136,1,2,0,4,"C655"},
	{2,139,1,1,0,5,"C681"},
	{2,136,1,3,0,7,"C655"},
	{2,136,1,4,0,6,"C655"},
	{2,137,1,1,0,13,"C656"},
	{2,137,1,2,0,14,"C656"},
	{2,137,1,3,0,15,"C656"},
	{2,137,1,4,0,16,"C656"},
	{2,138,1,1,0,10,"C653"},
	{2,138,1,2,0,11,"C653"}};

/*******************************************************************/
/*  The following lists are TDS Packet channelized engineering     */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {PKT_CHENG_ALL,
	PKT_CHAACS_S1,
	PKT_CHAACS_S2,
	PKT_CHAACS_SALL,
	PKT_CHENG_2BPS,
	PKT_CHENG_10BPS,
	PKT_CHENG_40BPS,
	PKT_CHENG_1200BPS,
	PKT_CHENG_RT,
	PKT_CHENG_PB,
	PKT_CHENG_FRAME,
        MAX_PKT_CHENG_TYPES};
ALLOC	int	pkt_cheng_selected[MAX_PKT_CHENG_TYPES];
static char* pkt_cheng_types[MAX_PKT_CHENG_TYPES] =
                 {"cpeng",
		  "ch_sub_aacs1_rt",
		  "ch_sub_aacs2_pb_rrcc",\
                  "ch_sub_aacs",
		  "ch_pkt_eng_frame_2",
		  "ch_pkt_eng_frame_10",\
                  "ch_pkt_eng_frame_40",
		  "ch_pkt_eng_frame_1200",\
                  "ch_pkt_eng_frame_rt",
		  "ch_pkt_eng_frame_pb",\
                  "ch_pkt_eng_frame"};

/*******************************************************************/
/*  The following lists are TIS Packet channelized engineering     */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{PKT_CHENG2_SFDU,PKT_CHENG10_SFDU,PKT_CHENG40_SFDU,PKT_CHENG1200_SFDU,
	 PKT_CHENG_AACS_RT_SFDU,PKT_CHENG_AACS_PB_SFDU,MAX_PKT_CHENG_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into pkt_cheng_types */
	char*		ddp_id;
	} pkt_cheng_sfdus[MAX_PKT_CHENG_SFDUS] = {
	{11,131,1,1,0,4,"C657"},
	{11,131,1,2,0,5,"C657"},
	{11,131,1,3,0,6,"C657"},
	{11,131,1,4,0,7,"C657"},
	{11,132,1,1,0,1,"C658"},
	{11,132,1,2,0,2,"C658"}};

/*******************************************************************/
/*  The following lists are TDS VCDU				   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {VCDU_ALL,
	VCDU0,
	VCDU1,
	VCDU2,
	VCDU3,
        VCDU4,
	VCDU5,
	VCDU6,
	VCDU7,
	VCDU_RT,
	VCDU_PB,
        VCDU_RRCC,
	MAX_VCDU_TYPES};
ALLOC	int	vcdu_selected[MAX_VCDU_TYPES];
static char* vcdu_types[MAX_VCDU_TYPES] = 
	       {"vcdu",
		"vcdu0_priority",
		"vcdu1_rt",
		"vcdu2_pb",
                "vcdu3_rrcc",
		"vcdu4_fill",
		"vcdu5_bdtt_rt",
		"vcdu6_bdtt_pb",
                "vcdu7_bdtt_rrcc",
		"vcdu_all_rt",
		"vcdu_all_pb",
                "vcdu_all_rrcc"};

/*******************************************************************/
/*  The following lists are TIS VCDU			           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{VCDU0_SFDU,VCDU1_SFDU,VCDU2_SFDU,VCDU3_SFDU,VCDU4_SFDU,VCDU5_SFDU,
	 VCDU6_SFDU,VCDU7_SFDU,MAX_VCDU_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format*/
	int		rcvd;/* sfdu rcvd of each type */
	int		dt_index;/* index into vcdu_types */
	char*		ddp_id;		
	} vcdu_sfdus[MAX_VCDU_SFDUS] = {
	{7,128,1,0,0,1,"C107"},
	{7,128,1,1,0,2,"C107"},
	{7,128,1,2,0,3,"C107"},
	{7,128,1,3,0,4,"C107"},
	{7,128,1,4,0,5,"C107"},
	{7,128,1,5,0,6,"C107"},
	{7,128,1,6,0,7,"C107"},
	{7,128,1,7,0,8,"C107"}};

/*******************************************************************/
/*  The following lists are TDS FCD 				   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {FCD_ALL,
	FCD_SUC,
	FCD_UNS,
	FCD_PAR,
	FCD_NOT,
	MAX_FCD_TYPES};
ALLOC	int	fcd_selected[MAX_FCD_TYPES];
static char* fcd_types[MAX_FCD_TYPES] = 
                 {"fcd",
		  "fcd_decoded_success",
		  "fcd_decoded_unsucc", 
                  "fcd_partial",
		  "fcd_not_rs"};

/*******************************************************************/
/*  The following lists are TIS FCD			           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{FCD_RS_DECODE_SFDU,FCD_PARTIAL_SFDU,FCD_NON_RS_SFDU,FCD_RS_UNSUC_SFDU,
	 MAX_FCD_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into fcd_types */
	char*		ddp_id;
	} fcd_sfdus[MAX_FCD_SFDUS] = {
	{1,11,1,1,0,1,"G111"},
	{1,11,1,2,0,3,"G112"},
	{1,11,1,3,0,4,"G113"},
	{1,11,1,4,0,2,"G114"}};

enum   {ALL_PKT_SCI,
	PKT_DDS,
	PKT_EDP,
	PKT_EUV,
	PKT_HIC,
	PKT_MAG,
	PKT_NIMS,
        PKT_OPN,
	PKT_PLS,
	PKT_PPR,
	PKT_PWH,
	PKT_PWL,
	PKT_SSI,
	PKT_UVS,
        MAX_PKT_SCI_TYPES};
ALLOC	int	pkt_sci_selected[MAX_PKT_SCI_TYPES];

static char*	pkt_sci_types[MAX_PKT_SCI_TYPES]={"pksci","dds",
                        "epd","euv","hic","mag","nims","opn","pls",
                        "ppr","pwh","pwl","ssi","uvs"};

/*******************************************************************/
/*  The following lists are TDS Packet Science DDS 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {ALL_DDS,DDS1,DDS2,DDS3,DDS_PB,MAX_DDS_TYPES};
ALLOC	int	dds_selected[MAX_DDS_TYPES];
static char*    dds_types[MAX_DDS_TYPES]=
		{"dds","dds1_rt","dds2_pb","dds3_rrcc","dds_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science DDS	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{DDS1_SFDU,DDS2_SFDU,DDS3_SFDU,MAX_DDS_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into dds_types */
	char*		ddp_id;
	} dds_sfdus[MAX_DDS_SFDUS] = {
	{3,140,1,1,0,1,"C675"},
	{3,140,1,2,0,2,"C675"},
	{3,140,1,3,0,3,"C675"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science EPD 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {ALL_EPD,EPD1,EPD2,EPD3,EPD_PB,MAX_EPD_TYPES};
ALLOC	int	epd_selected[MAX_EPD_TYPES];
static char*    epd_types[MAX_EPD_TYPES] =
                {"epd","epd1_rt","epd2_pb","epd3_rrcc","epd_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science EPD	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{EPD1_SFDU,EPD2_SFDU,EPD3_SFDU,MAX_EPD_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into epd_types */
	char*		ddp_id;
	} epd_sfdus[MAX_EPD_SFDUS] = {
	{3,141,1,1,0,1,"C661"},
	{3,141,1,2,0,2,"C661"},
	{3,141,1,3,0,3,"C661"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science EUV 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {ALL_EUV,EUV1,EUV2,MAX_EUV_TYPES};
ALLOC	int	euv_selected[MAX_EUV_TYPES];
static char*	euv_types[MAX_EUV_TYPES] = 
                        {"euv","euv1_rt","euv2_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science EUV	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{EUV1_SFDU,EUV2_SFDU,MAX_EUV_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into euv_types */
	char*		ddp_id;
	} euv_sfdus[MAX_EUV_SFDUS] = {
	{3,142,1,1,0,1,"C662"},
	{3,142,1,2,0,2,"C662"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science HIC 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {ALL_HIC,HIC1,HIC2,HIC3,HIC_PB,MAX_HIC_TYPES};
ALLOC	int	hic_selected[MAX_HIC_TYPES];
static char*	hic_types[MAX_HIC_TYPES] = 
                        {"hic","hic1_rt","hic2_pb","hic3_rrcc","hic_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science HIC	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{HIC1_SFDU,HIC2_SFDU,HIC3_SFDU,MAX_HIC_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into hic_types */
	char*		ddp_id;
	} hic_sfdus[MAX_HIC_SFDUS] = {
	{3,143,1,1,0,1,"C663"},
	{3,143,1,2,0,2,"C663"},
	{3,143,1,3,0,3,"C663"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science MAG 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {ALL_MAG,MAG1,MAG2,MAG3_COMP,MAG3_DECOMP,MAG4,MAG_PB,MAX_MAG_TYPES};
ALLOC	int	mag_selected[MAX_MAG_TYPES];
static char*	mag_types[MAX_MAG_TYPES] = 
                        {"mag_all","mag1_rt","mag2_pb","mag3_pb_comp",\
                        "mag3_pb_decomp","mag4_rrcc","mag_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science MAG	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{MAG1_SFDU,MAG2_SFDU,MAG3_SFDU,MAG4_SFDU,MAG3D_SFDU,MAX_MAG_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into mag_types */
	char*		ddp_id;
	} mag_sfdus[MAX_MAG_SFDUS] = {
	{3,144,1,1,0,1,"C664"},
	{3,144,1,2,0,2,"C664"},
	{3,156,1,4,0,3,"C683"},
	{3,144,1,3,0,5,"C664"},
	{3,144,1,5,0,4,"C664"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science NIMS 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum   {ALL_NIMS,
	NIMS1,
	NIMS2,
	NIMS3,
	NIMS4,
	NIMS5_COMP,
	NIMS5_DECOMP,
	NIMS6_COMP,
	NIMS6_DECOMP,
	NIMS7_COMP,
	NIMS7_DECOMP,
	NIMS_COMP,
	NIMS_PB,
        MAX_NIMS_TYPES};
ALLOC	int	nims_selected[MAX_NIMS_TYPES];
static char*	nims_types[MAX_NIMS_TYPES] = 
                       {"nims_all",
			"nims1_rt",
			"nims2_pb_11",
			"nims3_pb_6",\
			"nims4_pb_2",
			"nims5_pb_11_comp",
			"nims5_pb_11_decomp",\
                        "nims6_pb_6_comp",
			"nims6_pb_6_decomp",\
                        "nims7_pb_2_comp",
			"nims7_pb_2_decomp",\
                        "nims_comp",
			"nimspb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science NIMS	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{NIMS1_SFDU,NIMS2_SFDU,NIMS3_SFDU,NIMS4_SFDU,NIMS5_SFDU,NIMS6_SFDU,
	 NIMS7_SFDU,NIMS5D_SFDU,NIMS6D_SFDU,NIMS7D_SFDU,MAX_NIMS_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into nims_types */
	char*		ddp_id;
	} nims_sfdus[MAX_NIMS_SFDUS] = {
	{3,145,1,1,0,1,"C665"},
	{3,145,1,2,0,2,"C665"},
	{3,145,1,3,0,3,"C665"},
	{3,145,1,4,0,4,"C665"},
	{3,157,1,5,0,5,"C684"},
	{3,157,1,6,0,7,"C684"},
	{3,157,1,7,0,9,"C684"},
	{3,145,1,8,0,6,"C665"},
	{3,145,1,9,0,8,"C665"},
	{3,145,1,10,0,10,"C665"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science OPN 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {OPN_ALL,OPN1,OPN2,OPN3,OPN4,OPN_PB,MAX_OPN_TYPES};
ALLOC	int	opn_selected[MAX_OPN_TYPES];
static char*	opn_types[MAX_OPN_TYPES] =
                       {"opn","opn1_limb_rt","opn2_star_rt","opn3_limb_pb",\
                        "opn4_star_pb","opn_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science OPN	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{OPN1_SFDU,OPN2_SFDU,OPN3_SFDU,OPN4_SFDU,MAX_OPN_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into opn_types */
	char*		ddp_id;
	} opn_sfdus[MAX_OPN_SFDUS] = {
	{3,146,1,4,0,1,"C666"},
	{3,146,1,5,0,2,"C666"},
	{3,146,1,6,0,3,"C666"},
	{3,146,1,7,0,4,"C666"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science PLS 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {PLS_ALL,PLS1,PLS2,PLS3_COMP,PLS3_DECOMP,
      PLS4,PLS_PB,MAX_PLS_TYPES};
ALLOC	int	pls_selected[MAX_PLS_TYPES];
static char*	pls_types[MAX_PLS_TYPES] =
                       {"pls_all","pls1_rt","pls2_pb","pls3_pb_comp",\
                        "pls3_pb_decomp", "pls4_rrcc", "pls_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science PLS	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{PLS1_SFDU,PLS2_SFDU,PLS3_SFDU,PLS4_SFDU,PLS3D_SFDU,MAX_PLS_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into pls_types */
	char*		ddp_id;
	} pls_sfdus[MAX_PLS_SFDUS] = {
	{3,147,1,1,0,1,"C667"},
	{3,147,1,2,0,2,"C667"},
	{3,158,1,4,0,3,"C685"},
	{3,147,1,3,0,5,"C667"},
	{3,147,1,5,0,4,"C667"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science PPR 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {PPR_ALL,PPR1,PPR2_COMP,PPR2_DECOMP,PPR3,
      PPR4_COMP,PPR4_DECOMP,PPR_COMP,MAX_PPR_TYPES};
ALLOC	int	ppr_selected[MAX_PPR_TYPES];
static char*	ppr_types[MAX_PPR_TYPES] =
                       {"ppr_all","ppr1_pb","ppr2_pb_comp","ppr2_pb_decomp",\
                        "ppr3_burst","ppr4_burst_comp","ppr4_burst_decomp",\
                        "ppr_comp"};

/*******************************************************************/
/*  The following lists are TIS Packet Science PPR	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{PPR1_SFDU,PPR2_SFDU,PPR3_SFDU,PPR4_SFDU,PPR2D_SFDU,PPR4D_SFDU,
	MAX_PPR_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into ppr_types */
	char*		ddp_id;
	} ppr_sfdus[MAX_PPR_SFDUS] = {
	{3,148,1,1,0,1,"C668"},
	{3,159,1,1,0,2,"C686"},
	{3,148,1,2,0,4,"C668"},
	{3,159,1,2,0,5,"C686"},
	{3,148,1,5,0,3,"C668"},
	{3,148,1,6,0,6,"C668"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science PWH 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {PWH_ALL,PWH1,PWH2,PWH3,PWH4,PWH5,PWH_PB,MAX_PWH_TYPES};
ALLOC	int	pwh_selected[MAX_PWH_TYPES];
static char*	pwh_types[MAX_PWH_TYPES] =
                        {"pwh","pwh1_fill", "pwh2_pb_mpw", "pwh3_pb_mpp",\
                        "pwh4_pb_hpw", "pwh5_lpw_golay","pwh_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science PWH	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{PWH1_SFDU,PWH2_SFDU,PWH3_SFDU,PWH4_SFDU,PWH5_SFDU,MAX_PWH_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into pwh_types */
	char*		ddp_id;
	} pwh_sfdus[MAX_PWH_SFDUS] = {
	{3,149,1,4,0,1,"C669"},
	{3,149,1,1,0,2,"C669"},
	{3,149,1,2,0,3,"C669"},
	{3,149,1,3,0,4,"C669"},
	{3,149,1,6,0,5,"C669"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science PWL 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {PWL_ALL,PWL1,PWL2,PWL3,PWL4,PWL_PB,MAX_PWL_TYPES};
ALLOC	int	pwl_selected[MAX_PWL_TYPES];
static char*	pwl_types[MAX_PWL_TYPES] =
                        {"pwl","pwl1_rt_e_pkt","pwl2_rt_b_pkt","pwl3_pb",\
                        "pwl4_rrcc", "pwl_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science PWL	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{PWL1_SFDU,PWL2_SFDU,PWL3_SFDU,PWL4_SFDU,MAX_PWL_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into pwl_types */
	char*		ddp_id;
	} pwl_sfdus[MAX_PWL_SFDUS] = {
	{3,150,1,1,0,1,"C670"},
	{3,150,1,2,0,2,"C670"},
	{3,152,1,2,0,3,"C672"},
	{3,152,1,3,0,4,"C672"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science SSI 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {SSI_ALL,SSI1,SSI2,SSI3_COMP,SSI3_DECOMP,MAX_SSI_TYPES};
ALLOC	int	ssi_selected[MAX_SSI_TYPES];
static char*	ssi_types[MAX_SSI_TYPES] =
                        {"ssi","ssi1_ict_comp", "ssi2_barc_comp",\
                        "ssi3_hskp_comp", "ch_ssi3_hskp_comp"};

/*******************************************************************/
/*  The following lists are TIS Packet Science SSI	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{SSI1_SFDU,SSI2_SFDU,SSI3_SFDU,MAX_SSI_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into ssi_types */
	char*		ddp_id;
	} ssi_sfdus[MAX_SSI_SFDUS] = {
	{3,160,1,4,0,1,"C687"},
	{3,160,1,5,0,2,"C687"},
	{3,153,1,6,0,3,"C673"}};

/*******************************************************************/
/*  The following lists are TDS Packet Science UVS 		   */
/*  types that must be updated if TDS adds any new types.          */  
/*  This list is derived from TdsDataRes file.			   */
/*******************************************************************/
enum {UVS_ALL,UVS1,UVS2,UVS3_COMP,UVS3_DECOMP,
      UVS4,UVS_PB,MAX_UVS_TYPES};
ALLOC	int	uvs_selected[MAX_UVS_TYPES];
static char*	uvs_types[MAX_UVS_TYPES] =
                        {"uvs_all","uvs1_rt","uvs2_pb","uvs3_pb_comp",\
                         "uvs3_pb_decomp","uvs4_rrcc","uvs_pb"};

/*******************************************************************/
/*  The following lists are TIS Packet Science UVS	           */
/*  types that must be updated if TIS adds any new types.          */  
/*  These lists are derived from Appendix B of SFOC-5-SYS-DU-NJPL  */
/*******************************************************************/
enum	{UVS1_SFDU,UVS2_SFDU,UVS3_SFDU,UVS4_SFDU,UVS3D_SFDU,MAX_UVS_SFDUS};

static	struct {
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into uvs_types */
	char*		ddp_id;
	} uvs_sfdus[MAX_UVS_SFDUS] = {
	{3,154,1,1,0,1,"C674"},
	{3,154,1,2,0,2,"C674"},
	{3,161,1,4,0,3,"C688"},
	{3,154,1,3,0,5,"C674"},
	{3,154,1,5,0,4,"C674"}};




static	struct sfdu_struct{
	unsigned char	sfdu_id[4];/* major,minor,format */
	int		rcvd;
	int		dt_index;/* index into *_types */
	char*		ddp_id;
	};
/***********************************************/
/* These entries represent all TDS data types  */
/* including TDS channelized records.          */
/***********************************************/
/* MAX_DATA_TYPES + TDS CHANNELIZED DATA TYPES */
#define MAX_TDS_TYPES	MAX_DATA_TYPES+1
static 	struct	{
	int	num_sfdu_types;
	struct	sfdu_struct	*sfdus;
	char	**name_list;
        } frame_sfdus[MAX_TDS_TYPES] = {
	{MAX_ENG_SFDUS,(struct sfdu_struct*)eng_sfdus,eng_types},
  	{MAX_CHENG_SFDUS,(struct sfdu_struct*)cheng_sfdus,ch_eng_types},
	{MAX_LRS_SFDUS,(struct sfdu_struct*)&lrs_sfdus,data_type_names},
	{MAX_CLRS_SFDUS,(struct sfdu_struct*)&clrs_sfdus,data_type_names},
	{MAX_CHLRS_SFDUS,(struct sfdu_struct*)&chlrs_sfdus,data_type_names},
	{MAX_CHDRS_SFDUS,(struct sfdu_struct*)&chdrs_sfdus,data_type_names},
	{MAX_LPR_SFDUS,(struct sfdu_struct*)&lpr_sfdus,data_type_names},
	{MAX_CPRB_SFDUS,(struct sfdu_struct*)&cprb_sfdus,data_type_names},
	{MAX_IMG_SFDUS,(struct sfdu_struct*)img_sfdus,img_types},
	{MAX_QQC_SFDUS,(struct sfdu_struct*)qqc_sfdus,qqc_types},
	{MAX_CHQQC_SFDUS,(struct sfdu_struct*)chqqc_sfdus,ch_qqc_types},
	{MAX_MON_SFDUS,(struct sfdu_struct*)mon_sfdus,mon_types},
	{MAX_CHMON_SFDUS,(struct sfdu_struct*)chmon_sfdus,ch_mon_types},
	{MAX_PKT_ENG_SFDUS,(struct sfdu_struct*)pkt_eng_sfdus,pkt_eng_types},
	{MAX_PKT_CHENG_SFDUS,(struct sfdu_struct*)pkt_cheng_sfdus,
							pkt_cheng_types},
	{0,NULL,NULL},
	{MAX_DDS_SFDUS,(struct sfdu_struct*)dds_sfdus,dds_types},
	{MAX_EPD_SFDUS,(struct sfdu_struct*)epd_sfdus,epd_types},
	{MAX_EUV_SFDUS,(struct sfdu_struct*)euv_sfdus,euv_types},
	{MAX_HIC_SFDUS,(struct sfdu_struct*)hic_sfdus,hic_types},
	{MAX_MAG_SFDUS,(struct sfdu_struct*)mag_sfdus,mag_types},
	{MAX_NIMS_SFDUS,(struct sfdu_struct*)nims_sfdus,nims_types},
	{MAX_OPN_SFDUS,(struct sfdu_struct*)opn_sfdus,opn_types},
	{MAX_PLS_SFDUS,(struct sfdu_struct*)pls_sfdus,pls_types},
	{MAX_PPR_SFDUS,(struct sfdu_struct*)ppr_sfdus,ppr_types},
	{MAX_PWH_SFDUS,(struct sfdu_struct*)pwh_sfdus,pwh_types},
	{MAX_PWL_SFDUS,(struct sfdu_struct*)pwl_sfdus,pwl_types},
	{MAX_SSI_SFDUS,(struct sfdu_struct*)ssi_sfdus,ssi_types},
	{MAX_UVS_SFDUS,(struct sfdu_struct*)uvs_sfdus,uvs_types},
	{MAX_VCDU_SFDUS,(struct sfdu_struct*)vcdu_sfdus,vcdu_types},
	{MAX_FCD_SFDUS,(struct sfdu_struct*)fcd_sfdus,fcd_types},
	{0,NULL,NULL},
	{MAX_TDS_CHANNELIZED_SFDUS,(struct sfdu_struct*)tds_channel_sfdus,
	tds_channelized_names}};

ALLOC	int	unknown_sfdus_rcvd;
