/**************************************************************************
TITLE:  vgr_scet.c

AUTHOR:         Judy Yin
MERGED:         Aug 4, 1994
COMPILER:       gcc 4.5.2
OS:             Solaris 10.2
modified:       Ray Bambery - 5-14-2021
                added clearer error message to scet_load_file for failure to open
                added debug prints to print SCLK_SCET coefficients 
                Ray Bambery - 5-17-2021
                removed printf lines where necessary

                Ray Bambery - 12-07-2021 
                add protptype extern read_sclk to avoid msg
                warning: implicit declaration of function ‘read_sclk’

                change prototype 
                extern int any_time_to_seconds(register string s, double * t);
                to
                extern int any_time_to_seconds(register char* s, double * t);
                to avoid msg:
                warning: type defaults to ‘int’ in declaration of ‘string

routine                 called_by
scet_load_file          vgr_edrgen
sclktoscet              
****************************************************************************/

#include "sclkConvert.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "sclkscet.h"
#include "scegen.h"

#include "sfdu.h"
#define VGR_ID_1 2
extern int any_time_to_seconds(register char* s, double * t);
extern int read_sclk(SFDU *sfdu, int m_id, int *s_id);
int scet_load_file( char* filename);
int sclktoscet(double sclk,double *scet, double epoch);
//-----------------------------------------------------------------------
int scet_load_file( char* filename)
{
/*  open SCLK_SCET.XX file and invoke read_sclk from read_sclk.c
 *  5-14-2012 improved error messages
 */  
        int     spacecraft_id;
        SFDU    *ss_sfdu;
/*
 *     Attempt to open SCLK_SCET file as an sfdu.
 */
        if ((ss_sfdu = sfdu_open(filename, "r")) == NULL) {
            printf("vgr_scet: open_file: can not open file- %s \n", filename);
            fflush(stdout);
            exit(0);
        }

/*
 *      Attempt to read file.
 */
        if (read_sclk(ss_sfdu, VGR_ID_1, &spacecraft_id) == ERROR)
        {
                sfdu_close(ss_sfdu);
                printf("vgr_scet: MISSION INCONSISTENT with read_sclk in  %s \n", filename);
                fflush(stdout);
                exit(0);
        }
        return(OKAY);  /* if open and read are successful */
}
//------------------------------------------------------------------------- 
int sclktoscet(double sclk,double *scet, double epoch)
{
	sclktblptr      found;
        sclktbl         key;
        double          dbsclk;

        /* sanity checks */
        if (SCLK_TABLE == NULL)
                return(ERROR);
/*
         printf("sclktoscet: SCLK_TABLE= %d %x \n", SCLK_TABLE,SCLK_TABLE);   // removed 5-17-2021 - RJB


        DEBUG_PRN("DEBUG: Converting sclk = %lf\n", sclk);

    printf("DEBUG: Converting sclk = %lf\n", sclk);  */

/** ???  to try beyond scet coefficient file  

*/
 	epoch = SCLK_TABLE->scet0;
        key.scet0 = epoch;
        if (epoch <= 0.0)
        {
                found = SCLK_TABLE;
        } else 
	{
                if ((found = sclkfind(&key, compare_scet)) == NULL)
                        return(ERROR); 
        }

        /* dbsclk = sclk + offset */
        dbsclk = sclk + (found->dbsclk0 - found->sclk0);

 /*     removed 5-17-2021 - RJB
      printf ("sclktoscet:    \n");
      printf("   DEBUG: epoch dbsclk = %lf sclk = %lf\n", found->dbsclk0, found->sclk0);
        printf("   DEBUG: sclk converts to dbsclk of %lf\n", dbsclk);
 */
/*
 printf("DEBUG: found-> dbsclk = %lf found->sclk0 = %lf sclk = %lf\n",
        found->dbsclk0, found->sclk0, sclk);
 printf("DEBUG: sclk converts to dbsclk of %lf\n", dbsclk);
        key.dbsclk0 = dbsclk;
 printf("DEBUG: key.scet %lf found->scet0 =%lf\n", key.scet0, found->scet0);
*/
        key.dbsclk0 = dbsclk;
        if ((found = sclkfind(&key, compare_dbsclk)) == NULL){
	        printf("sclktoscet: ----sclkfind fail!!\n");
                return(ERROR);
   	}
/*   removed 5-17-2021 - RJB
        DEBUG_PRN("   DEBUG: using sclk0 = %lf\n", found->sclk0);
	DEBUG_PRN("   DEBUG: using scet0 = %lf\n", found->scet0);
 printf("   DEBUG: using sclk0 = %lf\n", found->sclk0);
 printf("   DEBUG: using scet0 = %lf\n", found->scet0);
 printf("   DEBUG: using sclkrate = %lf \n", found->sclkrate);
*/

        *scet = found->scet0 + found->sclkrate * (sclk - found->sclk0);

/*
 printf(" ---- scet before return = %lf\n", *scet);
*/
        return(OK);
}



