/***********************************************************************
TITLE:	sclkfind.c
CIN:	sclk_find.c,v 1.1.1.1 1994/08/31 19:22:02 root Exp

FILE NAME:	/u3/cvs_release/src/VGR_EDR/scet/sclk_find.c,v
AUTHOR:		David A. Wagner
CREATED: 	January 4, 1991
LAST UPDATE: 	1994/08/31 19:22:02
VERSION:	1.1.1.1
COMPILER:	cc and msc 6.0
OS:		SunOS 4.1 or MSDOS 3.3
REFERENCES:
WARNINGS:	Assumes that read_sclk has been called and an appropriate
		SCLKSCET file has been read into SCLK_TABLE.
BUGS:
UNIT TEST:	Compile with -DDEBUG and -DUNIT_TEST
WAIVERS:
DESCRIPTION:	Generic function to lookup values in the sclkscet table
		that is created in memory by read_sclk.  This is a modified
		replacement for the bsearch library function that knows
		about the SCLK_TABLE and its size and also will return the
		closest value less than the key value (bsearch only returns
		exact matches).

CHANGE HISTORY:
  sclk_find.c,v
 * Revision 1.1.1.1  1994/08/31  19:22:02  root
 * Initial Release
 *
 * Revision 1.5  1991/09/26  00:30:35  dsfa
 * corrected sclkfind error in found value
 *
 * Revision 1.4  1991/09/25  23:34:46  dsfa
 * changed max = to sclk_rows.
 *
 * Revision 1.3  1991/06/17  21:43:56  dsfa
 * changed sclkrows to sclk_rows
 *
 * Revision 1.2  1991/06/05  18:10:49  dsfa
 * changed readsclk to read_sclk
 *
 * Revision 1.1  1991/03/13  17:42:03  dsfa
 * Initial revision
 *
***********************************************************************/
//
//      routine                 called by
//      sclk_find               sclktoscet, vgr_scet             
//      compare_dbsclk          sclktoscet
//      compare_scet            sclktoscet
//
#include "sclkscet.h"

//--------------------------------------------------------------------
#ifdef __STDC__
sclktblptr
sclkfind(sclktblptr key, int (* compar)(sclktblptr key, sclktblptr elem))
#else
sclktblptr
sclkfind(key, compar)
	sclktblptr 	key;
	int		(* compar)();
#endif
{
	int index, max, min;
	sclktblptr ptr;

	min = 0; max = sclk_rows;
	for (;;)
	{
		/* default terminal case can occur if table is empty
		** or if search is reduced to a single row 
		*/
		if (max == min)
			return( SCLK_TABLE + min );

		index = (max + min)/2;

		ptr = SCLK_TABLE + index;
		switch ( compar(key, ptr) )
		{
		case -1 :	/* key is lt ptr */
			/* special case if at bottom of table */
			/* this is the only error return! */
			if (index == 0)
				return( (sclktblptr)NULL );

			max = index;
			break;
		case 1  :	/* key is gt ptr */
			/* terminal case 2: */
			if ((max - min) < 2)
				return( SCLK_TABLE + max-1 );

			min = index;
			break;
		case 0  :	/* key is eq ptr: return it */
			return(ptr);
		}
	}
}
//-------------------------------------------------------------------------
/* Compare function for sclkfind.. This function is called by the bsearch
** function to compare two table elements.  In this case we are 
** comparing by dbsclk values.  The function must return:
**	-1 if value1 < value2
**	0  if value1 == value2
**	1  if value1 > value2
*/
int
compare_dbsclk(value1, value2)
	register sclktblptr	value1, value2;
{
	register double diff;
/*
	DEBUG_PRN2("DEBUG: Comparing dbsclks: %lf and %lf\n", value1->dbsclk0,
		value2->dbsclk0);

printf("DEBUG: Comparing dbsclks: %lf and %lf\n", value1->dbsclk0,
                value2->dbsclk0);
*/
	diff = value1->dbsclk0 - value2->dbsclk0;

	if (diff > 0.0)		return(1);
	else if (diff < 0.0)	return(-1);
	else			return(0);
}
//-------------------------------------------------------------------------
/* Compare function for sclkfind. This function is called by the bsearch
** function to compare two table elements.  In this case we are 
** comparing by scet0 values.  The function must return:
**	-1 if value1 < value2
**	0  if value1 == value2
**	1  if value1 > value2
*/
int
compare_scet(value1, value2)
	register sclktblptr	value1, value2;
{
	register double diff;
/*
	DEBUG_PRN2("DEBUG: Comparing scets: %lf and %lf\n", value1->scet0,
		value2->scet0);
*/
	diff = value1->scet0 - value2->scet0;

	if (diff > 0.0)		return(1);
	else if (diff < 0.0)	return(-1);
	else			return(0);
}

