/******************************************************************************
TITLE: 	load_file.c  (open and read file into table in memory)
CIN:    fileio.c,v 1.1.1.1 1994/08/31 19:22:02 root Exp
FILE NAME:      /u3/cvs_release/src/VGR_EDR/scet/fileio.c,v
AUTHOR:         D. Flora-Adams
CREATED:       	November 15, 1991 
LAST UPDATE:    1994/08/31 19:22:02
VERSION:        1.1.1.1
COMPILER:       cc
OS:             SunOS 4.1
REFERENCES:
WARNINGS:       Currently assumes all SCLKSCET files are in SFOC SFDU format
BUGS:
WAIVERS:
DESCRIPTION:
**	load_file calls sfdu_open() and read_sclk() to open 
**	and read a SCLKvSCET Coefficient file. 
**	
**	The load_file function returns an integer value of 0, -1, or -2. 
**	If it cannot open the file as an sfdu it returns -1.  If it cannot
**	read the values into the internal table, it returns -2, otherwise it
**	returns 1 (OKAY).
******************************************************************************/
#include "sclkConvert.h"
#include <string.h>
#include "sfdu.h"

//-------------------------------------------------------------------
int
load_file(filename)
char	*filename;
{
	int	spacecraft_id;
	SFDU	*ss_sfdu;
/*
 *     Attempt to open SCLKvSCET file as an sfdu.
 */
	if ((ss_sfdu = sfdu_open(filename, "r")) == NULL)
	  	return(ERROR); /* Cannot open file */
/*
 * 	Attempt to read file.
 */
	if (read_sclk(ss_sfdu, mission_id, &spacecraft_id) == ERROR)
   	{
		sfdu_close(ss_sfdu);
		return(ERROR2); /* Mission inconsistent */
   	}
  	return(OKAY);  /* if open and read are successful */
}
