/**************************************************************************
TITLE:  vgr_struc.H

AUTHOR:         Judy Yin
CREATED:        Aug 4, 1994
modified:	3-12-2021 - Ray Bambery
		add comments
OS:		Solaris 10.2
COMPILER:       gcc 4.5.2
****************************************************************************/
#ifndef VGR_STRUC_HH
#define VGR_STRUC_HH
#include "./type_conv.H"

#define DATA_TRANSFER_SIZE  10

typedef struct trans_buf_struct {
        unsigned char buf[DATA_TRANSFER_SIZE];
        int buf_len;
} TRANS_BUF_STRUCT;

typedef struct vgr_time_struc{
        U8 m16[2];
        U8 m60[2];
        U8 ln_cnt[2];
} SFOC_SCLK_TIME;

typedef struct int_sclk_struc{
	int m16;
	int m60;
	int ln_cnt;
} SCLK_DCL;


typedef struct vgr_scet_struct{
	U8 hr[2];
	U8 sec[2];
	U8 msec[2];
	U8 yr;
} VGR_SCET;     

typedef struct std_time_fmt{
	int doy;
	int hour;
	int min;
	int sec;
	int msec;
	int year;
} STD_TIME_FMT;

//820-013-0161-Telecomm - Telemetry SFDU Interface
typedef struct sfoc_ert_struct{
	U8 ds1958[2];			/* days since Jan 1, 1958 */
	U8 msec[4];			/* ms of day 		*/
} SFOC_ERT_TIME; 
 
typedef struct sdr_time_dcl {
  U16 year;                             /* year                              */
  U16 hour;                             /* hour of year                      */
  U16 sec;                              /* second of hour                    */
  U16 msec;                             /* millisecond of second             */
}SDR_TIME_DCL  ;
/*
typedef struct vgr_sclk {
	unsigned char m16[2];
	unsigned char m60;
	unsigned char ln_cnt[2];
} VGR_SCLK;
*/

extern int debug_on;
extern int FINAL;

#endif
