/**************************************************************************
TITLE:  vgr_sfdu.H

AUTHOR:         Judy Yin
CREATED:        Aug 4, 1994
modified:	2-3-2021 - Ray Bambery
		removed friend def in public portion of class vgr_sfdu
		4-2-2021 - Ray Bambery 
		added sfdu_pointer to sfoc_hdr_struct
		added inline get_sfdu_ptr()
OS:		Solaris 10.2
COMPILER:       gcc 4.5.2
****************************************************************************/
#ifndef VGR_SFDU_HH
#define VGR_SFDU_HH

#include <math.h>
#include "vgr_def.H"
#include "vgr_struc.H" 
#include "vgr_edr.H"


typedef struct ddp_data_mode_struct
{
  char ddp_id[5];
  int  maj;
  int  min;
  int  fmt_id;
  int  msn_id;
  int  data_mode;
} DDP_DATA_MODE_STRUCT;

typedef struct MF_map_struc
{
	int instr_type;
	int start_bt;
 	int bit_len;
} MF_MAP;

//typedef struct sfoc_sclk_struc
//{
//	unsigned short m16;
//	unsigned short m60;
//	unsigned short ln_cnt;
//}  SFOC_SCLK;

typedef struct sfdu_edr_hdrmap_struct 
{
 //stnd_field_len may not equal to thdr_field_len
	int item_id;
        int hdr_no;
        int start_byt;   // already base 0, 16 bits per word
        int start_bit;  // start from low order bit
        int bit_len;
}  SFDU_EDR_HDR_MAP;
        
//?
//typedef struct sfoc_time_struc
//{
//	unsigned short yr;
//	unsigned short hr;
//	unsigned short 
typedef struct sfoc_hdr_struc
{
	U8 chdo_type[2];
        U8 chdo_len[2];
	U8* sfdu_pointer;			//added 4-2-2021 - RJB
        U8* data_ptr;
}  SFOC_HDR;

class vgr_sfdu {

private:
	SFOC_HDR sfoc_hdr[MAX_HDRS];
//	struct SFOC_HDR sfoc_hdr[MAX_HDRS];
        U8   prim_labl_hdr[PRIM_LABL_LEN + AGGR_CHDO_LEN ];
//	SFOC_HDR hdr;
	U8* 	prim_labl_hdr_ptr;     
//      int	get_prim_labl_hdr(void);
	int 	get_prim_labl_hdr(U8* sfdu_ptr);
 friend void copy_MF_data_block(vgr_sfdu& sfdu_ptr, int MF_no,
                                    SFOC_SCLK_TIME cur_sclk);

public:
	vgr_sfdu();
	int	load_file(char* file_name);
	int     load_data_from_file(); 
	int 	load_data_from_buf( U8* sfdu_pointer);
	int 	load_first_MF_from_file();
// friend void copy_MF_data_block(vgr_sfdu& sfdu_ptr, int MF_no,
//                                    SFOC_SCLK_TIME cur_sclk);

//  inline	const 	U8*	get_data_ptr()
 inline	U8*	get_data_ptr()
		{
		  return(sfoc_hdr[ DATA_SEG_ID].data_ptr);
		};
 inline U8*     get_sfdu_ptr()
		{
		  return(sfoc_hdr[DATA_SEG_ID].sfdu_pointer);
		}
	int     ddp_to_data_mode();
	int     ddp_to_data_mode( U8* ddp_id_tmp, int *maj,
                                  int *min, int *fmt_id, int *msn_id);
	U8	get_reed_golay();
	U8	get_bit_rate_index();
	U8	get_data_source_status();
	U8 	get_dqsw_status();
	void	convert_sfdu_to_edr(int sfdu_item_id, U8* sfdu_val_ptr);
//        unsigned short get_short_val(int offset, int start_bit, int bit_len);
//   	unsigned long  get_long_val(int offset, int start_bit, int bit_len);
//	U8  get_byte_val(int hdr_no, int offset, int start_bit, 
//                                  int bit_len);
	SFOC_SCLK_TIME      get_sclk();
	SFOC_ERT_TIME       get_ert();
	SFOC_ERT_TIME       get_scet();
//	U8* 	get_data_bits(int start_bit, int bit_len);
	TRANS_BUF_STRUCT* get_data_bits(int start_bit, int bit_len);
        TRANS_BUF_STRUCT* get_field_by_hdrmap(int def_item_id);
//      U8* 	get_field_by_hdrmap(int def_item_id);
//      U8* 	get_bits_given_byt (int sfdu_hdr_no, int start_byte, 
        TRANS_BUF_STRUCT* get_bits_given_byt (int sfdu_hdr_no, int start_byte, 
                	       int first_bit_in_byte, int bit_len); 

	U8*	       get_mf(int instr_no);
};

#endif
