/**************************************************************************
TITLE:  vgr_edr.H

AUTHOR:         Judy Yin
CREATED:        Aug 4, 1994
OS:		Solaris 10.2
COMPILER:       gcc 4.5.2
Revision:       Ray Bambery
		9-11-2020 - Ray Bambery
			add void to update_id
		4-6-2021  - Ray Bambery
			added record_processed parameter to store_or_write_MFs
		10-03-2010 -  Ray Bambery
			changed decom_tbl_struct from const char* to char*
		12-09-2021 - Ray Bambery
			undid char*, back to const char* to remove msg
			warning: ISO C++ forbids converting a string constant to ‘char*		
		04-08-2022 - Ray Bambery
			add record_processed to write_edr_rec parameters
****************************************************************************/
#ifndef  VGR_EDR_HH
#define  VGR_EDR_HH

#include <stdio.h>
#include <math.h>
#include "vgr_def.H"
#include "vgr_struc.H"
#include "type_conv.H"

#include "vgr_sfdu.H"
#include "vgr_scet.h"

#define LEAP_YEAR_OFF 	 1
#define DAYS_PER_YEAR    365
#define LEAP_DAY	 1
#define HOURS_PER_DAY    24
#define MSECS_PER_HOUR   3600000
#define SDR_HOURS_OFF    24  
#define MSECS_PER_SEC    1000

typedef struct decom_tbl_struc {
	U8	data_mode;
	U8	sc_id;				//0-
	const char*	file_name;			//changed const char* to char*
} DECOM_TBL_STRUC;

typedef struct info_struc_1 {
        int mfs_per_seg;
        int num_of_segs;
        int mf_size;
        int sub_hdr_size;
} INSTR_INFO;

typedef struct info_struc_2 {
	int sfdu_offset;
	int data_len;
} SFDU_INSTR_SUB_INFO;

typedef struct last_stat_struc {
	int    item_id;
	U8     buf;
} LAST_STAT;

typedef struct rec_id_struc {
	int instr;
	U8  rec_id; 
} REC_ID_STRUC;

typedef struct subhdr_optmz_struc_1 {
	int MF_mod;
	int m60_mod;
	int section_len;
} SUBHDR_OPTMZ;


typedef struct subhdr_map_struc {
        int MF;
        U16 mod60;
        U16 ln_cnt;
        int start_bit;
        int bit_len;
}  SUBHDR_MAP;

// see 
typedef struct edr_stnd_hdr {
	const char*  item_name;
	int item_id;         // defined in vgr_def.H
        int start_wd;   // changed to base 0, 32 bits per word
        int start_bit;  // start from high order bit 31
        int bit_len; // all in bits
        I16 copy_flg;
} EDR_STND_HDR;

class vgr_sfdu;

class vgr_edr {

PRIVATE:

 // variables shared among all EDRs
 static U8		last_PB_mode;
 static U8		fid;
 static U8		eng_sync;
 static U8		last_data_mode;
 static U8		cur_data_mode;
 static U8        	last_stat_tbl[MAX_LAST_STAT];
 static U8              cur_stat_tbl[MAX_LAST_STAT];
 static SFOC_SCLK_TIME  cur_sclk;
 static	SFOC_SCLK_TIME  last_sclk;
 static STD_TIME_FMT	cur_scet;
 static	int		first_DECOM;  
 static	FILE            *out_fd[MAX_INSTR_NUM];
 static FILE		*msg_fd;
 static	int		eng_rec_no;
 static int 		decom_rec_no;

 // variables local to each EDRs, diff for each instrument
  	U16		instr_no;
 	U16		phy_rec_no;
	U8 		last_seg_no;
	U16		first_MF;
	int             estimated_bit_err_cnt;


	U8		hdr[EDR_HDR_LEN];
	int	        sub_hdr_len;
        U8 		*sub_hdr_ptr;
	int 	        data_len;
	U8 		*data_ptr;	

  // subroutines
 	FILE *open_file(const char* file_name, char* type);
	int  load_scet_file(char* file_name);
	U8   get_rec_id(int instr, REC_ID_STRUC* id_map);
        void reset_edr_rec(void);
        void bit_shifting(U8 * sfdu_data, int start, int bit_len);
        void bit_copy(U8* target, TRANS_BUF_STRUCT* source,
                       int start_bit, int bit_len);
	void crs_pad (unsigned short int * in_buf, int in_buf_len,
                     unsigned short int * out_buf, int out_buf_len);
	void copy_to_hdr(U8* buf, int buf_len, int def_item_id);
	int overwrite_byte_to_hdr(U8* buf, int buf_len, int def_item_id);
	void copy_MF_data_block(vgr_sfdu& sfdu_obj, int MF_no, 
                                SFOC_SCLK_TIME cur_sclk);
        int  get_MF_no (int data_mod, SFOC_SCLK_TIME sfoc_time);
        U8   get_seg_no (int MF,U16 m16, U16 m60);
        int  add_bit_error_cnt(int bit_err_cnt);
        void set_dqi_dqsw(vgr_sfdu& sfdu_obj, int min_fram_num, U8* dqi_dqsw);

//   	void store_hdrs_of_first_MF(vgr_sfdu& sfdu_obj, vgr_scet& scet_co);      
   	void store_hdrs_of_first_MF(vgr_sfdu& sfdu_obj);      
//	void store_scet(vgr_scet& scet_co);
	void store_scet();


static inline  int  data_mode_index() {
		if (cur_data_mode == CR_5A) return( 0);
	        else  return(1);
	}


PUBLIC:

 static SDR_TIME_DCL	cur_ert;
 static U8              sc_id;

	vgr_edr(U16 instr);
 	~vgr_edr(void);

 static void fill_cur_stat_tbl(vgr_sfdu& sfdu_obj);
 static	void fill_last_stat_tbl(vgr_sfdu& sfdu_obj);
 static int  last_stat_tbl_changed();
 static int  data_mode_changed();
 static int  sclk_regression (SFOC_SCLK_TIME cur_sclk);
 static void store_last_sclk(SFOC_SCLK_TIME cur_sclk);
 static void init_format_id(vgr_sfdu& sfdu_obj); 
 static int  update_format_id( vgr_sfdu& sfdu_obj);		//static void
 static void print_time_msg(const char* txt_msg, FILE* msg_Fd);
 	void print_final_status(int instr_num, FILE* msg_Fd);

/*
 static inline FILE* get_file_ptr( int instru_number) {
	if (instru_number < MAX_INSTR_NUM)
	   return ( vgr_edr::out_fd[ instru_number] )
	else return ( NULL);
	}
*/
	void get_scet( VGR_SCET& tmp_scet, SFOC_SCLK_TIME new_sclk = cur_sclk);
        SDR_TIME_DCL get_store_ert(const SFOC_ERT_TIME& sfoc_ert );

	void write_edr_rec(int FINAL, int decom_sw, int record_processed);
	int  golay_reed_status();
	int  get_bit_rate_index(unsigned long bit_rate);
	SFOC_SCLK_TIME set_sclk(vgr_sfdu& sfdu_obj);
	void store_or_write_MFs( vgr_sfdu& sfdu_obj, int FINAL, int record_processed);
  	void set_mf_dt_presence(int MF_no, U8* data_presence);
	void allocate_data_buf();
        void set_subhdr(vgr_sfdu& sfdu_obj, U16 m16, U16 MF_no, U16 m60,
                        U16 ln_cnt);
	void subhdr_bit_copy(U8 subhdr[], U8 sfdu_data[],
	         int start_bit,  int bit_len);
        void extract_hdr(EDR_STND_HDR* map_tbl, int max_item, vgr_sfdu& sfdu_obj);


//  	void read_write_decom(FILE * output_fd);
	void read_write_decom(int instr_number);
//	void read_write_decom(void);
	void debug_print(const char* name, U8* buf, int len);
	void debug_print(const char* name, int len);
        void print_final_status( FILE* msg_Fd);

};

#endif 
