/**************************************************************************
TITLE:  vgr_sfdu2edr.C

AUTHOR:         Ray Bambery
CREATED:        Aug 4, 1994
COMPILER:       gcc 4.5.2
OS:		Solaris 10.2

COMPILER:	gcc 7.1
OS:		Centos7

modified:	Ray Bambery - 9-22-2020
		removed sfdu_pointer=ffffffffx logic
		it may have worked in 1994 but Judy's code in vgr_edrgen
		doesnt work with gcc/g++ v4.5.2 in 2020
		got rid of "if (sfdu_pointer == NULL || == (U8*)0xffffffff)"
		put in proper coding in vgr_edr_main.c to make logic work	

		Ray Bambery - 3-5-2021
		extracted main() from vgr_edrgen.C
		replaced this routine in edr2/edr/edr in place of vgr_edr_main.c
		located in /edr2/edr/ted
		Ray Bambery - 3-13-2021
		removed type_test prototype, added detailed comments
		Ray Bambery - 3-17-2021
		updated doc, fixed parameter checks in check_input
		Ray Bambery - 3-30-2021
		Put back in FINAL option for edr_type
		Ray Bambery - 4-2-2021
		Add check for argv[5] and it is "d" or "D" and then print out
		certain debug statements
		Ray Bambery - 4-6-2021
		passed record_processed thru  
		if argv[5] = d2 or D2 debug_on =2
		Ray Bambery - 5-17-2021
		added debug_on lines where necessary
		Ray Bambery - 6-8-2021
		fixed argc,argc checks in code due to aborts in argv[5]
		Still getting failures in read_sclk.c when not in debug mode.
		Get abort msg at varying points when reading SCLK_SCET.31 or
		SCLK_SCET.32
		Msg: 
		sclkentry = 2031072
  		sclkentry = 2031112 sclk_erows = 19
		read_sclk: START  sclk_rSegmentation Fault (core dumped)
		Ray Bambery - 8-25-2021 
		Add comments about FINAL beceause of missing eng and decom data
		in FINAL (weekly) products
		Ray Bambery - 11-18-2021
		flag freads and fwrites in debug statements
		Ray Bambery - 12-09-2021
		detect if input data is byte swapped and abort if so
		Ray Bambery - 01-07-2022
    		final debug printfs removed (//#)
		add help message if argc < 2)	
		Ray Bambery - 01-09-2022 
                Make beg_ert_day and first_rec global
                Make final_cleanup rename files to first_rec DOY
		Ray Bambery - 01-10-2022
		Remove all beg_ert_day printfs
		Ray Bambery - 02-04-2022 
                recopy strcpy(&scet_file_name[0], argv[2]); after NOW statement
		somehow forgets assignment in check_input

	*****   Ray Bambery - 04-07-2022 
	*****   The software was found to work differently in debug=1 and non-debug mode
	*****   for weekly (FINAL) edrs. In debug mode it gives he correct engineering
	*****   records while in non-debug mode it gives excessive numbers of them.
	*****   There are 70 of (debug_on == 1) clauses in the 4 source files for vgr_edr.
	*****   Systmattically, 5 such clauses will ne commented out in each of the
	*****   source files until the debug mode gives bad results.
'	*****
		Ray Bambery - 04-08-2022
		put in debug= 10 option
**************************************************************************
References:
1) 618-306_Rev. D, CHG 4 Voyager Experiment Data Record Format - 1 May 1986
2) 618-306_RevD_ch5 - 1 May 1989       CR5A format 
3) 618-609_RevB_chg6_VGR_swreq_edr - 2 June 1986
4) 820-013_0171-telecomm-VGR-NJPL-Rev G Appendix_L5 - 9-29-2009
5) 820-013_0161-Telecomm_RevB-L5 - 19 Nov 2014
6) 820-013_0172-Telecomm-CHDO_RevI-L5-1 - 10-03-2019


routine			calls		located in
main			check_input	vgr_sfdu2edr
			vgr_edrgen	vgr_edrgen
			C16_TO_I16	type_conv.H
check_input		<none>
final_cleanup		<none>


This is the main routine that builds program vgr_edr executable
argv requires 4 arguments
1 - input file = datafile.a or datafile.b - a type 2 sfdu formatted file
2 - scet file = SCLK_SCET.31 or SCLK_SCET.32 - a type 3 sfdu formatted file
3 - edr type  = "QUICK_LOOK" or "FINAL"  = a QUICKLOOK edr is from one nightly
		datafile run. "FINAL" (sometimes referred to as weekly) uses 
		a datafile which is a summary of all downlinks for a week. 
4 - destination = "OUTPUT" = a holdover term from an older version of this routina
		internally it was the destination
		it encompasses the following output files
		crs_edr, eng_edr, lec_edr, mag_edr, pls_edr, pra_edr,
		pws_edr, uvs_edr and vgr_msg file
5 - debug (optional) = "d" or "D" or "d2" or D2" - write out debug printf statments

This routine reads all records in the datafile and stores them in in_buf;
Each record replaces in_buf from 0 thru 357 bytes and then goes into vgr_edrgen.
Total records read into datafile is stored in rec_no.
	
*****************************************************************************Z
HISTORY:
 IN 2020 the Voyager project wanted to modify the VGR_EDR routine that
 converts a type 2 sfdu into instrument edrs.  The source code for the 
 existing VGR_EDR had become blurred.  It was not sure whether the code
 existing in /export/home/nertops/ron/edr mapped to VGR_EDR on its old
 SunOS 5.2 computers. That directory had a large number of duplicate
 routines modified from 1994 through 2002. The versions were almost
 the same. No comments were easily discernable as to what went into VGR_EDR.

 Furthermore, there was no readily accessible documentation of the data formats
 and how the code was supposed to work. Ultimately, documents showing the
 format of the sfdu type 2 and edrs for the various instruments at different
 cruise and enounter phases were found.
 
 In addition, other parts of the code were missing and had to be restored 
 from the archive.

 Specifically the source code for the ted tree with produces libted.a were
 missing. Eventually they were found and restored.

 Problems ensued when the makefiles were run. Many modules had problems compiling
 under the /tpc/bin/gcc compiler under Solaris 10.2. They were slowly fixed.

 Ultimately, a shock virtual machine (shock3-vm) was created behind the 
 firewall and the last remaining crashes were fixed.

 Fernando Peralta provided a video of the working widget from behind the 
 firewall to help in the debugging process.

 The master code for the original VGR_EDR widget processing is now stored under
 /export/home/rjb/VGR_EDR_widget on shock3-vm

 The driver in that older VGR_EDR code was called vgr_edr_main.c. It allowed
 for different inputs: 1 - data file, 2 - TDS link to an socket, 3 - a pointer
 to an oracle data base to find the data. Further more is created a X-motif
 widget to allow the user to drive the processing.

 The TDS link required a library libted.a in the link statement. The library
 located in a separate directory called ted was removed in this version.

 This routine vgr_sfdu2edr.C replaced vgr_edr_main.c. It removed the widget,
 the oracle database calls and the TDS link.  Another program called 
 data_fetch retrieves the the input to this routine, datafile.a for VGR1
 or datafile.b for VGR2.

 THe output of this routine is now vgr_edr and not VGR_EDR, to distinguish
 it from the X-Motif widget version.

 In the execution of vgr_edr it expects ain input  file name datafile.a or 
 datafile.b. When it opens the instrument edr files it does so with the
 temporary names crs_edr, lec_edr, mag_edr, pls_edr, pra_edr, pws_edr, uvs_edr
 and eng_edr. As the program ends it renames them to crsYRDOY.a or crsYRDOY.b,
 lecYRDOY.a or .b magYRDOY.a or .b plsYRDOY.a or .b, praYRDOY.a or .b pwsYRDOY.a
 or .b uvsYRDOY.a or .b in the routine final_cleanup.
 
 The YR and DOY come from cur_ert.hour/24 where cur_ert is from  last record
 read from the datafile.a or datafile.b. This had the advantage of always
 creating the correct output edr filenames from datafile even if you didn't
 know the origin of datafile.a or datafdile.b.
 
 This was no problem for the daily edrs. However, in the formalism designated
 by the Voyager project required the weekly edrs be given the YR and DOY of
 the first record so the filenames always comes out wrong for the weekly edrs.

****************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "vgr_struc.H"
#include "vgr_edr.H"
#include "vgr_sfdu.H"
#include "vgr_scet.h"


/* prototypes */
int  main(int, char**);
extern int vgr_edrgen(unsigned char*,char*, int, int);
int  check_input(int, char**);
void final_cleanup();

extern int  debug_on;
extern int  FINAL;
char scet_file_name[80];

extern int      beg_ert_day;
//int      first_rec = TRUE;
extern int	record_processed;  //sfdu_record processed 
extern FILE   	*msg_fd;

//---------------------------------------------------------------------

int main(int argc, char* argv[])
{

static U8 in_buf[358];   //formerly 5000
static int rec_no;
FILE* in_fd;
int total_read;
int i, ii,len;
int done, val_read;
U8 lable[5] = "NJPL";
U8 rev_lable[5] = "JNLP";

rec_no = 0;
debug_on = 0;		//no debug unless arg[5] says "d", "D", "d2" or "D2"

// Typical command line is:
// DAILY: vgr_edr /home/nertops/32/datafile.b /home/rjb/32/SCLK_SCET.32 QUICK_LOOK OUTPUT
// WEEKLY: vgr_edr /home/nertops/32/datafile.b /home/rjb/32/SCLK_SCET.32 FINAL OUTPUT
//#printf ("argc = %d\n",argc);
    if (argc < 2 ){
        printf("usage: vgr_edr input_file scet_file edr_type destination [debug_option (optional)] \n");
        exit(0);
    }  

printf ("argv[1] = %s\n",argv[1]);
printf ("argv[2] = %s\n",argv[2]);
printf ("argv[3] = %s\n",argv[3]);
printf ("argv[4] = %s\n",argv[4]);
if (argc > 5) {
	printf ("argv[5] = %s\n",argv[5]);
}
// check that arguments are valid 
// opens input datafile.a or datafile.b - references in_fd
if ( check_input(argc, argv) ) {

  if ((in_fd = fopen(argv[1],"r")) == NULL) {

	printf("vgr_sfdu2edr: can't open input file %s \n",argv[1]);
      exit(0);
  }
//#  printf ("vgr_sfdu2edr:  (datafile)  in_fd = %x\n",in_fd);
}
// check to see if edr_type is FINAL
// QUICK_LOOK is daily and does not include eng and decom
// FINAL is weeekly and does include them
FINAL = 0;		//default: "QUICK_LOOK"
if(strcmp(argv[3],"FINAL") == 0) { FINAL=1;}

if (argc > 5) {
    if (strcmp(argv[5], "d")  == 0){
       debug_on = 1;
	printf ("debug_on = 1\n");
    }
    if (strcmp(argv[5], "D") == 0){
       debug_on = 1;
	printf ("debug_on = 1\n");
    }
    if (strcmp(argv[5], "d2") == 0){
       debug_on = 2;
	 printf ("debug_on = 2\n");
    }
    if (strcmp(argv[5], "D2") == 0){
       debug_on = 2;
	 printf ("debug_on = 2\n");
    }
    if (strcmp(argv[5], "d3") == 0){
       debug_on = 3;
         printf ("debug_on = 3\n");
    }
    if (strcmp(argv[5], "D3") == 0){
       debug_on = 3;
         printf ("debug_on = 3\n");
    }
    if (strcmp(argv[5], "d10") == 0){
       debug_on = 10;
         printf ("debug_on = 10\n");
    }
    if (strcmp(argv[5], "D10") == 0){
       debug_on = 10;
         printf ("debug_on = 10\n");
    }


}
//printf ("vgr_sfdu2edr: scet_file_name =  %s \n", scet_file_name);
// loop thru each record of 358 bytes and process via vgr_edrgen
while( TRUE) {
    done = FALSE;
    while (!done) {
        /* test for legitimacy of datafile 	*/
	/* read 1st 4 bytes of datafile (in_fd) */
	/* should be 78,74,80,76 = "NJPL" 	*/
//	printf ("NJPL\n");
//
/* D-1 
	if (debug_on == 1) {
	   printf (">>>>>>>>>>>>>>>>>>>>>>>>> FREAD for NJPL from datafile (in_fd)\n");
        }
*/
      for (i = 0; i < 4; i++) {
	  val_read = fread(&in_buf[i], 1, 1, in_fd);
          if ((val_read) <= FALSE) {
	     
	     vgr_edrgen((U8*)NULL, scet_file_name, debug_on, FINAL );
//		printf(" vgr_sfdu2edr:: scet_file_name (fread) = %s \n", scet_file_name);
             exit(FALSE);
	  }

               if (debug_on == 2) {
                      printf(" #[%d]=%x", i, in_buf[i]);
               }

          if (in_buf[i] != lable[i])
             break;
      }
	/* check and see if byte swapped */
	if (strncmp((const char*)in_buf,(const char *)rev_lable,4) == 0) {
		printf ("vgr_sfdu2edr:: \n");
        	printf ("\nDATA SET is Byte reversed\n");
	        printf ("PLEASE run byteswap program\n\n");
        	exit(0);
	}
      if (i == 4)
         done = TRUE;
     }
  // following are sfdu type 2 labels
  // starting in in_buf[4] read 20 + 4
// D-2
  if (debug_on == 1) {
  	printf (">>>>>>>>>>>>>>>>>>>>>>>>>>>>> FREAD 1st 2 of 4 labels in sfdu2 datafile\n");
  }
//
  if(fread(&in_buf[4], 1, PRIM_LABL_LEN + AGGR_CHDO_LEN - 4, in_fd)) {
  
  total_read =  PRIM_LABL_LEN + AGGR_CHDO_LEN; 		//24 bytes
// D-3
  if (debug_on == 1) {
  	printf (">>>>>>>>>>>>>>>>>>>>>>>>>>>>> FREAD remaining labels in sfdu2 datafile\n");
  }
//
  for (i = 0; i < MAX_HDRS; i++)
  {
    if(!fread(&in_buf[total_read], 1, 4, in_fd))
    {
	printf(" eof!!\n");
        exit(0);  
    }     
	
    len = C16_TO_I16(&in_buf[total_read + 2]);
    total_read += 4;
	//    printf("  ==len = %d  ", len);
	// pass onto vgr_edrgen  
    if (!fread(&in_buf[total_read], 1, len, in_fd))
    {
      vgr_edrgen(NULL, scet_file_name, debug_on, FINAL);
      printf(" eof!!\n");
      exit(0);
    }	
    total_read += len;
  }
// now have read in all 358 bytes of each record (all records are in rec_no) in datafile.b
  rec_no ++;
// D-4 - add debug = 10
  if (debug_on == 1 || debug_on == 10) {
  	printf("\n==================== sfdu RECORD # %d ===========================\n",rec_no);
  	printf("                   in_buf address = %0x\n", in_buf);
  }
//
  fflush(stdout);
  strcpy(&scet_file_name[0], argv[2]);
  //make final call to vgr_edrgen to get last sfdu2 record
// D-5
  if (debug_on == 1) {
  	printf ("vgr_sfdu2edr:: NOW process (vgr_edrgen) the data part of datafile record\n");
	printf(" vgr_sfdu2edr:: scet_file_name = %s \n", scet_file_name);
  }
//
  vgr_edrgen(in_buf, scet_file_name, debug_on, FINAL); 
  }
}
}
//---------------------------------------------------------------------
int check_input(int argc, char** argv) {
  
 
// FILE* fd;
//   input: VGR_EDR datafile.a SCLK_SCET.31 QUICK_LOOK OUTPUT
//
//        printf ("vgr_edr_main: datafile:   argv[1] = %s\n",argv[1]);   datafile.a
//        printf ("vgr_edr_main: scet_file:  argv[2] = %s\n",argv[2]);	 SCLK_SCET.31
//        printf ("vgr_edr_main: edr_type:   argv[3] = %s\n",argv[3]);   "QUICK_LOOK"
//        printf ("vgr_edr_main: data_dest:  argv[4] = %s\n",argv[4]);   "OUTPUT"
//        peintf ("vgr_edr_main: debug: [optional] arg[5] = %s\n",argv[5]; "d"    
   if (argc < 2){
      printf("usage:  vgr_edr infile scet_file edr_type edr_destination\n");
      exit(0);
   }
   else {
//	printf ("argc = %d\n",argc);
       if (argc > 2) {
   //     strncpy(&scet_file_name[0], argv[2], strlen(argv[2]));
          strcpy(&scet_file_name[0], argv[2]);
          printf(" +++ %s \n", scet_file_name);
       }
       else {
          strcpy(&scet_file_name[0], "./scet1.out");
       }
       if (argc > 3) {
	  if (strcmp(argv[3],"QUICK_LOOK") == 0 || strcmp(argv[3],"FINAL") == 0) {
	 } else {
	    printf ("edr_type not QUICK_LOOK or FINAL\n");
	   exit(0);
          }
       }
       if (argc > 4) {
	  if (strcmp(argv[4],"OUTPUT") == 0 ) {
	 } else {
		printf ("data_dest not OUTPUT\n");
		exit(0);
	  }

       }
       if (argc > 5) {
          if (strcmp(argv[5], "D") == 0){
             debug_on = 1;
//		printf ("Debug_on = 1\n");
          }
       }
//OBSOLETE
//       if (argc > 4) {
//          if (!strncmp(argv[6], "Y", 1) || !strncmp(argv[4], "y", 1)){
//             FINAL = TRUE;
//          }
//       }

     }

   return(1);
}
//-------------------------------------------------------------------
void final_cleanup()
{
/* rename vgr_msg file  to vgr_msg.ERTYEAR ERTDOY */
/*  1-09-2022 - make routine use first DOY */ 
   char  _sc;
 
   char cmd[80]="";
   int  ert_day; 				// = vgr_edr::cur_ert.hour/24;
	ert_day = beg_ert_day;

//   printf ("finale_cleanup - beg_ert_day = %d\n",beg_ert_day);
   if (vgr_edr::sc_id > 0) _sc = 'a';
   else  _sc = 'b';

   fclose(msg_fd);
   sprintf(cmd," mv %s  %s.%d%c", MSG_FILE_NAME,
               MSG_FILE_NAME,beg_ert_day,_sc);
//	printf ("final_cleanup: %s\n",cmd);
   system (cmd);
}
/************************************************************************
 * OBSOLETED Routines:
 * open_file
 * sfdu_edr_hdr_cp
 ***********************************************************************/
//---------------------------------------------------------------------
/*
FILE* open_file(char file_name[], char type[])
{
FILE *fds;
char err_msg[50];

     if ((fds = fopen(file_name, type)) == NULL)
     {
       sprintf(err_msg,"can not open file- %s\n", file_name);
       exit(0);
     }

     return fds;
}
//--------------------------------------------------------------------
 void sfdu_edr_hdr_cp() {
*/
