/**************************************************************************
TITLE:  vgr_edrgen.C

AUTHOR:         Judy Yin
CREATED:        Aug 4, 1994
COMPILER:       gcc 4.5.2
OS:		Solaris 10.2
modified:	Ray Bambery - 9-22-2020
		removed sfdu_pointer=ffffffffx logic
		it may have worked in 1994 but Judy's code in vgr_edrgen
		doesnt work with gcc/g++ v4.5.2 in 2020
		got rid of "if (sfdu_pointer == NULL || == (U8*)0xffffffff)"
		put in proper coding in vgr_edr_main.c to make logic work	
		Ray Bambery - 3-6-2021
		removed vgr_edr_main.c from build - replaced it with vgr_sfdu2edr.C
		Put if (sfdu_pointer == NULL) below
		Ray Bambery - 3-13-2021
		added detailed comments.
		Ray Bambery - 3-30-2021
		made sure FINAL was implemented properly
                Ray Bambery - 5-17-2021
                added debug_on lines where necessary
		Ray Bambery - 6-8-2021
		checked out all if (debug_on == 1) statements for non printf statements
		due to failures in read_sclk.c when not in debug mode.
                Get abort msg at varying points when reading SCLK_SCET.31 or
                SCLK_SCET.32
                Msg: 
                sclkentry = 2031072
                sclkentry = 2031112 sclk_erows = 19
                read_sclk: START  sclk_rSegmentation Fault (core dumped)
                Ray Bambery - 8-25-2021 
                Add comments about FINAL beceause of missing eng and decom data
                in FINAL (weekly) products
		Ray Bambery - 10-12-2021
		fix output to msg_fd in
		//           first_rec = FALSE;         //now reset 
		//           vgr_edr::print_time_msg("ENDING",msg_fd);
		Ray Bambery - 11-18-2021
		mods to find out why it gives too many DCOM tables and ENG records
		in FINAL (weekly) runs
		Ray Bambery - 12-09-2021 
		change write_edr_rec(FINAL_sw, NULL); to write_edr_rec(FINAL_sw, 0); 
		Ray Bambery - 01-07-2022
    		final debug printfs removed (//#)	
		Ray Bambery - 1-9-2022
                reversed order of statements in routine vgr_edrgen toggling first_rec
		after print_time_msg
		Ray Bambery 01-10-2022
		remove
                Ray Bambery - 04-08-2022
                put in debug= 10 option
		add record_processed parameter to write_edr_rec 
		Ray Bambery - 5-19-2022
		change open on MSG_FILE from +a to w
                D-00 numbers refer to debug printouts in log in order seen 
                when debug_on == 1 or 10

********************************************************************************************
References:
1) 618-306_Rev. D, CHG 4 Voyager Experiment Data Record Format - 1 May 1986
2) 618-306_RevD_ch5 - 1 May 1989       CR5A format 
3) 618-609_RevB_chg6_VGR_swreq_edr - 2 June 1986
4) 820-013_0171-telecomm-VGR-NJPL-Rev G Appendix_L5 - 9-29-2009
5) 820-013_0161-Telecomm_RevB-L5 - 19 Nov 2014
6) 820-013_0172-Telecomm-CHDO_RevI-L5-1 - 10-03-2019

This routine:
1) determines if it generates weekly or daily edrs
2) determines if debug flag is on/off
3) reads SCLK_SCET file
4) checks to see if were reading last record of datafile
5) if not, loads sfdu data
6) calls vgr_edr  routines to create all edrs
7) on return, prints summary message

This routine is called from vgr_sfdu2edr.C. for each record of the sfdu file
datafile. It calls vgr_sfdu.C to extract data from the datafile and then
calls vgr_edr.C to create the edrs for the various instruments.

The calls to vgr_sfdu and vgr_edr are done thru the static calls right
before the definitions.

The call to vgr_sfdu() merely flushes out the  buffers.
The call to vgr_edr() opens all the output edr files and the msg file.
The real processing begins on the call 
1)  sfoc_data.load_data_from_buf
2)  vgr_edr::fill_cur_stat_tbl(sfoc_data);
3)  vgr_edr::fill_last_stat_tbl(sfoc_data);
4)  vgr_edr::init_format_id(sfoc_data);
5)  edr[instr_id].store_or_write_MFs(sfoc_data, FINAL_sw);
6)  vgr_edr::last_stat_tbl_changed() 
7)  vgr_edr::data_mode_changed())
8)  vgr_edr::fill_last_stat_tbl(sfoc_data);
9)  vgr_edr::store_last_sclk( sfoc_data.get_sclk());
**************************************************************************
Routines contained:
vgr_edrgen
type_test
final_cleanup

Routines removed:
open_file
MY_OWN_TEST routines - standalone tests used in original coding
**************************************************************************
routine			called by			location
vgr_edrgen		vgr_edr_main
vgr_edr			vgr_edrgen
vgr_sfdu		vgr_edrgen
type_test		vgr_edrgen
open_file		<none>
check_input		MY_OWN_TEST
final_cleanup		vgr_edrgen

routine			calls
main			check_input
			vgr_edrgen
			C16_TO_I16
vgr_edrgen		vgr_sfdu			vgr_sfdu.C
			vgr_edr 			vgr_edr.C
			scet_load_file  		vgr_scet.c
			final_cleanup			vgr_sfdu2edr
			sfoc_data.load_data_from_buf	vgr_sfdu.C
			vgr_edr::fill_cur_stat_tbl	vgr_edr.C
			vgr_edr::fill_last_stat_tbl	vgr_edr.C
		        vgr_edr::init_format_id		vgr_edr.C
			vgr_edr::print_time_msg		vgr_edr.C
check_input		<none>				vgr_sfdu2edr.C
final_cleanup		<none>				vgr_sfdu2edr.C

****************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "vgr_struc.H"
#include "vgr_edr.H"
#include "vgr_sfdu.H"
#include "vgr_scet.h"


//FILE *fd;
int  debug_on;
int  FINAL;
extern char scet_file_name[80];
extern void final_cleanup(void);

int      first_rec = TRUE;
int      record_processed = 0;
FILE   		*msg_fd;		//vgr_msg file


//------------------------------------------------------------
int vgr_edrgen
(U8* sfdu_pointer, char* scet_file_name, int debug_sw, int FINAL_sw)
{
// the following 2 calls invoke vgr_sfdu to read in the datafile data
// and vgr_edr to create the output edrs
static vgr_sfdu    sfoc_data;
static vgr_edr     edr[MAX_INSTR_NUM] ={ CRS,LECP,PLS,PRA,PWS,UVS,ENG,MAG};
					// need to init in this sequence
  int   instr_id;
  int 	buf_len;


  debug_on = debug_sw;		//if argv[5] is "D" or "d"
//  debug_on = 1;
  FINAL	   = FINAL_sw;   //=0 if DAILY =1 if WEEKLY
//#	printf ("vgr_edrgen:  Entry  FINAL = %d\n",FINAL);
// D-6
  if (debug_on == 1) {
	printf ("vgr_edrgen: FINAL (WEEKLY) edr being generated = %d\n",FINAL);
	printf ("vgr_edrgen: Entry  (TODAY) sfdu_pointer = %0xx\n",(U8*) sfdu_pointer);
  }
//
// FIRST RECORD  LOAD scet file
  if (first_rec) 
  {
// D-7
if (debug_on == 1) { 
		printf ("vgr_edrgen: first_rec - scet_file_name = %s\n",scet_file_name);
}
// 5-19-2022 - change +a to w
        msg_fd = fopen(MSG_FILE_NAME, "w");
	if (msg_fd == NULL)
	{
	   printf("vgr_edrgen: can not open file-  %s with a+ \n", MSG_FILE_NAME);
	}

       if (!strlen(scet_file_name))
       {
          strcpy(scet_file_name, "./SCET/scet1.out");
       }
// D-8
	if (debug_on == 1) {
       		printf ("vgr_edrgen:  .... loading scet coeffcient file  -- %s!\n", scet_file_name);
	}
//
       if (scet_load_file(scet_file_name) < FALSE ) {
          printf("vgr_edrgen:  ERROR: scet_load_file fail !!! \n");
          return(FALSE); 
       }
  }  //first_rec
//                                       if (debug_on == 2 )  type_test();

/*******************************************************************************
//// judy changed the following to (== NULL || (U8*0xffffffff)
////  comparison of sfdu_pointer with (-1) without casting to int is now illegal
  //if (sfdu_pointer == NULL)  // this is paired with the else if
  //JUDY's PATCH -temp!!

//// Ray Bambery's logic changes are from vgr_edrgen routine in vgr_main.C
//// which is no longer built  - vgr_main.C took account of oracle db and
//// setting up X-motif widget configuration
////
////  if (sfdu_pointer == NULL || sfdu_pointer ==  (U8*)0xffffffff) 
*******************************************************************************/

// LAST RECORD??
// D-9
	if (debug_on == 1) printf ("vgr_edrgen: sfdu_pointer = %x\n",sfdu_pointer);
//
   if (sfdu_pointer == NULL)       ///(U8*)0xffffffff)      //// NULL   drop || == (U8*)0xffffffff
  {
// D-10
	if (debug_on == 1) {
		printf(" vgr_edrgen: sfdu_pointer=NULL\n");
		printf("             --- writing last record !\n");
		printf ("vgr_edrgen: before edr.write_edr_rec   FINAL_sw = %d\n",FINAL_sw);
	}
//
//#	printf ("vgr_edrgen: before edr.write_edr_rec   FINAL_sw = %d\n",FINAL_sw);
    for (instr_id = 0; instr_id < MAX_INSTR_NUM; instr_id++)
    {
	edr[instr_id].write_edr_rec(FINAL_sw, 0, record_processed);
    }

//	printf ("vgr_edrgen::  print_final_status\n");
    for (instr_id = 0; instr_id < MAX_INSTR_NUM; instr_id++)
    {
	edr[instr_id].print_final_status( msg_fd);
    }

	vgr_edr::print_time_msg("ENDING", msg_fd);    
	final_cleanup();
// D-11
	if (debug_on == 1) {
		printf ("vgr_edrgen: returning- after final_cleanup----\n");
	}
//
    return(0);
  }  /* return if no data  */

  else   //YOU CAN use next line to try -JUDYi - a very OLD comment (RJB)
//   else if (sfdu_pointer != 0xffffffff)   - RJB changed this to just "else"
  {
// D-12
	if (debug_on == 1) {
		printf ("vgr_edrgen: sfoc_data.load_data_from_buf(sfdu_pointer=%x)\n",sfdu_pointer);
		printf ("            NOW loading SFDU file (datafile.a or datafile.b)\n");
	}
//
//#		printf ("            NOW loading SFDU file (datafile.a or datafile.b)\n");
// buf_len = 358 - end of 1st record of SFDU
	buf_len = sfoc_data.load_data_from_buf(sfdu_pointer);
// D-13
	if (debug_on == 1) {	
		printf ("vgr_edrgen:  buf_len = %d is beginning of next sfdu2 record\n",buf_len);
	}
//
	/* added 11-19-2021  RJB - This does not seem to occur in normal processing 
 	 *   It could be 0 if routine vgr_sfdu::get_prim_labl_hdr (NJPL2I00C220) is bad.
 	 *   For example, C220 is CR5A or C221 is UV5A are the only modes processed in this routine.
 	 *   If data is from any other mode, it will fail and return 0   
 	 *   This is why I exit.
 	 **/
	if (buf_len == 0) {
		printf ("vgr_edrgen:  WARNING::  buf_len return from sfoc_data.load_data_from_buf == 0\n");
		exit(1);
	}
        if (buf_len)  
        {
// D-14 
		if (debug_on == 1)
			printf(" buf_len> 0--- before fill_cur_stat_tbl \n");
//
	    record_processed++;
// D-15
	    if (debug_on == 1) {
		printf ("vgr_edrgen:: record_processed = %d\n",record_processed);
	    }
//
	    vgr_edr::fill_cur_stat_tbl(sfoc_data);       
//      						sfoc_data.hdr_validate();

//      correct data
//			if (debug_on == 2)
//			  edr[0].debug_print("vgr_edrgen: hdr 2", 4);
           if (first_rec) 
           {
	     if (debug_on == 2) {
		printf ("vgr_ergen: first_rec 2nd time\n");
	     }
             vgr_edr::fill_last_stat_tbl(sfoc_data);
	     vgr_edr::init_format_id(sfoc_data);
/*  No longer write decom data  ==  Somebody's comment from before 9-20-2020  
 *
 *	     for (instr_id = 0; instr_id < MAX_INSTR_NUM; instr_id++)
 *	     {
 *		vgr_edr::read_write_decom( vgr_edr::get_file_ptr(instr_id) );
 *		edr[instr_id].read_write_decom( instr_id );
 *	     }
 *
 *	     first_rec = FALSE;		//now reset 
 *	     vgr_edr::print_time_msg("ENDING",msg_fd);
 */
           } //first_rec
/*   Also removed earlier than 9-22-2020
 *         if ( !vgr_edr::comp_last_stat_tbl_clk(sfoc_data)) [
 *           for (instr_id = 0; instr_id < MAX_INSTR_NUM; instr_id++) [
 *               edr[instr_id].prepare_and_write();
 *           ]  
 *           vgr_edr::fill_last_stat_tbl(sfoc_data);
 *        ]
 *    ] ///
 */
	    if (debug_on == 2) {
		printf("vgr_edrgen: Not or after first rec  2nd time - loop thru instrums\n");
	    }
            for (instr_id = 0; instr_id < MAX_INSTR_NUM; instr_id++) 
            {
/*        Removed before 9-22-2021 
 *             edr[instr_id].extract_hdr( sfoc_data);
 *             edr[instr_id].store_or_write_MFs(sfoc_data, scet_co);
 *		if (instr_id == ENG)	
 *
 *        FINAL_sw = TRUE;    // this was set TRUE by some earlier programmer
 */
// D-16
		if (debug_on == 1) {
	   		printf ("vgr_edrgen:  before store_or_write_MFs  instr_id = %d\n",instr_id);
		}
//
               edr[instr_id].store_or_write_MFs(sfoc_data, FINAL_sw, record_processed);
                        if (debug_on == 2 )
                          edr[instr_id].debug_print("vgr_edrgen: hdr 4 ", 4);
            } 
// D-17 - added debug 10
		if (debug_on == 1 || debug_on == 10) {
			printf ("finished looping thru instruments\n");
		}
//
       }   /* end of if buf_len>0 */

       if (vgr_edr::last_stat_tbl_changed() || vgr_edr::data_mode_changed()) {
//		printf ("vgr_edrgen:: last_stat_tbl_changed or data_mode_changed\n");
          	vgr_edr::fill_last_stat_tbl(sfoc_data);
	}

       vgr_edr::store_last_sclk( sfoc_data.get_sclk());

       if (first_rec == TRUE)
       {
	  if (debug_on == 2) {
		printf ("vgr_ergen: first_rec 3rd time\n");
	  }
	/* print this message at end of log */
          vgr_edr::print_time_msg("BEGINNING", msg_fd);
	  first_rec = FALSE;    /* toogle off */
       }

    } /* end else - we processed valid data */ 
    if (debug_on == 2) {
		printf("vgr_edrgen: return (TRUE)\n");
    }
  return(TRUE);      
} 
//---------------------------------------------------------------------
void type_test(){
/* only used for debugging purposes */
     printf("unsigned short = %d \n", sizeof(unsigned short));
     printf("unsigned int   = %d \n", sizeof(unsigned int));
     printf("unsigned long  = %d \n", sizeof(unsigned long));
}

/*---------------------------------------------------------------------
   Deleted routines - before 9-22-2020
//---------------------------------------------------------------------

FILE* open_file(char file_name[], char type[])
{
    FILE *fds;
    char err_msg[50];

    if ((fds = fopen(file_name, type)) == NULL)
    {
        sprintf(err_msg,"can not open file- %s\n", file_name);
        exit(0);
    }

    return fds;
}
*/

