pro sc2eci_mat,q,s2emat
; build transformation matrix (spacecraft -> eci) from quaternions
; q - attitude quaternions (4,n)
; s2emat - transformation matrices(3,3,n)


n=n_elements(q(0,*))
s2emat=dblarr(3,3,n)

s2emat(0,0,*)=q(0,*)^2-q(1,*)^2-q(2,*)^2+q(3,*)^2
s2emat(1,1,*)=-q(0,*)^2+q(1,*)^2-q(2,*)^2+q(3,*)^2
s2emat(2,2,*)=-q(0,*)^2-q(1,*)^2+q(2,*)^2+q(3,*)^2
s2emat(0,1,*)=(2d)*(q(0,*)*q(1,*)+q(3,*)*q(2,*))
s2emat(0,2,*)=(2d)*(q(0,*)*q(2,*)-q(3,*)*q(1,*))
s2emat(1,0,*)=(2d)*(q(1,*)*q(0,*)-q(3,*)*q(2,*))
s2emat(1,2,*)=(2d)*(q(1,*)*q(2,*)+q(3,*)*q(0,*))
s2emat(2,0,*)=(2d)*(q(2,*)*q(0,*)+q(3,*)*q(1,*))
s2emat(2,1,*)=(2d)*(q(1,*)*q(2,*)-q(3,*)*q(0,*))
return
end



