pro xfr2_setup_gui
  @xfr2_common

  device, retain = 2

  ; define widgets
  w_base = widget_base(xsize = 810, ysize = 610, mbar = w_menubar, $
                       title = 'xf_radial2')

  w_base2 = widget_base(w_base, xsize = 195, ysize = 50, xoffset = 610, $
                        yoffset = 5, /exclusive)

  w_button1 = widget_button(w_base2, value = 'MLT', uvalue = 'b_MLT', $
                            /no_release)
  w_button2 = widget_button(w_base2, value = 'Magnetic Longitude', $
                            uvalue = 'b_MLON', /no_release)

  w_draw = widget_draw(w_base, xsize = 600, ysize = 600, $
                       xoffset = 5, yoffset = 5)

  w_label1 = widget_label(w_base, xoffset = 610, yoffset = 105, $
                          value = 'Divisions:')
 
  w_label2 = widget_label(w_base, xoffset = 710, xsize = 95, yoffset = 105, $
                          value = '8', /align_right)

  w_slider1 = widget_slider(w_base, xsize = 195, xoffset = 610, yoffset = 123,$
                            /suppress_value, minimum = 1, maximum = 96, $
                            value = 8, /drag, uvalue = 'w_slider1')

  w_label3 = widget_label(w_base, xoffset = 610, yoffset = 150, $
                          value = 'Offset:')
 
  w_label4 = widget_label(w_base, xoffset = 710, xsize = 95, yoffset = 150, $
                          value = '0.00', /align_right)

  w_slider2 = widget_slider(w_base, xsize = 195, xoffset = 610, yoffset = 168,$
                            /suppress_value, minimum = 0, maximum = 719, $
                            value = 0, /drag, uvalue = 'w_slider2')

  w_label5 = widget_label(w_base, xoffset = 610, yoffset = 195, $
                          value = 'Overlap:')
 
  w_label6 = widget_label(w_base, xoffset = 710, xsize = 95, yoffset = 195, $
                          value = '0%', /align_right)

  w_slider3 = widget_slider(w_base, xsize = 195, xoffset = 610, yoffset = 213,$
                            /suppress_value, minimum = -100, maximum = 500, $
                            value = 0, /drag, uvalue = 'w_slider3')

  w_label7 = widget_label(w_base, xoffset = 610, yoffset = 240, $
                          value = 'L-divisions:')
 
  w_label8 = widget_label(w_base, xoffset = 710, xsize = 95, yoffset = 240, $
                          value = '50', /align_right)

  w_slider4 = widget_slider(w_base, xsize = 195, xoffset = 610, yoffset = 258,$
                            /suppress_value, minimum = 4, maximum = 150, $
                            value = 50, /drag, uvalue = 'w_slider4')

  w_button3 = widget_button(w_base, xsize = 195, xoffset = 610, yoffset = 300,$
                            value = 'Calculate single', uvalue = 'calcsingle')

  w_button4 = widget_button(w_base, xsize = 195, xoffset = 610, yoffset = 326,$
                            value = 'Calculate all', uvalue = 'calcall')
  
  ; define menus
  m_file = widget_button(w_menubar, value = 'File', /menu)
  m_open = widget_button(m_file, value = 'Open FITS file ...', $
                         Event_Pro = 'xfr2_open')
  m_quit = widget_button(m_file, value = 'Quit', Event_Pro = 'xfr2_quit')

  ; default button state
  widget_control, w_button1, /set_button

  ; create hidden buffers
  window, 1, /Pixmap, XSize = 600, YSize = 600
  window, 2, /Pixmap, XSize = 600, YSize = 600 

  ; show window
  widget_control, w_base, /realize

  ; get handles for draw widgets
  widget_control, w_draw, get_value = h_draw

  ; enable events
  xmanager, 'xfr2', w_base, /no_block
end
