pro xfr2_open, ev
  @xfr2_common

  res = dialog_pickfile(dialog_parent = w_base, /read, $
                        filter = '*.fits', /fix_filter, $
                        get_path = path, /must_exist)

  ; if cancelled then just return without changing anything
  if res eq '' then return

  fileOpen = 1
  fileName = res
  curDir = path

  data = readfits(fileName, fitsHead)

  angleMode = sxpar(fitshead, 'ANG_MODE')
  maxL = sxpar(fitshead, 'MAX_L')

  if angleMode eq 0 then widget_control, w_button2, /set_button $
                    else widget_control, w_button1, /set_button

  earthRadius = 300.0D / maxL

  if maxL eq 0 then begin
      tmp = dialog_message(/error, 'FITS header has no entry for maxL.  ' + $
                           'File not loaded.')
      fileOpen = 0
      wset, h_draw
      polyfill, [-1, -1, 2, 2], [-1, 2, 2, -1], color = 0, /normal
      return
  end

  dataLog = alog10(data > 1.0)

  print, min(data)
  
  wset, 2
  tvscl, dataLog

  distUpdated = 0

  ; draw earth circle
  drawcircle, 299, 299, earthRadius, linecolor

  ; draw outer circle
  drawcircle, 299, 299, earthRadius * maxL, linecolor

  widget_control, w_slider4, get_value = v 
  lstep = maxL / double(v)

  xfr2_updatelabels
  xfr2_updateoverlay
end
