pro xf_radial2
  @xfr2_common

  ; figure out what kind of OS is being
  ; used and determine the appropriate
  ; directory delimiter
  case strlowcase(!version.os_family) of
      'unix':    dirDelimiter = '/'
      'windows': dirDelimiter = '\'
      'macos':   dirDelimiter = ':'
      else:      message, 'Unidentified OS: "' + !version.os_family + '"'
  end

  fileOpen = 0
  curDir = ''
  linecolor = 'EEAA44'XL

  angleMode = 1
  angleOffset = 0
  distUpdated = 0
  lstep = 0.5
  nSlices = 8
  relWidth = 1

  ; define widgets for GUI and start the program
  xfr2_setup_gui
end
