; draws an arc from a1 to a2 (radians) at x, y with radius r and color c
pro drawarc, x, y, a1, a2, r, c
  smoothness = 16.0
  circle = fltarr(2, smoothness + 1)
  for i = 0.0, smoothness do begin
      j = i / smoothness * (a2 - a1) + a1
      circle[0, i] = x + r * cos(j)
      circle[1, i] = y + r * sin(j)
  endfor
  plots, circle, /device, color = c, psym = 0
end

