
function zeropad, i, l
  n = fix(i)
  x = strmid(strcompress(string(n)), 1, 1000)
  while(strlen(x) lt l) do x = '0' + x
  return, x
end

pro setupPS, fname
  !p.thick=4
  !p.charsize=1
  !p.charthick=4
  !x.thick=3
  !y.thick=3
  !y.margin=2
  !p.linestyle = 0
  
  !p.font =  0
  set_plot,'ps'
  device, /helvetica
  device,filename=fname
  device,/landscape
  device,BITS = 8, /color

  TVLCT, [0,192,255], [0,192,0], [0,192,0]
end

pro closePS
  device,/close
  !p.thick=1
  !p.thick=1
  !p.charsize=1
  !p.charthick=1
  !x.thick=1
  !y.thick=1
  !p.font = -1
  !x.margin=[10,4]
  !y.margin=[5,2]
; set_plot,'win' ; for windows
; set_plot,'mac' ; for mac
  set_plot, 'x'  ; for linux
end

function fltToStr, f
  ipart = fix(f)
  fpart = fix((f mod 1.0 * 100) + 0.5)
 
  if ipart lt 10 then $
    a = string(format = '(I1)', ipart) $
  else if ipart lt 100 then $
    a = string(format = '(I2)', ipart) $
  else $
    a = string(format = '(I3)', ipart)
  
  if fpart lt 10 then b = string(format = '("0", I1)', fpart) $
                 else b = string(format = '(I2)', fpart)
  return, a + "." + b
end

pro redrawCircle
  @xf_azisum_common
  if fileLoaded then begin
      Device, Copy = [0, 0, 600, 600, 0, 0, 1]
      drawcircle, cir_x, cir_y, re_pix, c_circlecolor, 1
      
      if showOuterCircles then begin
          drawcircle, cir_x, cir_y, cir_r1 * re_pix, c_circlecolor, 0
          drawcircle, cir_x, cir_y, (cir_r1 + cir_thick) * re_pix, $
                      c_circlecolor, 0
      endif
  endif
end

pro xf_azisum_event, ev
  @xf_azisum_common

;  if suspendEvents then return

  suspendEvents = 1

  widget_control, ev.id, get_uvalue = info

  if info eq 'savedata1' then begin
      savemlt = not savemlt
  endif

  if info eq 'savedata2' then begin
      savemlon = not savemlon
  endif

  if info eq 'savegraph1' then begin
      graphmlt = not graphmlt
  endif

  if info eq 'savegraph2' then begin
      graphmlon = not graphmlon
  endif

  if info eq 'text1' then begin
      widget_control, w_text1, get_value = v
      v = float(v)
      if v lt 0.01 then v = 1.10
      if v gt 8.0 then v = 8.0
      widget_control, w_text1, set_value = fltToStr(v)
      widget_control, w_slider1, set_value = fix(v * 100 + 0.5)
      cir_r1 = v
      redrawCircle      
  endif     
  
  if info eq 'text2' then begin
      widget_control, w_text2, get_value = v
      v = float(v)
      if v lt 1.00 then v = 1.00
      if v gt 8.0 then v = 8.0
      widget_control, w_text2, set_value = fltToStr(v)
      widget_control, w_slider2, set_value = fix(v * 100 + 0.5)
      cir_thick = v
      redrawCircle      
  endif     
  
  if info eq 'text3' then begin
      widget_control, w_text3, get_value = v
      v = fix(v)
      if v lt 8 then v = 8
      if v gt 128 then v = 128
      widget_control, w_text3, set_value = zeroPad(v, 0)
      widget_control, w_slider3, set_value = fix(v)
  endif     
  
  if info eq 'slider1' then begin
      v = ev.value / 100.0
      widget_control, w_text1, set_value = fltToStr(v)
      cir_r1 = v
      redrawCircle
  endif

  if info eq 'slider2' then begin
      v = ev.value / 100.0
      widget_control, w_text2, set_value = fltToStr(v)
      cir_thick = v
      redrawCircle
  endif

  if info eq 'slider3' then begin
      v = ev.value
      widget_control, w_text3, set_value = zeroPad(v, 0)
  endif

  if info eq 'draw' and fileLoaded then begin  
      cursor, a, b, /nowait

      if (!mouse.button) eq 1 then begin
          cir_x = ev.x
          cir_y = ev.y

          redrawCircle
      endif 
      if (!mouse.button) eq 2 then begin
          convertxy, ev.x, ev.y, minl, mlt, maglon
          posStr = 'r: ' + fltToStr(minl) + '  (' + fltToStr(mlt) + '/' + $
            fltToStr(maglon) + ')'
          widget_control, w_label2, set_value = posstr
      endif
      if (!mouse.button) eq 4 then begin
reloop:
          groups = 72
          widget_control, w_text3, get_value = groups
          groups = fix(groups[0])
          mltGrpArray = intarr(600, 600)
          mltGrpAvgs = fltarr(groups)
          mltGrpTimes = fltarr(groups)
          mlonGrpArray = intarr(600, 600)
          mlonGrpAvgs = fltarr(groups)
          mlonGrpTimes = fltarr(groups)
          inner = fix(cir_r1 * re_pix)
          outer = fix((cir_r1 + cir_thick) * re_pix)
          minx = cir_x - outer
          maxx = cir_x + outer
          miny = cir_y - outer
          maxy = cir_y + outer
          if minx lt 1 then minx = 1
          if miny lt 1 then miny = 1
          if maxx gt 599 then maxx = 599
          if maxy gt 599 then maxy = 599
          minx = fix(minx[0])
          maxx = fix(maxx[0])
          miny = fix(miny[0])
          maxy = fix(maxy[0])
          x = ''
          x = 1
          y = ''
          y = 1
;          minx = 1
;          miny = 1
;          maxx = 599
;          maxy = 599
          for x = minx, maxx, 2 do begin
              for y = miny, maxy, 2 do begin
                  dist = sqrt(float((cir_x - x) ^ 2 + (cir_y - y) ^ 2))
                  if dist ge inner and dist le outer then begin
                      convertxy, x, y, minl, mlt, maglon
                      mltGrpArray[x    , y    ] = fix((mlt / 24.0D) * groups) + 1
;                      mltGrpArray[x - 1, y    ] = mltGrpArray[x, y]
;                      mltGrpArray[x    , y - 1] = mltGrpArray[x, y]
;                      mltGrpArray[x - 1, y - 1] = mltGrpArray[x, y]
                      mlonGrpArray[x, y] = fix((maglon / 360.0D) * groups) + 1
;                      mlonGrpArray[x - 1, y    ] = mlonGrpArray[x, y]
;                      mlonGrpArray[x    , y - 1] = mlonGrpArray[x, y]
;                      mlonGrpArray[x - 1, y - 1] = mlonGrpArray[x, y]
                  endif
              endfor
          endfor

          z = darray

          min = 1000000
          max = 0

          for i = 0, groups - 1 do begin
              subset = where(mltGrpArray eq (i + 1), count)
              if count lt min then min = count
              if count gt max then max = count
              if count gt 0 then begin
                  mltGrpAvgs[i] = mean(10 ^ darray[subset])
                  mltGrpTimes[i] = ((i + 0.5) / groups) * 24.0
                  displayVal = alog10(mltGrpAvgs[i])
;                  if i mod 2 eq 0 then displayVal = 0 else displayVal = 3
                  z[subset] = displayVal
                  subset = subset + 1
                  z[subset] = displayVal
                  subset = subset + 599
                  z[subset] = displayVal
                  subset = subset + 1
                  z[subset] = displayVal
              endif
              subset = where(mlonGrpArray eq (i + 1), count)              
;              mm = intarr(600,600)
;              mm[subset] = 1
;              tvscl, mm
;              wait, 0.01
              if count lt min then min = count
              if count gt max then max = count
              if count gt 0 then begin
                  mlonGrpAvgs[i] = mean(10 ^ darray[subset])
                  mlonGrpTimes[i] = ((i + 0.5) / groups) * 360.0
              endif
          endfor

          print, 'Minimum subdivision size (pixels): ', min
          print, 'Maximum subdivision size (pixels): ', max
          tvscl, z

;          fname = zeropad(s0year, 4) + zeropad(s0doy,3) + zeropad(s0hour,2) + $
;                  zeropad(s0min, 2) + '_' + zeropad(cir_r1 * 100, 4) + '-' + $
;                  zeropad((cir_r1 + cir_thick) * 100, 4)

          s1 = strpos(f_filename,'/',/reverse_search)
          s2 = strpos(f_filename,'.',/reverse_search)
          fname = strmid(f_filename,s1+1,s2-s1-1)
          
          get_lun, u1
          get_lun, u2
          
          prefix = ''
          widget_control, w_text4, get_value = prefix

          if strlen(prefix) lt 1 then prefix = './'
          if strmid(prefix, strlen(prefix) - 1, 1) ne '/' then prefix = prefix + '/'
          
          if saveMLT then openw, u1, prefix + fname + '.mlt'
          if saveMLON then openw, u2, prefix + fname + '.mlon'
          
          if saveMLT then printf, u1, '; shadowAngle = ', shadowAngle
          if saveMLON then printf, u2, '; shadowAngle = ', shadowAngle

	  if saveMLT then printf, "#            MLT       Avg Count"
	  if saveMLT then printf, "# --------------  --------------"
	  
	  if saveMLON then printf, "#          M-LON       Avg Count"
	  if saveMLON then printf, "# --------------  --------------"
	  
          for i = 0, groups - 1 do begin
              if saveMLT then printf, u1, mltGrpTimes[i], mltGrpAvgs[i]
              if saveMLON then printf, u2, mlonGrpTimes[i], mlonGrpAvgs[i]
          endfor
          if saveMLT then close, u1
          if saveMLON then close, u2
          free_lun, u2
          free_lun, u1

          if saveMLT then print, 'Data written to ' + prefix + fname + '.mlt'
          if saveMLON then print, 'Data written to ' + prefix + fname + '.mlon'

          if graphMLT or graphMLON then begin
              dateStr = stamp1 + ' - ' + stamp2
              
              radiiStr = '  r1 = ' + fltToStr(cir_r1) + ', r2 = ' + fltToStr(cir_r1 + cir_thick)
              window, 5, title = 'Graph'

              if graphMLT and graphMLON then $
                !p.multi = [0, 1, 2] $
              else $
                !p.multi = 0

              if graphMLT then begin
                  plot, mltGrpTimes, mltGrpAvgs, xrange = [-6, 30], xtickinterval = 6, $
                    background = 'ffffff'XUL, color = '000000'XUL, /nodata, $
                    xtickname = ['(18)', '0', '6', '12', '18', '24', '(6)'], $
                    xtitle = 'MLT', ytitle = 'Average intensity', $
                    ymargin = [2.5,2.5], title = 'AZISUM graph, ' + dateStr + radiiStr
                  oplot, [mltGrpTimes - 24, mltGrpTimes, mltGrpTimes + 24], $
                    [mltGrpAvgs, mltGrpAvgs, mltGrpAvgs], color = 'bbbbbb'XUL
                  oplot, mltGrpTimes, mltGrpAvgs, color = '000000'XUL
              endif
              
              if graphMLON then begin
                  plot, mlonGrpTimes, mlonGrpAvgs, xrange = [-60, 420], xtickinterval = 60, $
                    background = 'ffffff'XUL, color = '000000'XUL, /nodata, $
                    xtickname = ['(360)', '0', '60', '120', '180', '240', $
                                 '300', '360', '(60)'], $
                    xtitle = 'Magnetic Longitude', ytitle = 'Average intensity', $
                    ymargin = [4,1]
                  oplot, [mlonGrpTimes - 360, mlonGrpTimes, mlonGrpTimes + 360], $
                    [mlonGrpAvgs, mlonGrpAvgs, mlonGrpAvgs], color = 'bbbbbb'XUL
                  oplot, mlonGrpTimes, mlonGrpAvgs, color = '000000'XUL
              endif
              
              widget_control, w_draw, get_value = v
              wset, v
              
              setupPS, prefix + fname + '.ps'
              
              if graphMLT and graphMLON then $
                !p.multi = [0, 1, 2] $
              else $
                !p.multi = 0

              if graphMLT then begin
                  plot, mltGrpTimes, mltGrpAvgs, xrange = [-6, 30], xtickinterval = 6, $
                    background = 'ffffff'XUL, color = '000000'XUL, /nodata, $
                    xtickname = ['(18)', '0', '6', '12', '18', '24', '(6)'], $
                    xtitle = 'MLT', ytitle = 'Average intensity', $
                    ymargin = [2.5,2.5], title = 'AZISUM graph, ' + dateStr + radiiStr
                  oplot, [mltGrpTimes - 24, mltGrpTimes, mltGrpTimes + 24], $
                    [mltGrpAvgs, mltGrpAvgs, mltGrpAvgs], color = 'bb'XUL
                  oplot, mltGrpTimes, mltGrpAvgs, color = '000000'XUL
              endif

              if graphMLON then begin                 
                  plot, mlonGrpTimes, mlonGrpAvgs, xrange = [-60, 420], xtickinterval = 60, $
                    background = 'ffffff'XUL, color = '000000'XUL, /nodata, $
                    xtickname = ['(360)', '0', '60', '120', '180', '240', $
                                 '300', '360', '(60)'], $
                    xtitle = 'Magnetic Longitude', ytitle = 'Average intensity', $
                    ymargin = [4,1]
                  oplot, [mlonGrpTimes - 360, mlonGrpTimes, mlonGrpTimes + 360], $
                    [mlonGrpAvgs, mlonGrpAvgs, mlonGrpAvgs], color = 'bb'XUL
                  oplot, mlonGrpTimes, mlonGrpAvgs, color = '000000'XUL
              endif
              
              closePS             

              print, 'Graph saved as ' + prefix + fname + '.ps'

          endif
          if findex lt n_elements(xf_flist) - 1 then begin
              i = findex + 1
              xf_azisum_loadframe, i
              goto, reloop
          end
      endif
  end
  suspendEvents = 0
end

pro xf_azisum_quit, ev
  widget_control, ev.top, /destroy
end

pro xf_azisum_load, ev

  @xf_azisum_common

  xf_flist = dialog_pickfile(filter = '*.fits', /must_exist, $
                          /read, /multiple)

  xf_azisum_loadframe, 0
end

pro xf_azisum_loadframe, i
  @xf_azisum_common
  findex = i
                                ; load FITS file
  xf_load_fits_azisum, xf_flist[i]
  print, 'Loaded ' + xf_flist[i] + '...'
  f_filename = xf_flist[i]
  
; enable/disable widgets depending on type of frame
  if(angle_mode) then begin     ; MLT mode
      widget_control, w_button1, sensitive=1
      widget_control, w_button2, sensitive=0
      widget_control, w_button3, sensitive=1
      widget_control, w_button4, sensitive=0
      widget_control, w_button2, set_button=0
      widget_control, w_button4, set_button=0
      saveMLON = 0
      graphMLON = 0
  endif else begin              ; mlon mode
      widget_control, w_button1, sensitive=0
      widget_control, w_button2, sensitive=1
      widget_control, w_button3, sensitive=0
      widget_control, w_button4, sensitive=1
      widget_control, w_button1, set_button=0
      widget_control, w_button3, set_button=0
      saveMLT = 0
      graphMLT = 0
  endelse
                                ; calculate pixel size of 1 Re
  re_pix = 37.5

                                ; do truecolor palette setup
  intensityArray = fix((10 ^ darray))
  normArray = darray / 3.0
  r = (((normArray - 0.5) > 0) * 2) ^ 1
  g = normArray
  b = (normArray + r + normArray ^ 2) / 3
  dispArray = [[[fix(r * 255)]], $
               [[fix(g * 255)]], $
               [[fix(b * 255)]]]

  wset, 1

  tv,  dispArray, true = 3

  widget_control, w_draw, get_value = v
  wset, v


  dateStr = stamp1 + ' - ' + stamp2
  widget_control, w_label1, set_value = dateStr
  widget_control, w_label2, set_value = ''

  fileLoaded = 1
  widget_control, w_toggleCircles, sensitive = 1
  redrawCircle
end

pro xf_azisum_toggleCircles, ev
  @xf_azisum_common
  if showOuterCircles then begin
      showOuterCircles = 0
      widget_control, w_toggleCircles, set_value = 'Show circles'
  endif else begin
      showOuterCircles = 1
      widget_control, w_toggleCircles, set_value = 'Hide circles'
  endelse
  redrawCircle
end

pro xf_azisum

  @xf_azisum_common

  fileLoaded = 0
  showOuterCircles = 1
  suspendEvents = 0

  ; set up GUI
  set_plot, 'x'
  device, true_color = 24
  device, retain = 2
  !p.thick = 1
  !x.thick = 1
  !y.thick = 1
  w_base = widget_base(xsize = 608, $
                       ysize = 824, $
                       mbar = w_menubar, title = 'azisum')

  w_draw = widget_draw(w_base, uvalue = 'draw', xoffset = 4, yoffset = 24, $
                       xsize = 600, ysize = 600, /motion_events, $
                       /button_events)

  w_slider1 = widget_slider(w_base, uvalue = 'slider1', xoffset = 4, $
                            yoffset = 633, xsize = 236, /suppress_value, $
                            minimum = 100, maximum = 800, value = 110, /drag)
 
  w_text1 = widget_text(w_base, /editable, xoffset = 242, $
                       xsize = 4, yoffset = 628, value = '1.10', $
                       uvalue = 'text1')

  w_slider2 = widget_slider(w_base, uvalue = 'slider2', xoffset = 4, $
                            yoffset = 665, xsize = 236, /suppress_value, $
                            minimum = 1, maximum = 800, value = 50, /drag)

  w_text2 = widget_text(w_base, /editable, xoffset = 242, $
                       xsize = 4, yoffset = 660, value = '0.50', $
                       uvalue = 'text2')

  w_slider3 = widget_slider(w_base, uvalue = 'slider3', xoffset = 4, $
                            yoffset = 697, xsize = 236, /suppress_value, $
                            minimum = 8, maximum = 128, value = 72, /drag)

  w_text3 = widget_text(w_base, /editable, xoffset = 242, $
                       xsize = 4, yoffset = 692, value = '72', $
                       uvalue = 'text3')

  w_label1 = WIDGET_LABEL(w_base, xoffset = 284, yoffset = 4, xsize = 200, $
                          ysize = 16, value = '', /align_right)
 
  w_label2 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 4, xsize = 180, $
                          ysize = 16, value = '', $
                          /align_left)

  w_base2 = widget_base(w_base, /nonexclusive, yoffset = 724, xoffset = 0, xsize = 125)

  w_button1 = widget_button(w_base2, value = 'Save MLT data', yoffset = 0, xoffset = 4, $
                            uvalue = 'savedata1')

  w_button2 = widget_button(w_base2, value = 'Save mlon data', yoffset = 0, xoffset = 4, $
                            uvalue = 'savedata2')

  w_base3 = widget_base(w_base, /nonexclusive, yoffset = 724, xoffset = 130, xsize = 170)

  w_button3 = widget_button(w_base3, value = 'Make MLT graph', yoffset = 60, xoffset = 124, $
                            uvalue = 'savegraph1')

  w_button4 = widget_button(w_base3, value = 'Make mlon graph', yoffset = 60, xoffset = 124, $
                            uvalue = 'savegraph2')

  Widget_Control, w_button1, Set_Button=1
  saveMLT = 1
  Widget_Control, w_button2, Set_Button=1
  saveMLON = 1
  Widget_Control, w_button3, Set_Button=1
  graphMLT = 1
  Widget_Control, w_button4, Set_Button=1
  graphMLON = 1

  Widget_Control, w_button1, sensitive=0
  Widget_Control, w_button2, sensitive=0
  Widget_Control, w_button3, sensitive=0
  Widget_Control, w_button4, sensitive=0

  w_label3 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 796, xsize = 102, $
                          ysize = 16, value = 'Output directory', $
                          /align_left)

  w_text4 = widget_text(w_base, /editable, xoffset = 108, $
                       scr_xsize = 176, yoffset = 788, value = './output/', $
                       uvalue = 'text3')

  w_file = widget_button(w_menubar, value = 'File', /menu)
  w_load = widget_button(w_file, value = 'Load FITS file...', $
                         Event_Pro = 'xf_azisum_load')
  w_quit = widget_button(w_file, value = 'Quit', Event_Pro = 'xf_azisum_quit')

  w_view = widget_button(w_menubar, value = 'View', /menu)
  w_toggleCircles = widget_button(w_view, value = 'Hide circles', $
                                  Event_Pro = 'xf_azisum_toggleCircles', sensitive = 0)
 
  ; set up color constants and circle info
  white = 'ffffff'XUL
  black = '000000'XUL
  circlecolor = '77dd00'XUL
  cir_x = 300
  cir_y = 300
  cir_r1 = 1.10
  cir_thick = 0.50

  ; setup invisible graphics buffer
  window, 1, /Pixmap, XSize = 600, YSize = 600

  ; display window
  widget_control, w_base, /realize
 
  ; initialize event handler
  xmanager, 'xf_azisum', w_base, /no_block

  redrawCircle

  print, 'done'
end

