pro redrawX, nomarkings = nomarkings
  @tracer_common
  @euv_imtool-commons

  widget_control, w_slider1, get_value = minimum
  widget_control, w_slider2, get_value = maximum
  widget_control, w_slider3, get_value = gamma
  widget_control, w_slider4, get_value = hltpt
  widget_control, w_slider5, get_value = spread
  stretch, minimum, maximum, gamma / 100.0

  tvlct, palR, palG, palB, /get

  z = fix(displayArray / 3.1 * 255) < 255 > 0

  widget_control, w_slider6, get_value = steps
  widget_control, w_slider7, get_value = offset
  widget_control, w_slider8, get_value = stepstr
  widget_control, w_slider9, get_value = normstr

  print, steps, offset, normstr, stepstr

  p = indgen(256)
  
  p = fix((p * normstr + stepstr * (fix((p + offset) / 255.0D * steps) / (steps / 255.0D) - offset)) / $
          (normstr + stepstr))
  z = p[z]

  if doHL then begin
      lo = (hltpt - spread) > 0
      hi = (hltpt + spread) < 255
      b[lo : hi] = palG[lo : hi] * 1
      r[lo : hi] = palG[lo : hi] * 0.15
      dispArray = [[[r[z]]], [[palG[z]]], [[b[z]]]]
  endif else begin
      dispArray = [[[palR[z]]], [[palG[z]]], [[palB[z]]]]
  endelse

  wset, 1
  tv,  dispArray, true = 3

  wset, 3
  dispArray = [[[palB[z]]], [[palR[z]]], [[palG[z]]]]
  tv,  (dispArray + 255) / 2, true = 3

  if n_elements(nomarkings) eq 0 then redraw
end

pro redraw
  @tracer_common
  @euv_imtool-commons

  wset, 2
  Device, Copy = [0, 0, 280, 300, 0, 0, 1]
  if numPoints gt 0 then begin
              start = 0
              for i = 1, numPoints - 1 do begin
                  if cSpots[i] eq 0 then begin
                      plots, xSpots[start:i - 1], ySpots[start:i - 1], /device, $
                             color = 'ffffcc'XUL
                      start = i
                  endif
              endfor
              plots, xSpots[start:numPoints - 1], ySpots[start:numPoints - 1], /device, $
                             color = 'ffddcc'XUL
              plots, xSpots[0:numPoints - 1], ySpots[0:numPoints - 1], /device, $
                     psym = 6, color = '000000'XUL, symsize = 0.33333
              plots, xSpots[0:numPoints - 1], ySpots[0:numPoints - 1], /device, $
                     psym = 3, color = 'ffffff'XUL
  endif
  if foundEarth then drawEarth, cir_x, cir_y, 2
  wset, drawHandle
  Device, Copy = [0, 0, 280, 300, 0, 0, 2]
end

pro drawEarth, x, y, h
  @tracer_common

  wset, h
  Device, Copy = [0, 0, 280, 300, 0, 0, 2]
  smoothness = 16
  circle = fltarr(2, smoothness + 1)
  for i = 0.0, smoothness do begin
      j = i / smoothness * 3.14159 * 2
      circle[0, i] = x + re_pix * cos(j)
      circle[1, i] = y + re_pix * sin(j)
  endfor
  plots, circle, /device, color = 0, psym = 3     
  for i = 0.0, smoothness do begin
      j = (i + 0.5) / smoothness * 3.14159 * 2
      circle[0, i] = x + re_pix * cos(j)
      circle[1, i] = y + re_pix * sin(j)
  endfor
  plots, circle, /device, color = 255 * (1 + 256 + 256 * 256L), psym = 3 
end

function intToStr, i
  return, strmid(strcompress(string(i)), 1, 1000)
end

function zeropad, i, l
  n = fix(i)
  x = strmid(strcompress(string(n)), 1, 1000)
  while(strlen(x) lt l) do x = '0' + x
  return, x
end

pro tracer_quit, ev
  widget_control, ev.top, /destroy
end

pro tracer_load, index
  @tracer_common
  @euv_imtool-commons

  if index le 0 then index = 0
  if index ge n_elements(filesList) then index = n_elements(filesList) - 1

  f_filename = fprefix + filesList[index]

  widget_control, w_slider10, set_value = index

  ; load FITS file
  load_fits_tracer, f_filename
  
  displayArray = darray
  subback = 0

  ; calculate pixel size of 1 Re
  re_pix = (asin(1.0/(vmag(image_x, image_y, image_z) / 6378)) * !RADEG) / 0.3

  dateStr = zeropad(s0year, 4) + '/' + zeropad(s0doy,3) + '/' + $
            zeropad(s0hour,2) + ':' + zeropad(s0min, 2)
 
  fileStr = strmid(f_filename, 0, strpos(f_filename, '.', /reverse_search))

  widget_control, w_label1, set_value = dateStr
  
  f = fileStr + '.clk'

  widget_control, w_text1, set_value = f

  z = findfile(f, count = c)

  calc_sm_coords
  fileLoaded = index
  tp_saved = t5##t1##transpose(t2)##transpose(t3)##transpose(t4)

  numPoints = 0
  nextisconnected = 0
  lastX = -1
  lastY = -1

  if n_elements(cir_x) eq 0 then begin
      cir_x = 0
      cir_y = 0
      subback_y1 = -1
  endif

  if c gt 0 then begin
      openr, 1, f
      numPoints = numLines(f)
      a = ''
      readf, 1, a
      if a eq '# version 2.0' then begin
          extraColumn = 1
          numPoints = numPoints - 1
      endif else begin
          extraColumn = 0
          close, 1
          openr, 1, f
      endelse
      a = 0
      b = 0
      c = 0
      d = 0
      x = 0
      y = 0
      conn = 0
      for i = 0, numPoints - 1 do begin
          if extraColumn then readf, 1, a, b, c, x, y, cx, cy, conn $
                         else readf, 1, a, b, c, x, y, cx, cy          
          xSpots[i] = x
          ySpots[i] = y
          cSpots[i] = conn
          if i eq 0 then begin
              cir_x = cx
              cir_y = cy
          endif
          foundEarth = 1
      endfor
      close, 1
  endif

  if foundEarth then begin
      widget_control, w_save, sensitive = 1
      widget_control, w_recenter, sensitive = 1
  endif else begin
      widget_control, w_save, sensitive = 0
      widget_control, w_recenter, sensitive = 0
  endelse

  if index eq 0 then widget_control, w_prev, sensitive = 0 $
                else widget_control, w_prev, sensitive = 1

  if index eq (n_elements(filesList) - 1) then widget_control, w_next, sensitive = 0 $
                                          else widget_control, w_next, sensitive = 1

  redrawX
end

pro tracer
  @tracer_common
  @euv_imtool-commons

  lastX = -1
  lastY = -1
  numPoints = 0
  nextisconnected = 0
  xSpots = intarr(1000)
  ySpots = intarr(1000)
  cSpots = intarr(1000)
  fixedDist = 7
  fileLoaded = 0
  foundEarth = 0
  doHL = 0

  ; set up GUI
  if !version.os eq 'Win32' then set_plot,'WIN' $
  else if !version.os eq 'MacOS' then set_plot,'MAC' $
  else set_plot, 'x'            ; default to linux

  if !version.os eq 'linux' then device, true_color = 24
  device, retain = 2

  loadct, 8
  stretch, 0, 255, 1
  tvlct, palR, palG, palB, /get

  !p.thick = 1
  !x.thick = 1
  !y.thick = 1
  w_base = widget_base(xsize = 368, $
                       ysize = 542, $
                       title = 'Tracer')

  w_draw = widget_draw(w_base, uvalue = 'draw', xoffset = 4, yoffset = 20 + 28, $
                       xsize = 280, ysize = 300, /button_events, /motion_events)

  w_label1 = WIDGET_LABEL(w_base, xoffset = 54, yoffset = 6, xsize = 180, $
                          ysize = 16, value = '', /align_center)

  w_text1 = widget_text(w_base, xoffset = 4, $
                       scr_xsize = 230, yoffset = 20 + 332, value = '', $
                       uvalue = 'text1', sensitive = 1, /editable)

  w_save = widget_button(w_base, value = 'Save', xoffset = 238, yoffset = 20 + 332, ysize = 31, $
                         scr_xsize = 46, sensitive = 0, uvalue = 'save')
   
  w_next = widget_button(w_base, value = "Next", xoffset = 244, yoffset = 4, ysize = 20, $
                         scr_xsize = 40, sensitive = 1, uvalue = 'next')
   
  w_prev = widget_button(w_base, value = "Prev", xoffset = 4, yoffset = 4, ysize = 20, $
                         scr_xsize = 40, sensitive = 1, uvalue = 'prev')

  w_hide = widget_button(w_base, value = 'Hide markings', xoffset = 4, yoffset = 20 + 493, $
                         scr_xsize = 138, sensitive = 1, uvalue = 'hide')

  w_subback = widget_button(w_base, value = 'Subtract background', xoffset = 146, yoffset = 20 + 493, $
                         scr_xsize = 138, sensitive = 1, uvalue = 'subback')

  w_slider1 = widget_slider(w_base, uvalue = 'slider', xoffset = 74, $
                            yoffset = 20 + 367, xsize = 210, /suppress_value, $
                            minimum = 0, maximum = 255, value = 0, /drag)  

  w_label2 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 20 + 369, xsize = 66, $
                          ysize = 16, value = 'CT Minimum', /align_left)

  w_slider2 = widget_slider(w_base, uvalue = 'slider', xoffset = 74, $
                            yoffset = 20 + 387, xsize = 210, /suppress_value, $
                            minimum = 0, maximum = 255, value = 255, /drag)

  w_label3 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 20 + 389, xsize = 66, $
                          ysize = 16, value = 'CT Maximum', /align_left)
   
  w_slider3 = widget_slider(w_base, uvalue = 'slider', xoffset = 74, $
                            yoffset = 20 + 407, xsize = 210, /suppress_value, $
                            minimum = 0, maximum = 200, value = 100, /drag)

  w_label4 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 20 + 409, xsize = 66, $
                          ysize = 16, value = 'CT Gamma', /align_left)

  w_slider4 = widget_slider(w_base, uvalue = 'slider', xoffset = 74, $
                            yoffset = 20 + 427, xsize = 210, /suppress_value, $
                            minimum = 0, maximum = 255, value = 0, /drag)

  w_label5 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 20 + 429, xsize = 66, $
                          ysize = 16, value = 'HL Center', /align_left)

  w_slider5 = widget_slider(w_base, uvalue = 'slider', xoffset = 74, $
                            yoffset = 20 + 447, xsize = 210, /suppress_value, $
                            minimum = 0, maximum = 50, value = 0, /drag)

  w_label6 = WIDGET_LABEL(w_base, xoffset = 4, yoffset = 20 + 449, xsize = 66, $
                          ysize = 16, value = 'HL Range', /align_left)

  w_toggleHL = widget_button(w_base, value = 'Enable Highlighting', xoffset = 4, yoffset = 20 + 467, $
                             ysize = 24, scr_xsize = 138, sensitive = 1, uvalue = 'toggleHL')  

  w_slider6 = widget_slider(w_base, xoffset = 288, yoffset = 20 + 4, xsize = 16, ysize = 514, $
                            /vertical, minimum = 4, maximum = 32, value = 4, /drag, $
                            uvalue = 'slider')

  w_slider7 = widget_slider(w_base, xoffset = 308, yoffset = 20 + 4, xsize = 16, ysize = 514, $
                            /vertical, minimum = -32, maximum = 32, value = 0, /drag, $
                            uvalue = 'slider')

  w_slider8 = widget_slider(w_base, xoffset = 328, yoffset = 20 + 4, xsize = 16, ysize = 514, $
                            /vertical, minimum = 0, maximum = 32, value = 0, /drag, $
                            uvalue = 'slider')

  w_slider9 = widget_slider(w_base, xoffset = 348, yoffset = 20 + 4, xsize = 16, ysize = 514, $
                            /vertical, minimum = 1, maximum = 32, value = 1, /drag, $
                            uvalue = 'slider')

  w_slider10 = widget_slider(w_base, xoffset = 4, yoffset = 28, xsize = 280, ysize = 16, $
                            minimum = 0, maximum = 1, value = 0, $
                            uvalue = 'changeframeslider', scroll = 6)


   
  w_recenter = widget_button(w_base, value = 'Redefine Center', xoffset = 146, yoffset = 20 + 467, ysize = 24, $
                         scr_xsize = 138, sensitive = 0, uvalue = 'recenter')  
   
  ; setup invisible graphics buffers
  window, 1, /Pixmap, XSize = 280, YSize = 300
  window, 2, /Pixmap, XSize = 280, YSize = 300
  window, 3, /Pixmap, XSize = 280, YSize = 600

  fprefix = dialog_pickfile(/must_exist, filter = '*.fits', $
                            title = 'Please select directory to get FITS files from')

  if fprefix eq '' then return

  if !version.os eq 'Win32' then delim = '\' $
  else if !version.os eq 'MacOS' then delim = ':' $
  else delim = '/'            ; default to linux

  if strpos(fprefix, delim) eq -1 then $
    fprefix = fprefix + delim $
  else $
    fprefix = strmid(fprefix, 0, strpos(fprefix, delim, /reverse_search) + 1)

  ext = 'fits'
  flist = findfile(fprefix + '*.' + ext)

  print, flist

  flist = strmid(flist, strlen(fprefix), 1000)

  filesList = flist[sort(flist)]

  widget_control, w_slider10, set_slider_max = n_elements(filesList) - 1

  print, filesList

  ; display window
  widget_control, w_base, /realize

  widget_control, w_draw, get_value = drawHandle

  tracer_load, 0

  ; initialize event handler
  xmanager, 'tracer', w_base

end
