pro openDirectory, dir
  @seamfix_common
  fitsDir = dir

  flist = findfile(dir + '*.fits')

  fitsFiles = flist[sort(flist)]
  fitsFilesN = n_elements(fitsFiles)
  
  widget_control, w_slider_time, set_slider_max = fitsFilesN - 1, set_slider_min = 0, /sensitive

  seamfix_loadframe, 0
end

pro pickfolder
  @seamfix_common
  res = dialog_pickfile(/must_exist, dialog_parent = w_base, filter = '*.fits')
  if res eq '' then return
  if strpos(res, '/') ne -1 then res = strmid(res, 0, strpos(res, '/', /reverse_search)) $
                            else res = ''
  openDirectory, res + '/'
end

pro makeGraph
  @seamfix_common
  seamfix_graph_setup
  oplot, xvals, avgVal, color = 'ddaa77'XUL
  oplot, xvals, yvals, color = '997722'XUL
  oplot, xvals, yvals, color = '660000'XUL, psym = 4, symsize = 0.33333
  seamfix_graph_show
  widget_control, w_button_graphfactors, sensitive = 1
  widget_control, w_button_savefactors, sensitive = 1
  graphExists = 1
  graphmode = 0
end

pro seamfix_event, ev
  @seamfix_common
  @euv_imtool-commons

  widget_control, ev.id, get_uvalue = id

  if id eq 'button_newdirectory' then begin
      pickfolder
  endif

  if id eq 'button_resetgraph' then begin
      multFacts = fltarr(140) + 1
      seamfix_loadframe, currentFile
      return
  endif

  if id eq 'button_savefactors' then begin
      multFacts = yvals / avgVal
      save, multFacts, filename = 'multfacts.sav'
      return
  endif

  if not fileOpened then return

  if id eq 'button_savefits' then begin
      res = dialog_pickfile(dialog_parent = w_base, filter = '*.fits')
      if res eq '' then return
      backup = darray
      darray = darrayModified
      seamfix_writefits, res
      darray = backup
  endif

  if id eq 'button_graphfactors' and graphExists then begin
      graphExists = 0
      widget_control, w_button_graphfactors, set_value = 'Graph values'
      gY1 = graph_y1
      gY2 = graph_y2
      factors = yvals / avgVal
      high = max(factors)
      low = min(factors)
      print, high, low
      range = high - low
      graph_y2 = high + 0.1 * range
      graph_y1 = low - 0.1 * range
      print, graph_y2, graph_y1
      seamfix_graph_setup
      oplot, xvals, factors, color = '997722'XUL
      oplot, xvals, factors, color = '660000'XUL, psym = 4, symsize = 0.3333
      seamfix_graph_show
      graph_y1 = gY1
      graph_y2 = gY2
      graphmode = 1
      return
  endif

  if id eq 'button_graphfactors' and graphmode eq 1 then begin
      widget_control, w_button_graphfactors, set_value = 'Graph factors'
      makeGraph
      return
  endif

  if id eq 'button_prev' then begin
      seamfix_loadframe, currentFile - 1
      return
  endif

  if id eq 'button_next' then begin
      get_lun, ff
      openw, ff, 'temp', /append
      printf, ff, avgVal
      close, ff
      free_lun, ff
      seamfix_loadframe, currentFile + 1
      return
  endif

  if id eq 'slider_time' then begin
      widget_control, w_slider_time, get_value = v
      seamfix_loadframe, v
      return
  endif

  if id eq 'button_zoomout' then begin
      minY = min(avgVal) < 0
      maxY = (fix(max(avgVal) / 100.0) + 1) * 100 < (max(avgVal) * 1.15)
      
      graph_x1 = 0
      graph_x2 = 279
      graph_y1 = minY
      graph_y2 = maxY

      makeGraph
      
      widget_control, w_button_zoomout, sensitive = 0
      return
  endif

  if id eq 'draw_graph' and graphExists then begin
      if ev.type eq 0 and ev.press eq 4 then begin
          draw_graph_zooming = 1
          draw_graph_zoom_x1 = ev.x
          draw_graph_zoom_y1 = ev.y
          return
      endif

      if ev.type eq 1 and ev.release eq 4 then begin
          draw_graph_zooming = 0
          x = ev.x > 0 < 847
          y = ev.y > 0 < 199
          if x eq draw_graph_zoom_x1 or y eq draw_graph_zoom_y1 then return
          if x lt draw_graph_zoom_x1 then begin
              x1 = x
              x2 = draw_graph_zoom_x1
          endif else begin
              x1 = draw_graph_zoom_x1
              x2 = x
          endelse
          if y lt draw_graph_zoom_y1 then begin
              y1 = y
              y2 = draw_graph_zoom_y1
          endif else begin
              y1 = draw_graph_zoom_y1
              y2 = y
          endelse
          seamfix_graph_setup


          graph_x2 = (((x2 - graph_pix_x1) / graph_pix_xscale) + graph_x1) < graph_x2
          graph_y2 = (((y2 - graph_pix_y1) / graph_pix_yscale) + graph_y1) < graph_y2        
          graph_x1 = (((x1 - graph_pix_x1) / graph_pix_xscale) + graph_x1) > graph_x1
          graph_y1 = (((y1 - graph_pix_y1) / graph_pix_yscale) + graph_y1) > graph_y1

          makeGraph

          widget_control, w_button_zoomout, sensitive = 1
      endif

      if draw_graph_zooming then begin
          wset, 1
          device, copy = [0, 0, 848, 200, 0, 700, 2]
          x = ev.x > 0 < 847
          y = ev.y > 0 < 199
          plots, [x, x, draw_graph_zoom_x1, draw_graph_zoom_x1, x], $
                 [y, draw_graph_zoom_y1, draw_graph_zoom_y1, y, y] + 700, color = 'ffaa88'XUL, /device

          wset, h_draw_graph
          device, copy = [0, 700, 848, 200, 0, 0, 1]         
          return
      endif 

      if ev.type eq 1 and ev.release eq 1 then begin
          draw_graph_dragging = 0
          makeGraph
          return
      endif

      y = (((ev.y - graph_pix_y1) / graph_pix_yscale) + graph_y1) < graph_y2 > 0
      x = fix(((((ev.x - graph_pix_x1) / graph_pix_xscale) + graph_x1) < graph_x2 > 0 + 1) / 2) * 2

      wset, h_draw_graph
      device, copy = [0, 0, 848, 200, 0, 0, 2]         

      dst = sqrt((y - yvals) ^ 2 + (x - xvals) ^ 4)
      ind = where(dst eq min(dst))
      ind = ind[0]

      if ev.type eq 0 and ev.press eq 1 then begin
          draw_graph_dragging = 1
          seamfix_graph_setup
          oplot, xvals, avgVal, color = 'ddaa77'XUL
          if ind eq 0 then begin
              xv = xvals[1:139]
              yv = yvals[1:139]
          endif else if ind eq 139 then begin
              xv = xvals[0:138]
              yv = yvals[0:138]
          endif else begin
              oplot, xvals[0:(ind-1)], yvals[0:(ind-1)], color = '997722'XUL
              oplot, xvals[0:(ind-1)], yvals[0:(ind-1)], color = '660000'XUL, psym = 4, symsize = 0.33333
              xv = xvals[(ind+1):139]
              yv = yvals[(ind+1):139]
          endelse
          oplot, xv, yv, color = '997722'XUL
          oplot, xv, yv, color = '660000'XUL, psym = 4, symsize = 0.33333
          seamfix_graph_show

          wset, 1
          device, copy = [0, 0, 848, 200, 0, 700, 2]
      endif
          

      if draw_graph_dragging then begin
          wset, 2
          device, copy = [0, 700, 848, 200, 0, 0, 1]
          ind = graph_pointatX / 2
          oplot, xvals[(ind - 1):(ind + 1)], [yvals[ind - 1], y, yvals[ind + 1]], color = 'ff5555'XUL
          yvals[ind] = y
          darrayModified[(ind*2):(ind*2+1), *] = alog10(darrayLinear[(ind*2):(ind*2+1), *] $
                                                        * yvals[ind] / avgVal[ind])
          d = alog10(darrayLinear[(ind*2):(ind*2+1), *] * yvals[ind] / avgVal[ind])
;          d = darray[(ind * 2):(ind * 2 + 1), *]
          wset, h_draw_secondary
          seamfix_draw, d, x = ind*2, y = 0
  
      endif

      graph_pointatX = ind * 2    

      wset, h_draw_graph
      plots, [xvals[ind], yvals[ind]], color = 255, psym = 4, symsize = 1.333

      ; other code here
  endif

  if id eq 'draw_main' then begin
      if ev.type eq 0 and ev.press eq 1 then begin
          draw_main_dragging = 1
          if draw_main_y1 eq -1 then draw_main_y1 = ev.y $
          else begin
              if abs(ev.y - draw_main_y1) lt abs(ev.y - draw_main_y2) then $
                draw_main_y1 = draw_main_y2
          endelse
      endif

      if ev.type eq 1 and ev.release eq 1 then begin
          widget_control, w_button_zoomout, sensitive = 0
          y1 = draw_main_y1
          y2 = ev.y > 0 < 299
          if y2 lt y1 then begin
              y1 = ev.y > 0 < 299
              y2 = draw_main_y1
          endif
          draw_main_y1 = y1
          draw_main_y2 = y2
          draw_main_dragging = 0
      endif
      
      if draw_main_dragging then begin
          y1 = draw_main_y1
          y2 = ev.y > 0 < 299
          if y2 lt y1 then begin
              y1 = ev.y > 0 < 299
              y2 = draw_main_y1
          endif
          h = (y2 - y1) > 1
          wset, 1
          device, copy = [0, 400, 280, 300, 560, 400, 1]
          device, copy = [280, 400 + y1, 280, h, 560, 400 + y1, 1]

          xvals = fltarr(140)
          yvals = fltarr(140)

          for i = 0, 139 do begin
              avgVal[i] = mean(darrayLinear[i * 2, y1:y2])
              yvals[i] = mean(10 ^ darrayModified[i * 2, y1:y2])
              xvals[i] = i * 2
          endfor

          minY = min(avgVal) < 0
          maxY = (fix(max(avgVal) / 100.0) + 1) * 100 < (max(avgVal) * 1.15)

          graph_x1 = 0
          graph_x2 = 279
          graph_y1 = minY
          graph_y2 = maxY

          makeGraph

          wset, h_draw_main
          device, copy = [560, 400, 280, 300, 0, 0, 1]
      endif
  endif      
end
