pro rotsum_loadframe, n
  @euv_imtool-commons
  @rotsum_common
  
  rotsum_loadfits, files[n]

  curFile = n
  redrawPick

  if n eq 0 then $
    widget_control, w_prev, sensitive = 0 $
  else $
    widget_control, w_prev, sensitive = 1
    
  if n eq (n_elements(files) - 1) then $
    widget_control, w_next, sensitive = 0 $
  else $
    widget_control, w_next, sensitive = 1

  widget_control, w_datelabel, set_value = dateStrings[n]
    
  calc_sm_coords
  tp_saved = t5##t1##transpose(t2)##transpose(t3)##transpose(t4)
  ; calculate pixel size of 1 Re
  re_pix = (asin(1.0/(vmag(image_x, image_y, image_z) / 6378)) * !RADEG) / 0.3
  

  clk = strmid(files[n], 0, strpos(files[n], '.', /reverse_search)) + '.clk'

  res = findfile(clk)
  if res[0] ne '' then begin
      get_lun, u
      openr, u, clk
      tmp = ''
      readf, u, tmp
      if tmp eq '# version 2.0' then begin
          cir_x = 0
          cir_y = 0
          a = 0
          b = 0
          c = 0
          d = 0
          e = 0
          readf, u, a, b, c, d, e, cir_x, cir_y
      endif
      close, u
      free_lun, u
  endif

  window, 3, /pixmap, xsize = 280, ysize = 300
  wset, 3
  tvscl, darray

  wset, h_draw1
  device, copy = [0, 0, 280, 300, 0, 0, 3]

  if cir_x ne -1 then drawEarth, cir_x, cir_y
  if foundMINL ne -1 then begin
      ang = ((turnAng - 15) * 24) * (jd - foundJD)
      res = rotsum_findXY(foundMINL, foundMLON + ang)
      
      wset, h_draw1
      plots, [res[0]], [res[1]], psym = 2, color = 'ffaaff'XUL, $
             symsize = 0.3333, /device
  endif

  savedArrays = fltarr(1, 280, 300)
  savedArrays[0, *, *] = darray
  savedJDs = jd
  savedReps = re_pix
 
;  circle, 210, 225, 50, color = '0000ff'XUL
end
