pro colorchanged
  @rotsum_common
  if n_elements(curBig) eq 0 then return
  wset, h_draw2
  tvlct, palR, palG, palB, /get
  tv, [[[palR[curBig]]], [[palG[curBig]]], [[palB[curBig]]]], true = 3

end

function strip, d
  return, strmid(d, 0, 4) + strmid(d, 5, 3) + $
          strmid(d, 9, 2) + strmid(d, 12, 2)
end

pro rotsum_event, ev
  @euv_imtool-commons
  @rotsum_common

  uval = ''
  widget_control, ev.id, get_uvalue = uval

  if uval eq 'd_pick' then begin
      if ev.press gt 0 then begin
          v = 0
          selChange = 1
          widget_control, w_slider, get_value = v
          x = fix((ev.x - 1) / 140.0D) > 0 < 4
          if ev.press eq 1 or (ev.press eq 4 and sel1 eq -1) then begin
              sel1 = x + v
              sel2 = sel1
              rotsum_loadframe, sel1
          endif else if ev.press eq 4 then begin
              sel2 = x + v
              selChange = 1
              redrawPick
          endif
      endif
      return
  endif

  if uval eq 's_pick' then begin
      redrawPick
      return
  endif

  if uval eq 'b_pal' then begin
      xloadct, updatecallback = 'colorchanged'
      tvlct, palR, palG, palB, /get
  endif

  if uval eq 'd_big' and n_elements(savedRotated) ne 0 then begin
      n = n_elements(savedJDs)
      if n eq 0 then return
      if ev.press eq 1 then begin
          bigFrame = bigFrame + 1
          if bigFrame eq n then bigFrame = 0
      endif else if ev.press eq 4 then bigFrame = -1

      wset, 4
      if bigFrame eq -1 then begin
          tv, [[[palR[combined]]], [[palG[combined]]], [[palB[combined]]]], $
              true = 3
          curBig = combined
      endif else begin
          curBig[*, *] = savedRotated[bigFrame, *, *]
          tv, [[[palR[curBig]]], [[palG[curBig]]], [[palB[curBig]]]], true = 3
          ds = dateStrings(first + bigFrame)
          polyfill, [0, 0, 420, 420], [0, 20, 20, 0], $
                    color = '550000'XUL, /device
          xyouts, 5, 5, 'Frame ' + zeroPad(bigFrame + 1, 0) + ' of ' + $
                  zeroPad(n, 0) + ' - ' + ds, $
                  color = 'ffffff'XUL, $
                  charsize = 1.333, charthick = 1.333, /device
          
      endelse

      wset, h_draw2
      device, copy = [0, 0, 420, 450, 0, 0, 4]
      return
  endif

  if uval eq 'd_main' then begin
      if cir_x eq -1 or ev.press eq 4 then begin
          drawEarth, ev.x, ev.y

          cir_x = ev.x
          cir_y = ev.y
          return
      endif

      if ev.press eq 1 then begin
          drawEarth, cir_x, cir_y
          rotsum_markspot, ev.x, ev.y
      endif
      return
  endif

  if uval eq 'b_next' then begin
      if curFile lt (n_elements(files) - 1) then rotsum_loadFrame, curFile + 1
      return
  endif

  if uval eq 'b_prev' then begin
      if curFile gt 0 then rotsum_loadFrame, curFile - 1
      return
  endif

  if uval eq 'b_go' then begin
      s1 = min([sel1, sel2])
      s2 = max([sel1, sel2])
      first = s1
      if selChange then begin
          savedArrays = fltarr(s2 - s1 + 1, 280, 300)
          savedJDs = fltarr(s2 - s1 + 1)
          savedReps = fltarr(s2 - s1 + 1)
          n = s2 - s1 + 1
          for i = s1, s2 do begin
              rotsum_loadfits, files[i]
              calc_sm_coords
              tp_saved = t5##t1##transpose(t2)##transpose(t3)##transpose(t4)
              rr = (asin(1.0/(vmag(image_x, image_y, image_z) / 6378)) * $
                        !RADEG) / 0.3
              savedReps[i - s1] = rr
              savedArrays[i - s1, *, *] = darray
              savedJDs[i - s1] = jd
              wset, 4
              polyfill, [0, 0, 420, 420], [0, 20, 20, 0], $
                        color = '550000'XUL, /device
              xyouts, 5, 5, 'Reading FITS files (' + $
                      zeroPad(fix((i - s1 + 1.0D) / n * 100) $
                              < 100 > 0, 0) + $
                      '% complete) ...', color = 'ffffff'XUL, $
                      charsize = 1.333, charthick = 1.333, /device
              wset, h_draw2
              device, copy = [0, 0, 420, 20, 0, 0, 4]
          endfor
          selChange = 0
      endif
      if s2 ne foundFrame then begin
          rotsum_loadfits, files[foundFrame]
          calc_sm_coords
      endif
      rotsum_dobatch
      rotsum_loadfits, files[curFile]
      calc_sm_coords
      return
  endif     

  if uval eq 't_rot' then begin
      v = ''
      widget_control, ev.id, get_value = v
      if v eq '' then v = '0'
      if strmid(v, 0, 1) eq '-' then v = '-0' + strmid(v,1,50) $
                                else v = '0' + v
      v = double(v)
      ipart = fix(v)
      fpart = fix((v mod 1.0D) * 1000 + 0.5)
      reconst = zeroPad(ipart, 0) + '.' + zeroPad(fpart, 3)
      widget_control, ev.id, set_value = reconst
      turnAng = v
      wset, h_draw1
      device, copy = [0, 0, 280, 300, 0, 0, 3]

      if cir_x ne -1 then drawEarth, cir_x, cir_y
      if foundMINL ne -1 then begin
          ang = ((turnAng - 15) * 24) * (jd - foundJD)
          res = rotsum_findXY(foundMINL, foundMLON + ang)
          
          wset, h_draw1
          plots, [res[0]], [res[1]], psym = 2, color = 'ffaaff'XUL, $
                 symsize = 0.3333, /device
      endif
  endif

  if uval eq 'b_save' then begin
      def = strip(dateStrings[first]) + '_' + $
            strip(dateStrings[first + n_elements(savedJDs) - 1]) + $
            '_composite.png'
      fname = dialog_pickfile(/write, filter = '*.png', $
                              title = 'Save composite as...', file = def)
      if fname eq '' then return
      write_png, fname, combined, palR, palG, palB
  endif
  if uval eq 'b_save2' then begin
      dir = dialog_pickfile(/directory, title = 'Save frames in folder...')
      if dir eq '' then return
      if strmid(dir, strlen(dir) - 1, 1) ne directoryDelimiter then $
        dir = dir + directoryDelimiter
      n = size(savedRotated)
      n = n[1]
      d = intarr(420, 450)
      for i = 0, n - 1 do begin
          fname = strip(dateStrings[first + i]) + '.png'
          d[*, *] = savedRotated[i, *, *]
          write_png, fname, d, palR, palG, palB
      endfor
  endif
end
