pro circle, x, y, r, color = c, linewidth = l, smoothness = s, filled = f, linestyle = t
  if n_elements(c) eq 0 then c = '000000'XUL
  if n_elements(l) eq 0 then l = 1
  if n_elements(s) eq 0 then s = 32
  if n_elements(f) eq 0 then f = 0
  if n_elements(t) eq 0 then t = 0

  cirX = double(x) + double(r) * cos(indgen(s + 1, /float) / s * !pi * 2.00D)
  cirY = double(y) + double(r) * sin(indgen(s + 1, /float) / s * !pi * 2.00D)

  if f eq 0 then plots, cirX, cirY, color = c, thick = l, /device, linestyle = t $
  else polyfill, cirX, cirY, color = c, thick = l, /device, linestyle = t
  
end
