
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; calculate the (reduced) julian date from
; year, doy, hour, minute,second and millisecond
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

; last modified: 29-Mar-2000

function calc_jd, year, doy, hour, minute, second, msec

; --------------------------------------------------------------
; load day 0 of the year into an array for the juldate procedure
; --------------------------------------------------------------
tt = intarr(3)
tt[0] = year
tt[1] = 1
tt[2] = 0

; ------------------------------------------------------
; calculate the reduced (- 24000000) Julian date for the
; start of the year in question
; ------------------------------------------------------
juldate,tt,jj

; ---------------------------
; add in the rest of the time
; ---------------------------
jd = jj + doy + (hour/24.0) + (minute/1400.0) + (second/86400.0) + (msec/86400000.)

return,jd

end
