pro plotter_loadframe, i
  @plotter_common
  @euv_imtool-commons

  if i lt 0 then i = 0
  if i ge n_elements(clkList) then i = n_elements(clkList) - 1
  filename = clkList[i]
  curFile = i

  fits = strmid(filename, 0, strpos(filename, '.', /reverse_search)) + '.fits'
  print, fits
  if numlines(fits) eq -1 then begin
      print, 'PLOTTER : Matching FITS file not found'
      wset, h_draw2
      polyfill, [0, 0, 1, 1], [0, 1, 1, 0], /normal, $
                color = '773344'XUL, orientation = 45.0000D, spacing = 0.125
      polyfill, [0, 0, 1, 1], [0, 1, 1, 0], /normal, $
                color = '773344'XUL, orientation = -45.0000D, spacing = 0.125
      widget_control, w_date, set_value = '(no date available)'
      fitsfound = 0
  endif else begin
      plotter_loadfits, fits
      widget_control, w_date, set_value = zeroPad(s0year, 4) + '/' + zeroPad(s0doy, 3) + '/' + $
                                          zeroPad(s0hour, 2) + ':' + zeroPad(s0min, 2)
      fitsfound = 1
  endelse

  plotter_readclick, filename

  plotter_plot

  if curFile gt 0 then $
    widget_control, w_prev, sensitive = 1 $
  else $
    widget_control, w_prev, sensitive = 0

  if curFile lt (n_elements(clkList) - 1) then $
    widget_control, w_next, sensitive = 1 $
  else $
    widget_control, w_next, sensitive = 0
end
