pro bgsub_redraw
  @euv_imtool-commons
  @bgsub_common

  wset, 1
  device, copy = [0, 0, 280, 300, 560, 0, 1]
  
  if startX ne -1 then begin
      xmin = startX < endX
      xmax = startX > endX
      w = xmax - xmin + 1
      device, copy = [840 + xmin, 0, w, 300, 560 + xmin, 0, 1]
  endif
  
  if startY ne -1 then begin
      ymin = startY < endY
      ymax = startY > endY
      h = ymax - ymin + 1
      
      device, copy = [280, ymin, 280, h, 560, ymin, 1]
  endif

  if startX ne -1 and startY ne -1 then begin
      device, copy = [1120 + xmin, ymin, w, h, 560 + xmin, ymin, 1]
  endif

  wset, h_draw1
  device, copy = [560, 0, 280, 300, 0, 0, 1]
  
  if dragging and (startY ne -1 or startX ne -1) then begin
      dl = darrayl
  
      yminS = fix(ymin / 2)
      ymaxS = fix(ymax / 2)
      
      for i = 0, 139 do begin
          avgs[i] = mean(dl[i, yminS:ymaxS])
          dl[i, *] = dl[i, *] - avgs[i]
      endfor
      
      widget_control, w_bottom, get_value = b
      widget_control, w_top, get_value = t
      b = fix(b[0])
      t = fix(t[0])
      
      step = (t - b) / 149.0D
      
      for i = 0, 149 do begin
          x = b + step * i
          dl[*, i] = dl[*, i] - x
      endfor
      
      adjusted = dl
      
      wset, h_draw2
      tvscl, rebin(alog10(dl > 1), 280, 300)
      
      wset, 3
      
      x1 = (309 - 280) / 309.0D
      x2 = (309 - 1) / 309.0D
      y1 = 0
      y2 = (150 - 1) / 150.0D
      
      !p.position = [x1, y1, x2, y2]
      
      plot, avgs, background = 'bfbfbf'XUL, color = 0, ymargin = [2.5, 1.3], $
            xmargin = [4, 2.8], xrange = [0, 140], xstyle = 1
      
      wset, h_draw3
      device, copy = [0, 0, 309, 150, 0, 0, 3]
  endif

  if dragging or dragging2 and startX ne -1 then begin
      xminS = fix(xmin / 2)
      xmaxS = fix(xmax / 2)
      
      for i = 0, 149 do begin
          vAvgs[i] = mean(darrayl[xminS:xmaxS, i])
          vAvgs2[i] = mean(adjusted[xminS:xmaxS, i])
      endfor

      wset, 4
      
      x1 = (329 - 300) / 329.0D
      x2 = (329 - 1) / 329.0D
      y1 = 0
      y2 = (150 - 1) / 150.0D
      
      !p.position = [x1, y1, x2, y2]

      ymax = max([vAvgs, vAvgs2])
      ymin = min([vAvgs, vAvgs2]) < 0
      
      plot, [0], [0], background = 'bfbfbf'XUL, color = 0, $
            xrange = [0, 150], xstyle = 1, /nodata, yrange = [ymin, ymax]
      oplot, [-20, 170], [0, 0], color = 'dddddd'XUL, linestyle = 2
      oplot, reverse(vAvgs2), color = '777777'XUL
      oplot, reverse(vAvgs), color = 0

      m = tvrd()
      
      m = rotate(m, 3)
      
      wset, h_draw4
      tv, m
;      device, copy = [0, 0, 309, 150, 0, 0, 5]
  endif
end
  
