pro bgsub_loadframe, n
  @euv_imtool-commons
  @bgsub_common

  bgsub_loadfits, files[n]

  shortFn = files[n]
  i = strpos(shortFn, directoryDelimiter, /reverse_search)
  if i ne -1 then shortFn = strmid(shortFn, i + 1, 1000)

  curFrame = n

  dateStr = zeroPad(s0year, 4) + '/' + zeroPad(s0doy, 3) + '/' + $
            zeroPad(s0hour, 2) + ':' + zeroPad(s0min, 2)

  widget_control, w_datelabel, set_value = dateStr + ' (' + shortFn + ')'

  if n gt 0 then $
    widget_control, w_prev, sensitive = 1 $
  else $
    widget_control, w_prev, sensitive = 0

  if n lt (filesN - 1) then $
    widget_control, w_next, sensitive = 1 $
  else $
    widget_control, w_next, sensitive = 0

  adjusted = darrayl

  wset, 1
  d = darray - min(darray)
  d = d / max(d) * 255
  tv, d, 0, 0
  d = (d * 3 + 255) / 4
  tv, [[[d * 0.50]], [[d * 0.75]], [[d * 1.00]]], 280, 0, true = 3
  tv, [[[d * 0.95]], [[d * 0.85]], [[d * 0.65]]], 840, 0, true = 3
  tv, [[[d * 0.65]], [[d * 0.95]], [[d * 0.65]]], 1120, 0, true = 3

  dragging = 1
  bgsub_redraw
  dragging = 0
end
